package cn.bsl.bxbg.zhiban.view;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.ZhibanInfoAdapter;
import cn.bsl.bxbg.zhiban.bean.DutyPlanDutiesBean;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import cn.bsl.bxbg.zhiban.utils.Constant;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class ZhibanInfoActivity extends BaseActivity implements AdapterView.OnItemClickListener{

    @BindView(R.id.zb_lv)
    ListView zbLv;
    private DutyPlanClient dutyPlanClient = new DutyPlanClient();
    private static final String TAG = "ZhibanInfoActivity";
    private ZhibanInfoAdapter zhibanInfoAdapter;
    private List<DutyPlanDutiesBean> planDuties;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_zhiban_info);
        ButterKnife.bind(this);
        initView();
        queryRecord();
    }

    private void initView() {
        zbLv.setOnItemClickListener(this);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        Intent intent = new Intent(ZhibanInfoActivity.this, ZhibanDetailsActivity.class);
        intent.putExtra("dutyId", planDuties.get(position).getDutyId());
        startActivity(intent);
    }


    /**
     *  TODO  按本月查询信息 需要添加filters
     *  判断id相等并且早中晚包含本人信息的将加入列表
     */
    private void queryRecord() {
        Observable.zip(dutyPlanClient.dutyPlanLeaderRecord(), dutyPlanClient.dutiesRecord(),
                new BiFunction<List<DutyPlanResponse>, List<CCDuties>, List<DutyPlanDutiesBean>>() {
                    @Override
                    public List<DutyPlanDutiesBean> apply(@NonNull List<DutyPlanResponse> dutyPlanResponses,
                                                          @NonNull List<CCDuties> ccDuties) throws Exception {
                        List<DutyPlanDutiesBean> dutyPlanDutiesBeen = new ArrayList<>();
                        DutyPlanDutiesBean dutyPlanDutiesBean;
                        for (int i = 0; i < dutyPlanResponses.size(); i++) {
                            for (int i1 = 0; i1 < ccDuties.size(); i1++) {
                                String id = dutyPlanResponses.get(i).getId();
                                String onDutyPlanId = ccDuties.get(i1).getOnDutyPlanId();
                                if (id.equals(onDutyPlanId) && (ccDuties.get(i1).getMorning().contains(Constant.USER_NAME)
                                        ||ccDuties.get(i1).getNoon().contains(Constant.USER_NAME)
                                        ||ccDuties.get(i1).getEvening().contains(Constant.USER_NAME)
                                        || ccDuties.get(i1).getClassLeaders().contains(Constant.USER_NAME))) {
                                    dutyPlanDutiesBean = new DutyPlanDutiesBean();
                                    dutyPlanDutiesBean.setPlanId(id);
                                    dutyPlanDutiesBean.setDutyId(ccDuties.get(i1).getId());
                                    dutyPlanDutiesBean.setLeader(ccDuties.get(i1).getClassLeaders());
                                    dutyPlanDutiesBean.setYear(dutyPlanResponses.get(i).getWhatYear());
                                    dutyPlanDutiesBean.setMonth(dutyPlanResponses.get(i).getWhatMonth());
                                    dutyPlanDutiesBean.setMorning(ccDuties.get(i1).getMorning());
                                    dutyPlanDutiesBean.setNoon(ccDuties.get(i1).getNoon());
                                    dutyPlanDutiesBean.setEvening(ccDuties.get(i1).getEvening());
                                    dutyPlanDutiesBean.setDutyDate(ccDuties.get(i1).getDutyDate());

                                    dutyPlanDutiesBeen.add(dutyPlanDutiesBean);
                                }
                            }
                        }
                        return dutyPlanDutiesBeen;
                    }
                }).observeOn(AndroidSchedulers.mainThread())
                .subscribeOn(Schedulers.io())
                .subscribe(new Consumer<List<DutyPlanDutiesBean>>() {
                    @Override
                    public void accept(List<DutyPlanDutiesBean> dutyPlanDutiesBeen) throws Exception {
//                        zbLv.setAdapter(new ZhibanTableAdapter(dutyPlanDutiesBeen));
                        Log.d(TAG, "accept: " + dutyPlanDutiesBeen.size());
                        planDuties = dutyPlanDutiesBeen;
                        zhibanInfoAdapter=new ZhibanInfoAdapter(planDuties);
                        zbLv.setAdapter(zhibanInfoAdapter);
                    }
                }, Throwable::printStackTrace);
    }


}
