package cn.bsl.bxbg.zhiban.view;

import android.content.Intent;
import android.os.Bundle;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.ZbPeopleAdapter;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

public class ZhibanDetailsActivity extends BaseActivity {

    private List<CCDuties> ccDuties = new ArrayList<>();
    @BindView(R.id.duty_time)
    TextView dutyTime;
    @BindView(R.id.zb_people)
    ListView zbPeople;
    DutyPlanClient dutyPlanClient = new DutyPlanClient();
    private String dutyId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_zhiban_details);
        ButterKnife.bind(this);
        initData();
    }

    private void initData() {
        dutyId = getIntent().getStringExtra("dutyId");
        queryDetails(dutyId);
    }

    private void queryDetails(String dutyId) {
        dutyPlanClient.dutiesById(dutyId)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(clcDuties -> {
                    ccDuties.clear();
                    dutyTime.setText(clcDuties.getDutyDate());
                    ccDuties.add(clcDuties);
                    zbPeople.setAdapter(new ZbPeopleAdapter(ccDuties));
                }, Throwable::printStackTrace);
    }

    @OnClick(R.id.tb)
    public void onViewClicked() {
        Intent intent = new Intent(this,TiaoBanPublish.class);
        intent.putExtra("id", dutyId);
        intent.putExtra("morning", ccDuties.get(0).getMorning());
        intent.putExtra("noon", ccDuties.get(0).getNoon());
        intent.putExtra("evening", ccDuties.get(0).getEvening());
        intent.putExtra("dutyTime", dutyTime.getText().toString());
        startActivity(intent);
    }
}
