package cn.bsl.bxbg.zhiban.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.bean.DutyPlanDutiesBean;

/**
 * Created by Xinghx on 2018/3/6 0006.
 */

public class ZhibanInfoAdapter extends BaseAdapter {
    List<DutyPlanDutiesBean> dutyPlanResponses;

    public ZhibanInfoAdapter(List<DutyPlanDutiesBean> dutyPlanResponses) {
        this.dutyPlanResponses = dutyPlanResponses;
    }

    @Override
    public int getCount() {
        return dutyPlanResponses.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_zhiban_info, parent,false);
            holder = new ViewHolder(convertView);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.zbName.setText(dutyPlanResponses.get(position).getLeader());
        holder.zbTime.setText(dutyPlanResponses.get(position).getDutyDate());
        return convertView;
    }

    class ViewHolder {
        @BindView(R.id.zb_title)
        TextView zbTitle;
        @BindView(R.id.zb_name)
        TextView zbName;
        @BindView(R.id.zb_time)
        TextView zbTime;

        ViewHolder(View view) {
            ButterKnife.bind(this, view);
        }
    }
}
