package cn.bsl.bxbg.zhiban.net.client;

import java.util.List;

import cn.bsl.bxbg.zhiban.bean.ShiftBean;
import cn.bsl.bxbg.zhiban.bean.TimeBean;
import cn.bsl.bxbg.zhiban.net.api.DutyAPI;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.CCDutiesEdit;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;
import cn.bsl.bxbg.zhiban.net.response.CCShiftsInclude;
import cn.bsl.bxbg.zhiban.net.response.CCShiftsUni;
import cn.bsl.bxbg.zhiban.net.response.DutiesTbResponse;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import cn.bsl.bxbg.zhiban.net.response.TiaobanBean;
import cn.bsl.bxbg.zhiban.utils.Constant;
import cn.bsl.bxbg.zhiban.utils.DateUtils;
import io.reactivex.Observable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by Xinghx on 2018/3/14 0014.
 */

public class DutyPlanClient extends BaseClient {
    DutyAPI dutyAPI = new Retrofit.Builder()
            .baseUrl(Constant.HOST)
            .client(getClient())
            .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())
            .build()
            .create(DutyAPI.class);

    public Observable<List<DutyPlanResponse>> dutyPlanLeaderRecord() {
        return dutyAPI.dutyPlanLeader("1","100");
    }

    public Observable<List<CCDuties>> dutiesRecord() {
        return dutyAPI.dutiesRecord("1", "100","duty_date","{'cc_duty':{'duty_date':{like:'%"+ DateUtils.getMonth()+"%'}}}");
    }

    public Observable<CCDuties> dutiesById(String id) {
        return dutyAPI.dutiesById(Constant.USER_ID+"",id);
    }


    // 调班申请默认为0 ， 1为同意调班 2为不同意调班  // 手机端调班人和申请人为同一人
    public Observable<TiaobanBean> tiaobanBean(String transferredClass,String transferredName,String id,String reason,String dutyTime,String shift_timeStatus,String departMent) {
        return dutyAPI.tbRecord(Constant.USER_ID+"",Constant.USER_ID+"",Constant.USER_NAME,
                transferredName,transferredClass,id,reason,dutyTime,"0",shift_timeStatus,departMent);
    }

    public Observable<CCDutiesEdit> editMorning(String cc_id,String morning) {
        return dutyAPI.editMorning(Constant.USER_ID+"", cc_id, morning);
    }

    public Observable<CCDutiesEdit> editNoon(String cc_id,String noon) {
        return dutyAPI.editNoon(Constant.USER_ID+"", cc_id, noon);
    }

    public Observable<CCDutiesEdit> editNight(String cc_id,String night) {
        return dutyAPI.editNight(Constant.USER_ID+"", cc_id, night);
    }

    public Observable<CCDutiesEdit> editLeader(String cc_id,String leader) {
        return dutyAPI.editLeader(Constant.USER_ID+"", cc_id, leader);
    }

    public Observable<List<DutiesTbResponse>> dutiesTb() {
        return dutyAPI.dutiesTb("1", "1000", "{'cc_shift':{'includes':['applicant_duty_id']}}");
    }

    public Observable<List<DutiesTbResponse>> dutiesTbDetails(String id) {
        return dutyAPI.dutiesTbDetails("1", "1000","{'cc_shift':{'id':{'equalTo':'"+id+"'}}}","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShifts>> shiftsRecord() {
        return dutyAPI.ccShifts("1","1000","{'cc_shift':{'applicantTransferredNameequalTo':{'fieldsValuesOr':{'fields':['transferred_class','transferred_name'],'values':['"+Constant.USER_NAME+"']}}}}","last_update_time","desc",
                "{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShifts>> shiftRecordFinish() {
        return dutyAPI.ccShifts("1","1000","{'cc_shift': {'applicant': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'notEqualTo': '0'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShiftsInclude>> shiftFinish() {
        return dutyAPI.ccShiftsicl("1","1000","{'cc_shift': {'applicant': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'notEqualTo': '0'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShifts>> shiftRecordNotFinish() {
        return dutyAPI.ccShifts("1","1000","{'cc_shift': {'applicant': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'equalTo': '0'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShiftsInclude>> shiftInclNotFinish() {
        return dutyAPI.ccShiftsicl("1","1000","{'cc_shift': {'applicant': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'equalTo': '0'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShiftsInclude>> shiftWaitMe(String status) {
        return dutyAPI.ccShiftsicl("1","1000","{'cc_shift': {'transferred_name': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'equalTo': '"+status+"'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShifts>> shiftWaitMe() {
        return dutyAPI.ccShifts("1","1000","{'cc_shift': {'transferred_name': {'equalTo': '"+Constant.USER_NAME+"'},'status': {'notEqualTo': 'status'}}}","last_update_time","desc","{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Observable<List<CCShiftsUni>> ccshiftUni(String id) {
        return dutyAPI.ccShiftsUnique("1", "1000", "{'cc_shift':{'id':{'equalTo':'" + id + "'}}}",
                "{'cc_duty':{'includes':['applicant_duty_id']}}");
    }

    public Observable<CCShifts> ccShiftsEdit(String id, String status) {
        return dutyAPI.ccShiftsEdit(Constant.USER_ID+"", id, status);
    }

    public Call<TimeBean> timeBean() {
        return dutyAPI.timeBean();
    }

    // 以下为交接班操作
    public Observable<ShiftBean> shiftNew(String ccId,String successor,String dutyDepartment,
                                   String dutyDate,String dutyShift) {
        return dutyAPI.shiftNew(Constant.USER_ID + "", ccId,
                Constant.USER_NAME, successor, "1", dutyDepartment, dutyDate, dutyShift);
    }

    public Observable<List<CCDuties>> findPeopleByTime(String date) {
        return dutyAPI.findPeopleByTime("{'cc_duty':{'duty_date':{'equalTo':'"+date+"'}}}");
    }

    // column 代表的是要查哪个字段
    public Observable<List<ShiftBean>> shiftList(String date,String name,String column) {
        return dutyAPI.shiftList("1","1000","{'cc_shift_shift':{'duty_date':{'like':'%"+date+"%'},'"+column+"':{'equalTo':'"+name+"'}}}","create_time","desc");
    }


    public Observable<ShiftBean> editShiftRecord(String id,String content) {
        return dutyAPI.editShiftRecord(Constant.USER_ID + "", id, content);
    }


    public Observable<ShiftBean> editShiftStatus(String id,String status) {
        return dutyAPI.editShiftStatus(Constant.USER_ID+"",id,status);
    }

}
