package cn.bsl.bxbg.zhiban.net.api;

import java.util.List;

import cn.bsl.bxbg.zhiban.bean.ShiftBean;
import cn.bsl.bxbg.zhiban.bean.TimeBean;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.CCDutiesEdit;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;
import cn.bsl.bxbg.zhiban.net.response.CCShiftsInclude;
import cn.bsl.bxbg.zhiban.net.response.CCShiftsUni;
import cn.bsl.bxbg.zhiban.net.response.DutiesTbResponse;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import cn.bsl.bxbg.zhiban.net.response.TiaobanBean;
import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

/**
 * Created by Xinghx on 2018/3/14 0014.
 */

public interface DutyAPI {
    @GET("cc_duty_plans")
    Observable<List<DutyPlanResponse>> dutyPlanLeader(@Query("pageNo") String pageNo,
                                                      @Query("pageSize") String pageSize);


    @GET("cc_duties")
    Observable<List<CCDuties>> dutiesRecord(@Query("pageNo") String pageNo,
                                            @Query("pageSize") String pageSize,
                                            @Query("sortItem") String sortItem,
                                            @Query("filters") String filters);

    @GET("cc_duties/{id}")
    Observable<CCDuties> dutiesById(@Header("X-Auth-Token") String header,
                                    @Path("id") String id);

    @FormUrlEncoded
    @POST("roleManagerController.do")
    Call<ResponseBody> people(@Field("method") String method, @Field("userId") String userId);

    @FormUrlEncoded
    @POST("return_department_people")
    Call<ResponseBody> getAllpeople(@Field("userId") String userId);



    @FormUrlEncoded
    @POST("cc_shifts/new")
    Observable<TiaobanBean> tbRecord(@Header("X-Auth-Token") String header,
                                     @Field("applicantId") String applicantId,
                                     @Field("applicant") String applicant,
                                     @Field("transferredName") String transferredName,
                                     @Field("transferredClass") String transferredClass,
                                     @Field("applicantDutyId") String applicantDutyId,
                                     @Field("reason") String reason,
                                     @Field("shiftTime") String shiftTime,
                                     @Field("status") String status,
                                     @Field("transferredClassTime") String transferredClassTime,
                                     @Field("applicantPosition") String applicatPosition);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editMorning(@Header("X-Auth-Token") String header,
                                         @Path("id") String cc_duty_id,
                                         @Field("morning") String morning);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editNoon(@Header("X-Auth-Token") String header,
                                      @Path("id") String cc_duty_id,
                                      @Field("noon") String noon);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editNight(@Header("X-Auth-Token") String header,
                                       @Path("id") String cc_duty_id,
                                       @Field("night") String night);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editLeader(@Header("X-Auth-Token") String header,
                                        @Path("id") String cc_duty_id,
                                        @Field("classLeaders") String leader);

    @GET("cc_duties")
    Observable<List<DutiesTbResponse>> dutiesTb(@Query("pageNo") String pageNo,
                                                @Query("pageSize") String pageSize,
                                                @Query("refers") String refers);

    @GET("cc_shifts")
    Observable<List<DutiesTbResponse>> dutiesTbDetails(@Query("pageNo") String pageNo,
                                                       @Query("pageSize") String pageSize,
                                                       @Query("filters") String filters,
                                                       @Query("includes") String refers);

    @GET("cc_shifts")
    Call<List<CCShifts>> ccShifts(@Query("pageNo") String pageNo,
                                  @Query("pageSize") String pageSize,
                                  @Query("filters") String filters,
                                  @Query("sortItem") String sortItem,
                                  @Query("sortOrder") String sortOrder,
                                  @Query("includes") String includes);

    @GET("cc_shifts")
    Call<List<CCShiftsInclude>> ccShiftsicl(@Query("pageNo") String pageNo,
                                         @Query("pageSize") String pageSize,
                                         @Query("filters") String filters,
                                         @Query("sortItem") String sortItem,
                                         @Query("sortOrder") String sortOrder,
                                         @Query("includes") String includes);

    @GET("cc_shifts")
    Observable<List<CCShiftsUni>> ccShiftsUnique(@Query("pageNo") String pageNo,
                                                 @Query("pageSize") String pageSize,
                                                 @Query("filters") String filters,
                                                 @Query("includes") String includes);

    @FormUrlEncoded
    @POST("cc_shifts/{cc_shift_id}/edit")
    Observable<CCShifts> ccShiftsEdit(@Header("X-Auth-Token") String header,
                                      @Path("cc_shift_id") String id,
                                      @Field("status") String status);

    @GET("obtain_time")
    Call<TimeBean> timeBean();


    @GET("cc_duties")
    Observable<List<CCDuties>> findPeopleByTime(@Query("filters")String filters);

    // 交接班

    // 待交班 状态为1 ， 点击交班后状态修改为0，详情中 如果状态为0 那么就提示 等待接班人接班。
    // 接班人接班后 状态改为2，已交班完成 并且交班日期生成

    @FormUrlEncoded
    @POST("cc_shift_shifts/new")
    Observable<ShiftBean> shiftNew(@Header("X-Auth-Token") String token,
                                   @Field("ccDutyId") String dutyId,
                                   @Field("handover") String handover,
                                   @Field("successor") String successor,
                                   @Field("remark") String type,
                                   @Field("dutyDepartment") String dutyDepartment,
                                   @Field("dutyDate") String dutyDate,
                                   @Field("dutyShift") String duryShift);

    // 待接班
    @GET("cc_shift_shifts")
    Observable<List<ShiftBean>> shiftList(@Query("pageNo") String pageNo,
                                          @Query("pageSize") String pageSize,
                                          @Query("filters") String filters,
                                          @Query("sortItem") String sortItem,
                                          @Query("sortOrder") String sortOrder);


    // 修改状态
    @FormUrlEncoded
    @POST("cc_shift_shifts/{id}/edit")
    Observable<ShiftBean> editShiftStatus(@Header("X-Auth-Token") String token,
                                                @Path("id") String ccShiftID,
                                                @Field("remark") String status);

    // 修改值班内容。
    @FormUrlEncoded
    @POST("cc_shift_shifts/{id}/edit")
    Observable<ShiftBean> editShiftRecord(@Header("X-Auth-Token") String token,
                                                @Path("id") String ccShiftID,
                                                @Field("dutyContent") String dutyContent);
}
