/*
 * Group.java
 * classes : cn.com.bril.announcement.entity.Group
 * @author 李小娇
 * V 1.0.0
 * Create at 2016-9-25 下午4:53:26
 */
package cn.bsl.bxbg.zhiban.bean;

import java.io.Serializable;
import java.util.ArrayList;

public class Group implements Serializable {
	private static final String TAG = "Group";

	private String id;
	private String dept;
	private ArrayList<SppUser> users;
	private boolean isChecked;

	public Group(String id, String name) {
		this.dept = name;
		users = new ArrayList<SppUser>();
		this.isChecked = false;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setChecked(boolean isChecked) {
		this.isChecked = isChecked;
	}

	public void toggle() {
		this.isChecked = !this.isChecked;
	}

	public boolean getChecked() {
		return this.isChecked;
	}

	public String getId() {
		return id;
	}

	public String getName() {
		return dept;
	}

	public void addChildrenItem(SppUser child) {
		users.add(child);
	}

	public int getChildrenCount() {
		return users.size();
	}

	public SppUser getChildItem(int index) {
		return users.get(index);
	}

	public ArrayList<SppUser> getChildren() {
		return users;
	}

	public void setChildren(ArrayList<SppUser> children) {
		this.users = children;
	}

}
