/*
 * Dept.java
 * classes : cn.com.bril.announcement.entity.Group
 * @author 李小娇
 * V 1.0.0
 * Create at 2016-9-25 下午4:53:26
 */
package cn.bsl.bxbg.zhiban.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @title: Dept.java
 * @package：cn.com.bril.announcement.entity.Group
 * @description: TODO
 * @author 李小娇 
 * @time：create at 2016-9-25 下午4:53:26
 */
public class Dept implements Serializable{
  private static final String TAG = "Dept";
  
  private String id;
  private String name;
  private ArrayList<User> children;
  private boolean isChecked;

  public Dept(String id, String name) {
      this.name = name;
      this.id=id;
      children = new ArrayList<User>();
      this.isChecked = false;
  }

  public void setChecked(boolean isChecked) {
      this.isChecked = isChecked;
  }

  public void toggle() {
      this.isChecked = !this.isChecked;
  }

  public boolean getChecked() {
      return this.isChecked;
  }

  public String getId() {
      return id;
  }

  public String getName() {
      return name;
  }

  public void addChildrenItem(User child) {
      children.add(child);
  }
  
  public void addChildrenAll(List<User> childs) {
    children.addAll(childs);
  }

  public int getChildrenCount() {
      return children.size();
  }

  public User getChildItem(int index) {
      return children.get(index);
  }

  public ArrayList<User> getChildren() {
    return this.children;
  }

  public void setChildren(ArrayList<User> children) {
  this.children = children;}
  
  public void deleteChild(int poi){
    children.remove(poi);
  }
  
}
