package cn.bsl.bxbg.zhiban.view;

import android.os.Bundle;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.ZhibanTableAdapter;
import cn.bsl.bxbg.zhiban.bean.DutyPlanDutiesBean;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class ZhibanTableActivity extends BaseActivity {

    @BindView(R.id.zb_table_lv)
    ListView zbTableLv;
    private static final String TAG = "ZhibanTableActivity";
    private DutyPlanClient dutyPlanClient = new DutyPlanClient();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_zhiban_table);
        ButterKnife.bind(this);
//        zbTableLv.setAdapter(new ZhibanTableAdapter(TestBean.testBeen()));
        queryRecord();
    }

    private void queryRecord() {
        Observable.zip(dutyPlanClient.dutyPlanLeaderRecord(), dutyPlanClient.dutiesRecord(),
                new BiFunction<List<DutyPlanResponse>, List<CCDuties>, List<DutyPlanDutiesBean>>() {
                    @Override
                    public List<DutyPlanDutiesBean> apply(@NonNull List<DutyPlanResponse> dutyPlanResponses,
                                                          @NonNull List<CCDuties> ccDuties) throws Exception {
                        List<DutyPlanDutiesBean> dutyPlanDutiesBeen = new ArrayList<>();
                        DutyPlanDutiesBean dutyPlanDutiesBean;
                        for (int i = 0; i < dutyPlanResponses.size(); i++) {
                            for (int i1 = 0; i1 < ccDuties.size(); i1++) {
                                String id = dutyPlanResponses.get(i).getId();
                                String onDutyPlanId = ccDuties.get(i1).getOnDutyPlanId();
                                if (id.equals(onDutyPlanId)) {
                                    dutyPlanDutiesBean = new DutyPlanDutiesBean();
                                    dutyPlanDutiesBean.setPlanId(id);
                                    dutyPlanDutiesBean.setDutyId(onDutyPlanId);
                                    dutyPlanDutiesBean.setLeader(ccDuties.get(i1).getClassLeaders());
                                    dutyPlanDutiesBean.setYear(dutyPlanResponses.get(i).getWhatYear());
                                    dutyPlanDutiesBean.setMonth(dutyPlanResponses.get(i).getWhatMonth());
                                    dutyPlanDutiesBean.setMorning(ccDuties.get(i1).getMorning());
                                    dutyPlanDutiesBean.setNoon(ccDuties.get(i1).getNoon());
                                    dutyPlanDutiesBean.setEvening(ccDuties.get(i1).getEvening());
                                    dutyPlanDutiesBean.setDutyDate(ccDuties.get(i1).getDutyDate());

                                    dutyPlanDutiesBeen.add(dutyPlanDutiesBean);
                                }
                            }
                        }
                        return dutyPlanDutiesBeen;
                    }
                }).observeOn(AndroidSchedulers.mainThread())
                .subscribeOn(Schedulers.io())
                .subscribe(new Consumer<List<DutyPlanDutiesBean>>() {
                    @Override
                    public void accept(List<DutyPlanDutiesBean> dutyPlanDutiesBeen) throws Exception {
                        zbTableLv.setAdapter(new ZhibanTableAdapter(dutyPlanDutiesBeen));
                    }
                }, Throwable::printStackTrace);
    }
}
