package cn.bsl.bxbg.zhiban.view;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.HomeAdapter;
import cn.bsl.bxbg.zhiban.bean.MenuBean;

public class MainActivity extends BaseActivity implements AdapterView.OnItemClickListener{

    @BindView(R.id.home_gv)
    GridView homeGv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ButterKnife.bind(this);
        initTab();
    }

    private void initTab() {
        homeGv.setAdapter(new HomeAdapter(menuData()));
        homeGv.setOnItemClickListener(this);
    }

    private List<MenuBean> menuData() {
        List<MenuBean> menuList = new ArrayList<>();
        MenuBean fbjl = new MenuBean(R.drawable.zb_info,"值班信息");
        MenuBean fbj2 = new MenuBean(R.drawable.zb_table,"值班表");
        MenuBean fbj3 = new MenuBean(R.drawable.tb_record,"调班记录");
        menuList.add(fbjl);
        menuList.add(fbj2);
        menuList.add(fbj3);
        return menuList;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        Intent intent = new Intent();
        switch (position) {
            case 0:
                intent.setClass(MainActivity.this, ZhibanInfoActivity.class);
                break;
            case 1:
                intent.setClass(MainActivity.this, ZhibanTableActivity.class);
                break;
            case 2:
                intent.setClass(MainActivity.this,TiaobanRecordActivity.class);
                break;
        }
        startActivity(intent);
    }
}
