package cn.bsl.bxbg.zhiban.view;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.TiaobanInfoAdapter;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TiaobanRecordActivity extends BaseActivity {

    @BindView(R.id.tbLv)
    ListView tbLv;

    private DutyPlanClient dutyPlanClient = new DutyPlanClient();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tiaoban_record);
        ButterKnife.bind(this);
        queryRecord();

    }

    private void queryRecord() {
        dutyPlanClient.shiftsRecord().enqueue(new Callback<List<CCShifts>>() {
            @Override
            public void onResponse(Call<List<CCShifts>> call, Response<List<CCShifts>> response) {
                List<CCShifts> ccShift = response.body();
                tbLv.setAdapter(new TiaobanInfoAdapter(ccShift));
                tbLv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                        Intent intent = new Intent(TiaobanRecordActivity.this,TiaobanDetailsActivity.class);
                        intent.putExtra("id", ccShift.get(position).getApplicantDutyId());
                        startActivity(intent);
                    }
                });
            }

            @Override
            public void onFailure(Call<List<CCShifts>> call, Throwable t) {
                t.printStackTrace();
            }
        });
    }

}
