package cn.bsl.bxbg.zhiban.view;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.CCDutiesEdit;
import cn.bsl.bxbg.zhiban.net.response.TiaobanBean;
import cn.bsl.bxbg.zhiban.utils.Constant;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

public class TiaoBanPublish extends BaseActivity {

    @BindView(R.id.reason)
    EditText reason;
    @BindView(R.id.button)
    TextView button;
    private static final String TAG = "TiaoBanPublish";
    @BindView(R.id.choose_result)
    TextView chooseResult;
    @BindView(R.id.choose_time_area)
    TextView chooseTimeArea;
    private String morning;
    private String noon;
    private String evening;
    private DutyPlanClient dutyPlanClient = new DutyPlanClient();
    private String id;
    private String dutyTime;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tiao_ban_publish);
        ButterKnife.bind(this);
        initData();
    }

    private void initData() {
        id = getIntent().getStringExtra("id");
        morning = getIntent().getStringExtra("morning");
        noon = getIntent().getStringExtra("noon");
        evening = getIntent().getStringExtra("evening");
        dutyTime = getIntent().getStringExtra("dutyTime");

    }


    @OnClick({R.id.change_people,R.id.choose_time,R.id.button})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.change_people:
                Intent intent = new Intent(this, DutyChangePeopleActivity.class);
                startActivityForResult(intent, 0x00);
                break;
            case R.id.choose_time:
                showTimeSelector();
                break;
            case R.id.button:
                submit();
                break;
        }
    }

    private void submit() {
        String choose_person = chooseResult.getText().toString();
        String choose_time = chooseTimeArea.getText().toString();
        String choose_reason = reason.getText().toString();
        if (TextUtils.isEmpty(choose_reason)) {
            Toast.makeText(this, "请输入调班原因", Toast.LENGTH_SHORT).show();
            return;
        }
        if (choose_time.equals("选择您要调整的时间段")) {
            Toast.makeText(this, "请选择时间", Toast.LENGTH_SHORT).show();
            return;
        }
        if (choose_person.equals("请选择变更人")) {
            Toast.makeText(this, "请选择变更人", Toast.LENGTH_SHORT).show();
            return;
        }

        dutyPlanClient.tiaobanBean(choose_person,id,choose_reason,dutyTime).flatMap(new Function<TiaobanBean, ObservableSource<CCDutiesEdit>>() {
            @Override
            public ObservableSource<CCDutiesEdit> apply(@NonNull TiaobanBean tiaobanBean) throws Exception {
                if (choose_time.equals("08:30 - 12:00")) {
                    // morning
                    return dutyPlanClient.editMorning(id, morning.replace(Constant.USER_NAME, choose_person));
                } else if (choose_time.equals("12:00 - 18:30")){
                    // noon
                    return dutyPlanClient.editNoon(id, noon.replace(Constant.USER_NAME, choose_person));
                } else {
                    // evening
                    return dutyPlanClient.editNight(id, evening.replace(Constant.USER_NAME, choose_person));
                }
            }
        }).subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new Consumer<CCDutiesEdit>() {
            @Override
            public void accept(CCDutiesEdit ccDutiesEdit) throws Exception {
                Toast.makeText(TiaoBanPublish.this, "申请成功", Toast.LENGTH_SHORT).show();
                finish();
            }
        },Throwable::printStackTrace);
    }

    private void showTimeSelector() {
        List<String> times = new ArrayList<>(3);
        if (morning.contains(Constant.USER_NAME)) {
            times.add("08:30 - 12:00");
        }
        if (noon.contains(Constant.USER_NAME)) {
            times.add("12:00 - 18:30");
        }

        if (evening.contains(Constant.USER_NAME)) {
            times.add("18:30 - 08:30");
        }

        String[] strings = times.toArray(new String[0]);
        final AlertDialog publish_sign_type = new AlertDialog
                .Builder(this)
                .setTitle("请选择时间段")
                .setItems(strings, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                        chooseTimeArea.setText(strings[which]);
                    }
                })
                .create();

        publish_sign_type.show();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0x00 && data != null) {
            String id = data.getStringExtra("id");
            String name = data.getStringExtra("name");
            chooseResult.setText(name);
        }
    }

}
