package cn.bsl.bxbg.zhiban.view;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.adapter.DutyChangePeopleAdapter;
import cn.bsl.bxbg.zhiban.bean.AllPersonBean;
import cn.bsl.bxbg.zhiban.bean.TreeChildren;
import cn.bsl.bxbg.zhiban.net.client.AllPeopleClient;
import cn.bsl.bxbg.zhiban.utils.TreeNode;
import cn.bsl.bxbg.zhiban.utils.TreeNodeHelper;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DutyChangePeopleActivity extends BaseActivity implements AdapterView.OnItemClickListener{
    @BindView(R.id.dutyLv)
    ListView dutyLv;
    private TreeNode root;
    private AllPeopleClient dutyPlanClient = new AllPeopleClient();
    private List<AllPersonBean> allPersonBeen = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_duty_change_people);
        ButterKnife.bind(this);

        root = TreeNode.root();
        dutyPlanClient.stringCall().enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                try {
                    String string = response.body().string();
                    String replace = string.replace("\"children\":\"\"", "\"children\":[]");
                    List<TreeChildren> list = new Gson().fromJson(replace, new TypeToken<List<TreeChildren>>() {
                    }.getType());
                    TreeNode treeNode = TreeNodeHelper.buildTree(root, list);
                    for (int i = 0; i < treeNode.getChildren().size(); i++) {
                        List<TreeNode> dept = treeNode.getChildren().get(i).getChildren();
                        for (int idept = 0; idept < dept.size(); idept++) {
                            List<TreeNode> children = dept.get(idept).getChildren();
                            for (int i1 = 0; i1 < children.size(); i1++) {
                                TreeNode treeNode1 = children.get(i1);
                                if (treeNode1.isPerson()) {
                                    String id = treeNode1.getUserId();
                                    String value = (String) treeNode1.getValue();
                                    allPersonBeen.add(new AllPersonBean(id, value));
                                }

                            }
                        }
                    }


                } catch (IOException e) {
                    e.printStackTrace();
                }
                Collections.sort(allPersonBeen);
                dutyLv.setAdapter(new DutyChangePeopleAdapter(allPersonBeen));
                dutyLv.setOnItemClickListener(DutyChangePeopleActivity.this);
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                t.printStackTrace();
            }
        });

    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        Intent intent = new Intent();
        intent.putExtra("id", allPersonBeen.get(position).getUserId());
        intent.putExtra("name", allPersonBeen.get(position).getUserName());
        setResult(RESULT_OK,intent);
        finish();
    }
}
