package cn.bsl.bxbg.zhiban.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;

/**
 * Created by Xinghx on 2018/3/19 0019.
 */

public class ZbPeopleAdapter extends BaseAdapter {

    private List<CCDuties> ccDuties;

    public ZbPeopleAdapter(List<CCDuties> ccDuties) {
        this.ccDuties = ccDuties;
    }

    @Override
    public int getCount() {
        return ccDuties.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.item_zb_people, parent, false);
            viewHolder = new ViewHolder(convertView);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }
        viewHolder.zbLeaderName.setText(ccDuties.get(position).getClassLeaders());
        viewHolder.zbZaoName.setText(ccDuties.get(position).getMorning());
        viewHolder.zbZhongName.setText(ccDuties.get(position).getNoon());
        viewHolder.zbWanName.setText(ccDuties.get(position).getEvening());
        return convertView;
    }

    static class ViewHolder {
        @BindView(R.id.zb_leader_name)
        TextView zbLeaderName;
        @BindView(R.id.zb_zao_name)
        TextView zbZaoName;
        @BindView(R.id.zb_zhong_name)
        TextView zbZhongName;
        @BindView(R.id.zb_wan_name)
        TextView zbWanName;

        ViewHolder(View view) {
            ButterKnife.bind(this, view);
        }
    }
}
