/**
 * @desc 数据库定义文件
 * @author hm20160509
 * @date 2018/2/5
 */

const ModelSchema = {
  'CcDuty': {
    'model': 'CcDuty',
    'modelPlural': 'CcDuties',
    'modelCamel': 'ccDuty',
    'modelCamelPlural': 'ccDuties',
    'modelUnderscore': 'cc_duty',
    'modelUnderscorePlural': 'cc_duties',
    'columns': [
      {
        'id': 'o124',
        'objectId': '4CE4D5AC-D329-4893-B195-DD6A248B1AE4',
        'name': '值班人',
        'code': 'watch_people',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'watchPeople',
        'codeCamelPlural': 'watchPeople',
        'codeUnderscore': 'watch_people',
        'codeUnderscorePlural': 'watch_people',
        'type': 'string'
      },
      {
        'id': 'o125',
        'objectId': '64C558CE-347C-4234-880A-C98A8C6B404C',
        'name': '值班类型',
        'code': 'type',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o126',
        'objectId': 'FC331B64-AE43-41C5-8238-01395D64CD4A',
        'name': '值班日期',
        'code': 'duty_date',
        'creationDate': '1516606222',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'dutyDate',
        'codeCamelPlural': 'dutyDates',
        'codeUnderscore': 'duty_date',
        'codeUnderscorePlural': 'duty_dates',
        'type': 'string'
      },
      {
        'id': 'o127',
        'objectId': '0597CBC8-434D-4ABD-BBEB-52C694D06175',
        'name': '值班结束时间',
        'code': 'end_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'endTime',
        'codeCamelPlural': 'endTimes',
        'codeUnderscore': 'end_time',
        'codeUnderscorePlural': 'end_times',
        'type': 'datetime'
      },
      {
        'id': 'o128',
        'objectId': '9463E2F4-6629-4E0C-8AB3-4341476805C3',
        'name': '值班开始时间',
        'code': 'start_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'startTime',
        'codeCamelPlural': 'startTimes',
        'codeUnderscore': 'start_time',
        'codeUnderscorePlural': 'start_times',
        'type': 'datetime'
      },
      {
        'id': 'o129',
        'objectId': '188B1624-90ED-470A-8569-077DAFB874E9',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o130',
        'objectId': 'BD4635BE-C89F-41A0-9735-2EC694B643CE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o131',
        'objectId': 'E5D8D3FF-98CE-4478-A471-01494FC4AD15',
        'name': '值班计划id',
        'code': 'on_duty_plan_id',
        'creationDate': '1516589570',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'onDutyPlanId',
        'codeCamelPlural': 'onDutyPlanIds',
        'codeUnderscore': 'on_duty_plan_id',
        'codeUnderscorePlural': 'on_duty_plan_ids',
        'type': 'string'
      }
    ]
  },
  'CcDutyPlan': {
    'model': 'CcDutyPlan',
    'modelPlural': 'CcDutyPlans',
    'modelCamel': 'ccDutyPlan',
    'modelCamelPlural': 'ccDutyPlans',
    'modelUnderscore': 'cc_duty_plan',
    'modelUnderscorePlural': 'cc_duty_plans',
    'columns': [
      {
        'id': 'o134',
        'objectId': '6C6CC8AD-3B86-445C-A5CB-40098ED88CB2',
        'name': '计划名称',
        'code': 'name',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o135',
        'objectId': '1A1C287E-4E01-4FB5-9261-A59C5BA487A7',
        'name': '带班领导',
        'code': 'leadership',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'leadership',
        'codeCamelPlural': 'leaderships',
        'codeUnderscore': 'leadership',
        'codeUnderscorePlural': 'leaderships',
        'type': 'string'
      },
      {
        'id': 'o136',
        'objectId': '14FAD9EF-E0A5-4689-9008-4DF5BB68029C',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o137',
        'objectId': '5D48CD41-17EB-4F84-B750-7720700F4354',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcHmUser': {
    'model': 'CcHmUser',
    'modelPlural': 'CcHmUsers',
    'modelCamel': 'ccHmUser',
    'modelCamelPlural': 'ccHmUsers',
    'modelUnderscore': 'cc_hm_user',
    'modelUnderscorePlural': 'cc_hm_users',
    'columns': [
      {
        'id': 'o140',
        'objectId': '8FD46305-665A-4D68-8CEB-C8F3B21E68D4',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o141',
        'objectId': 'BC0164C2-8A2C-49AE-82B9-23BD14C5CD60',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o142',
        'objectId': 'AAFD7A92-2C66-4338-AD57-D73DC1A31EE6',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o143',
        'objectId': '9238B77C-2B6C-4EC8-89D9-F81D1D5087AB',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o144',
        'objectId': '0320FE5F-5DDA-431C-B335-05DB1AA7201F',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o145',
        'objectId': '785AD6EA-F1F6-4D7F-9E9A-59A73238B85E',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o146',
        'objectId': 'D8832FE5-60F6-47A8-BF3D-1DC0925BFF72',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o147',
        'objectId': 'A5C75EEB-C768-4ABF-98BC-6E8D17B68DAF',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o148',
        'objectId': 'DFD8E29B-7F7C-4280-862F-562410237BAC',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o149',
        'objectId': '9DB750AC-1723-4CA8-B948-BD3F22A23327',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o150',
        'objectId': '8639104D-24E4-4AF2-AC9E-D7E52DCFA585',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o151',
        'objectId': 'FF38874B-464D-43BC-9EBC-D46D2E89C1D2',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcShift': {
    'model': 'CcShift',
    'modelPlural': 'CcShifts',
    'modelCamel': 'ccShift',
    'modelCamelPlural': 'ccShifts',
    'modelUnderscore': 'cc_shift',
    'modelUnderscorePlural': 'cc_shifts',
    'columns': [
      {
        'id': 'o154',
        'objectId': '19389CBA-9CC7-4509-89A6-C3F81B8329B3',
        'name': '申请人',
        'code': 'applicant_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'applicantId',
        'codeCamelPlural': 'applicantIds',
        'codeUnderscore': 'applicant_id',
        'codeUnderscorePlural': 'applicant_ids',
        'type': 'string'
      },
      {
        'id': 'o155',
        'objectId': '57567B7E-A992-4EE3-8895-76F6AC510AF6',
        'name': '被调班人',
        'code': 'transferred_class_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'transferredClassId',
        'codeCamelPlural': 'transferredClassIds',
        'codeUnderscore': 'transferred_class_id',
        'codeUnderscorePlural': 'transferred_class_ids',
        'type': 'string'
      },
      {
        'id': 'o156',
        'objectId': '39906390-F7B4-49E9-8C93-F83E15653C98',
        'name': '申请人值班id',
        'code': 'applicant_duty_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'applicantDutyId',
        'codeCamelPlural': 'applicantDutyIds',
        'codeUnderscore': 'applicant_duty_id',
        'codeUnderscorePlural': 'applicant_duty_ids',
        'type': 'string'
      },
      {
        'id': 'o157',
        'objectId': '62279FC3-9336-4B17-8FC8-67A05FEEE83D',
        'name': '被调班值班id',
        'code': 'transferred_class_duty_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'transferredClassDutyId',
        'codeCamelPlural': 'transferredClassDutyIds',
        'codeUnderscore': 'transferred_class_duty_id',
        'codeUnderscorePlural': 'transferred_class_duty_ids',
        'type': 'string'
      },
      {
        'id': 'o158',
        'objectId': 'D0EF4EC4-7385-45AC-87A5-1C02AB5183A0',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o159',
        'objectId': '7F1CAFB0-493E-465F-B922-D3F4C49843C5',
        'name': '调班原因',
        'code': 'reason',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'reason',
        'codeCamelPlural': 'reasons',
        'codeUnderscore': 'reason',
        'codeUnderscorePlural': 'reasons',
        'type': 'string'
      },
      {
        'id': 'o160',
        'objectId': 'DE6B4DC4-4B20-4042-A1BD-2E9872164FCE',
        'name': '审批人',
        'code': 'approver',
        'creationDate': '1516619603',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approver',
        'codeCamelPlural': 'approvers',
        'codeUnderscore': 'approver',
        'codeUnderscorePlural': 'approvers',
        'type': 'string'
      },
      {
        'id': 'o161',
        'objectId': 'D53FD831-3BB8-434A-AF1F-2A301A323F18',
        'name': '申请时间',
        'code': 'application_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'applicationTime',
        'codeCamelPlural': 'applicationTimes',
        'codeUnderscore': 'application_time',
        'codeUnderscorePlural': 'application_times',
        'type': 'datetime'
      },
      {
        'id': 'o162',
        'objectId': '25805415-3B22-4C21-B698-968794882B62',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o163',
        'objectId': '196F37A9-5D5F-4E7F-BD95-9B48CCC63DA4',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcOfficialDocuments': {
    'model': 'CcOfficialDocuments',
    'modelPlural': 'CcOfficialDocuments',
    'modelCamel': 'ccOfficialDocuments',
    'modelCamelPlural': 'ccOfficialDocuments',
    'modelUnderscore': 'cc_official_documents',
    'modelUnderscorePlural': 'cc_official_documents',
    'columns': [
      {
        'id': 'o166',
        'objectId': '47B0F2AE-E08A-4DEC-90B0-373E2509BAB9',
        'name': '文件名称',
        'code': 'name',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o167',
        'objectId': 'BC4DE0AA-526B-4B6E-A2DF-B2650395F113',
        'name': '文件类型',
        'code': 'type',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o168',
        'objectId': '468FE5CE-A271-4F33-9216-0AB0BCAA6956',
        'name': '文件路径',
        'code': 'path',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'path',
        'codeCamelPlural': 'paths',
        'codeUnderscore': 'path',
        'codeUnderscorePlural': 'paths',
        'type': 'string'
      },
      {
        'id': 'o169',
        'objectId': 'A3D1E7EC-F57F-43E3-A499-8506515EA0BD',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o170',
        'objectId': 'CF59986C-5C74-4325-A568-48CA91A6AF71',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o171',
        'objectId': '5129706E-65B9-49BC-9834-E5C2B8CE1269',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcDocumentCirculationApproval': {
    'model': 'CcDocumentCirculationApproval',
    'modelPlural': 'CcDocumentCirculationApprovals',
    'modelCamel': 'ccDocumentCirculationApproval',
    'modelCamelPlural': 'ccDocumentCirculationApprovals',
    'modelUnderscore': 'cc_document_circulation_approval',
    'modelUnderscorePlural': 'cc_document_circulation_approvals',
    'columns': [
      {
        'id': 'o174',
        'objectId': 'EFB78600-3FF9-4D58-AEF2-F4EC27E81FC4',
        'name': '来文单位',
        'code': 'communications_unit',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'communicationsUnit',
        'codeCamelPlural': 'communicationsUnits',
        'codeUnderscore': 'communications_unit',
        'codeUnderscorePlural': 'communications_units',
        'type': 'string'
      },
      {
        'id': 'o175',
        'objectId': 'B5A67378-3A88-4575-BE71-4F04AD18D622',
        'name': '签发处室',
        'code': 'lssued_room',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'lssuedRoom',
        'codeCamelPlural': 'lssuedRooms',
        'codeUnderscore': 'lssued_room',
        'codeUnderscorePlural': 'lssued_rooms',
        'type': 'string'
      },
      {
        'id': 'o176',
        'objectId': 'EF12637F-0619-4F5E-BBCC-46D2D4AB22E6',
        'name': '公文编号',
        'code': 'document_number',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'documentNumber',
        'codeCamelPlural': 'documentNumbers',
        'codeUnderscore': 'document_number',
        'codeUnderscorePlural': 'document_numbers',
        'type': 'string'
      },
      {
        'id': 'o177',
        'objectId': 'B4165EF4-73FB-45F3-A7A0-683AA3EF79A0',
        'name': '公文标题',
        'code': 'official_title',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'officialTitle',
        'codeCamelPlural': 'officialTitles',
        'codeUnderscore': 'official_title',
        'codeUnderscorePlural': 'official_titles',
        'type': 'string'
      },
      {
        'id': 'o178',
        'objectId': '008CB669-6EC8-4360-AEBA-3B2CAEB7B9E4',
        'name': '拟办意见',
        'code': 'proposed_advice',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'proposedAdvice',
        'codeCamelPlural': 'proposedAdvices',
        'codeUnderscore': 'proposed_advice',
        'codeUnderscorePlural': 'proposed_advices',
        'type': 'string'
      },
      {
        'id': 'o179',
        'objectId': 'CBDB4ADD-E390-41D2-8430-5327B45A9908',
        'name': '审批人',
        'code': 'approver',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approver',
        'codeCamelPlural': 'approvers',
        'codeUnderscore': 'approver',
        'codeUnderscorePlural': 'approvers',
        'type': 'string'
      },
      {
        'id': 'o180',
        'objectId': '31D91995-9E37-4AD0-83D4-9B0ECEE85A91',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o181',
        'objectId': '0BF41682-6B35-4C23-9FD2-F6D746B41EF7',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o182',
        'objectId': 'FB756629-0212-47F1-A8CE-BF603434B471',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o183',
        'objectId': 'B24C2912-8D7A-4DD6-9BE3-0A9DE42D2260',
        'name': '流转状态',
        'code': 'circulation_state',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'comment': '是否流转',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'circulationState',
        'codeCamelPlural': 'circulationStates',
        'codeUnderscore': 'circulation_state',
        'codeUnderscorePlural': 'circulation_states',
        'type': 'string'
      },
      {
        'id': 'o184',
        'objectId': 'FB513329-FAB9-4727-9439-C3BBE56C0568',
        'name': '上个流转id',
        'code': 'prev_id',
        'creationDate': '1516622793',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'prevId',
        'codeCamelPlural': 'prevIds',
        'codeUnderscore': 'prev_id',
        'codeUnderscorePlural': 'prev_ids',
        'type': 'string'
      },
      {
        'id': 'o185',
        'objectId': '135AE37A-2AA4-4241-992F-0CB0F0C1160E',
        'name': '审批状态',
        'code': 'approval_status',
        'creationDate': '1516622924',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'approvalStatus',
        'codeCamelPlural': 'approvalStatuses',
        'codeUnderscore': 'approval_status',
        'codeUnderscorePlural': 'approval_statuses',
        'type': 'string'
      }
    ]
  },
  'CcOfficialDocumentsAnnex': {
    'model': 'CcOfficialDocumentsAnnex',
    'modelPlural': 'CcOfficialDocumentsAnnexes',
    'modelCamel': 'ccOfficialDocumentsAnnex',
    'modelCamelPlural': 'ccOfficialDocumentsAnnexes',
    'modelUnderscore': 'cc_official_documents_annex',
    'modelUnderscorePlural': 'cc_official_documents_annexes',
    'columns': [
      {
        'id': 'o188',
        'objectId': '544B7417-98F0-46EC-9A05-E258B508A7B3',
        'name': '文件',
        'code': 'file_id',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o189',
        'objectId': 'E3D32F81-319D-4295-93BA-50128DE34167',
        'name': '公文流转审批id',
        'code': 'document_approval_id',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'documentApprovalId',
        'codeCamelPlural': 'documentApprovalIds',
        'codeUnderscore': 'document_approval_id',
        'codeUnderscorePlural': 'document_approval_ids',
        'type': 'string'
      },
      {
        'id': 'o190',
        'objectId': '3D39FB62-AACE-4AB1-8C98-7137FAF96B59',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o191',
        'objectId': '2CB73EA7-90C5-4960-A966-E90164572460',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMsMemorabilia': {
    'model': 'CcMsMemorabilia',
    'modelPlural': 'CcMsMemorabilias',
    'modelCamel': 'ccMsMemorabilia',
    'modelCamelPlural': 'ccMsMemorabilias',
    'modelUnderscore': 'cc_ms_memorabilia',
    'modelUnderscorePlural': 'cc_ms_memorabilias',
    'columns': [
      {
        'id': 'o194',
        'objectId': '70C99D13-DCD5-4346-866A-55813A32E2AC',
        'name': '分类',
        'code': 'type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o195',
        'objectId': 'CA0C6F6F-2EAD-4C5B-B9E0-C7B3BC4B2414',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o196',
        'objectId': '1E628551-E99D-4F47-B915-81D50F239105',
        'name': '正文',
        'code': 'text',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'text',
        'codeCamelPlural': 'texts',
        'codeUnderscore': 'text',
        'codeUnderscorePlural': 'texts',
        'type': 'string'
      },
      {
        'id': 'o197',
        'objectId': '49CA7DBC-D47A-47F3-BF8F-341FA39EFF6F',
        'name': '附件',
        'code': 'annex',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'annex',
        'codeCamelPlural': 'annexes',
        'codeUnderscore': 'annex',
        'codeUnderscorePlural': 'annexes',
        'type': 'string'
      },
      {
        'id': 'o198',
        'objectId': '02D6977B-D4F1-465E-B81B-AC5785835530',
        'name': '文件',
        'code': 'file',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'file',
        'codeCamelPlural': 'files',
        'codeUnderscore': 'file',
        'codeUnderscorePlural': 'files',
        'type': 'string'
      },
      {
        'id': 'o199',
        'objectId': '85611331-685C-47D2-B142-CA0070BF53B4',
        'name': '文字描述',
        'code': 'remarks',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o200',
        'objectId': 'C75E01CE-442E-485A-949C-6F54CEFC5995',
        'name': '发布类型',
        'code': 'release_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'releaseType',
        'codeCamelPlural': 'releaseTypes',
        'codeUnderscore': 'release_type',
        'codeUnderscorePlural': 'release_types',
        'type': 'number'
      },
      {
        'id': 'o201',
        'objectId': 'FABCD839-BA2F-4D6B-AE93-4A77895754AA',
        'name': '发布时间',
        'code': 'release_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'releaseTime',
        'codeCamelPlural': 'releaseTimes',
        'codeUnderscore': 'release_time',
        'codeUnderscorePlural': 'release_times',
        'type': 'datetime'
      },
      {
        'id': 'o202',
        'objectId': '50A41678-8487-4108-B498-A81B77EA4229',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o203',
        'objectId': '7B52322F-93ED-4682-BD17-576144DB8BD6',
        'name': '是否发布',
        'code': 'is_release',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'isRelease',
        'codeCamelPlural': 'isReleases',
        'codeUnderscore': 'is_release',
        'codeUnderscorePlural': 'is_releases',
        'type': 'number'
      },
      {
        'id': 'o204',
        'objectId': '17F9B255-E031-47D1-8934-600358441907',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o205',
        'objectId': 'C0A3187D-FFA1-4013-B08F-B76ADE23977E',
        'name': '保存草稿时间',
        'code': 'save_draft_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'saveDraftTime',
        'codeCamelPlural': 'saveDraftTimes',
        'codeUnderscore': 'save_draft_time',
        'codeUnderscorePlural': 'save_draft_times',
        'type': 'datetime'
      },
      {
        'id': 'o206',
        'objectId': '75393C40-B82B-44DC-B0BE-97323D9C227C',
        'name': '是否显示在专网首页',
        'code': 'is_show_home',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'isShowHome',
        'codeCamelPlural': 'isShowHomes',
        'codeUnderscore': 'is_show_home',
        'codeUnderscorePlural': 'is_show_homes',
        'type': 'datetime'
      },
      {
        'id': 'o207',
        'objectId': '69FFF59C-92B7-45B2-A4F4-1EBF8E9EC94D',
        'name': '附件类型',
        'code': 'annex_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'annexType',
        'codeCamelPlural': 'annexTypes',
        'codeUnderscore': 'annex_type',
        'codeUnderscorePlural': 'annex_types',
        'type': 'number'
      },
      {
        'id': 'o208',
        'objectId': 'CF2EB293-1240-4AB6-AB67-C5FF5E7996EA',
        'name': '文件类型',
        'code': 'file_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'fileType',
        'codeCamelPlural': 'fileTypes',
        'codeUnderscore': 'file_type',
        'codeUnderscorePlural': 'file_types',
        'type': 'number'
      },
      {
        'id': 'o209',
        'objectId': '88281CE3-74BF-4BF0-8B9A-87684B013B9F',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516619369',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      }
    ]
  },
  'CcWorkCircle': {
    'model': 'CcWorkCircle',
    'modelPlural': 'CcWorkCircles',
    'modelCamel': 'ccWorkCircle',
    'modelCamelPlural': 'ccWorkCircles',
    'modelUnderscore': 'cc_work_circle',
    'modelUnderscorePlural': 'cc_work_circles',
    'columns': [
      {
        'id': 'o212',
        'objectId': '6C6D9E0D-D9C9-40AE-911C-B25337502036',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o213',
        'objectId': 'D9D5066A-F607-4705-B266-186D838E73D1',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o214',
        'objectId': '006127A6-9741-48F9-AEF6-065C34161599',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o215',
        'objectId': '79EE9EFC-F6BE-466F-AC14-94AF0D44DCD6',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o216',
        'objectId': 'AAB2B820-965E-4D09-938A-6C575FF54C6E',
        'name': '描述',
        'code': 'remarks',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcUser': {
    'model': 'CcUser',
    'modelPlural': 'CcUsers',
    'modelCamel': 'ccUser',
    'modelCamelPlural': 'ccUsers',
    'modelUnderscore': 'cc_user',
    'modelUnderscorePlural': 'cc_users',
    'columns': [
      {
        'id': 'o219',
        'objectId': 'D3866FB1-2265-43F3-8F9B-15CBDCACA12A',
        'name': '圈子成员',
        'code': 'user_id',
        'creationDate': '1516594354',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o220',
        'objectId': 'DF72B6F2-918F-4547-90A4-67144C51E45E',
        'name': '所属圈子',
        'code': 'cc_work_circle_id',
        'creationDate': '1516594354',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccWorkCircleId',
        'codeCamelPlural': 'ccWorkCircleIds',
        'codeUnderscore': 'cc_work_circle_id',
        'codeUnderscorePlural': 'cc_work_circle_ids',
        'type': 'string'
      },
      {
        'id': 'o221',
        'objectId': '1754F7DA-144D-4EC0-9E95-0BB94289B3C8',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594406',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o222',
        'objectId': '20D3FD45-2B50-494F-9A78-C3F0DA80DF30',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594406',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageTaskActivity': {
    'model': 'CcMessageTaskActivity',
    'modelPlural': 'CcMessageTaskActivities',
    'modelCamel': 'ccMessageTaskActivity',
    'modelCamelPlural': 'ccMessageTaskActivities',
    'modelUnderscore': 'cc_message_task_activity',
    'modelUnderscorePlural': 'cc_message_task_activities',
    'columns': [
      {
        'id': 'o225',
        'objectId': '05E61AB7-A96C-46C2-86E1-91CBFE2279F6',
        'name': '所属圈子',
        'code': 'cc_work_circle_id',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccWorkCircleId',
        'codeCamelPlural': 'ccWorkCircleIds',
        'codeUnderscore': 'cc_work_circle_id',
        'codeUnderscorePlural': 'cc_work_circle_ids',
        'type': 'string'
      },
      {
        'id': 'o226',
        'objectId': 'D9D071F7-9FEA-4D22-BD93-0EC1BBB93684',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o227',
        'objectId': 'D224F3AC-EC14-4832-AB35-E8A436D0A5FC',
        'name': '正文',
        'code': 'text',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'text',
        'codeCamelPlural': 'texts',
        'codeUnderscore': 'text',
        'codeUnderscorePlural': 'texts',
        'type': 'string'
      },
      {
        'id': 'o228',
        'objectId': '9D965B45-FEA3-4E16-AB7E-926C37E2DF6A',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o229',
        'objectId': 'FFAA470C-F23E-4C0B-A904-3E715122C5B3',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o230',
        'objectId': '2354FD56-7927-4398-828E-234F9CAD4928',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516594995',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o231',
        'objectId': 'AB6A1FD6-BD77-45EB-91C9-171E71817818',
        'name': '类型',
        'code': 'type',
        'creationDate': '1516595889',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      }
    ]
  },
  'CcPraise': {
    'model': 'CcPraise',
    'modelPlural': 'CcPraises',
    'modelCamel': 'ccPraise',
    'modelCamelPlural': 'ccPraises',
    'modelUnderscore': 'cc_praise',
    'modelUnderscorePlural': 'cc_praises',
    'columns': [
      {
        'id': 'o234',
        'objectId': '86575B62-8B13-4882-8CA5-40A5ECEF777F',
        'name': '所属消息、任务、活动',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o235',
        'objectId': '0CF9E7F7-CABB-41C9-B439-B17B8F859DE2',
        'name': '点赞人',
        'code': 'user_id',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o236',
        'objectId': '25ACA4A5-824D-4A72-A940-AD9F1B9368B5',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o237',
        'objectId': '72453E19-F7D3-4CC0-A603-14F9E63EF8FB',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageReply': {
    'model': 'CcMessageReply',
    'modelPlural': 'CcMessageReplies',
    'modelCamel': 'ccMessageReply',
    'modelCamelPlural': 'ccMessageReplies',
    'modelUnderscore': 'cc_message_reply',
    'modelUnderscorePlural': 'cc_message_replies',
    'columns': [
      {
        'id': 'o240',
        'objectId': '96C59171-D6D3-41D7-8B92-A11DC8EECD8A',
        'name': '点评人',
        'code': 'user_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o241',
        'objectId': '0584C677-B98E-4F24-8B9D-CCC7376BE6C9',
        'name': '回复消息回复',
        'code': 'cc_message_reply_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageReplyId',
        'codeCamelPlural': 'ccMessageReplyIds',
        'codeUnderscore': 'cc_message_reply_id',
        'codeUnderscorePlural': 'cc_message_reply_ids',
        'type': 'string'
      },
      {
        'id': 'o242',
        'objectId': '7A74B43C-797A-4683-9F58-A45EBABADF03',
        'name': '所属消息、任务、活动',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o243',
        'objectId': '7B3A3A4A-603D-4C02-BFD6-1CFFF6302DCB',
        'name': '回复内容',
        'code': 'content',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o244',
        'objectId': '16B835F9-1268-4F07-B643-74594491FBE0',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o245',
        'objectId': '45ECB100-8A04-4003-88F7-5C695458D7F1',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o246',
        'objectId': 'AE4183AD-664C-45AF-BFDD-4FEF5AC4A13F',
        'name': '消息类型',
        'code': 'type',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      }
    ]
  },
  'CcMessageReplyStatus': {
    'model': 'CcMessageReplyStatus',
    'modelPlural': 'CcMessageReplyStatuses',
    'modelCamel': 'ccMessageReplyStatus',
    'modelCamelPlural': 'ccMessageReplyStatuses',
    'modelUnderscore': 'cc_message_reply_status',
    'modelUnderscorePlural': 'cc_message_reply_statuses',
    'columns': [
      {
        'id': 'o249',
        'objectId': '045C40F0-4EA3-41B3-ABBB-F36029B53EB6',
        'name': '回复消息id',
        'code': 'cc_message_reply_id',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageReplyId',
        'codeCamelPlural': 'ccMessageReplyIds',
        'codeUnderscore': 'cc_message_reply_id',
        'codeUnderscorePlural': 'cc_message_reply_ids',
        'type': 'string'
      },
      {
        'id': 'o250',
        'objectId': '3A0D90FA-5AE1-4258-8D3D-AF5CC68C450D',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o251',
        'objectId': '97B515F5-FE19-49A3-94C0-171F3C3DE4A7',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o252',
        'objectId': '285753FA-3BE5-44DC-80CA-B471CC43326B',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageTaskActivityParticipate': {
    'model': 'CcMessageTaskActivityParticipate',
    'modelPlural': 'CcMessageTaskActivityParticipates',
    'modelCamel': 'ccMessageTaskActivityParticipate',
    'modelCamelPlural': 'ccMessageTaskActivityParticipates',
    'modelUnderscore': 'cc_message_task_activity_participate',
    'modelUnderscorePlural': 'cc_message_task_activity_participates',
    'columns': [
      {
        'id': 'o255',
        'objectId': '9DB774B5-0077-4907-BB26-2EC65377DF28',
        'name': '参与人',
        'code': 'user_id',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o256',
        'objectId': 'A6D0A38D-BCE1-4A1C-85D2-FECB935D118E',
        'name': '参与的活动id',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o257',
        'objectId': 'BF382D92-97A2-4674-9F84-AE021E6FB4C7',
        'name': '参与的操作',
        'code': 'content',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(5000)',
        'length': '5000',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o258',
        'objectId': 'EB25C8E0-2DE7-4A42-B1D6-8A52C37C530C',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o259',
        'objectId': '448CB49C-F216-403E-8A30-33F7288BEAAD',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcTotalCall': {
    'model': 'CcTotalCall',
    'modelPlural': 'CcTotalCalls',
    'modelCamel': 'ccTotalCall',
    'modelCamelPlural': 'ccTotalCalls',
    'modelUnderscore': 'cc_total_call',
    'modelUnderscorePlural': 'cc_total_calls',
    'columns': [
      {
        'id': 'o262',
        'objectId': '79F09FDE-9E09-4384-815A-C38905BF62CA',
        'name': '单位',
        'code': 'unit',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'unit',
        'codeCamelPlural': 'units',
        'codeUnderscore': 'unit',
        'codeUnderscorePlural': 'units',
        'type': 'string'
      },
      {
        'id': 'o263',
        'objectId': 'DF10A595-456D-4173-90E9-30CBB12D6E52',
        'name': '部门',
        'code': 'department',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'department',
        'codeCamelPlural': 'departments',
        'codeUnderscore': 'department',
        'codeUnderscorePlural': 'departments',
        'type': 'string'
      },
      {
        'id': 'o264',
        'objectId': '4507C1A9-D760-4524-AFF4-EA1CA29C1083',
        'name': '电话',
        'code': 'phone',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'phone',
        'codeCamelPlural': 'phones',
        'codeUnderscore': 'phone',
        'codeUnderscorePlural': 'phones',
        'type': 'string'
      },
      {
        'id': 'o265',
        'objectId': '5E21807E-A911-4F9B-B3F0-32AB6A1D35C8',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o266',
        'objectId': '534FE4EC-50DE-47C6-A0E2-494B84241D6C',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcSecondaryMenuDictionary': {
    'model': 'CcSecondaryMenuDictionary',
    'modelPlural': 'CcSecondaryMenuDictionaries',
    'modelCamel': 'ccSecondaryMenuDictionary',
    'modelCamelPlural': 'ccSecondaryMenuDictionaries',
    'modelUnderscore': 'cc_secondary_menu_dictionary',
    'modelUnderscorePlural': 'cc_secondary_menu_dictionaries',
    'columns': [
      {
        'id': 'o269',
        'objectId': '7A26DCC7-2195-41E0-A59B-53B820FE5445',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o270',
        'objectId': 'BCE0151C-8F72-4432-8B34-79DF52F14688',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o271',
        'objectId': '77960568-7F94-4C3B-8C18-655887B5E793',
        'name': '最后更新时间',
        'code': 'lst_update_time',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lstUpdateTime',
        'codeCamelPlural': 'lstUpdateTimes',
        'codeUnderscore': 'lst_update_time',
        'codeUnderscorePlural': 'lst_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMenuResources': {
    'model': 'CcMenuResources',
    'modelPlural': 'CcMenuResources',
    'modelCamel': 'ccMenuResources',
    'modelCamelPlural': 'ccMenuResources',
    'modelUnderscore': 'cc_menu_resources',
    'modelUnderscorePlural': 'cc_menu_resources',
    'columns': [
      {
        'id': 'o274',
        'objectId': 'E0232D85-FABA-42B1-8E1E-E21D4A7A5B62',
        'name': '文件名称',
        'code': 'name',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o275',
        'objectId': 'F978196E-61EA-4F93-B9C7-66DBBA794D3A',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o276',
        'objectId': '777D6C5D-5A54-4171-94E7-F737B8B60C18',
        'name': '简介',
        'code': 'lntroduction',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'lntroduction',
        'codeCamelPlural': 'lntroductions',
        'codeUnderscore': 'lntroduction',
        'codeUnderscorePlural': 'lntroductions',
        'type': 'string'
      },
      {
        'id': 'o277',
        'objectId': '33449CD4-C227-42EB-95D6-EAF42CA5DB94',
        'name': '发布人',
        'code': 'publisher',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'publisher',
        'codeCamelPlural': 'publishers',
        'codeUnderscore': 'publisher',
        'codeUnderscorePlural': 'publishers',
        'type': 'string'
      },
      {
        'id': 'o278',
        'objectId': 'F87A9677-66F1-435F-86AE-CE357552FAC9',
        'name': '类型',
        'code': 'type',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o279',
        'objectId': 'A264D410-B6AF-44A3-8DE4-D96F893501D5',
        'name': '缩略图',
        'code': 'thumbnail',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'thumbnail',
        'codeCamelPlural': 'thumbnails',
        'codeUnderscore': 'thumbnail',
        'codeUnderscorePlural': 'thumbnails',
        'type': 'string'
      },
      {
        'id': 'o280',
        'objectId': '9F014F8E-09D7-4930-AB28-FF747BEE0A9B',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o281',
        'objectId': '8666BD33-451B-4EB4-85F9-E386BBAE510F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMenuResourceAssociation': {
    'model': 'CcMenuResourceAssociation',
    'modelPlural': 'CcMenuResourceAssociations',
    'modelCamel': 'ccMenuResourceAssociation',
    'modelCamelPlural': 'ccMenuResourceAssociations',
    'modelUnderscore': 'cc_menu_resource_association',
    'modelUnderscorePlural': 'cc_menu_resource_associations',
    'columns': [
      {
        'id': 'o284',
        'objectId': 'D1CF9181-9FEF-4338-8709-FE81BBA2D904',
        'name': '菜单id',
        'code': 'menu_id',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517187173',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'menuId',
        'codeCamelPlural': 'menuIds',
        'codeUnderscore': 'menu_id',
        'codeUnderscorePlural': 'menu_ids',
        'type': 'string'
      },
      {
        'id': 'o285',
        'objectId': '57FD053C-2DF9-4CEC-B2F8-E09680CC5D75',
        'name': '资源id',
        'code': 'resource_id',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'resourceId',
        'codeCamelPlural': 'resourceIds',
        'codeUnderscore': 'resource_id',
        'codeUnderscorePlural': 'resource_ids',
        'type': 'string'
      },
      {
        'id': 'o286',
        'objectId': '17F85474-8F01-409C-9EB2-EFCCAB8A84C5',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o287',
        'objectId': '1379ECE0-5237-48E6-9735-06C3793F5828',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcProcuratorate': {
    'model': 'CcProcuratorate',
    'modelPlural': 'CcProcuratorates',
    'modelCamel': 'ccProcuratorate',
    'modelCamelPlural': 'ccProcuratorates',
    'modelUnderscore': 'cc_procuratorate',
    'modelUnderscorePlural': 'cc_procuratorates',
    'columns': [
      {
        'id': 'o290',
        'objectId': '117CBCF2-0EAA-40A2-8BA7-5F1FA4877106',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o291',
        'objectId': 'A1BCCC38-F837-4877-A054-DEE89EBCBDC1',
        'name': 'icon标题',
        'code': 'icon_tile',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'iconTile',
        'codeCamelPlural': 'iconTiles',
        'codeUnderscore': 'icon_tile',
        'codeUnderscorePlural': 'icon_tiles',
        'type': 'string'
      },
      {
        'id': 'o292',
        'objectId': '4E81C6E7-BCCF-43C5-AD44-E3DC1B1CA581',
        'name': '官方网站',
        'code': 'official_website',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'officialWebsite',
        'codeCamelPlural': 'officialWebsites',
        'codeUnderscore': 'official_website',
        'codeUnderscorePlural': 'official_websites',
        'type': 'string'
      },
      {
        'id': 'o293',
        'objectId': '6777DEE4-A6C0-438D-9485-5F610A28AD13',
        'name': '上级id',
        'code': 'parent_id',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'parentId',
        'codeCamelPlural': 'parentIds',
        'codeUnderscore': 'parent_id',
        'codeUnderscorePlural': 'parent_ids',
        'type': 'string'
      },
      {
        'id': 'o294',
        'objectId': 'C32E15A6-0A42-4A95-861E-4E2543C82C34',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o295',
        'objectId': 'E0D22E4E-8B11-410C-9C24-7BE8DF5D77CE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o296',
        'objectId': 'FF50B21F-8BF7-4A60-A9E1-957326C99A9C',
        'name': '简介',
        'code': 'Introduction',
        'creationDate': '1516624111',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'introduction',
        'codeCamelPlural': 'introductions',
        'codeUnderscore': 'introduction',
        'codeUnderscorePlural': 'introductions',
        'type': 'string'
      }
    ]
  },
  'CcDigitalBook': {
    'model': 'CcDigitalBook',
    'modelPlural': 'CcDigitalBooks',
    'modelCamel': 'ccDigitalBook',
    'modelCamelPlural': 'ccDigitalBooks',
    'modelUnderscore': 'cc_digital_book',
    'modelUnderscorePlural': 'cc_digital_books',
    'columns': [
      {
        'id': 'o299',
        'objectId': 'A91EB68C-DCD0-42FB-8837-9C59A9B21D1B',
        'name': '书名',
        'code': 'book_name',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'bookName',
        'codeCamelPlural': 'bookNames',
        'codeUnderscore': 'book_name',
        'codeUnderscorePlural': 'book_names',
        'type': 'string'
      },
      {
        'id': 'o300',
        'objectId': 'DA394B8E-04B2-4926-A6EF-B822E85E62A9',
        'name': '作者',
        'code': 'author',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'author',
        'codeCamelPlural': 'authors',
        'codeUnderscore': 'author',
        'codeUnderscorePlural': 'authors',
        'type': 'string'
      },
      {
        'id': 'o301',
        'objectId': '2B373844-8096-4BA5-8BC9-EF60235E687C',
        'name': '出版社',
        'code': 'publishing_house',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'publishingHouse',
        'codeCamelPlural': 'publishingHouses',
        'codeUnderscore': 'publishing_house',
        'codeUnderscorePlural': 'publishing_houses',
        'type': 'string'
      },
      {
        'id': 'o302',
        'objectId': '201A205C-89C4-4851-A884-535F49ACDAC5',
        'name': '出版年代',
        'code': 'year_publication',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'yearPublication',
        'codeCamelPlural': 'yearPublications',
        'codeUnderscore': 'year_publication',
        'codeUnderscorePlural': 'year_publications',
        'type': 'string'
      },
      {
        'id': 'o303',
        'objectId': 'DA677C68-2771-4D03-AAB9-45BB2CBA4E72',
        'name': '书籍类型',
        'code': 'type',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o304',
        'objectId': '795AAF47-9471-478E-81B0-DB8DA46C4943',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o305',
        'objectId': 'B73B0F2F-793C-4A2A-B5A2-B72223DD5AD0',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcLogging': {
    'model': 'CcLogging',
    'modelPlural': 'CcLoggings',
    'modelCamel': 'ccLogging',
    'modelCamelPlural': 'ccLoggings',
    'modelUnderscore': 'cc_logging',
    'modelUnderscorePlural': 'cc_loggings',
    'columns': [
      {
        'id': 'o308',
        'objectId': '19ED900A-55C6-478F-8C06-F736670CA88D',
        'name': '操作人',
        'code': 'operator',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'operator',
        'codeCamelPlural': 'operators',
        'codeUnderscore': 'operator',
        'codeUnderscorePlural': 'operators',
        'type': 'string'
      },
      {
        'id': 'o309',
        'objectId': '793DF0F3-5276-49DF-9A22-BA5081BA0052',
        'name': '登录时间段',
        'code': 'login_time_period',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'loginTimePeriod',
        'codeCamelPlural': 'loginTimePeriods',
        'codeUnderscore': 'login_time_period',
        'codeUnderscorePlural': 'login_time_periods',
        'type': 'datetime'
      },
      {
        'id': 'o310',
        'objectId': 'AD6E90D6-D196-430B-A7A4-08C48807ACDB',
        'name': '操作时间段',
        'code': 'operating_time_period',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'operatingTimePeriod',
        'codeCamelPlural': 'operatingTimePeriods',
        'codeUnderscore': 'operating_time_period',
        'codeUnderscorePlural': 'operating_time_periods',
        'type': 'datetime'
      },
      {
        'id': 'o311',
        'objectId': 'F0E2D7DB-BDE3-4AF8-931B-33754C5E4CF5',
        'name': '登录类型',
        'code': 'login_type',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'loginType',
        'codeCamelPlural': 'loginTypes',
        'codeUnderscore': 'login_type',
        'codeUnderscorePlural': 'login_types',
        'type': 'number'
      },
      {
        'id': 'o312',
        'objectId': '33DD0885-D4B4-4850-8707-B025A64E461E',
        'name': '操作类型',
        'code': 'type_operation',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'typeOperation',
        'codeCamelPlural': 'typeOperations',
        'codeUnderscore': 'type_operation',
        'codeUnderscorePlural': 'type_operations',
        'type': 'string'
      },
      {
        'id': 'o313',
        'objectId': 'CDA47511-8BA1-4267-90ED-9A4FC7CEEBFA',
        'name': '操作模块',
        'code': 'operating_module',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'operatingModule',
        'codeCamelPlural': 'operatingModules',
        'codeUnderscore': 'operating_module',
        'codeUnderscorePlural': 'operating_modules',
        'type': 'string'
      },
      {
        'id': 'o314',
        'objectId': 'C0739437-14E9-4A91-A07A-7716BFD18A2C',
        'name': '所属组织',
        'code': 'affiliation',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'affiliation',
        'codeCamelPlural': 'affiliations',
        'codeUnderscore': 'affiliation',
        'codeUnderscorePlural': 'affiliations',
        'type': 'string'
      },
      {
        'id': 'o315',
        'objectId': '9E586E79-DCCD-4BA7-ACF7-FAE2E93B51F0',
        'name': '所属部门',
        'code': 'their_department',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'theirDepartment',
        'codeCamelPlural': 'theirDepartments',
        'codeUnderscore': 'their_department',
        'codeUnderscorePlural': 'their_departments',
        'type': 'string'
      },
      {
        'id': 'o316',
        'objectId': 'EC1967CD-6199-406D-846D-A0AA6AC0D9A0',
        'name': '日志内容',
        'code': 'log_content',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(4096)',
        'length': '4096',
        'codeCamel': 'logContent',
        'codeCamelPlural': 'logContents',
        'codeUnderscore': 'log_content',
        'codeUnderscorePlural': 'log_contents',
        'type': 'string'
      }
    ]
  },
  'CcAddressBook': {
    'model': 'CcAddressBook',
    'modelPlural': 'CcAddressBooks',
    'modelCamel': 'ccAddressBook',
    'modelCamelPlural': 'ccAddressBooks',
    'modelUnderscore': 'cc_address_book',
    'modelUnderscorePlural': 'cc_address_books',
    'columns': [
      {
        'id': 'o319',
        'objectId': '37B78CCB-20C4-4F78-80A7-0CC01FFC8E96',
        'name': '联系人id',
        'code': 'contact_id',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'contactId',
        'codeCamelPlural': 'contactIds',
        'codeUnderscore': 'contact_id',
        'codeUnderscorePlural': 'contact_ids',
        'type': 'string'
      },
      {
        'id': 'o320',
        'objectId': '5D2CB394-5FF9-4799-8B8C-6CC48FD3C935',
        'name': '联系号码',
        'code': 'contact_number',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186316',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'contactNumber',
        'codeCamelPlural': 'contactNumbers',
        'codeUnderscore': 'contact_number',
        'codeUnderscorePlural': 'contact_numbers',
        'type': 'string'
      },
      {
        'id': 'o321',
        'objectId': '8A52E9AE-54E0-48D9-960C-49E3B8D79C11',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o322',
        'objectId': '7E20B2ED-3984-48B2-B372-1FD186BDD9B9',
        'name': '谁的通讯录',
        'code': 'who_address_book',
        'creationDate': '1516608273',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'whoAddressBook',
        'codeCamelPlural': 'whoAddressBooks',
        'codeUnderscore': 'who_address_book',
        'codeUnderscorePlural': 'who_address_books',
        'type': 'string'
      },
      {
        'id': 'o323',
        'objectId': '0B939852-4245-48F5-A7ED-DA86949D7891',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o324',
        'objectId': '9C05E18A-0B55-4088-80E3-64B5B0964CDC',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o325',
        'objectId': 'A5C096D3-CC35-468E-A9A1-76EAC4C20E35',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o326',
        'objectId': 'F67A7681-8984-46B6-B281-85452D65F64A',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'HmUser2': {
    'model': 'HmUser2',
    'modelPlural': 'HmUser2S',
    'modelCamel': 'hmUser2',
    'modelCamelPlural': 'hmUser2S',
    'modelUnderscore': 'hm_user2',
    'modelUnderscorePlural': 'hm_user2S',
    'columns': [
      {
        'id': 'o329',
        'objectId': '84F13FFE-9682-412F-B86C-3C8C68D2DFB8',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o330',
        'objectId': '6A027C75-5B15-4D1B-A69C-B7B45013BE72',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o331',
        'objectId': '1BD4130E-FDE7-452C-8137-1E3D99CCB61C',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o332',
        'objectId': '883D5241-780B-4B07-81FE-1F8A05333044',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o333',
        'objectId': '012ADB3C-2B35-4EB8-809A-8105F880BBD6',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o334',
        'objectId': 'B8951D57-D1D9-4A04-BB39-F1FEDB3BC950',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o335',
        'objectId': 'B26B75DE-56CE-49E2-89F9-1AF2E4A840B4',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o336',
        'objectId': 'C2156628-116D-41F2-B8B5-79F8A9D80895',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o337',
        'objectId': '48D449BA-FC4D-4D3A-BF09-A891C627A02D',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o338',
        'objectId': '30E9B035-A6FD-49CA-983E-705C34162D52',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o339',
        'objectId': 'E0386394-AD66-4591-859F-2B5E1F2A1D89',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o340',
        'objectId': 'B5BCB5C5-192F-4BD0-8215-BB65A8288168',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcCanteenCardSpending': {
    'model': 'CcCanteenCardSpending',
    'modelPlural': 'CcCanteenCardSpendings',
    'modelCamel': 'ccCanteenCardSpending',
    'modelCamelPlural': 'ccCanteenCardSpendings',
    'modelUnderscore': 'cc_canteen_card_spending',
    'modelUnderscorePlural': 'cc_canteen_card_spendings',
    'columns': [
      {
        'id': 'o343',
        'objectId': 'DBB121B8-B97A-4840-9C16-32F41519D9FC',
        'name': '消费人员',
        'code': 'people',
        'creationDate': '1516608458',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'people',
        'codeCamelPlural': 'people',
        'codeUnderscore': 'people',
        'codeUnderscorePlural': 'people',
        'type': 'string'
      },
      {
        'id': 'o344',
        'objectId': '47CF3995-B71B-407B-AA80-454D1ED2DA81',
        'name': '消费金额',
        'code': 'amount_consumption',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'double',
        'codeCamel': 'amountConsumption',
        'codeCamelPlural': 'amountConsumptions',
        'codeUnderscore': 'amount_consumption',
        'codeUnderscorePlural': 'amount_consumptions',
        'type': 'number'
      },
      {
        'id': 'o345',
        'objectId': '8E873C91-3FD8-4764-ABB3-74B8EFC917FC',
        'name': '消费时间',
        'code': 'spending_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'spendingTime',
        'codeCamelPlural': 'spendingTimes',
        'codeUnderscore': 'spending_time',
        'codeUnderscorePlural': 'spending_times',
        'type': 'datetime'
      },
      {
        'id': 'o346',
        'objectId': '7088DEE3-AA94-4F93-883E-820326B5F9A4',
        'name': '消费类型',
        'code': 'type',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o347',
        'objectId': 'A1E9BC8F-EC52-419E-A31C-E573B9F79E61',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o348',
        'objectId': '454F5535-8FD8-41FA-9573-C95DFED5E3C5',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o349',
        'objectId': '15234182-7387-4D15-A5D9-857BFD3C5E34',
        'name': '余额',
        'code': 'balance',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'double',
        'codeCamel': 'balance',
        'codeCamelPlural': 'balances',
        'codeUnderscore': 'balance',
        'codeUnderscorePlural': 'balances',
        'type': 'number'
      }
    ]
  },
  'HmUser3': {
    'model': 'HmUser3',
    'modelPlural': 'HmUser3S',
    'modelCamel': 'hmUser3',
    'modelCamelPlural': 'hmUser3S',
    'modelUnderscore': 'hm_user3',
    'modelUnderscorePlural': 'hm_user3S',
    'columns': [
      {
        'id': 'o352',
        'objectId': '96B8B552-949D-441D-9E9D-537B4EC3D6A5',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o353',
        'objectId': '7BCB231E-A918-440E-A0EF-28C05622DFE3',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o354',
        'objectId': 'F6802DC5-1328-4DBA-A056-75E4D62FEAA4',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o355',
        'objectId': 'FC448B4F-BE63-42F6-812E-93C8916F5DA4',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o356',
        'objectId': '2258795B-6BDA-4A77-8F76-326D65E135EA',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o357',
        'objectId': '7B134816-F72B-4830-8A0E-58748F4696EF',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o358',
        'objectId': '53E7A96B-3CA5-4991-B1FD-9EFF56B25B44',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o359',
        'objectId': '0E5A430B-4B17-4DFA-92AF-457B113CF481',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o360',
        'objectId': 'BC3617FB-A06D-486E-AD1E-CD978A881142',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o361',
        'objectId': '0C87C134-1F9E-46FD-8865-AC616F169E1C',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o362',
        'objectId': '4900C242-F151-4B43-8C43-8603B0EDAF49',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o363',
        'objectId': 'AD21D50C-88DD-40A5-AE98-235B1D74324C',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcCheckNavigation': {
    'model': 'CcCheckNavigation',
    'modelPlural': 'CcCheckNavigations',
    'modelCamel': 'ccCheckNavigation',
    'modelCamelPlural': 'ccCheckNavigations',
    'modelUnderscore': 'cc_check_navigation',
    'modelUnderscorePlural': 'cc_check_navigations',
    'columns': [
      {
        'id': 'o366',
        'objectId': '51453EE3-6597-43D0-81D5-45EEFD5E8139',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o367',
        'objectId': 'AC7DF886-C78C-410B-86C5-41ABF96D9E1B',
        'name': 'icon标题',
        'code': 'icon_tile',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'iconTile',
        'codeCamelPlural': 'iconTiles',
        'codeUnderscore': 'icon_tile',
        'codeUnderscorePlural': 'icon_tiles',
        'type': 'string'
      },
      {
        'id': 'o368',
        'objectId': '6A487C4A-BF74-41E3-B310-F1130AA26DB9',
        'name': '官方网站',
        'code': 'official_website',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'officialWebsite',
        'codeCamelPlural': 'officialWebsites',
        'codeUnderscore': 'official_website',
        'codeUnderscorePlural': 'official_websites',
        'type': 'string'
      },
      {
        'id': 'o369',
        'objectId': '1F0467ED-6A16-486E-8238-E068E530A7BA',
        'name': '上级id',
        'code': 'parent_id',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'parentId',
        'codeCamelPlural': 'parentIds',
        'codeUnderscore': 'parent_id',
        'codeUnderscorePlural': 'parent_ids',
        'type': 'string'
      },
      {
        'id': 'o370',
        'objectId': '1E6BC255-B254-4F80-869E-8F4B0B951761',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o371',
        'objectId': '8F06F06D-BBB4-4896-A7B9-0D193A3CF4A4',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o372',
        'objectId': 'ED770D0E-FBF9-406E-A4F1-E4E4A5915B59',
        'name': '简介',
        'code': 'lntroduction',
        'creationDate': '1516624111',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'lntroduction',
        'codeCamelPlural': 'lntroductions',
        'codeUnderscore': 'lntroduction',
        'codeUnderscorePlural': 'lntroductions',
        'type': 'string'
      },
      {
        'id': 'o373',
        'objectId': '7A60AA1A-21E8-4B53-B0A8-D88A1A42CC69',
        'name': '概况',
        'code': 'survey',
        'creationDate': '1517892939',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'survey',
        'codeCamelPlural': 'surveys',
        'codeUnderscore': 'survey',
        'codeUnderscorePlural': 'surveys',
        'type': 'string'
      },
      {
        'id': 'o374',
        'objectId': '56B4F551-EB58-45C5-87AE-E4FE2C2FB108',
        'name': '机构设置',
        'code': 'lnstitution_setting',
        'creationDate': '1517892939',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'lnstitutionSetting',
        'codeCamelPlural': 'lnstitutionSettings',
        'codeUnderscore': 'lnstitution_setting',
        'codeUnderscorePlural': 'lnstitution_settings',
        'type': 'string'
      },
      {
        'id': 'o375',
        'objectId': '70203EB7-5987-4EB6-8D19-397B707F8925',
        'name': '检查职能机构设置单位简介',
        'code': 'function',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'function',
        'codeCamelPlural': 'functions',
        'codeUnderscore': 'function',
        'codeUnderscorePlural': 'functions',
        'type': 'string'
      },
      {
        'id': 'o376',
        'objectId': 'EBBBB0B3-A4C7-4C3A-9B87-DC5032C8BBA0',
        'name': '微信地址',
        'code': 'wechat_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'wechatAddress',
        'codeCamelPlural': 'wechatAddresses',
        'codeUnderscore': 'wechat_address',
        'codeUnderscorePlural': 'wechat_addresses',
        'type': 'string'
      },
      {
        'id': 'o377',
        'objectId': 'DEFE33A8-2EAA-4A19-AF41-E2FF1E2FAD37',
        'name': '微博地址',
        'code': 'micro_blog_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'microBlogAddress',
        'codeCamelPlural': 'microBlogAddresses',
        'codeUnderscore': 'micro_blog_address',
        'codeUnderscorePlural': 'micro_blog_addresses',
        'type': 'string'
      },
      {
        'id': 'o378',
        'objectId': 'ED695748-DE8B-48D7-A88E-F4E3553DC690',
        'name': '头条地址',
        'code': 'headline_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'headlineAddress',
        'codeCamelPlural': 'headlineAddresses',
        'codeUnderscore': 'headline_address',
        'codeUnderscorePlural': 'headline_addresses',
        'type': 'string'
      },
      {
        'id': 'o379',
        'objectId': 'D3F2AF28-8C00-4E24-9A5A-5B4B0DEB0894',
        'name': '类型',
        'code': 'type',
        'creationDate': '1517894103',
        'creator': 'yide',
        'modificationDate': '1517896759',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      }
    ]
  },
  'CcNotifications': {
    'model': 'CcNotifications',
    'modelPlural': 'CcNotifications',
    'modelCamel': 'ccNotifications',
    'modelCamelPlural': 'ccNotifications',
    'modelUnderscore': 'cc_notifications',
    'modelUnderscorePlural': 'cc_notifications',
    'columns': [
      {
        'id': 'o382',
        'objectId': '6F115051-18ED-407D-B688-1DB2E062C1F2',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o383',
        'objectId': '04C175A8-1E14-49A3-98EA-C8A888795DFC',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o384',
        'objectId': 'A8D13242-CA8B-4D85-99CD-AB59DC4C495A',
        'name': '类型',
        'code': 'type',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o385',
        'objectId': 'F277EF1E-7304-46E8-AC9D-D9A065166C22',
        'name': '标题',
        'code': 'title',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(512)',
        'length': '512',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o386',
        'objectId': '3A51C135-F410-4F48-B677-273577993088',
        'name': '签收类型',
        'code': 'sign_type',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'comment': '1.签收2.非签收',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'signType',
        'codeCamelPlural': 'signTypes',
        'codeUnderscore': 'sign_type',
        'codeUnderscorePlural': 'sign_types',
        'type': 'string'
      },
      {
        'id': 'o387',
        'objectId': '44815BE2-BE98-4FC7-93D5-FF78F8F7F7B5',
        'name': '公告类型',
        'code': 'notice_type',
        'creationDate': '1517902860',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'comment': '1.通知.2.通报',
        'dataType': 'varchar(43)',
        'length': '43',
        'codeCamel': 'noticeType',
        'codeCamelPlural': 'noticeTypes',
        'codeUnderscore': 'notice_type',
        'codeUnderscorePlural': 'notice_types',
        'type': 'string'
      },
      {
        'id': 'o388',
        'objectId': '769F47EC-1C2E-4098-82E1-EB83AB36C8E1',
        'name': '发布内容',
        'code': 'publish_content',
        'creationDate': '1517902897',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(4096)',
        'length': '4096',
        'codeCamel': 'publishContent',
        'codeCamelPlural': 'publishContents',
        'codeUnderscore': 'publish_content',
        'codeUnderscorePlural': 'publish_contents',
        'type': 'string'
      },
      {
        'id': 'o389',
        'objectId': '8DBEA194-914F-429C-8B06-193D5F1DEE7C',
        'name': '审批状态',
        'code': 'state_approval',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'stateApproval',
        'codeCamelPlural': 'stateApprovals',
        'codeUnderscore': 'state_approval',
        'codeUnderscorePlural': 'state_approvals',
        'type': 'string'
      },
      {
        'id': 'o390',
        'objectId': '5768A6F2-DB27-411F-B8C3-14BB017A3FD5',
        'name': '是否撤销',
        'code': 'revokes',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908940',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'revokes',
        'codeCamelPlural': 'revokes',
        'codeUnderscore': 'revokes',
        'codeUnderscorePlural': 'revokes',
        'type': 'string'
      },
      {
        'id': 'o391',
        'objectId': '254A3CE6-D2EB-432A-8812-492ECA39588C',
        'name': '是否短信提醒',
        'code': 'sms_reminding',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'smsReminding',
        'codeCamelPlural': 'smsRemindings',
        'codeUnderscore': 'sms_reminding',
        'codeUnderscorePlural': 'sms_remindings',
        'type': 'string'
      },
      {
        'id': 'o392',
        'objectId': '0203317E-D891-49B5-BAA3-C75FFD982E0C',
        'name': '是否推送专网',
        'code': 'special_network',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'specialNetwork',
        'codeCamelPlural': 'specialNetworks',
        'codeUnderscore': 'special_network',
        'codeUnderscorePlural': 'special_networks',
        'type': 'string'
      },
      {
        'id': 'o393',
        'objectId': '6E2CE4CD-3BA1-4287-8654-AFAD05FA49B6',
        'name': '是否推送多媒体',
        'code': 'push_multimedia',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'pushMultimedia',
        'codeCamelPlural': 'pushMultimedias',
        'codeUnderscore': 'push_multimedia',
        'codeUnderscorePlural': 'push_multimedias',
        'type': 'string'
      },
      {
        'id': 'o394',
        'objectId': '6BE29475-78B3-40A1-ACE2-4A46D8FD62EF',
        'name': '最终审批人',
        'code': 'final_approver',
        'creationDate': '1517908623',
        'creator': 'yide',
        'modificationDate': '1517908656',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'finalApprover',
        'codeCamelPlural': 'finalApprovers',
        'codeUnderscore': 'final_approver',
        'codeUnderscorePlural': 'final_approvers',
        'type': 'string'
      }
    ]
  },
  'CcPublishers': {
    'model': 'CcPublishers',
    'modelPlural': 'CcPublishers',
    'modelCamel': 'ccPublishers',
    'modelCamelPlural': 'ccPublishers',
    'modelUnderscore': 'cc_publishers',
    'modelUnderscorePlural': 'cc_publishers',
    'columns': [
      {
        'id': 'o397',
        'objectId': 'DEA80EDC-151A-4D9E-B3AF-E0C29E6DE6B0',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o398',
        'objectId': '262898A8-CCEC-4435-A336-73FDF9300645',
        'name': '最后创建时间',
        'code': 'last_update_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o399',
        'objectId': '24B938F2-6598-4ECA-879A-929119CF3763',
        'name': '通知通报id',
        'code': 'cc_notifications_id',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o400',
        'objectId': '16A9AA93-BDE7-454D-A393-2CBCA86E3FEE',
        'name': '是否查看',
        'code': 'see',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905823',
        'modifier': 'yide',
        'comment': '1.查看.   其他都是未查看',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'see',
        'codeCamelPlural': 'sees',
        'codeUnderscore': 'see',
        'codeUnderscorePlural': 'sees',
        'type': 'string'
      },
      {
        'id': 'o401',
        'objectId': '2863D653-418D-473A-A546-A6364F1D59F3',
        'name': '是否签收',
        'code': 'sign',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905843',
        'modifier': 'yide',
        'comment': '1.签收.  其他都是未签收',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'sign',
        'codeCamelPlural': 'signs',
        'codeUnderscore': 'sign',
        'codeUnderscorePlural': 'signs',
        'type': 'string'
      },
      {
        'id': 'o402',
        'objectId': '0637FE2F-E9C6-470F-B9F9-2B6C3F3B1DCA',
        'name': '签收时间',
        'code': 'sign_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'signTime',
        'codeCamelPlural': 'signTimes',
        'codeUnderscore': 'sign_time',
        'codeUnderscorePlural': 'sign_times',
        'type': 'datetime'
      },
      {
        'id': 'o403',
        'objectId': 'F8BF7EFF-A11A-4CAE-AB19-88E4DF561AF8',
        'name': '查看时间',
        'code': 'see_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'seeTime',
        'codeCamelPlural': 'seeTimes',
        'codeUnderscore': 'see_time',
        'codeUnderscorePlural': 'see_times',
        'type': 'datetime'
      }
    ]
  },
  'CcAssociatedFile': {
    'model': 'CcAssociatedFile',
    'modelPlural': 'CcAssociatedFiles',
    'modelCamel': 'ccAssociatedFile',
    'modelCamelPlural': 'ccAssociatedFiles',
    'modelUnderscore': 'cc_associated_file',
    'modelUnderscorePlural': 'cc_associated_files',
    'columns': [
      {
        'id': 'o406',
        'objectId': '82595090-88F1-4048-9DC0-9A1D350FA3D1',
        'name': '通知通报id',
        'code': 'cc_notifications_id',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517908819',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o407',
        'objectId': 'A362390A-3193-452B-8D20-5E609B691BC7',
        'name': '文件id',
        'code': 'file_id',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o408',
        'objectId': '2783A94A-FF29-4198-B85C-B98D89FB481F',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o409',
        'objectId': '8F8161D3-59C5-45E0-B4B6-90B238363713',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcApprovalProcess': {
    'model': 'CcApprovalProcess',
    'modelPlural': 'CcApprovalProcesses',
    'modelCamel': 'ccApprovalProcess',
    'modelCamelPlural': 'ccApprovalProcesses',
    'modelUnderscore': 'cc_approval_process',
    'modelUnderscorePlural': 'cc_approval_processes',
    'columns': [
      {
        'id': 'o412',
        'objectId': '364B610A-8E79-42CE-9848-AB9C9C63EFBD',
        'name': '审批人',
        'code': 'approver_id',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approverId',
        'codeCamelPlural': 'approverIds',
        'codeUnderscore': 'approver_id',
        'codeUnderscorePlural': 'approver_ids',
        'type': 'string'
      },
      {
        'id': 'o413',
        'objectId': '94CD0829-9627-4835-A93C-98BD691C7F2F',
        'name': '通知通告id',
        'code': 'cc_notifications_id',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o414',
        'objectId': '598FF24D-3D8E-4AF6-BA83-BF2C33C75D24',
        'name': '创建日期',
        'code': 'create_time',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o415',
        'objectId': 'F9B3E808-6487-4CB4-AC3A-B3185B3DE72A',
        'name': '最后更新日期',
        'code': 'last_update_time',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o416',
        'objectId': 'E48B0C06-0D12-46AE-A273-167073583A36',
        'name': '上级流转',
        'code': 'superior_circulation',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'superiorCirculation',
        'codeCamelPlural': 'superiorCirculations',
        'codeUnderscore': 'superior_circulation',
        'codeUnderscorePlural': 'superior_circulations',
        'type': 'string'
      }
    ]
  }
}

exports = module.exports = ModelSchema
