/**
 * @desc 数据库定义文件
 * @author hm20160509
 * @date 2018/2/5
 */

const ModelSchema = {
  'CcDuty': {
    'model': 'CcDuty',
    'modelPlural': 'CcDuties',
    'modelCamel': 'ccDuty',
    'modelCamelPlural': 'ccDuties',
    'modelUnderscore': 'cc_duty',
    'modelUnderscorePlural': 'cc_duties',
    'columns': [
      {
        'id': 'o211',
        'objectId': '4CE4D5AC-D329-4893-B195-DD6A248B1AE4',
        'name': '值班人',
        'code': 'watch_people',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'watchPeople',
        'codeCamelPlural': 'watchPeople',
        'codeUnderscore': 'watch_people',
        'codeUnderscorePlural': 'watch_people',
        'type': 'string'
      },
      {
        'id': 'o212',
        'objectId': '64C558CE-347C-4234-880A-C98A8C6B404C',
        'name': '值班类型',
        'code': 'type',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o213',
        'objectId': 'FC331B64-AE43-41C5-8238-01395D64CD4A',
        'name': '值班日期',
        'code': 'duty_date',
        'creationDate': '1516606222',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'dutyDate',
        'codeCamelPlural': 'dutyDates',
        'codeUnderscore': 'duty_date',
        'codeUnderscorePlural': 'duty_dates',
        'type': 'string'
      },
      {
        'id': 'o214',
        'objectId': '0597CBC8-434D-4ABD-BBEB-52C694D06175',
        'name': '值班结束时间',
        'code': 'end_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'endTime',
        'codeCamelPlural': 'endTimes',
        'codeUnderscore': 'end_time',
        'codeUnderscorePlural': 'end_times',
        'type': 'datetime'
      },
      {
        'id': 'o215',
        'objectId': '9463E2F4-6629-4E0C-8AB3-4341476805C3',
        'name': '值班开始时间',
        'code': 'start_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'startTime',
        'codeCamelPlural': 'startTimes',
        'codeUnderscore': 'start_time',
        'codeUnderscorePlural': 'start_times',
        'type': 'datetime'
      },
      {
        'id': 'o216',
        'objectId': '188B1624-90ED-470A-8569-077DAFB874E9',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o217',
        'objectId': 'BD4635BE-C89F-41A0-9735-2EC694B643CE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516588016',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o218',
        'objectId': 'E5D8D3FF-98CE-4478-A471-01494FC4AD15',
        'name': '值班计划id',
        'code': 'on_duty_plan_id',
        'creationDate': '1516589570',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcDutyPlan',
          'modelCamel': 'ccDutyPlan',
          'modelCamelPlural': 'ccDutyPlans',
          'modelUnderscore': 'cc_duty_plan',
          'modelUnderscorePlural': 'cc_duty_plans'
        },
        'codeCamel': 'onDutyPlanId',
        'codeCamelPlural': 'onDutyPlanIds',
        'codeUnderscore': 'on_duty_plan_id',
        'codeUnderscorePlural': 'on_duty_plan_ids',
        'type': 'string'
      },
      {
        'id': 'o219',
        'objectId': 'A8F5BC1B-BA1A-4132-B050-3FB09ED1781C',
        'name': '值班阶段',
        'code': 'duty_stage',
        'creationDate': '1520587588',
        'creator': 'yide',
        'modificationDate': '1520588005',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'dutyStage',
        'codeCamelPlural': 'dutyStages',
        'codeUnderscore': 'duty_stage',
        'codeUnderscorePlural': 'duty_stages',
        'type': 'string'
      },
      {
        'id': 'o220',
        'objectId': 'A6466C2E-025B-4745-B201-25A4936A3D45',
        'name': '值班岗位',
        'code': 'post_duty',
        'creationDate': '1520588205',
        'creator': 'yide',
        'modificationDate': '1520588287',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'postDuty',
        'codeCamelPlural': 'postDuties',
        'codeUnderscore': 'post_duty',
        'codeUnderscorePlural': 'post_duties',
        'type': 'string'
      }
    ]
  },
  'CcDutyPlan': {
    'model': 'CcDutyPlan',
    'modelPlural': 'CcDutyPlans',
    'modelCamel': 'ccDutyPlan',
    'modelCamelPlural': 'ccDutyPlans',
    'modelUnderscore': 'cc_duty_plan',
    'modelUnderscorePlural': 'cc_duty_plans',
    'columns': [
      {
        'id': 'o223',
        'objectId': '6C6CC8AD-3B86-445C-A5CB-40098ED88CB2',
        'name': '计划名称',
        'code': 'name',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o224',
        'objectId': '1A1C287E-4E01-4FB5-9261-A59C5BA487A7',
        'name': '带班领导',
        'code': 'leadership',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'leadership',
        'codeCamelPlural': 'leaderships',
        'codeUnderscore': 'leadership',
        'codeUnderscorePlural': 'leaderships',
        'type': 'string'
      },
      {
        'id': 'o225',
        'objectId': '14FAD9EF-E0A5-4689-9008-4DF5BB68029C',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o226',
        'objectId': '5D48CD41-17EB-4F84-B750-7720700F4354',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516588920',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o227',
        'objectId': '82F5A65A-B5E6-4527-A1C2-31025AE88241',
        'name': '值班类型',
        'code': 'duty_type',
        'creationDate': '1520588321',
        'creator': 'yide',
        'modificationDate': '1520588385',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'dutyType',
        'codeCamelPlural': 'dutyTypes',
        'codeUnderscore': 'duty_type',
        'codeUnderscorePlural': 'duty_types',
        'type': 'string'
      }
    ]
  },
  'CcHmUser': {
    'model': 'CcHmUser',
    'modelPlural': 'CcHmUsers',
    'modelCamel': 'ccHmUser',
    'modelCamelPlural': 'ccHmUsers',
    'modelUnderscore': 'cc_hm_user',
    'modelUnderscorePlural': 'cc_hm_users',
    'columns': [
      {
        'id': 'o230',
        'objectId': '8FD46305-665A-4D68-8CEB-C8F3B21E68D4',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o231',
        'objectId': 'BC0164C2-8A2C-49AE-82B9-23BD14C5CD60',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o232',
        'objectId': 'AAFD7A92-2C66-4338-AD57-D73DC1A31EE6',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o233',
        'objectId': '9238B77C-2B6C-4EC8-89D9-F81D1D5087AB',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o234',
        'objectId': '0320FE5F-5DDA-431C-B335-05DB1AA7201F',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o235',
        'objectId': '785AD6EA-F1F6-4D7F-9E9A-59A73238B85E',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o236',
        'objectId': 'D8832FE5-60F6-47A8-BF3D-1DC0925BFF72',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o237',
        'objectId': 'A5C75EEB-C768-4ABF-98BC-6E8D17B68DAF',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o238',
        'objectId': 'DFD8E29B-7F7C-4280-862F-562410237BAC',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o239',
        'objectId': '9DB750AC-1723-4CA8-B948-BD3F22A23327',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o240',
        'objectId': '8639104D-24E4-4AF2-AC9E-D7E52DCFA585',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o241',
        'objectId': 'FF38874B-464D-43BC-9EBC-D46D2E89C1D2',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcShift': {
    'model': 'CcShift',
    'modelPlural': 'CcShifts',
    'modelCamel': 'ccShift',
    'modelCamelPlural': 'ccShifts',
    'modelUnderscore': 'cc_shift',
    'modelUnderscorePlural': 'cc_shifts',
    'columns': [
      {
        'id': 'o244',
        'objectId': '19389CBA-9CC7-4509-89A6-C3F81B8329B3',
        'name': '申请人',
        'code': 'applicant_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcHmUser',
          'modelCamel': 'ccHmUser',
          'modelCamelPlural': 'ccHmUsers',
          'modelUnderscore': 'cc_hm_user',
          'modelUnderscorePlural': 'cc_hm_users'
        },
        'codeCamel': 'applicantId',
        'codeCamelPlural': 'applicantIds',
        'codeUnderscore': 'applicant_id',
        'codeUnderscorePlural': 'applicant_ids',
        'type': 'string'
      },
      {
        'id': 'o245',
        'objectId': '57567B7E-A992-4EE3-8895-76F6AC510AF6',
        'name': '被调班人(变更人)',
        'code': 'transferred_class_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1520588685',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcHmUser',
          'modelCamel': 'ccHmUser',
          'modelCamelPlural': 'ccHmUsers',
          'modelUnderscore': 'cc_hm_user',
          'modelUnderscorePlural': 'cc_hm_users'
        },
        'codeCamel': 'transferredClassId',
        'codeCamelPlural': 'transferredClassIds',
        'codeUnderscore': 'transferred_class_id',
        'codeUnderscorePlural': 'transferred_class_ids',
        'type': 'string'
      },
      {
        'id': 'o246',
        'objectId': '39906390-F7B4-49E9-8C93-F83E15653C98',
        'name': '申请人值班id',
        'code': 'applicant_duty_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcDuty',
          'modelCamel': 'ccDuty',
          'modelCamelPlural': 'ccDuties',
          'modelUnderscore': 'cc_duty',
          'modelUnderscorePlural': 'cc_duties'
        },
        'codeCamel': 'applicantDutyId',
        'codeCamelPlural': 'applicantDutyIds',
        'codeUnderscore': 'applicant_duty_id',
        'codeUnderscorePlural': 'applicant_duty_ids',
        'type': 'string'
      },
      {
        'id': 'o247',
        'objectId': '62279FC3-9336-4B17-8FC8-67A05FEEE83D',
        'name': '被调班值班id',
        'code': 'transferred_class_duty_id',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcDuty',
          'modelCamel': 'ccDuty',
          'modelCamelPlural': 'ccDuties',
          'modelUnderscore': 'cc_duty',
          'modelUnderscorePlural': 'cc_duties'
        },
        'codeCamel': 'transferredClassDutyId',
        'codeCamelPlural': 'transferredClassDutyIds',
        'codeUnderscore': 'transferred_class_duty_id',
        'codeUnderscorePlural': 'transferred_class_duty_ids',
        'type': 'string'
      },
      {
        'id': 'o248',
        'objectId': 'D0EF4EC4-7385-45AC-87A5-1C02AB5183A0',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o249',
        'objectId': '7F1CAFB0-493E-465F-B922-D3F4C49843C5',
        'name': '调班原因',
        'code': 'reason',
        'creationDate': '1516619250',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'reason',
        'codeCamelPlural': 'reasons',
        'codeUnderscore': 'reason',
        'codeUnderscorePlural': 'reasons',
        'type': 'string'
      },
      {
        'id': 'o250',
        'objectId': 'DE6B4DC4-4B20-4042-A1BD-2E9872164FCE',
        'name': '审批人',
        'code': 'approver',
        'creationDate': '1516619603',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approver',
        'codeCamelPlural': 'approvers',
        'codeUnderscore': 'approver',
        'codeUnderscorePlural': 'approvers',
        'type': 'string'
      },
      {
        'id': 'o251',
        'objectId': 'D53FD831-3BB8-434A-AF1F-2A301A323F18',
        'name': '申请时间',
        'code': 'application_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'applicationTime',
        'codeCamelPlural': 'applicationTimes',
        'codeUnderscore': 'application_time',
        'codeUnderscorePlural': 'application_times',
        'type': 'datetime'
      },
      {
        'id': 'o252',
        'objectId': '25805415-3B22-4C21-B698-968794882B62',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o253',
        'objectId': '196F37A9-5D5F-4E7F-BD95-9B48CCC63DA4',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516619814',
        'creator': 'yide',
        'modificationDate': '1517185974',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcOfficialDocument': {
    'model': 'CcOfficialDocument',
    'modelPlural': 'CcOfficialDocuments',
    'modelCamel': 'ccOfficialDocument',
    'modelCamelPlural': 'ccOfficialDocuments',
    'modelUnderscore': 'cc_official_document',
    'modelUnderscorePlural': 'cc_official_documents',
    'columns': [
      {
        'id': 'o256',
        'objectId': '47B0F2AE-E08A-4DEC-90B0-373E2509BAB9',
        'name': '文件名称',
        'code': 'name',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o257',
        'objectId': 'BC4DE0AA-526B-4B6E-A2DF-B2650395F113',
        'name': '文件类型',
        'code': 'type',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o258',
        'objectId': '468FE5CE-A271-4F33-9216-0AB0BCAA6956',
        'name': '文件路径',
        'code': 'path',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'path',
        'codeCamelPlural': 'paths',
        'codeUnderscore': 'path',
        'codeUnderscorePlural': 'paths',
        'type': 'string'
      },
      {
        'id': 'o259',
        'objectId': 'A3D1E7EC-F57F-43E3-A499-8506515EA0BD',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o260',
        'objectId': 'CF59986C-5C74-4325-A568-48CA91A6AF71',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o261',
        'objectId': '5129706E-65B9-49BC-9834-E5C2B8CE1269',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516621489',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcDocumentCirculationApproval': {
    'model': 'CcDocumentCirculationApproval',
    'modelPlural': 'CcDocumentCirculationApprovals',
    'modelCamel': 'ccDocumentCirculationApproval',
    'modelCamelPlural': 'ccDocumentCirculationApprovals',
    'modelUnderscore': 'cc_document_circulation_approval',
    'modelUnderscorePlural': 'cc_document_circulation_approvals',
    'columns': [
      {
        'id': 'o264',
        'objectId': 'EFB78600-3FF9-4D58-AEF2-F4EC27E81FC4',
        'name': '来文单位',
        'code': 'communications_unit',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'communicationsUnit',
        'codeCamelPlural': 'communicationsUnits',
        'codeUnderscore': 'communications_unit',
        'codeUnderscorePlural': 'communications_units',
        'type': 'string'
      },
      {
        'id': 'o265',
        'objectId': 'B5A67378-3A88-4575-BE71-4F04AD18D622',
        'name': '签发处室',
        'code': 'lssued_room',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'lssuedRoom',
        'codeCamelPlural': 'lssuedRooms',
        'codeUnderscore': 'lssued_room',
        'codeUnderscorePlural': 'lssued_rooms',
        'type': 'string'
      },
      {
        'id': 'o266',
        'objectId': 'EF12637F-0619-4F5E-BBCC-46D2D4AB22E6',
        'name': '公文编号',
        'code': 'document_number',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'documentNumber',
        'codeCamelPlural': 'documentNumbers',
        'codeUnderscore': 'document_number',
        'codeUnderscorePlural': 'document_numbers',
        'type': 'string'
      },
      {
        'id': 'o267',
        'objectId': 'B4165EF4-73FB-45F3-A7A0-683AA3EF79A0',
        'name': '公文标题',
        'code': 'official_title',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'officialTitle',
        'codeCamelPlural': 'officialTitles',
        'codeUnderscore': 'official_title',
        'codeUnderscorePlural': 'official_titles',
        'type': 'string'
      },
      {
        'id': 'o268',
        'objectId': '008CB669-6EC8-4360-AEBA-3B2CAEB7B9E4',
        'name': '拟办意见',
        'code': 'proposed_advice',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'proposedAdvice',
        'codeCamelPlural': 'proposedAdvices',
        'codeUnderscore': 'proposed_advice',
        'codeUnderscorePlural': 'proposed_advices',
        'type': 'string'
      },
      {
        'id': 'o269',
        'objectId': 'CBDB4ADD-E390-41D2-8430-5327B45A9908',
        'name': '审批人',
        'code': 'approver',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approver',
        'codeCamelPlural': 'approvers',
        'codeUnderscore': 'approver',
        'codeUnderscorePlural': 'approvers',
        'type': 'string'
      },
      {
        'id': 'o270',
        'objectId': '31D91995-9E37-4AD0-83D4-9B0ECEE85A91',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o271',
        'objectId': '0BF41682-6B35-4C23-9FD2-F6D746B41EF7',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o272',
        'objectId': 'FB756629-0212-47F1-A8CE-BF603434B471',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o273',
        'objectId': 'B24C2912-8D7A-4DD6-9BE3-0A9DE42D2260',
        'name': '流转状态',
        'code': 'circulation_state',
        'creationDate': '1516622187',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'comment': '是否流转',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'circulationState',
        'codeCamelPlural': 'circulationStates',
        'codeUnderscore': 'circulation_state',
        'codeUnderscorePlural': 'circulation_states',
        'type': 'string'
      },
      {
        'id': 'o274',
        'objectId': 'FB513329-FAB9-4727-9439-C3BBE56C0568',
        'name': '上个流转id',
        'code': 'prev_id',
        'creationDate': '1516622793',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'prevId',
        'codeCamelPlural': 'prevIds',
        'codeUnderscore': 'prev_id',
        'codeUnderscorePlural': 'prev_ids',
        'type': 'string'
      },
      {
        'id': 'o275',
        'objectId': '135AE37A-2AA4-4241-992F-0CB0F0C1160E',
        'name': '审批状态',
        'code': 'approval_status',
        'creationDate': '1516622924',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'approvalStatus',
        'codeCamelPlural': 'approvalStatuses',
        'codeUnderscore': 'approval_status',
        'codeUnderscorePlural': 'approval_statuses',
        'type': 'string'
      }
    ]
  },
  'CcOfficialDocumentsAnnex': {
    'model': 'CcOfficialDocumentsAnnex',
    'modelPlural': 'CcOfficialDocumentsAnnexes',
    'modelCamel': 'ccOfficialDocumentsAnnex',
    'modelCamelPlural': 'ccOfficialDocumentsAnnexes',
    'modelUnderscore': 'cc_official_documents_annex',
    'modelUnderscorePlural': 'cc_official_documents_annexes',
    'columns': [
      {
        'id': 'o278',
        'objectId': '544B7417-98F0-46EC-9A05-E258B508A7B3',
        'name': '文件',
        'code': 'file_id',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcOfficialDocument',
          'modelCamel': 'ccOfficialDocument',
          'modelCamelPlural': 'ccOfficialDocuments',
          'modelUnderscore': 'cc_official_document',
          'modelUnderscorePlural': 'cc_official_documents'
        },
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o279',
        'objectId': 'E3D32F81-319D-4295-93BA-50128DE34167',
        'name': '公文流转审批id',
        'code': 'document_approval_id',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcDocumentCirculationApproval',
          'modelCamel': 'ccDocumentCirculationApproval',
          'modelCamelPlural': 'ccDocumentCirculationApprovals',
          'modelUnderscore': 'cc_document_circulation_approval',
          'modelUnderscorePlural': 'cc_document_circulation_approvals'
        },
        'codeCamel': 'documentApprovalId',
        'codeCamelPlural': 'documentApprovalIds',
        'codeUnderscore': 'document_approval_id',
        'codeUnderscorePlural': 'document_approval_ids',
        'type': 'string'
      },
      {
        'id': 'o280',
        'objectId': '3D39FB62-AACE-4AB1-8C98-7137FAF96B59',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o281',
        'objectId': '2CB73EA7-90C5-4960-A966-E90164572460',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516622410',
        'creator': 'yide',
        'modificationDate': '1517186002',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMsMemorabilia': {
    'model': 'CcMsMemorabilia',
    'modelPlural': 'CcMsMemorabilias',
    'modelCamel': 'ccMsMemorabilia',
    'modelCamelPlural': 'ccMsMemorabilias',
    'modelUnderscore': 'cc_ms_memorabilia',
    'modelUnderscorePlural': 'cc_ms_memorabilias',
    'columns': [
      {
        'id': 'o284',
        'objectId': '70C99D13-DCD5-4346-866A-55813A32E2AC',
        'name': '分类',
        'code': 'type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o285',
        'objectId': 'CA0C6F6F-2EAD-4C5B-B9E0-C7B3BC4B2414',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o286',
        'objectId': '1E628551-E99D-4F47-B915-81D50F239105',
        'name': '正文',
        'code': 'text',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'text',
        'codeCamelPlural': 'texts',
        'codeUnderscore': 'text',
        'codeUnderscorePlural': 'texts',
        'type': 'string'
      },
      {
        'id': 'o287',
        'objectId': '49CA7DBC-D47A-47F3-BF8F-341FA39EFF6F',
        'name': '附件',
        'code': 'annex',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'annex',
        'codeCamelPlural': 'annexes',
        'codeUnderscore': 'annex',
        'codeUnderscorePlural': 'annexes',
        'type': 'string'
      },
      {
        'id': 'o288',
        'objectId': '02D6977B-D4F1-465E-B81B-AC5785835530',
        'name': '文件',
        'code': 'file',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'file',
        'codeCamelPlural': 'files',
        'codeUnderscore': 'file',
        'codeUnderscorePlural': 'files',
        'type': 'string'
      },
      {
        'id': 'o289',
        'objectId': '85611331-685C-47D2-B142-CA0070BF53B4',
        'name': '文字描述',
        'code': 'remarks',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o290',
        'objectId': 'C75E01CE-442E-485A-949C-6F54CEFC5995',
        'name': '发布类型',
        'code': 'release_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'releaseType',
        'codeCamelPlural': 'releaseTypes',
        'codeUnderscore': 'release_type',
        'codeUnderscorePlural': 'release_types',
        'type': 'number'
      },
      {
        'id': 'o291',
        'objectId': 'FABCD839-BA2F-4D6B-AE93-4A77895754AA',
        'name': '发布时间',
        'code': 'release_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'releaseTime',
        'codeCamelPlural': 'releaseTimes',
        'codeUnderscore': 'release_time',
        'codeUnderscorePlural': 'release_times',
        'type': 'datetime'
      },
      {
        'id': 'o292',
        'objectId': '50A41678-8487-4108-B498-A81B77EA4229',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o293',
        'objectId': '7B52322F-93ED-4682-BD17-576144DB8BD6',
        'name': '是否发布',
        'code': 'is_release',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'isRelease',
        'codeCamelPlural': 'isReleases',
        'codeUnderscore': 'is_release',
        'codeUnderscorePlural': 'is_releases',
        'type': 'number'
      },
      {
        'id': 'o294',
        'objectId': '17F9B255-E031-47D1-8934-600358441907',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o295',
        'objectId': 'C0A3187D-FFA1-4013-B08F-B76ADE23977E',
        'name': '保存草稿时间',
        'code': 'save_draft_time',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'saveDraftTime',
        'codeCamelPlural': 'saveDraftTimes',
        'codeUnderscore': 'save_draft_time',
        'codeUnderscorePlural': 'save_draft_times',
        'type': 'datetime'
      },
      {
        'id': 'o296',
        'objectId': '75393C40-B82B-44DC-B0BE-97323D9C227C',
        'name': '是否显示在专网首页',
        'code': 'is_show_home',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'isShowHome',
        'codeCamelPlural': 'isShowHomes',
        'codeUnderscore': 'is_show_home',
        'codeUnderscorePlural': 'is_show_homes',
        'type': 'datetime'
      },
      {
        'id': 'o297',
        'objectId': '69FFF59C-92B7-45B2-A4F4-1EBF8E9EC94D',
        'name': '附件类型',
        'code': 'annex_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'annexType',
        'codeCamelPlural': 'annexTypes',
        'codeUnderscore': 'annex_type',
        'codeUnderscorePlural': 'annex_types',
        'type': 'number'
      },
      {
        'id': 'o298',
        'objectId': 'CF2EB293-1240-4AB6-AB67-C5FF5E7996EA',
        'name': '文件类型',
        'code': 'file_type',
        'creationDate': '1516592899',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'fileType',
        'codeCamelPlural': 'fileTypes',
        'codeUnderscore': 'file_type',
        'codeUnderscorePlural': 'file_types',
        'type': 'number'
      },
      {
        'id': 'o299',
        'objectId': '88281CE3-74BF-4BF0-8B9A-87684B013B9F',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516619369',
        'creator': 'yide',
        'modificationDate': '1517186089',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      }
    ]
  },
  'CcWorkCircle': {
    'model': 'CcWorkCircle',
    'modelPlural': 'CcWorkCircles',
    'modelCamel': 'ccWorkCircle',
    'modelCamelPlural': 'ccWorkCircles',
    'modelUnderscore': 'cc_work_circle',
    'modelUnderscorePlural': 'cc_work_circles',
    'columns': [
      {
        'id': 'o302',
        'objectId': '6C6D9E0D-D9C9-40AE-911C-B25337502036',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o303',
        'objectId': 'D9D5066A-F607-4705-B266-186D838E73D1',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o304',
        'objectId': '006127A6-9741-48F9-AEF6-065C34161599',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o305',
        'objectId': '79EE9EFC-F6BE-466F-AC14-94AF0D44DCD6',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o306',
        'objectId': 'AAB2B820-965E-4D09-938A-6C575FF54C6E',
        'name': '描述',
        'code': 'remarks',
        'creationDate': '1516594154',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcUser': {
    'model': 'CcUser',
    'modelPlural': 'CcUsers',
    'modelCamel': 'ccUser',
    'modelCamelPlural': 'ccUsers',
    'modelUnderscore': 'cc_user',
    'modelUnderscorePlural': 'cc_users',
    'columns': [
      {
        'id': 'o309',
        'objectId': 'D3866FB1-2265-43F3-8F9B-15CBDCACA12A',
        'name': '圈子成员',
        'code': 'user_id',
        'creationDate': '1516594354',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o310',
        'objectId': 'DF72B6F2-918F-4547-90A4-67144C51E45E',
        'name': '所属圈子',
        'code': 'cc_work_circle_id',
        'creationDate': '1516594354',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcWorkCircle',
          'modelCamel': 'ccWorkCircle',
          'modelCamelPlural': 'ccWorkCircles',
          'modelUnderscore': 'cc_work_circle',
          'modelUnderscorePlural': 'cc_work_circles'
        },
        'codeCamel': 'ccWorkCircleId',
        'codeCamelPlural': 'ccWorkCircleIds',
        'codeUnderscore': 'cc_work_circle_id',
        'codeUnderscorePlural': 'cc_work_circle_ids',
        'type': 'string'
      },
      {
        'id': 'o311',
        'objectId': '1754F7DA-144D-4EC0-9E95-0BB94289B3C8',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594406',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o312',
        'objectId': '20D3FD45-2B50-494F-9A78-C3F0DA80DF30',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594406',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageTaskActivity': {
    'model': 'CcMessageTaskActivity',
    'modelPlural': 'CcMessageTaskActivities',
    'modelCamel': 'ccMessageTaskActivity',
    'modelCamelPlural': 'ccMessageTaskActivities',
    'modelUnderscore': 'cc_message_task_activity',
    'modelUnderscorePlural': 'cc_message_task_activities',
    'columns': [
      {
        'id': 'o315',
        'objectId': '05E61AB7-A96C-46C2-86E1-91CBFE2279F6',
        'name': '所属圈子',
        'code': 'cc_work_circle_id',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcWorkCircle',
          'modelCamel': 'ccWorkCircle',
          'modelCamelPlural': 'ccWorkCircles',
          'modelUnderscore': 'cc_work_circle',
          'modelUnderscorePlural': 'cc_work_circles'
        },
        'codeCamel': 'ccWorkCircleId',
        'codeCamelPlural': 'ccWorkCircleIds',
        'codeUnderscore': 'cc_work_circle_id',
        'codeUnderscorePlural': 'cc_work_circle_ids',
        'type': 'string'
      },
      {
        'id': 'o316',
        'objectId': 'D9D071F7-9FEA-4D22-BD93-0EC1BBB93684',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(200)',
        'length': '200',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o317',
        'objectId': 'D224F3AC-EC14-4832-AB35-E8A436D0A5FC',
        'name': '正文',
        'code': 'text',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'text',
        'codeCamelPlural': 'texts',
        'codeUnderscore': 'text',
        'codeUnderscorePlural': 'texts',
        'type': 'string'
      },
      {
        'id': 'o318',
        'objectId': '9D965B45-FEA3-4E16-AB7E-926C37E2DF6A',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o319',
        'objectId': 'FFAA470C-F23E-4C0B-A904-3E715122C5B3',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594622',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o320',
        'objectId': '2354FD56-7927-4398-828E-234F9CAD4928',
        'name': '创建人',
        'code': 'user_id',
        'creationDate': '1516594995',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o321',
        'objectId': 'AB6A1FD6-BD77-45EB-91C9-171E71817818',
        'name': '类型',
        'code': 'type',
        'creationDate': '1516595889',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o322',
        'objectId': '05AAEF68-34E5-429C-B883-190649874B4D',
        'name': '图片',
        'code': 'image_url',
        'creationDate': '1520407897',
        'creator': 'yide',
        'modificationDate': '1520408229',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'imageUrl',
        'codeCamelPlural': 'imageUrls',
        'codeUnderscore': 'image_url',
        'codeUnderscorePlural': 'image_urls',
        'type': 'string'
      },
      {
        'id': 'o323',
        'objectId': 'EB50D0A7-F64F-4896-A60D-CC21498009A3',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520408035',
        'creator': 'yide',
        'modificationDate': '1520408200',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcPraise': {
    'model': 'CcPraise',
    'modelPlural': 'CcPraises',
    'modelCamel': 'ccPraise',
    'modelCamelPlural': 'ccPraises',
    'modelUnderscore': 'cc_praise',
    'modelUnderscorePlural': 'cc_praises',
    'columns': [
      {
        'id': 'o326',
        'objectId': '86575B62-8B13-4882-8CA5-40A5ECEF777F',
        'name': '所属消息、任务、活动',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcMessageTaskActivity',
          'modelCamel': 'ccMessageTaskActivity',
          'modelCamelPlural': 'ccMessageTaskActivities',
          'modelUnderscore': 'cc_message_task_activity',
          'modelUnderscorePlural': 'cc_message_task_activities'
        },
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o327',
        'objectId': '0CF9E7F7-CABB-41C9-B439-B17B8F859DE2',
        'name': '点赞人',
        'code': 'user_id',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o328',
        'objectId': '25ACA4A5-824D-4A72-A940-AD9F1B9368B5',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o329',
        'objectId': '72453E19-F7D3-4CC0-A603-14F9E63EF8FB',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516594874',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageReply': {
    'model': 'CcMessageReply',
    'modelPlural': 'CcMessageReplies',
    'modelCamel': 'ccMessageReply',
    'modelCamelPlural': 'ccMessageReplies',
    'modelUnderscore': 'cc_message_reply',
    'modelUnderscorePlural': 'cc_message_replies',
    'columns': [
      {
        'id': 'o332',
        'objectId': '96C59171-D6D3-41D7-8B92-A11DC8EECD8A',
        'name': '点评人',
        'code': 'user_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o333',
        'objectId': '0584C677-B98E-4F24-8B9D-CCC7376BE6C9',
        'name': '回复消息回复',
        'code': 'cc_message_reply_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcMessageTaskActivity',
          'modelCamel': 'ccMessageTaskActivity',
          'modelCamelPlural': 'ccMessageTaskActivities',
          'modelUnderscore': 'cc_message_task_activity',
          'modelUnderscorePlural': 'cc_message_task_activities'
        },
        'codeCamel': 'ccMessageReplyId',
        'codeCamelPlural': 'ccMessageReplyIds',
        'codeUnderscore': 'cc_message_reply_id',
        'codeUnderscorePlural': 'cc_message_reply_ids',
        'type': 'string'
      },
      {
        'id': 'o334',
        'objectId': '7A74B43C-797A-4683-9F58-A45EBABADF03',
        'name': '所属消息、任务、活动',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o335',
        'objectId': '7B3A3A4A-603D-4C02-BFD6-1CFFF6302DCB',
        'name': '回复内容',
        'code': 'content',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o336',
        'objectId': '16B835F9-1268-4F07-B643-74594491FBE0',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o337',
        'objectId': '45ECB100-8A04-4003-88F7-5C695458D7F1',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o338',
        'objectId': 'AE4183AD-664C-45AF-BFDD-4FEF5AC4A13F',
        'name': '消息类型',
        'code': 'type',
        'creationDate': '1516595128',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      }
    ]
  },
  'CcMessageReplyStatu': {
    'model': 'CcMessageReplyStatu',
    'modelPlural': 'CcMessageReplyStatus',
    'modelCamel': 'ccMessageReplyStatu',
    'modelCamelPlural': 'ccMessageReplyStatus',
    'modelUnderscore': 'cc_message_reply_statu',
    'modelUnderscorePlural': 'cc_message_reply_status',
    'columns': [
      {
        'id': 'o341',
        'objectId': '045C40F0-4EA3-41B3-ABBB-F36029B53EB6',
        'name': '回复消息id',
        'code': 'cc_message_reply_id',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcMessageReply',
          'modelCamel': 'ccMessageReply',
          'modelCamelPlural': 'ccMessageReplies',
          'modelUnderscore': 'cc_message_reply',
          'modelUnderscorePlural': 'cc_message_replies'
        },
        'codeCamel': 'ccMessageReplyId',
        'codeCamelPlural': 'ccMessageReplyIds',
        'codeUnderscore': 'cc_message_reply_id',
        'codeUnderscorePlural': 'cc_message_reply_ids',
        'type': 'string'
      },
      {
        'id': 'o342',
        'objectId': '3A0D90FA-5AE1-4258-8D3D-AF5CC68C450D',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o343',
        'objectId': '97B515F5-FE19-49A3-94C0-171F3C3DE4A7',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o344',
        'objectId': '285753FA-3BE5-44DC-80CA-B471CC43326B',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516595575',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMessageTaskActivityParticipate': {
    'model': 'CcMessageTaskActivityParticipate',
    'modelPlural': 'CcMessageTaskActivityParticipates',
    'modelCamel': 'ccMessageTaskActivityParticipate',
    'modelCamelPlural': 'ccMessageTaskActivityParticipates',
    'modelUnderscore': 'cc_message_task_activity_participate',
    'modelUnderscorePlural': 'cc_message_task_activity_participates',
    'columns': [
      {
        'id': 'o347',
        'objectId': '9DB774B5-0077-4907-BB26-2EC65377DF28',
        'name': '参与人',
        'code': 'user_id',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o348',
        'objectId': 'A6D0A38D-BCE1-4A1C-85D2-FECB935D118E',
        'name': '参与的活动id',
        'code': 'cc_message_task_activity_id',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'foreignTable': {
          'model': 'CcMessageTaskActivity',
          'modelCamel': 'ccMessageTaskActivity',
          'modelCamelPlural': 'ccMessageTaskActivities',
          'modelUnderscore': 'cc_message_task_activity',
          'modelUnderscorePlural': 'cc_message_task_activities'
        },
        'codeCamel': 'ccMessageTaskActivityId',
        'codeCamelPlural': 'ccMessageTaskActivityIds',
        'codeUnderscore': 'cc_message_task_activity_id',
        'codeUnderscorePlural': 'cc_message_task_activity_ids',
        'type': 'string'
      },
      {
        'id': 'o349',
        'objectId': 'BF382D92-97A2-4674-9F84-AE021E6FB4C7',
        'name': '参与的操作',
        'code': 'content',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'varchar(5000)',
        'length': '5000',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o350',
        'objectId': 'EB25C8E0-2DE7-4A42-B1D6-8A52C37C530C',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o351',
        'objectId': '448CB49C-F216-403E-8A30-33F7288BEAAD',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1516596176',
        'creator': 'yide',
        'modificationDate': '1517186098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcTotalCall': {
    'model': 'CcTotalCall',
    'modelPlural': 'CcTotalCalls',
    'modelCamel': 'ccTotalCall',
    'modelCamelPlural': 'ccTotalCalls',
    'modelUnderscore': 'cc_total_call',
    'modelUnderscorePlural': 'cc_total_calls',
    'columns': [
      {
        'id': 'o354',
        'objectId': '79F09FDE-9E09-4384-815A-C38905BF62CA',
        'name': '单位',
        'code': 'unit',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'unit',
        'codeCamelPlural': 'units',
        'codeUnderscore': 'unit',
        'codeUnderscorePlural': 'units',
        'type': 'string'
      },
      {
        'id': 'o355',
        'objectId': 'DF10A595-456D-4173-90E9-30CBB12D6E52',
        'name': '部门',
        'code': 'department',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'department',
        'codeCamelPlural': 'departments',
        'codeUnderscore': 'department',
        'codeUnderscorePlural': 'departments',
        'type': 'string'
      },
      {
        'id': 'o356',
        'objectId': '4507C1A9-D760-4524-AFF4-EA1CA29C1083',
        'name': '电话',
        'code': 'phone',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'phone',
        'codeCamelPlural': 'phones',
        'codeUnderscore': 'phone',
        'codeUnderscorePlural': 'phones',
        'type': 'string'
      },
      {
        'id': 'o357',
        'objectId': '5E21807E-A911-4F9B-B3F0-32AB6A1D35C8',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o358',
        'objectId': '534FE4EC-50DE-47C6-A0E2-494B84241D6C',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623289',
        'creator': 'yide',
        'modificationDate': '1517186109',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcSecondaryMenuDictionary': {
    'model': 'CcSecondaryMenuDictionary',
    'modelPlural': 'CcSecondaryMenuDictionaries',
    'modelCamel': 'ccSecondaryMenuDictionary',
    'modelCamelPlural': 'ccSecondaryMenuDictionaries',
    'modelUnderscore': 'cc_secondary_menu_dictionary',
    'modelUnderscorePlural': 'cc_secondary_menu_dictionaries',
    'columns': [
      {
        'id': 'o361',
        'objectId': '7A26DCC7-2195-41E0-A59B-53B820FE5445',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o362',
        'objectId': 'BCE0151C-8F72-4432-8B34-79DF52F14688',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o363',
        'objectId': '77960568-7F94-4C3B-8C18-655887B5E793',
        'name': '最后更新时间',
        'code': 'lst_update_time',
        'creationDate': '1516624328',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lstUpdateTime',
        'codeCamelPlural': 'lstUpdateTimes',
        'codeUnderscore': 'lst_update_time',
        'codeUnderscorePlural': 'lst_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcMenuResource': {
    'model': 'CcMenuResource',
    'modelPlural': 'CcMenuResources',
    'modelCamel': 'ccMenuResource',
    'modelCamelPlural': 'ccMenuResources',
    'modelUnderscore': 'cc_menu_resource',
    'modelUnderscorePlural': 'cc_menu_resources',
    'columns': [
      {
        'id': 'o366',
        'objectId': 'E0232D85-FABA-42B1-8E1E-E21D4A7A5B62',
        'name': '文件名称',
        'code': 'name',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o367',
        'objectId': 'F978196E-61EA-4F93-B9C7-66DBBA794D3A',
        'name': '标题',
        'code': 'title',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o368',
        'objectId': '777D6C5D-5A54-4171-94E7-F737B8B60C18',
        'name': '简介',
        'code': 'lntroduction',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'lntroduction',
        'codeCamelPlural': 'lntroductions',
        'codeUnderscore': 'lntroduction',
        'codeUnderscorePlural': 'lntroductions',
        'type': 'string'
      },
      {
        'id': 'o369',
        'objectId': '33449CD4-C227-42EB-95D6-EAF42CA5DB94',
        'name': '发布人',
        'code': 'publisher',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'publisher',
        'codeCamelPlural': 'publishers',
        'codeUnderscore': 'publisher',
        'codeUnderscorePlural': 'publishers',
        'type': 'string'
      },
      {
        'id': 'o370',
        'objectId': 'F87A9677-66F1-435F-86AE-CE357552FAC9',
        'name': '类型',
        'code': 'type',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o371',
        'objectId': 'A264D410-B6AF-44A3-8DE4-D96F893501D5',
        'name': '封面图片',
        'code': 'thumbnail',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1520564182',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'thumbnail',
        'codeCamelPlural': 'thumbnails',
        'codeUnderscore': 'thumbnail',
        'codeUnderscorePlural': 'thumbnails',
        'type': 'string'
      },
      {
        'id': 'o372',
        'objectId': '9F014F8E-09D7-4930-AB28-FF747BEE0A9B',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1520564503',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o373',
        'objectId': '8666BD33-451B-4EB4-85F9-E386BBAE510F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516624411',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o374',
        'objectId': '05E11BFA-4FC4-4F37-9EFE-26F415BC0121',
        'name': '发布时间',
        'code': 'release_time',
        'creationDate': '1520564182',
        'creator': 'yide',
        'modificationDate': '1520564503',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'releaseTime',
        'codeCamelPlural': 'releaseTimes',
        'codeUnderscore': 'release_time',
        'codeUnderscorePlural': 'release_times',
        'type': 'datetime'
      },
      {
        'id': 'o375',
        'objectId': 'B6E38C2C-638D-495F-B560-7A1C05576187',
        'name': '视频名称',
        'code': 'video_name',
        'creationDate': '1520564182',
        'creator': 'yide',
        'modificationDate': '1520564503',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'videoName',
        'codeCamelPlural': 'videoNames',
        'codeUnderscore': 'video_name',
        'codeUnderscorePlural': 'video_names',
        'type': 'string'
      },
      {
        'id': 'o376',
        'objectId': '94575AEA-F6A2-4643-A0D4-FECD1359ED3F',
        'name': '视频路径',
        'code': 'video_path',
        'creationDate': '1520564182',
        'creator': 'yide',
        'modificationDate': '1520564503',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'videoPath',
        'codeCamelPlural': 'videoPaths',
        'codeUnderscore': 'video_path',
        'codeUnderscorePlural': 'video_paths',
        'type': 'string'
      },
      {
        'id': 'o377',
        'objectId': 'ADE705A5-D9ED-4A1F-8580-BFF461105393',
        'name': '内容',
        'code': 'content',
        'creationDate': '1520564182',
        'creator': 'yide',
        'modificationDate': '1520564503',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      }
    ]
  },
  'CcMenuResourceAssociation': {
    'model': 'CcMenuResourceAssociation',
    'modelPlural': 'CcMenuResourceAssociations',
    'modelCamel': 'ccMenuResourceAssociation',
    'modelCamelPlural': 'ccMenuResourceAssociations',
    'modelUnderscore': 'cc_menu_resource_association',
    'modelUnderscorePlural': 'cc_menu_resource_associations',
    'columns': [
      {
        'id': 'o380',
        'objectId': 'D1CF9181-9FEF-4338-8709-FE81BBA2D904',
        'name': '菜单id',
        'code': 'menu_id',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517187173',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcSecondaryMenuDictionary',
          'modelCamel': 'ccSecondaryMenuDictionary',
          'modelCamelPlural': 'ccSecondaryMenuDictionaries',
          'modelUnderscore': 'cc_secondary_menu_dictionary',
          'modelUnderscorePlural': 'cc_secondary_menu_dictionaries'
        },
        'codeCamel': 'menuId',
        'codeCamelPlural': 'menuIds',
        'codeUnderscore': 'menu_id',
        'codeUnderscorePlural': 'menu_ids',
        'type': 'string'
      },
      {
        'id': 'o381',
        'objectId': '57FD053C-2DF9-4CEC-B2F8-E09680CC5D75',
        'name': '资源id',
        'code': 'resource_id',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcMenuResource',
          'modelCamel': 'ccMenuResource',
          'modelCamelPlural': 'ccMenuResources',
          'modelUnderscore': 'cc_menu_resource',
          'modelUnderscorePlural': 'cc_menu_resources'
        },
        'codeCamel': 'resourceId',
        'codeCamelPlural': 'resourceIds',
        'codeUnderscore': 'resource_id',
        'codeUnderscorePlural': 'resource_ids',
        'type': 'string'
      },
      {
        'id': 'o382',
        'objectId': '17F85474-8F01-409C-9EB2-EFCCAB8A84C5',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o383',
        'objectId': '1379ECE0-5237-48E6-9735-06C3793F5828',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516624615',
        'creator': 'yide',
        'modificationDate': '1517186121',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcProcuratorate': {
    'model': 'CcProcuratorate',
    'modelPlural': 'CcProcuratorates',
    'modelCamel': 'ccProcuratorate',
    'modelCamelPlural': 'ccProcuratorates',
    'modelUnderscore': 'cc_procuratorate',
    'modelUnderscorePlural': 'cc_procuratorates',
    'columns': [
      {
        'id': 'o386',
        'objectId': '117CBCF2-0EAA-40A2-8BA7-5F1FA4877106',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o387',
        'objectId': 'A1BCCC38-F837-4877-A054-DEE89EBCBDC1',
        'name': 'icon标题',
        'code': 'icon_tile',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'iconTile',
        'codeCamelPlural': 'iconTiles',
        'codeUnderscore': 'icon_tile',
        'codeUnderscorePlural': 'icon_tiles',
        'type': 'string'
      },
      {
        'id': 'o388',
        'objectId': '4E81C6E7-BCCF-43C5-AD44-E3DC1B1CA581',
        'name': '官方网站',
        'code': 'official_website',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'officialWebsite',
        'codeCamelPlural': 'officialWebsites',
        'codeUnderscore': 'official_website',
        'codeUnderscorePlural': 'official_websites',
        'type': 'string'
      },
      {
        'id': 'o389',
        'objectId': '6777DEE4-A6C0-438D-9485-5F610A28AD13',
        'name': '上级id',
        'code': 'parent_id',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'parentId',
        'codeCamelPlural': 'parentIds',
        'codeUnderscore': 'parent_id',
        'codeUnderscorePlural': 'parent_ids',
        'type': 'string'
      },
      {
        'id': 'o390',
        'objectId': 'C32E15A6-0A42-4A95-861E-4E2543C82C34',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o391',
        'objectId': 'E0D22E4E-8B11-410C-9C24-7BE8DF5D77CE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o392',
        'objectId': 'FF50B21F-8BF7-4A60-A9E1-957326C99A9C',
        'name': '简介',
        'code': 'Introduction',
        'creationDate': '1516624111',
        'creator': 'yide',
        'modificationDate': '1517186131',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'introduction',
        'codeCamelPlural': 'introductions',
        'codeUnderscore': 'introduction',
        'codeUnderscorePlural': 'introductions',
        'type': 'string'
      }
    ]
  },
  'CcDigitalBook': {
    'model': 'CcDigitalBook',
    'modelPlural': 'CcDigitalBooks',
    'modelCamel': 'ccDigitalBook',
    'modelCamelPlural': 'ccDigitalBooks',
    'modelUnderscore': 'cc_digital_book',
    'modelUnderscorePlural': 'cc_digital_books',
    'columns': [
      {
        'id': 'o395',
        'objectId': 'A91EB68C-DCD0-42FB-8837-9C59A9B21D1B',
        'name': '书名',
        'code': 'book_name',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'bookName',
        'codeCamelPlural': 'bookNames',
        'codeUnderscore': 'book_name',
        'codeUnderscorePlural': 'book_names',
        'type': 'string'
      },
      {
        'id': 'o396',
        'objectId': 'DA394B8E-04B2-4926-A6EF-B822E85E62A9',
        'name': '作者',
        'code': 'author',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'author',
        'codeCamelPlural': 'authors',
        'codeUnderscore': 'author',
        'codeUnderscorePlural': 'authors',
        'type': 'string'
      },
      {
        'id': 'o397',
        'objectId': '2B373844-8096-4BA5-8BC9-EF60235E687C',
        'name': '出版社',
        'code': 'publishing_house',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'publishingHouse',
        'codeCamelPlural': 'publishingHouses',
        'codeUnderscore': 'publishing_house',
        'codeUnderscorePlural': 'publishing_houses',
        'type': 'string'
      },
      {
        'id': 'o398',
        'objectId': '21977459-DA31-45CB-AC8A-9149579A421F',
        'name': '出版日期',
        'code': 'date_publication',
        'creationDate': '1520215748',
        'creator': 'yide',
        'modificationDate': '1520215775',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'datePublication',
        'codeCamelPlural': 'datePublications',
        'codeUnderscore': 'date_publication',
        'codeUnderscorePlural': 'date_publications',
        'type': 'datetime'
      },
      {
        'id': 'o399',
        'objectId': '201A205C-89C4-4851-A884-535F49ACDAC5',
        'name': '出版年代',
        'code': 'year_publication',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'yearPublication',
        'codeCamelPlural': 'yearPublications',
        'codeUnderscore': 'year_publication',
        'codeUnderscorePlural': 'year_publications',
        'type': 'string'
      },
      {
        'id': 'o400',
        'objectId': 'DA677C68-2771-4D03-AAB9-45BB2CBA4E72',
        'name': '书籍类型',
        'code': 'type',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o401',
        'objectId': '795AAF47-9471-478E-81B0-DB8DA46C4943',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o402',
        'objectId': 'B73B0F2F-793C-4A2A-B5A2-B72223DD5AD0',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516601703',
        'creator': 'yide',
        'modificationDate': '1517186137',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcLogging': {
    'model': 'CcLogging',
    'modelPlural': 'CcLoggings',
    'modelCamel': 'ccLogging',
    'modelCamelPlural': 'ccLoggings',
    'modelUnderscore': 'cc_logging',
    'modelUnderscorePlural': 'cc_loggings',
    'columns': [
      {
        'id': 'o405',
        'objectId': '19ED900A-55C6-478F-8C06-F736670CA88D',
        'name': '操作人',
        'code': 'operator',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'operator',
        'codeCamelPlural': 'operators',
        'codeUnderscore': 'operator',
        'codeUnderscorePlural': 'operators',
        'type': 'string'
      },
      {
        'id': 'o406',
        'objectId': '793DF0F3-5276-49DF-9A22-BA5081BA0052',
        'name': '登录时间段',
        'code': 'login_time_period',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'loginTimePeriod',
        'codeCamelPlural': 'loginTimePeriods',
        'codeUnderscore': 'login_time_period',
        'codeUnderscorePlural': 'login_time_periods',
        'type': 'datetime'
      },
      {
        'id': 'o407',
        'objectId': 'AD6E90D6-D196-430B-A7A4-08C48807ACDB',
        'name': '操作时间段',
        'code': 'operating_time_period',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'operatingTimePeriod',
        'codeCamelPlural': 'operatingTimePeriods',
        'codeUnderscore': 'operating_time_period',
        'codeUnderscorePlural': 'operating_time_periods',
        'type': 'datetime'
      },
      {
        'id': 'o408',
        'objectId': 'F0E2D7DB-BDE3-4AF8-931B-33754C5E4CF5',
        'name': '登录类型',
        'code': 'login_type',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'loginType',
        'codeCamelPlural': 'loginTypes',
        'codeUnderscore': 'login_type',
        'codeUnderscorePlural': 'login_types',
        'type': 'number'
      },
      {
        'id': 'o409',
        'objectId': '33DD0885-D4B4-4850-8707-B025A64E461E',
        'name': '操作类型',
        'code': 'type_operation',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'typeOperation',
        'codeCamelPlural': 'typeOperations',
        'codeUnderscore': 'type_operation',
        'codeUnderscorePlural': 'type_operations',
        'type': 'string'
      },
      {
        'id': 'o410',
        'objectId': 'CDA47511-8BA1-4267-90ED-9A4FC7CEEBFA',
        'name': '操作模块',
        'code': 'operating_module',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'operatingModule',
        'codeCamelPlural': 'operatingModules',
        'codeUnderscore': 'operating_module',
        'codeUnderscorePlural': 'operating_modules',
        'type': 'string'
      },
      {
        'id': 'o411',
        'objectId': 'C0739437-14E9-4A91-A07A-7716BFD18A2C',
        'name': '所属组织',
        'code': 'affiliation',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'affiliation',
        'codeCamelPlural': 'affiliations',
        'codeUnderscore': 'affiliation',
        'codeUnderscorePlural': 'affiliations',
        'type': 'string'
      },
      {
        'id': 'o412',
        'objectId': '9E586E79-DCCD-4BA7-ACF7-FAE2E93B51F0',
        'name': '所属部门',
        'code': 'their_department',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'theirDepartment',
        'codeCamelPlural': 'theirDepartments',
        'codeUnderscore': 'their_department',
        'codeUnderscorePlural': 'their_departments',
        'type': 'string'
      },
      {
        'id': 'o413',
        'objectId': 'EC1967CD-6199-406D-846D-A0AA6AC0D9A0',
        'name': '日志内容',
        'code': 'log_content',
        'creationDate': '1516625377',
        'creator': 'yide',
        'modificationDate': '1517186144',
        'modifier': 'yide',
        'dataType': 'varchar(4096)',
        'length': '4096',
        'codeCamel': 'logContent',
        'codeCamelPlural': 'logContents',
        'codeUnderscore': 'log_content',
        'codeUnderscorePlural': 'log_contents',
        'type': 'string'
      }
    ]
  },
  'CcAddressBook': {
    'model': 'CcAddressBook',
    'modelPlural': 'CcAddressBooks',
    'modelCamel': 'ccAddressBook',
    'modelCamelPlural': 'ccAddressBooks',
    'modelUnderscore': 'cc_address_book',
    'modelUnderscorePlural': 'cc_address_books',
    'columns': [
      {
        'id': 'o416',
        'objectId': '37B78CCB-20C4-4F78-80A7-0CC01FFC8E96',
        'name': '联系人id',
        'code': 'contact_id',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'HmUser2',
          'modelCamel': 'hmUser2',
          'modelCamelPlural': 'hmUser2S',
          'modelUnderscore': 'hm_user2',
          'modelUnderscorePlural': 'hm_user2S'
        },
        'codeCamel': 'contactId',
        'codeCamelPlural': 'contactIds',
        'codeUnderscore': 'contact_id',
        'codeUnderscorePlural': 'contact_ids',
        'type': 'string'
      },
      {
        'id': 'o417',
        'objectId': '5D2CB394-5FF9-4799-8B8C-6CC48FD3C935',
        'name': '联系号码',
        'code': 'contact_number',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186316',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'contactNumber',
        'codeCamelPlural': 'contactNumbers',
        'codeUnderscore': 'contact_number',
        'codeUnderscorePlural': 'contact_numbers',
        'type': 'string'
      },
      {
        'id': 'o418',
        'objectId': '8A52E9AE-54E0-48D9-960C-49E3B8D79C11',
        'name': '状态',
        'code': 'status',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o419',
        'objectId': '7E20B2ED-3984-48B2-B372-1FD186BDD9B9',
        'name': '谁的通讯录',
        'code': 'who_address_book',
        'creationDate': '1516608273',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'whoAddressBook',
        'codeCamelPlural': 'whoAddressBooks',
        'codeUnderscore': 'who_address_book',
        'codeUnderscorePlural': 'who_address_books',
        'type': 'string'
      },
      {
        'id': 'o420',
        'objectId': '0B939852-4245-48F5-A7ED-DA86949D7891',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o421',
        'objectId': '9C05E18A-0B55-4088-80E3-64B5B0964CDC',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o422',
        'objectId': 'A5C096D3-CC35-468E-A9A1-76EAC4C20E35',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o423',
        'objectId': 'F67A7681-8984-46B6-B281-85452D65F64A',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516601917',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'HmUser2': {
    'model': 'HmUser2',
    'modelPlural': 'HmUser2S',
    'modelCamel': 'hmUser2',
    'modelCamelPlural': 'hmUser2S',
    'modelUnderscore': 'hm_user2',
    'modelUnderscorePlural': 'hm_user2S',
    'columns': [
      {
        'id': 'o426',
        'objectId': '84F13FFE-9682-412F-B86C-3C8C68D2DFB8',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o427',
        'objectId': '6A027C75-5B15-4D1B-A69C-B7B45013BE72',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o428',
        'objectId': '1BD4130E-FDE7-452C-8137-1E3D99CCB61C',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o429',
        'objectId': '883D5241-780B-4B07-81FE-1F8A05333044',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o430',
        'objectId': '012ADB3C-2B35-4EB8-809A-8105F880BBD6',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o431',
        'objectId': 'B8951D57-D1D9-4A04-BB39-F1FEDB3BC950',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o432',
        'objectId': 'B26B75DE-56CE-49E2-89F9-1AF2E4A840B4',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o433',
        'objectId': 'C2156628-116D-41F2-B8B5-79F8A9D80895',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o434',
        'objectId': '48D449BA-FC4D-4D3A-BF09-A891C627A02D',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o435',
        'objectId': '30E9B035-A6FD-49CA-983E-705C34162D52',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o436',
        'objectId': 'E0386394-AD66-4591-859F-2B5E1F2A1D89',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o437',
        'objectId': 'B5BCB5C5-192F-4BD0-8215-BB65A8288168',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517186153',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcCanteenCardSpending': {
    'model': 'CcCanteenCardSpending',
    'modelPlural': 'CcCanteenCardSpendings',
    'modelCamel': 'ccCanteenCardSpending',
    'modelCamelPlural': 'ccCanteenCardSpendings',
    'modelUnderscore': 'cc_canteen_card_spending',
    'modelUnderscorePlural': 'cc_canteen_card_spendings',
    'columns': [
      {
        'id': 'o440',
        'objectId': 'DBB121B8-B97A-4840-9C16-32F41519D9FC',
        'name': '消费人员',
        'code': 'people',
        'creationDate': '1516608458',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'people',
        'codeCamelPlural': 'people',
        'codeUnderscore': 'people',
        'codeUnderscorePlural': 'people',
        'type': 'string'
      },
      {
        'id': 'o441',
        'objectId': '47CF3995-B71B-407B-AA80-454D1ED2DA81',
        'name': '消费金额',
        'code': 'amount_consumption',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'double',
        'codeCamel': 'amountConsumption',
        'codeCamelPlural': 'amountConsumptions',
        'codeUnderscore': 'amount_consumption',
        'codeUnderscorePlural': 'amount_consumptions',
        'type': 'number'
      },
      {
        'id': 'o442',
        'objectId': '8E873C91-3FD8-4764-ABB3-74B8EFC917FC',
        'name': '消费时间',
        'code': 'spending_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'spendingTime',
        'codeCamelPlural': 'spendingTimes',
        'codeUnderscore': 'spending_time',
        'codeUnderscorePlural': 'spending_times',
        'type': 'datetime'
      },
      {
        'id': 'o443',
        'objectId': '7088DEE3-AA94-4F93-883E-820326B5F9A4',
        'name': '消费类型',
        'code': 'type',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o444',
        'objectId': 'A1E9BC8F-EC52-419E-A31C-E573B9F79E61',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o445',
        'objectId': '454F5535-8FD8-41FA-9573-C95DFED5E3C5',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o446',
        'objectId': '15234182-7387-4D15-A5D9-857BFD3C5E34',
        'name': '余额',
        'code': 'balance',
        'creationDate': '1516602518',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'double',
        'codeCamel': 'balance',
        'codeCamelPlural': 'balances',
        'codeUnderscore': 'balance',
        'codeUnderscorePlural': 'balances',
        'type': 'number'
      }
    ]
  },
  'HmUser': {
    'model': 'HmUser',
    'modelPlural': 'HmUsers',
    'modelCamel': 'hmUser',
    'modelCamelPlural': 'hmUsers',
    'modelUnderscore': 'hm_user',
    'modelUnderscorePlural': 'hm_users',
    'columns': [
      {
        'id': 'o449',
        'objectId': '96B8B552-949D-441D-9E9D-537B4EC3D6A5',
        'name': '用户名字',
        'code': 'username',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'foreignTable': {
          'model': 'authToken',
          'modelCamel': 'authToken',
          'modelCamelPlural': 'authTokens',
          'modelUnderscore': 'auth_token',
          'modelUnderscorePlural': 'auth_tokens'
        },
        'codeCamel': 'username',
        'codeCamelPlural': 'usernames',
        'codeUnderscore': 'username',
        'codeUnderscorePlural': 'usernames',
        'type': 'string'
      },
      {
        'id': 'o450',
        'objectId': '7BCB231E-A918-440E-A0EF-28C05622DFE3',
        'name': '登录ID',
        'code': 'loginid',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'columnMandatory': '1',
        'codeCamel': 'loginid',
        'codeCamelPlural': 'loginids',
        'codeUnderscore': 'loginid',
        'codeUnderscorePlural': 'loginids',
        'type': 'string'
      },
      {
        'id': 'o451',
        'objectId': 'F6802DC5-1328-4DBA-A056-75E4D62FEAA4',
        'name': '密码',
        'code': 'password',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'password',
        'codeCamelPlural': 'passwords',
        'codeUnderscore': 'password',
        'codeUnderscorePlural': 'passwords',
        'type': 'string'
      },
      {
        'id': 'o452',
        'objectId': 'FC448B4F-BE63-42F6-812E-93C8916F5DA4',
        'name': '联系电话',
        'code': 'mobile',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(16)',
        'length': '16',
        'codeCamel': 'mobile',
        'codeCamelPlural': 'mobiles',
        'codeUnderscore': 'mobile',
        'codeUnderscorePlural': 'mobiles',
        'type': 'string'
      },
      {
        'id': 'o453',
        'objectId': '2258795B-6BDA-4A77-8F76-326D65E135EA',
        'name': '邮箱',
        'code': 'email',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'email',
        'codeCamelPlural': 'emails',
        'codeUnderscore': 'email',
        'codeUnderscorePlural': 'emails',
        'type': 'string'
      },
      {
        'id': 'o454',
        'objectId': '7B134816-F72B-4830-8A0E-58748F4696EF',
        'name': '头像',
        'code': 'avatar',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'avatar',
        'codeCamelPlural': 'avatars',
        'codeUnderscore': 'avatar',
        'codeUnderscorePlural': 'avatars',
        'type': 'string'
      },
      {
        'id': 'o455',
        'objectId': '53E7A96B-3CA5-4991-B1FD-9EFF56B25B44',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o456',
        'objectId': '0E5A430B-4B17-4DFA-92AF-457B113CF481',
        'name': '更新时间',
        'code': 'last_update_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o457',
        'objectId': 'BC3617FB-A06D-486E-AD1E-CD978A881142',
        'name': '最后登录时间',
        'code': 'last_login_time',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastLoginTime',
        'codeCamelPlural': 'lastLoginTimes',
        'codeUnderscore': 'last_login_time',
        'codeUnderscorePlural': 'last_login_times',
        'type': 'datetime'
      },
      {
        'id': 'o458',
        'objectId': '0C87C134-1F9E-46FD-8865-AC616F169E1C',
        'name': '安全级别',
        'code': 'security_level',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'securityLevel',
        'codeCamelPlural': 'securityLevels',
        'codeUnderscore': 'security_level',
        'codeUnderscorePlural': 'security_levels',
        'type': 'number'
      },
      {
        'id': 'o459',
        'objectId': '4900C242-F151-4B43-8C43-8603B0EDAF49',
        'name': '类型',
        'code': 'type',
        'creationDate': '1498990741',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'comment': '1:企业，2：代理商',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o460',
        'objectId': 'AD21D50C-88DD-40A5-AE98-235B1D74324C',
        'name': '部门id',
        'code': 'department_id',
        'creationDate': '1503476586',
        'creator': 'yide',
        'modificationDate': '1517186161',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcCheckNavigation': {
    'model': 'CcCheckNavigation',
    'modelPlural': 'CcCheckNavigations',
    'modelCamel': 'ccCheckNavigation',
    'modelCamelPlural': 'ccCheckNavigations',
    'modelUnderscore': 'cc_check_navigation',
    'modelUnderscorePlural': 'cc_check_navigations',
    'columns': [
      {
        'id': 'o463',
        'objectId': '51453EE3-6597-43D0-81D5-45EEFD5E8139',
        'name': '名称',
        'code': 'name',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o464',
        'objectId': 'AC7DF886-C78C-410B-86C5-41ABF96D9E1B',
        'name': 'icon标题',
        'code': 'icon_tile',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'iconTile',
        'codeCamelPlural': 'iconTiles',
        'codeUnderscore': 'icon_tile',
        'codeUnderscorePlural': 'icon_tiles',
        'type': 'string'
      },
      {
        'id': 'o465',
        'objectId': '6A487C4A-BF74-41E3-B310-F1130AA26DB9',
        'name': '官方网站',
        'code': 'official_website',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'officialWebsite',
        'codeCamelPlural': 'officialWebsites',
        'codeUnderscore': 'official_website',
        'codeUnderscorePlural': 'official_websites',
        'type': 'string'
      },
      {
        'id': 'o466',
        'objectId': '1F0467ED-6A16-486E-8238-E068E530A7BA',
        'name': '上级id',
        'code': 'parent_id',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'parentId',
        'codeCamelPlural': 'parentIds',
        'codeUnderscore': 'parent_id',
        'codeUnderscorePlural': 'parent_ids',
        'type': 'string'
      },
      {
        'id': 'o467',
        'objectId': '1E6BC255-B254-4F80-869E-8F4B0B951761',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o468',
        'objectId': '8F06F06D-BBB4-4896-A7B9-0D193A3CF4A4',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1516623692',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o469',
        'objectId': 'ED770D0E-FBF9-406E-A4F1-E4E4A5915B59',
        'name': '简介',
        'code': 'lntroduction',
        'creationDate': '1516624111',
        'creator': 'yide',
        'modificationDate': '1517893108',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'lntroduction',
        'codeCamelPlural': 'lntroductions',
        'codeUnderscore': 'lntroduction',
        'codeUnderscorePlural': 'lntroductions',
        'type': 'string'
      },
      {
        'id': 'o470',
        'objectId': '7A60AA1A-21E8-4B53-B0A8-D88A1A42CC69',
        'name': '概况',
        'code': 'survey',
        'creationDate': '1517892939',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'survey',
        'codeCamelPlural': 'surveys',
        'codeUnderscore': 'survey',
        'codeUnderscorePlural': 'surveys',
        'type': 'string'
      },
      {
        'id': 'o471',
        'objectId': '56B4F551-EB58-45C5-87AE-E4FE2C2FB108',
        'name': '机构设置',
        'code': 'lnstitution_setting',
        'creationDate': '1517892939',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'lnstitutionSetting',
        'codeCamelPlural': 'lnstitutionSettings',
        'codeUnderscore': 'lnstitution_setting',
        'codeUnderscorePlural': 'lnstitution_settings',
        'type': 'string'
      },
      {
        'id': 'o472',
        'objectId': '70203EB7-5987-4EB6-8D19-397B707F8925',
        'name': '检查职能机构设置单位简介',
        'code': 'function',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(6144)',
        'length': '6144',
        'codeCamel': 'function',
        'codeCamelPlural': 'functions',
        'codeUnderscore': 'function',
        'codeUnderscorePlural': 'functions',
        'type': 'string'
      },
      {
        'id': 'o473',
        'objectId': 'EBBBB0B3-A4C7-4C3A-9B87-DC5032C8BBA0',
        'name': '微信地址',
        'code': 'wechat_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'wechatAddress',
        'codeCamelPlural': 'wechatAddresses',
        'codeUnderscore': 'wechat_address',
        'codeUnderscorePlural': 'wechat_addresses',
        'type': 'string'
      },
      {
        'id': 'o474',
        'objectId': 'DEFE33A8-2EAA-4A19-AF41-E2FF1E2FAD37',
        'name': '微博地址',
        'code': 'micro_blog_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'microBlogAddress',
        'codeCamelPlural': 'microBlogAddresses',
        'codeUnderscore': 'micro_blog_address',
        'codeUnderscorePlural': 'micro_blog_addresses',
        'type': 'string'
      },
      {
        'id': 'o475',
        'objectId': 'ED695748-DE8B-48D7-A88E-F4E3553DC690',
        'name': '头条地址',
        'code': 'headline_address',
        'creationDate': '1517893108',
        'creator': 'yide',
        'modificationDate': '1517894027',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'headlineAddress',
        'codeCamelPlural': 'headlineAddresses',
        'codeUnderscore': 'headline_address',
        'codeUnderscorePlural': 'headline_addresses',
        'type': 'string'
      },
      {
        'id': 'o476',
        'objectId': 'D3F2AF28-8C00-4E24-9A5A-5B4B0DEB0894',
        'name': '类型',
        'code': 'type',
        'creationDate': '1517894103',
        'creator': 'yide',
        'modificationDate': '1517896759',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      }
    ]
  },
  'CcNotification': {
    'model': 'CcNotification',
    'modelPlural': 'CcNotifications',
    'modelCamel': 'ccNotification',
    'modelCamelPlural': 'ccNotifications',
    'modelUnderscore': 'cc_notification',
    'modelUnderscorePlural': 'cc_notifications',
    'columns': [
      {
        'id': 'o479',
        'objectId': '6F115051-18ED-407D-B688-1DB2E062C1F2',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o480',
        'objectId': '04C175A8-1E14-49A3-98EA-C8A888795DFC',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o481',
        'objectId': 'A8D13242-CA8B-4D85-99CD-AB59DC4C495A',
        'name': '类型',
        'code': 'type',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517902860',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o482',
        'objectId': 'F277EF1E-7304-46E8-AC9D-D9A065166C22',
        'name': '标题',
        'code': 'title',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(512)',
        'length': '512',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o483',
        'objectId': '3A51C135-F410-4F48-B677-273577993088',
        'name': '签收类型',
        'code': 'sign_type',
        'creationDate': '1517902682',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'comment': '1.签收2.非签收',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'signType',
        'codeCamelPlural': 'signTypes',
        'codeUnderscore': 'sign_type',
        'codeUnderscorePlural': 'sign_types',
        'type': 'string'
      },
      {
        'id': 'o484',
        'objectId': '44815BE2-BE98-4FC7-93D5-FF78F8F7F7B5',
        'name': '公告类型',
        'code': 'notice_type',
        'creationDate': '1517902860',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'comment': '1.通知.2.通报',
        'dataType': 'varchar(43)',
        'length': '43',
        'codeCamel': 'noticeType',
        'codeCamelPlural': 'noticeTypes',
        'codeUnderscore': 'notice_type',
        'codeUnderscorePlural': 'notice_types',
        'type': 'string'
      },
      {
        'id': 'o485',
        'objectId': '769F47EC-1C2E-4098-82E1-EB83AB36C8E1',
        'name': '发布内容',
        'code': 'publish_content',
        'creationDate': '1517902897',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(4096)',
        'length': '4096',
        'codeCamel': 'publishContent',
        'codeCamelPlural': 'publishContents',
        'codeUnderscore': 'publish_content',
        'codeUnderscorePlural': 'publish_contents',
        'type': 'string'
      },
      {
        'id': 'o486',
        'objectId': '8DBEA194-914F-429C-8B06-193D5F1DEE7C',
        'name': '审批状态',
        'code': 'state_approval',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'stateApproval',
        'codeCamelPlural': 'stateApprovals',
        'codeUnderscore': 'state_approval',
        'codeUnderscorePlural': 'state_approvals',
        'type': 'string'
      },
      {
        'id': 'o487',
        'objectId': '5768A6F2-DB27-411F-B8C3-14BB017A3FD5',
        'name': '是否撤销',
        'code': 'revokes',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908940',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'revokes',
        'codeCamelPlural': 'revokes',
        'codeUnderscore': 'revokes',
        'codeUnderscorePlural': 'revokes',
        'type': 'string'
      },
      {
        'id': 'o488',
        'objectId': '254A3CE6-D2EB-432A-8812-492ECA39588C',
        'name': '是否短信提醒',
        'code': 'sms_reminding',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'smsReminding',
        'codeCamelPlural': 'smsRemindings',
        'codeUnderscore': 'sms_reminding',
        'codeUnderscorePlural': 'sms_remindings',
        'type': 'string'
      },
      {
        'id': 'o489',
        'objectId': '0203317E-D891-49B5-BAA3-C75FFD982E0C',
        'name': '是否推送专网',
        'code': 'special_network',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'specialNetwork',
        'codeCamelPlural': 'specialNetworks',
        'codeUnderscore': 'special_network',
        'codeUnderscorePlural': 'special_networks',
        'type': 'string'
      },
      {
        'id': 'o490',
        'objectId': '6E2CE4CD-3BA1-4287-8654-AFAD05FA49B6',
        'name': '是否推送多媒体',
        'code': 'push_multimedia',
        'creationDate': '1517906794',
        'creator': 'yide',
        'modificationDate': '1517908623',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'pushMultimedia',
        'codeCamelPlural': 'pushMultimedias',
        'codeUnderscore': 'push_multimedia',
        'codeUnderscorePlural': 'push_multimedias',
        'type': 'string'
      },
      {
        'id': 'o491',
        'objectId': '6BE29475-78B3-40A1-ACE2-4A46D8FD62EF',
        'name': '最终审批人',
        'code': 'final_approver',
        'creationDate': '1517908623',
        'creator': 'yide',
        'modificationDate': '1517908656',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'finalApprover',
        'codeCamelPlural': 'finalApprovers',
        'codeUnderscore': 'final_approver',
        'codeUnderscorePlural': 'final_approvers',
        'type': 'string'
      },
      {
        'id': 'o492',
        'objectId': 'B79A02F8-A887-45FE-A15E-7B4035EF0246',
        'name': '发布人',
        'code': 'publisher_id',
        'creationDate': '1520211884',
        'creator': 'yide',
        'modificationDate': '1520211967',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'publisherId',
        'codeCamelPlural': 'publisherIds',
        'codeUnderscore': 'publisher_id',
        'codeUnderscorePlural': 'publisher_ids',
        'type': 'string'
      },
      {
        'id': 'o493',
        'objectId': '879407C0-6405-4B02-8818-2663A87E6422',
        'name': '发布时间',
        'code': 'release_time',
        'creationDate': '1520588975',
        'creator': 'yide',
        'modificationDate': '1520589135',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'releaseTime',
        'codeCamelPlural': 'releaseTimes',
        'codeUnderscore': 'release_time',
        'codeUnderscorePlural': 'release_times',
        'type': 'datetime'
      }
    ]
  },
  'CcPublisher': {
    'model': 'CcPublisher',
    'modelPlural': 'CcPublishers',
    'modelCamel': 'ccPublisher',
    'modelCamelPlural': 'ccPublishers',
    'modelUnderscore': 'cc_publisher',
    'modelUnderscorePlural': 'cc_publishers',
    'columns': [
      {
        'id': 'o496',
        'objectId': 'DEA80EDC-151A-4D9E-B3AF-E0C29E6DE6B0',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o497',
        'objectId': '262898A8-CCEC-4435-A336-73FDF9300645',
        'name': '最后创建时间',
        'code': 'last_update_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o498',
        'objectId': '24B938F2-6598-4ECA-879A-929119CF3763',
        'name': '通知通报id',
        'code': 'cc_notifications_id',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o499',
        'objectId': '16A9AA93-BDE7-454D-A393-2CBCA86E3FEE',
        'name': '是否查看',
        'code': 'see',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905823',
        'modifier': 'yide',
        'comment': '1.查看.   其他都是未查看',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'see',
        'codeCamelPlural': 'sees',
        'codeUnderscore': 'see',
        'codeUnderscorePlural': 'sees',
        'type': 'string'
      },
      {
        'id': 'o500',
        'objectId': '2863D653-418D-473A-A546-A6364F1D59F3',
        'name': '是否签收',
        'code': 'sign',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905843',
        'modifier': 'yide',
        'comment': '1.签收.  其他都是未签收',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'sign',
        'codeCamelPlural': 'signs',
        'codeUnderscore': 'sign',
        'codeUnderscorePlural': 'signs',
        'type': 'string'
      },
      {
        'id': 'o501',
        'objectId': '0637FE2F-E9C6-470F-B9F9-2B6C3F3B1DCA',
        'name': '签收时间',
        'code': 'sign_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'signTime',
        'codeCamelPlural': 'signTimes',
        'codeUnderscore': 'sign_time',
        'codeUnderscorePlural': 'sign_times',
        'type': 'datetime'
      },
      {
        'id': 'o502',
        'objectId': 'F8BF7EFF-A11A-4CAE-AB19-88E4DF561AF8',
        'name': '查看时间',
        'code': 'see_time',
        'creationDate': '1517905334',
        'creator': 'yide',
        'modificationDate': '1517905766',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'seeTime',
        'codeCamelPlural': 'seeTimes',
        'codeUnderscore': 'see_time',
        'codeUnderscorePlural': 'see_times',
        'type': 'datetime'
      },
      {
        'id': 'o503',
        'objectId': 'E830C00B-0780-482A-A289-F18E2D844971',
        'name': '接收人id',
        'code': 'recipient_id',
        'creationDate': '1520580296',
        'creator': 'yide',
        'modificationDate': '1520580381',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'recipientId',
        'codeCamelPlural': 'recipientIds',
        'codeUnderscore': 'recipient_id',
        'codeUnderscorePlural': 'recipient_ids',
        'type': 'string'
      }
    ]
  },
  'CcAssociatedFile': {
    'model': 'CcAssociatedFile',
    'modelPlural': 'CcAssociatedFiles',
    'modelCamel': 'ccAssociatedFile',
    'modelCamelPlural': 'ccAssociatedFiles',
    'modelUnderscore': 'cc_associated_file',
    'modelUnderscorePlural': 'cc_associated_files',
    'columns': [
      {
        'id': 'o506',
        'objectId': '82595090-88F1-4048-9DC0-9A1D350FA3D1',
        'name': '通知通报id',
        'code': 'cc_notifications_id',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517908819',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o507',
        'objectId': 'A362390A-3193-452B-8D20-5E609B691BC7',
        'name': '文件id',
        'code': 'file_id',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o508',
        'objectId': '2783A94A-FF29-4198-B85C-B98D89FB481F',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o509',
        'objectId': '8F8161D3-59C5-45E0-B4B6-90B238363713',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1517906069',
        'creator': 'yide',
        'modificationDate': '1517906672',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o510',
        'objectId': '0D9E082E-F201-4249-A4DE-D9205450034A',
        'name': '文件类型',
        'code': 'type',
        'creationDate': '1520408533',
        'creator': 'yide',
        'modificationDate': '1520408566',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      }
    ]
  },
  'CcApprovalProce': {
    'model': 'CcApprovalProce',
    'modelPlural': 'CcApprovalProces',
    'modelCamel': 'ccApprovalProce',
    'modelCamelPlural': 'ccApprovalProces',
    'modelUnderscore': 'cc_approval_proce',
    'modelUnderscorePlural': 'cc_approval_proces',
    'columns': [
      {
        'id': 'o513',
        'objectId': '364B610A-8E79-42CE-9848-AB9C9C63EFBD',
        'name': '审批人',
        'code': 'approver_id',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approverId',
        'codeCamelPlural': 'approverIds',
        'codeUnderscore': 'approver_id',
        'codeUnderscorePlural': 'approver_ids',
        'type': 'string'
      },
      {
        'id': 'o514',
        'objectId': '94CD0829-9627-4835-A93C-98BD691C7F2F',
        'name': '通知通告id',
        'code': 'cc_notifications_id',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccNotificationsId',
        'codeCamelPlural': 'ccNotificationsIds',
        'codeUnderscore': 'cc_notifications_id',
        'codeUnderscorePlural': 'cc_notifications_ids',
        'type': 'string'
      },
      {
        'id': 'o515',
        'objectId': '598FF24D-3D8E-4AF6-BA83-BF2C33C75D24',
        'name': '创建日期',
        'code': 'create_time',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o516',
        'objectId': 'F9B3E808-6487-4CB4-AC3A-B3185B3DE72A',
        'name': '最后更新日期',
        'code': 'last_update_time',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o517',
        'objectId': 'E48B0C06-0D12-46AE-A273-167073583A36',
        'name': '上级流转',
        'code': 'superior_circulation',
        'creationDate': '1517907031',
        'creator': 'yide',
        'modificationDate': '1517907341',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'superiorCirculation',
        'codeCamelPlural': 'superiorCirculations',
        'codeUnderscore': 'superior_circulation',
        'codeUnderscorePlural': 'superior_circulations',
        'type': 'string'
      },
      {
        'id': 'o518',
        'objectId': '95C58042-4758-4B90-AAF7-9583586B3E97',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1520211986',
        'creator': 'yide',
        'modificationDate': '1520212036',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcRuleMaintenance': {
    'model': 'CcRuleMaintenance',
    'modelPlural': 'CcRuleMaintenances',
    'modelCamel': 'ccRuleMaintenance',
    'modelCamelPlural': 'ccRuleMaintenances',
    'modelUnderscore': 'cc_rule_maintenance',
    'modelUnderscorePlural': 'cc_rule_maintenances',
    'columns': [
      {
        'id': 'o521',
        'objectId': '9D5F0C2F-69CE-4E7C-AE36-CEBA58606D26',
        'name': '规则编号',
        'code': 'number',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520228108',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'number',
        'codeCamelPlural': 'numbers',
        'codeUnderscore': 'number',
        'codeUnderscorePlural': 'numbers',
        'type': 'string'
      },
      {
        'id': 'o522',
        'objectId': '0E967962-7931-40F5-8A3E-3F6593B6FD70',
        'name': '规则名称',
        'code': 'name',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716631',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(255)',
        'length': '255',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o523',
        'objectId': 'D5D15673-2501-473B-B04C-74E4F4D9CCE3',
        'name': '创建人',
        'code': 'creator_id',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716631',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'creatorId',
        'codeCamelPlural': 'creatorIds',
        'codeUnderscore': 'creator_id',
        'codeUnderscorePlural': 'creator_ids',
        'type': 'string'
      },
      {
        'id': 'o524',
        'objectId': 'CAB1F09B-7619-4D77-A2D0-D4D702DD7B1A',
        'name': '启用',
        'code': 'is_used',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218514',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'isUsed',
        'codeCamelPlural': 'isUseds',
        'codeUnderscore': 'is_used',
        'codeUnderscorePlural': 'is_useds',
        'type': 'number'
      },
      {
        'id': 'o525',
        'objectId': 'C12CDD2F-23E9-43BA-9371-569EDE7FDBD2',
        'name': '创建日期',
        'code': 'create_time',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218514',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o526',
        'objectId': 'E19C6C37-4C4E-4D12-BA3B-662BE1F75ABE',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716631',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o527',
        'objectId': '8641411A-B498-4EFA-8445-61741EE174F1',
        'name': '使用科室',
        'code': 'department_id',
        'creationDate': '1519716304',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716631',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      }
    ]
  },
  'CcNumberMaintenance': {
    'model': 'CcNumberMaintenance',
    'modelPlural': 'CcNumberMaintenances',
    'modelCamel': 'ccNumberMaintenance',
    'modelCamelPlural': 'ccNumberMaintenances',
    'modelUnderscore': 'cc_number_maintenance',
    'modelUnderscorePlural': 'cc_number_maintenances',
    'columns': [
      {
        'id': 'o530',
        'objectId': '05CDA9C6-E076-40DB-B9F6-673E34D64D60',
        'name': '区域名称',
        'code': 'area_name',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(255)',
        'length': '255',
        'codeCamel': 'areaName',
        'codeCamelPlural': 'areaNames',
        'codeUnderscore': 'area_name',
        'codeUnderscorePlural': 'area_names',
        'type': 'string'
      },
      {
        'id': 'o531',
        'objectId': '9D272D03-B6EE-47B5-9F71-D5B08C1AD2A5',
        'name': '区域类型',
        'code': 'area_type',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'areaType',
        'codeCamelPlural': 'areaTypes',
        'codeUnderscore': 'area_type',
        'codeUnderscorePlural': 'area_types',
        'type': 'number'
      },
      {
        'id': 'o532',
        'objectId': 'B56EEE66-78BC-4695-BD10-CD5A1023CCFA',
        'name': '区域长度',
        'code': 'area_length',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'areaLength',
        'codeCamelPlural': 'areaLengths',
        'codeUnderscore': 'area_length',
        'codeUnderscorePlural': 'area_lengths',
        'type': 'number'
      },
      {
        'id': 'o533',
        'objectId': '5EAA439A-4975-42D3-8C6C-4597114FCB85',
        'name': '是否使用',
        'code': 'is_used',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'isUsed',
        'codeCamelPlural': 'isUseds',
        'codeUnderscore': 'is_used',
        'codeUnderscorePlural': 'is_useds',
        'type': 'number'
      },
      {
        'id': 'o534',
        'objectId': 'A5BEF767-C1AF-4314-8F11-3455F9107EB2',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o535',
        'objectId': '6BBF3924-EAB1-486A-AF6D-86EE6991E9D4',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1519716703',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519716990',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcTemplateManager': {
    'model': 'CcTemplateManager',
    'modelPlural': 'CcTemplateManagers',
    'modelCamel': 'ccTemplateManager',
    'modelCamelPlural': 'ccTemplateManagers',
    'modelUnderscore': 'cc_template_manager',
    'modelUnderscorePlural': 'cc_template_managers',
    'columns': [
      {
        'id': 'o538',
        'objectId': 'E31A59A5-9710-40AC-8D00-E56C859178D6',
        'name': '模板名称',
        'code': 'name',
        'creationDate': '1519717068',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218278',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(255)',
        'length': '255',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o539',
        'objectId': 'D195026B-6DC6-4C3C-98E8-01C9BBD5FD15',
        'name': '选择模板',
        'code': 'template',
        'creationDate': '1519717068',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218278',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(255)',
        'length': '255',
        'codeCamel': 'template',
        'codeCamelPlural': 'templates',
        'codeUnderscore': 'template',
        'codeUnderscorePlural': 'templates',
        'type': 'string'
      },
      {
        'id': 'o540',
        'objectId': '0F060A9E-2052-48BE-AB19-732C4DFCC8C9',
        'name': '使用科室',
        'code': 'department_id',
        'creationDate': '1519717068',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218278',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      },
      {
        'id': 'o541',
        'objectId': '06A96CCC-6DA0-4AFF-B523-B973B35E7716',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1519717068',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218278',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o542',
        'objectId': 'DCD4E06B-9504-4428-A269-362209F9FDF8',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1519717068',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218278',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcOfficialDocumentGenerate': {
    'model': 'CcOfficialDocumentGenerate',
    'modelPlural': 'CcOfficialDocumentGenerates',
    'modelCamel': 'ccOfficialDocumentGenerate',
    'modelCamelPlural': 'ccOfficialDocumentGenerates',
    'modelUnderscore': 'cc_official_document_generate',
    'modelUnderscorePlural': 'cc_official_document_generates',
    'columns': [
      {
        'id': 'o545',
        'objectId': '41023AA2-24A8-4F81-AEE6-9DE52A664E8D',
        'name': '公文名称',
        'code': 'name',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(255)',
        'length': '255',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o546',
        'objectId': 'D387C090-68B2-4519-B3FF-26A2D404AF58',
        'name': '生成科室',
        'code': 'department_id',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'departmentId',
        'codeCamelPlural': 'departmentIds',
        'codeUnderscore': 'department_id',
        'codeUnderscorePlural': 'department_ids',
        'type': 'string'
      },
      {
        'id': 'o547',
        'objectId': '9A204A28-0B9D-4B78-9D99-A678C8448087',
        'name': '生成人',
        'code': 'creator_id',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'creatorId',
        'codeCamelPlural': 'creatorIds',
        'codeUnderscore': 'creator_id',
        'codeUnderscorePlural': 'creator_ids',
        'type': 'string'
      },
      {
        'id': 'o548',
        'objectId': '426979E8-83D2-4BEE-A88C-48AD4468AE83',
        'name': '机密年限',
        'code': 'secret_years',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'secretYears',
        'codeCamelPlural': 'secretYears',
        'codeUnderscore': 'secret_years',
        'codeUnderscorePlural': 'secret_years',
        'type': 'number'
      },
      {
        'id': 'o549',
        'objectId': 'F9DD87FB-3574-49BE-9C90-C24EB373BA41',
        'name': '紧急程度',
        'code': 'emergency_level',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'int',
        'codeCamel': 'emergencyLevel',
        'codeCamelPlural': 'emergencyLevels',
        'codeUnderscore': 'emergency_level',
        'codeUnderscorePlural': 'emergency_levels',
        'type': 'number'
      },
      {
        'id': 'o550',
        'objectId': '1F16EE92-FA44-48F2-810D-5C4F6585C709',
        'name': '选择模板',
        'code': 'template_id',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'templateId',
        'codeCamelPlural': 'templateIds',
        'codeUnderscore': 'template_id',
        'codeUnderscorePlural': 'template_ids',
        'type': 'string'
      },
      {
        'id': 'o551',
        'objectId': '30C2C61D-8344-4048-9B57-F7A4EDE25583',
        'name': '选择字号',
        'code': 'font',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(100)',
        'length': '100',
        'codeCamel': 'font',
        'codeCamelPlural': 'fonts',
        'codeUnderscore': 'font',
        'codeUnderscorePlural': 'fonts',
        'type': 'string'
      },
      {
        'id': 'o552',
        'objectId': 'CE020650-3E16-4561-A1C6-1631772D39CE',
        'name': '正文内容',
        'code': 'content',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'text',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o553',
        'objectId': '6A0B3E3A-7C3D-4D48-8D3C-ED1BF7D300C1',
        'name': '已生成文件',
        'code': 'file_name',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218608',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(100)',
        'length': '100',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o554',
        'objectId': '81AC01F0-0AC7-4DFC-A231-4F94D0E3D865',
        'name': '生成文件路径',
        'code': 'file_path',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(100)',
        'length': '100',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o555',
        'objectId': 'CCA0BBC3-99DD-4380-BC05-BD10F381DD5D',
        'name': '备注',
        'code': 'remarks',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'varchar(1000)',
        'length': '1000',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o556',
        'objectId': '3EE91CCA-7F33-4E72-BF33-2217F780759B',
        'name': '生成时间',
        'code': 'create_tine',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1520218703',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'createTine',
        'codeCamelPlural': 'createTines',
        'codeUnderscore': 'create_tine',
        'codeUnderscorePlural': 'create_tines',
        'type': 'datetime'
      },
      {
        'id': 'o557',
        'objectId': 'A9A021C4-719B-4664-8B72-32003F5B7D13',
        'name': '最后修改时间',
        'code': 'last_update_time',
        'creationDate': '1519717302',
        'creator': 'shidaizhoukan',
        'modificationDate': '1519717843',
        'modifier': 'shidaizhoukan',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcPendingTask': {
    'model': 'CcPendingTask',
    'modelPlural': 'CcPendingTasks',
    'modelCamel': 'ccPendingTask',
    'modelCamelPlural': 'ccPendingTasks',
    'modelUnderscore': 'cc_pending_task',
    'modelUnderscorePlural': 'cc_pending_tasks',
    'columns': [
      {
        'id': 'o560',
        'objectId': '8BE7836C-CB2B-461C-A8DA-DA81D6BD1BD8',
        'name': '任务类型',
        'code': 'type',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1520589387',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o561',
        'objectId': 'E8C3FD75-6074-46DA-B673-321F076D73C6',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1519802970',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o562',
        'objectId': '34466663-D5D5-4F24-A7B9-D1AFBA2CE68F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1519802970',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o563',
        'objectId': '6CD263D7-4026-4F4D-8675-5FD40E3AF94D',
        'name': '任务状态',
        'code': 'status',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1520589387',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o564',
        'objectId': 'D3A5B27A-0D4D-4C24-8A5F-D8B349F73EA6',
        'name': '备忘',
        'code': 'remarks',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1520566233',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'remarks',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remarks',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o565',
        'objectId': '1C9582B6-2D16-43BE-A836-501539EA8845',
        'name': '待办任务id',
        'code': 'pending_task_id',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1519802970',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'pendingTaskId',
        'codeCamelPlural': 'pendingTaskIds',
        'codeUnderscore': 'pending_task_id',
        'codeUnderscorePlural': 'pending_task_ids',
        'type': 'string'
      },
      {
        'id': 'o566',
        'objectId': '2CD9F80F-2D28-4194-A1A7-5107F6189E92',
        'name': '审批人id',
        'code': 'approver',
        'creationDate': '1519802521',
        'creator': 'yide',
        'modificationDate': '1519802970',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'approver',
        'codeCamelPlural': 'approvers',
        'codeUnderscore': 'approver',
        'codeUnderscorePlural': 'approvers',
        'type': 'string'
      },
      {
        'id': 'o567',
        'objectId': '2167F3AA-85D2-4BAC-88F3-4EE020059ACF',
        'name': '任务地点',
        'code': 'task_location',
        'creationDate': '1520227183',
        'creator': 'yide',
        'modificationDate': '1520227453',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'taskLocation',
        'codeCamelPlural': 'taskLocations',
        'codeUnderscore': 'task_location',
        'codeUnderscorePlural': 'task_locations',
        'type': 'string'
      },
      {
        'id': 'o568',
        'objectId': '1919DD69-4EEC-4BAD-A552-7B4C2BE1E503',
        'name': '任务时间',
        'code': 'task_time',
        'creationDate': '1520227183',
        'creator': 'yide',
        'modificationDate': '1520227453',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'taskTime',
        'codeCamelPlural': 'taskTimes',
        'codeUnderscore': 'task_time',
        'codeUnderscorePlural': 'task_times',
        'type': 'datetime'
      },
      {
        'id': 'o569',
        'objectId': '0E0B1BFA-C44A-45DA-9FD1-195B1E47EA3C',
        'name': '完成时间',
        'code': 'completion_time',
        'creationDate': '1520227183',
        'creator': 'yide',
        'modificationDate': '1520227453',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'completionTime',
        'codeCamelPlural': 'completionTimes',
        'codeUnderscore': 'completion_time',
        'codeUnderscorePlural': 'completion_times',
        'type': 'datetime'
      },
      {
        'id': 'o570',
        'objectId': '9D0F58FF-F882-4C79-8207-207C637C6735',
        'name': '审批时间',
        'code': 'examination_approval_time',
        'creationDate': '1520227183',
        'creator': 'yide',
        'modificationDate': '1520227453',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'examinationApprovalTime',
        'codeCamelPlural': 'examinationApprovalTimes',
        'codeUnderscore': 'examination_approval_time',
        'codeUnderscorePlural': 'examination_approval_times',
        'type': 'datetime'
      },
      {
        'id': 'o571',
        'objectId': '06AA0579-74A5-4537-B1F6-D343DE03B209',
        'name': '审批意见',
        'code': 'examination_approval_opinion',
        'creationDate': '1520227183',
        'creator': 'yide',
        'modificationDate': '1520227453',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'examinationApprovalOpinion',
        'codeCamelPlural': 'examinationApprovalOpinions',
        'codeUnderscore': 'examination_approval_opinion',
        'codeUnderscorePlural': 'examination_approval_opinions',
        'type': 'string'
      },
      {
        'id': 'o572',
        'objectId': 'F7B3FBC9-974F-487F-8F8B-048EE739BB0A',
        'name': '任务名称',
        'code': 'task_name',
        'creationDate': '1520566147',
        'creator': 'yide',
        'modificationDate': '1520566233',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'taskName',
        'codeCamelPlural': 'taskNames',
        'codeUnderscore': 'task_name',
        'codeUnderscorePlural': 'task_names',
        'type': 'string'
      }
    ]
  },
  'CcMemorandum': {
    'model': 'CcMemorandum',
    'modelPlural': 'CcMemorandums',
    'modelCamel': 'ccMemorandum',
    'modelCamelPlural': 'ccMemorandums',
    'modelUnderscore': 'cc_memorandum',
    'modelUnderscorePlural': 'cc_memorandums',
    'columns': [
      {
        'id': 'o575',
        'objectId': '26F2FF5C-232E-46FA-97C6-3ABDA619D051',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1519803999',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o576',
        'objectId': '563510E4-2C51-4238-80D2-D6D890D7A4A9',
        'name': '完成时间',
        'code': 'completion_time',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1519803999',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'completionTime',
        'codeCamelPlural': 'completionTimes',
        'codeUnderscore': 'completion_time',
        'codeUnderscorePlural': 'completion_times',
        'type': 'datetime'
      },
      {
        'id': 'o577',
        'objectId': '2F46A0CE-0AA4-43E0-A253-92FC0E5FF94F',
        'name': '时间',
        'code': 'time_completed',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1520566240',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'timeCompleted',
        'codeCamelPlural': 'timeCompleteds',
        'codeUnderscore': 'time_completed',
        'codeUnderscorePlural': 'time_completeds',
        'type': 'datetime'
      },
      {
        'id': 'o578',
        'objectId': 'CFAE8054-3869-4301-B7C9-383F25F6D323',
        'name': '标题',
        'code': 'tile',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1519803999',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'tile',
        'codeCamelPlural': 'tiles',
        'codeUnderscore': 'tile',
        'codeUnderscorePlural': 'tiles',
        'type': 'string'
      },
      {
        'id': 'o579',
        'objectId': 'CD77202E-81FC-4A97-B472-E8EC562B36D2',
        'name': '内容',
        'code': 'content',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1519803999',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o580',
        'objectId': 'FDE0CC04-19F0-4265-AE32-D667127597F4',
        'name': '提醒方式',
        'code': 'modes',
        'creationDate': '1519803136',
        'creator': 'yide',
        'modificationDate': '1519809086',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'modes',
        'codeCamelPlural': 'modes',
        'codeUnderscore': 'modes',
        'codeUnderscorePlural': 'modes',
        'type': 'number'
      },
      {
        'id': 'o581',
        'objectId': 'BB1CCBC4-C1E6-4215-A135-5131BBB8DFAE',
        'name': '用户id',
        'code': 'user_id',
        'creationDate': '1519803999',
        'creator': 'yide',
        'modificationDate': '1519804022',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      }
    ]
  },
  'CcSoundRecording': {
    'model': 'CcSoundRecording',
    'modelPlural': 'CcSoundRecordings',
    'modelCamel': 'ccSoundRecording',
    'modelCamelPlural': 'ccSoundRecordings',
    'modelUnderscore': 'cc_sound_recording',
    'modelUnderscorePlural': 'cc_sound_recordings',
    'columns': [
      {
        'id': 'o584',
        'objectId': '848FFB67-0B88-45D9-B358-6AC9ECF708F9',
        'name': '文件名称',
        'code': 'file_name',
        'creationDate': '1519804030',
        'creator': 'yide',
        'modificationDate': '1519804392',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o585',
        'objectId': 'E05F82AF-ECE0-4EE8-8A8F-5F15BF39C66F',
        'name': '文件路径',
        'code': 'file_path',
        'creationDate': '1519804030',
        'creator': 'yide',
        'modificationDate': '1519804392',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o586',
        'objectId': '0A8CB3F1-AA89-4912-898C-160BB5A32437',
        'name': '上传人',
        'code': 'uploading_person',
        'creationDate': '1519804030',
        'creator': 'yide',
        'modificationDate': '1519804392',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadingPerson',
        'codeCamelPlural': 'uploadingPeople',
        'codeUnderscore': 'uploading_person',
        'codeUnderscorePlural': 'uploading_people',
        'type': 'string'
      },
      {
        'id': 'o587',
        'objectId': 'A9EBDD66-9CF8-473F-9F93-0AEA546D2152',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1519804030',
        'creator': 'yide',
        'modificationDate': '1519804392',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o588',
        'objectId': 'FAF59070-22AD-4B2E-AB43-2CE95E942A46',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1519804030',
        'creator': 'yide',
        'modificationDate': '1519804392',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o589',
        'objectId': '0E758B9A-B998-436C-AA1D-D666037DDD15',
        'name': '类型',
        'code': 'type',
        'creationDate': '1520213038',
        'creator': 'yide',
        'modificationDate': '1520213071',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      }
    ]
  },
  'CcResource': {
    'model': 'CcResource',
    'modelPlural': 'CcResources',
    'modelCamel': 'ccResource',
    'modelCamelPlural': 'ccResources',
    'modelUnderscore': 'cc_resource',
    'modelUnderscorePlural': 'cc_resources',
    'columns': [
      {
        'id': 'o592',
        'objectId': '77885F2D-27BD-44C1-A8A5-02014099516D',
        'name': '资源名称',
        'code': 'name',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o593',
        'objectId': '3561B238-E0F0-4453-927B-872CF153E258',
        'name': '资料科室',
        'code': 'lnformation_department',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'lnformationDepartment',
        'codeCamelPlural': 'lnformationDepartments',
        'codeUnderscore': 'lnformation_department',
        'codeUnderscorePlural': 'lnformation_departments',
        'type': 'string'
      },
      {
        'id': 'o594',
        'objectId': 'C090D56C-0B8E-4355-BA07-9FB1206FD6F3',
        'name': '上传日期',
        'code': 'upload_time',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'uploadTime',
        'codeCamelPlural': 'uploadTimes',
        'codeUnderscore': 'upload_time',
        'codeUnderscorePlural': 'upload_times',
        'type': 'datetime'
      },
      {
        'id': 'o595',
        'objectId': 'E73AD667-0618-4C45-8B10-3EED48D84B63',
        'name': '上传人id',
        'code': 'upload_peple',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadPeple',
        'codeCamelPlural': 'uploadPeples',
        'codeUnderscore': 'upload_peple',
        'codeUnderscorePlural': 'upload_peples',
        'type': 'string'
      },
      {
        'id': 'o596',
        'objectId': 'B086D07D-EF82-42F3-8259-2D804A2B8EC4',
        'name': '32寸播放',
        'code': 'thirty_two_playback',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'thirtyTwoPlayback',
        'codeCamelPlural': 'thirtyTwoPlaybacks',
        'codeUnderscore': 'thirty_two_playback',
        'codeUnderscorePlural': 'thirty_two_playbacks',
        'type': 'string'
      },
      {
        'id': 'o597',
        'objectId': '62B61458-B2AE-4658-B4D1-7C90B2445A10',
        'name': '55寸播放',
        'code': 'fifty_five_playback',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'fiftyFivePlayback',
        'codeCamelPlural': 'fiftyFivePlaybacks',
        'codeUnderscore': 'fifty_five_playback',
        'codeUnderscorePlural': 'fifty_five_playbacks',
        'type': 'string'
      },
      {
        'id': 'o598',
        'objectId': 'B93833E5-A275-49A4-9C94-9BCEFA26F411',
        'name': '附件id',
        'code': 'file_id',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o599',
        'objectId': 'EC15CAAB-5901-4538-A930-764A62FA2211',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o600',
        'objectId': '00E85F3F-65B9-45FC-BCF6-6863EA973487',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520223475',
        'creator': 'yide',
        'modificationDate': '1520224158',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o601',
        'objectId': '596E4EDE-C224-48A5-A956-DCA1629DDDD5',
        'name': '排序',
        'code': 'rank',
        'creationDate': '1520224316',
        'creator': 'yide',
        'modificationDate': '1520224414',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'rank',
        'codeCamelPlural': 'ranks',
        'codeUnderscore': 'rank',
        'codeUnderscorePlural': 'ranks',
        'type': 'number'
      },
      {
        'id': 'o602',
        'objectId': '756F1865-DA5B-49E0-89F1-E800C63FA7CC',
        'name': '内容',
        'code': 'content',
        'creationDate': '1520567860',
        'creator': 'yide',
        'modificationDate': '1520568033',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o603',
        'objectId': '2BCA5704-745A-4B31-8715-1323545488B1',
        'name': '简介',
        'code': 'brief_Introduction',
        'creationDate': '1520567860',
        'creator': 'yide',
        'modificationDate': '1520568033',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'briefIntroduction',
        'codeCamelPlural': 'briefIntroductions',
        'codeUnderscore': 'brief_introduction',
        'codeUnderscorePlural': 'brief_introductions',
        'type': 'string'
      }
    ]
  },
  'CcPlayRule': {
    'model': 'CcPlayRule',
    'modelPlural': 'CcPlayRules',
    'modelCamel': 'ccPlayRule',
    'modelCamelPlural': 'ccPlayRules',
    'modelUnderscore': 'cc_play_rule',
    'modelUnderscorePlural': 'cc_play_rules',
    'columns': [
      {
        'id': 'o606',
        'objectId': '54061969-352E-4441-A038-32C32B314AE6',
        'name': '名称',
        'code': 'name',
        'creationDate': '1520224450',
        'creator': 'yide',
        'modificationDate': '1520224761',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o607',
        'objectId': '022593BD-E5CB-4E04-8D8B-90D5347F7202',
        'name': '内容',
        'code': 'content',
        'creationDate': '1520224450',
        'creator': 'yide',
        'modificationDate': '1520224761',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'content',
        'codeCamelPlural': 'contents',
        'codeUnderscore': 'content',
        'codeUnderscorePlural': 'contents',
        'type': 'string'
      },
      {
        'id': 'o608',
        'objectId': 'C96E8992-DCBA-49CB-AD41-6F02F1EF9FAB',
        'name': '规则适用',
        'code': 'application_rules',
        'creationDate': '1520224450',
        'creator': 'yide',
        'modificationDate': '1520224761',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'applicationRules',
        'codeCamelPlural': 'applicationRules',
        'codeUnderscore': 'application_rules',
        'codeUnderscorePlural': 'application_rules',
        'type': 'string'
      },
      {
        'id': 'o609',
        'objectId': '859234A3-759C-4E1B-AC8E-34653A03E915',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520224450',
        'creator': 'yide',
        'modificationDate': '1520224761',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o610',
        'objectId': 'C0FC7F64-85D0-49D2-AD71-0A8939103CD7',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520224450',
        'creator': 'yide',
        'modificationDate': '1520224761',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o611',
        'objectId': 'B06E91E4-B585-44BD-B85A-A83F29BFBC14',
        'name': '32或者55寸播放',
        'code': 'type',
        'creationDate': '1520567714',
        'creator': 'yide',
        'modificationDate': '1520567803',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o612',
        'objectId': 'CDA32E2F-7F9D-4C60-B055-7341197F76E6',
        'name': '状态',
        'code': 'status',
        'creationDate': '1520567832',
        'creator': 'yide',
        'modificationDate': '1520567848',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      }
    ]
  },
  'CcPlaybackSequence': {
    'model': 'CcPlaybackSequence',
    'modelPlural': 'CcPlaybackSequences',
    'modelCamel': 'ccPlaybackSequence',
    'modelCamelPlural': 'ccPlaybackSequences',
    'modelUnderscore': 'cc_playback_sequence',
    'modelUnderscorePlural': 'cc_playback_sequences',
    'columns': [
      {
        'id': 'o615',
        'objectId': 'B798186E-B5EF-4C88-8BF8-0ED9497B5C88',
        'name': '播放规则id',
        'code': 'cc_play_rule_id',
        'creationDate': '1520224848',
        'creator': 'yide',
        'modificationDate': '1520569586',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcPlayRule',
          'modelCamel': 'ccPlayRule',
          'modelCamelPlural': 'ccPlayRules',
          'modelUnderscore': 'cc_play_rule',
          'modelUnderscorePlural': 'cc_play_rules'
        },
        'codeCamel': 'ccPlayRuleId',
        'codeCamelPlural': 'ccPlayRuleIds',
        'codeUnderscore': 'cc_play_rule_id',
        'codeUnderscorePlural': 'cc_play_rule_ids',
        'type': 'string'
      },
      {
        'id': 'o616',
        'objectId': '7667D20C-752E-4369-88FC-A1B15438AEC6',
        'name': '资源id',
        'code': 'cc_resources_id',
        'creationDate': '1520224848',
        'creator': 'yide',
        'modificationDate': '1520569605',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcResource',
          'modelCamel': 'ccResource',
          'modelCamelPlural': 'ccResources',
          'modelUnderscore': 'cc_resource',
          'modelUnderscorePlural': 'cc_resources'
        },
        'codeCamel': 'ccResourcesId',
        'codeCamelPlural': 'ccResourcesIds',
        'codeUnderscore': 'cc_resources_id',
        'codeUnderscorePlural': 'cc_resources_ids',
        'type': 'string'
      },
      {
        'id': 'o617',
        'objectId': 'AF37029F-027F-47A9-AF80-80C220FD922E',
        'name': '排序',
        'code': 'rank',
        'creationDate': '1520224848',
        'creator': 'yide',
        'modificationDate': '1520225098',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'rank',
        'codeCamelPlural': 'ranks',
        'codeUnderscore': 'rank',
        'codeUnderscorePlural': 'ranks',
        'type': 'number'
      },
      {
        'id': 'o618',
        'objectId': '0611488D-49E9-444E-A0E5-61EF7735252B',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520224848',
        'creator': 'yide',
        'modificationDate': '1520225098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o619',
        'objectId': '70C54D28-D95E-4A6E-A7E3-F2A8107B7F6F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520224848',
        'creator': 'yide',
        'modificationDate': '1520228945',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcReleaseRecord': {
    'model': 'CcReleaseRecord',
    'modelPlural': 'CcReleaseRecords',
    'modelCamel': 'ccReleaseRecord',
    'modelCamelPlural': 'ccReleaseRecords',
    'modelUnderscore': 'cc_release_record',
    'modelUnderscorePlural': 'cc_release_records',
    'columns': [
      {
        'id': 'o622',
        'objectId': 'CEA7032C-C0C2-4BDD-A4B1-690F97670DC8',
        'name': '完成状态',
        'code': 'status',
        'creationDate': '1520227496',
        'creator': 'yide',
        'modificationDate': '1520227718',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'string'
      },
      {
        'id': 'o623',
        'objectId': 'AF740919-66D4-4C6B-8765-4C872AC2CC58',
        'name': '标题',
        'code': 'title',
        'creationDate': '1520227496',
        'creator': 'yide',
        'modificationDate': '1520227718',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'title',
        'codeCamelPlural': 'titles',
        'codeUnderscore': 'title',
        'codeUnderscorePlural': 'titles',
        'type': 'string'
      },
      {
        'id': 'o624',
        'objectId': 'E38427C3-CC42-44BF-8270-498564111A87',
        'name': '小标题',
        'code': 'small_title',
        'creationDate': '1520227496',
        'creator': 'yide',
        'modificationDate': '1520227718',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'smallTitle',
        'codeCamelPlural': 'smallTitles',
        'codeUnderscore': 'small_title',
        'codeUnderscorePlural': 'small_titles',
        'type': 'string'
      },
      {
        'id': 'o625',
        'objectId': '4585A356-3BC2-4D2B-951B-770089F41DEC',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520227496',
        'creator': 'yide',
        'modificationDate': '1520227718',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o626',
        'objectId': '09EB0FD5-A74B-44FB-AE00-D6FBEB5172F4',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520227496',
        'creator': 'yide',
        'modificationDate': '1520227718',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcSubject': {
    'model': 'CcSubject',
    'modelPlural': 'CcSubjects',
    'modelCamel': 'ccSubject',
    'modelCamelPlural': 'ccSubjects',
    'modelUnderscore': 'cc_subject',
    'modelUnderscorePlural': 'cc_subjects',
    'columns': [
      {
        'id': 'o629',
        'objectId': '6D77A5F8-40A4-4474-8452-0B5FA389EAA3',
        'name': '题目',
        'code': 'subject',
        'creationDate': '1520387116',
        'creator': 'yide',
        'modificationDate': '1520387302',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'subject',
        'codeCamelPlural': 'subjects',
        'codeUnderscore': 'subject',
        'codeUnderscorePlural': 'subjects',
        'type': 'string'
      },
      {
        'id': 'o630',
        'objectId': 'ADD30926-B7B1-4F47-8D4D-B0947D27FED5',
        'name': '题目类型',
        'code': 'subject_type',
        'creationDate': '1520387116',
        'creator': 'yide',
        'modificationDate': '1520387302',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'subjectType',
        'codeCamelPlural': 'subjectTypes',
        'codeUnderscore': 'subject_type',
        'codeUnderscorePlural': 'subject_types',
        'type': 'string'
      },
      {
        'id': 'o631',
        'objectId': 'E55634E3-725C-4794-8347-D47BC5410D13',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520387116',
        'creator': 'yide',
        'modificationDate': '1520387302',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o632',
        'objectId': 'F8B11EE7-6D7C-44BB-843F-CDF74BB36C79',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520387116',
        'creator': 'yide',
        'modificationDate': '1520387302',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o633',
        'objectId': '48B44B19-4211-4635-A2B8-8635FF2AE9F1',
        'name': '官方解析',
        'code': 'commentary',
        'creationDate': '1520388562',
        'creator': 'yide',
        'modificationDate': '1520409149',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'commentary',
        'codeCamelPlural': 'commentaries',
        'codeUnderscore': 'commentary',
        'codeUnderscorePlural': 'commentaries',
        'type': 'string'
      }
    ]
  },
  'CcOption': {
    'model': 'CcOption',
    'modelPlural': 'CcOptions',
    'modelCamel': 'ccOption',
    'modelCamelPlural': 'ccOptions',
    'modelUnderscore': 'cc_option',
    'modelUnderscorePlural': 'cc_options',
    'columns': [
      {
        'id': 'o636',
        'objectId': 'BC6DBFF7-5091-46CE-A654-12182A63EE72',
        'name': '序号',
        'code': 'serial_number',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520387583',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'serialNumber',
        'codeCamelPlural': 'serialNumbers',
        'codeUnderscore': 'serial_number',
        'codeUnderscorePlural': 'serial_numbers',
        'type': 'string'
      },
      {
        'id': 'o637',
        'objectId': '11E0EC72-606A-42B6-8953-4BD8BDC668B7',
        'name': '描述',
        'code': 'description',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520409008',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'description',
        'codeCamelPlural': 'descriptions',
        'codeUnderscore': 'description',
        'codeUnderscorePlural': 'descriptions',
        'type': 'string'
      },
      {
        'id': 'o638',
        'objectId': '6A80C2CE-3238-4105-8894-416F2BA9D707',
        'name': '是否是正确答案',
        'code': 'correct',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520387583',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'correct',
        'codeCamelPlural': 'corrects',
        'codeUnderscore': 'correct',
        'codeUnderscorePlural': 'corrects',
        'type': 'string'
      },
      {
        'id': 'o639',
        'objectId': '38171B70-49E7-4AF2-8E97-D603691EBD96',
        'name': '排序',
        'code': 'rank',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520387583',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'rank',
        'codeCamelPlural': 'ranks',
        'codeUnderscore': 'rank',
        'codeUnderscorePlural': 'ranks',
        'type': 'number'
      },
      {
        'id': 'o640',
        'objectId': '0335656A-5283-4DC8-BE9A-E5035057815A',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520387583',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o641',
        'objectId': '5C0DBA30-9AFE-42A0-84A2-4079D1A6966D',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520387316',
        'creator': 'yide',
        'modificationDate': '1520387583',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o642',
        'objectId': '1F659665-58F1-422B-9F77-D22769981698',
        'name': '题目id',
        'code': 'cc_subject_id',
        'creationDate': '1520387606',
        'creator': 'yide',
        'modificationDate': '1520389233',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcSubject',
          'modelCamel': 'ccSubject',
          'modelCamelPlural': 'ccSubjects',
          'modelUnderscore': 'cc_subject',
          'modelUnderscorePlural': 'cc_subjects'
        },
        'codeCamel': 'ccSubjectId',
        'codeCamelPlural': 'ccSubjectIds',
        'codeUnderscore': 'cc_subject_id',
        'codeUnderscorePlural': 'cc_subject_ids',
        'type': 'string'
      }
    ]
  },
  'CcTestPaper': {
    'model': 'CcTestPaper',
    'modelPlural': 'CcTestPapers',
    'modelCamel': 'ccTestPaper',
    'modelCamelPlural': 'ccTestPapers',
    'modelUnderscore': 'cc_test_paper',
    'modelUnderscorePlural': 'cc_test_papers',
    'columns': [
      {
        'id': 'o645',
        'objectId': '64DF5C1B-7F8F-4F1F-B772-1EE0E822E4BC',
        'name': '试卷名称',
        'code': 'test_paper_name',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389090',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'testPaperName',
        'codeCamelPlural': 'testPaperNames',
        'codeUnderscore': 'test_paper_name',
        'codeUnderscorePlural': 'test_paper_names',
        'type': 'string'
      },
      {
        'id': 'o646',
        'objectId': 'BBF3E279-F3EF-4274-B5D9-DCD8930FB761',
        'name': '考试时长',
        'code': 'long_exam',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'longExam',
        'codeCamelPlural': 'longExams',
        'codeUnderscore': 'long_exam',
        'codeUnderscorePlural': 'long_exams',
        'type': 'number'
      },
      {
        'id': 'o647',
        'objectId': '5403C8A4-72D6-40AE-B03D-88098E1D87B5',
        'name': '总分',
        'code': 'total_score',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'totalScore',
        'codeCamelPlural': 'totalScores',
        'codeUnderscore': 'total_score',
        'codeUnderscorePlural': 'total_scores',
        'type': 'number'
      },
      {
        'id': 'o648',
        'objectId': 'F5B6B743-D26C-4067-A15E-E0E1888321D8',
        'name': '合格分',
        'code': 'qualified_score',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'qualifiedScore',
        'codeCamelPlural': 'qualifiedScores',
        'codeUnderscore': 'qualified_score',
        'codeUnderscorePlural': 'qualified_scores',
        'type': 'number'
      },
      {
        'id': 'o649',
        'objectId': '9B593424-D17E-4F9B-8DD8-8DAEF53B9B78',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o650',
        'objectId': '30B3E8C5-E7E5-440F-AFFF-C125060BF2A2',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o651',
        'objectId': '8FB533FB-FB00-4C1F-9E14-2268C1E75C17',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520388768',
        'creator': 'yide',
        'modificationDate': '1520389090',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o652',
        'objectId': 'AB80983C-72B6-4AB3-A4B6-541AB62F27DE',
        'name': '共多少道题目',
        'code': 'sum_subject',
        'creationDate': '1520389103',
        'creator': 'yide',
        'modificationDate': '1520389202',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'sumSubject',
        'codeCamelPlural': 'sumSubjects',
        'codeUnderscore': 'sum_subject',
        'codeUnderscorePlural': 'sum_subjects',
        'type': 'number'
      }
    ]
  },
  'CcPaperTitle': {
    'model': 'CcPaperTitle',
    'modelPlural': 'CcPaperTitles',
    'modelCamel': 'ccPaperTitle',
    'modelCamelPlural': 'ccPaperTitles',
    'modelUnderscore': 'cc_paper_title',
    'modelUnderscorePlural': 'cc_paper_titles',
    'columns': [
      {
        'id': 'o655',
        'objectId': 'A5CA594C-08EA-4E25-8E85-A05A868EDBC5',
        'name': '题目id',
        'code': 'cc_subject_id',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390549',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcSubject',
          'modelCamel': 'ccSubject',
          'modelCamelPlural': 'ccSubjects',
          'modelUnderscore': 'cc_subject',
          'modelUnderscorePlural': 'cc_subjects'
        },
        'codeCamel': 'ccSubjectId',
        'codeCamelPlural': 'ccSubjectIds',
        'codeUnderscore': 'cc_subject_id',
        'codeUnderscorePlural': 'cc_subject_ids',
        'type': 'string'
      },
      {
        'id': 'o656',
        'objectId': 'B612188E-A6C9-4161-A36D-541231401917',
        'name': '试卷id',
        'code': 'cc_test_paper_id',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390563',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcTestPaper',
          'modelCamel': 'ccTestPaper',
          'modelCamelPlural': 'ccTestPapers',
          'modelUnderscore': 'cc_test_paper',
          'modelUnderscorePlural': 'cc_test_papers'
        },
        'codeCamel': 'ccTestPaperId',
        'codeCamelPlural': 'ccTestPaperIds',
        'codeUnderscore': 'cc_test_paper_id',
        'codeUnderscorePlural': 'cc_test_paper_ids',
        'type': 'string'
      },
      {
        'id': 'o657',
        'objectId': '3B889236-F71A-4C11-B602-8A8144DB9D19',
        'name': '题目在本试卷中所占分值',
        'code': 'fraction',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390532',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'fraction',
        'codeCamelPlural': 'fractions',
        'codeUnderscore': 'fraction',
        'codeUnderscorePlural': 'fractions',
        'type': 'number'
      },
      {
        'id': 'o658',
        'objectId': '54535AFE-4B8B-4FDC-8A80-C422DBD61EB9',
        'name': '排序',
        'code': 'rank',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390532',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'rank',
        'codeCamelPlural': 'ranks',
        'codeUnderscore': 'rank',
        'codeUnderscorePlural': 'ranks',
        'type': 'number'
      },
      {
        'id': 'o659',
        'objectId': 'C5F8747F-F311-411F-946D-6F38778D955A',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390532',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o660',
        'objectId': 'E9A8686D-2F96-497D-8752-9A1D1AB2B86F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520389253',
        'creator': 'yide',
        'modificationDate': '1520390532',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcUserTestRecord': {
    'model': 'CcUserTestRecord',
    'modelPlural': 'CcUserTestRecords',
    'modelCamel': 'ccUserTestRecord',
    'modelCamelPlural': 'ccUserTestRecords',
    'modelUnderscore': 'cc_user_test_record',
    'modelUnderscorePlural': 'cc_user_test_records',
    'columns': [
      {
        'id': 'o663',
        'objectId': '048E9F5D-B168-4171-AC54-0B8DB576F9A1',
        'name': '试卷id',
        'code': 'cc_test_paper_id',
        'creationDate': '1520390590',
        'creator': 'yide',
        'modificationDate': '1520390947',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcTestPaper',
          'modelCamel': 'ccTestPaper',
          'modelCamelPlural': 'ccTestPapers',
          'modelUnderscore': 'cc_test_paper',
          'modelUnderscorePlural': 'cc_test_papers'
        },
        'codeCamel': 'ccTestPaperId',
        'codeCamelPlural': 'ccTestPaperIds',
        'codeUnderscore': 'cc_test_paper_id',
        'codeUnderscorePlural': 'cc_test_paper_ids',
        'type': 'string'
      },
      {
        'id': 'o664',
        'objectId': '359470F5-3220-4A7A-BE48-0EBF5700DCCB',
        'name': '用户id',
        'code': 'user_id',
        'creationDate': '1520390590',
        'creator': 'yide',
        'modificationDate': '1520390911',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o665',
        'objectId': 'C9D7E20E-96AC-4E34-9E31-0C61F98C3416',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520390590',
        'creator': 'yide',
        'modificationDate': '1520390911',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o666',
        'objectId': '55DE6754-F33D-410E-BC75-29EB550F4521',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520390590',
        'creator': 'yide',
        'modificationDate': '1520390911',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o667',
        'objectId': '51B3D2B4-D7D3-4F11-ADB8-228E1F8F454C',
        'name': '用时',
        'code': 'when_long',
        'creationDate': '1520391418',
        'creator': 'yide',
        'modificationDate': '1520391465',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'whenLong',
        'codeCamelPlural': 'whenLongs',
        'codeUnderscore': 'when_long',
        'codeUnderscorePlural': 'when_longs',
        'type': 'number'
      },
      {
        'id': 'o668',
        'objectId': 'F70ADE3B-A4E3-460B-A3CB-0B81CFF7C9B6',
        'name': '成绩',
        'code': 'achievement',
        'creationDate': '1520391418',
        'creator': 'yide',
        'modificationDate': '1520391465',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'achievement',
        'codeCamelPlural': 'achievements',
        'codeUnderscore': 'achievement',
        'codeUnderscorePlural': 'achievements',
        'type': 'number'
      },
      {
        'id': 'o669',
        'objectId': 'C4BCB114-BA3B-4E39-A3C2-45FCF7048B86',
        'name': '评级',
        'code': 'grade',
        'creationDate': '1520391482',
        'creator': 'yide',
        'modificationDate': '1520392668',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'grade',
        'codeCamelPlural': 'grades',
        'codeUnderscore': 'grade',
        'codeUnderscorePlural': 'grades',
        'type': 'string'
      }
    ]
  },
  'CcRecordAnswer': {
    'model': 'CcRecordAnswer',
    'modelPlural': 'CcRecordAnswers',
    'modelCamel': 'ccRecordAnswer',
    'modelCamelPlural': 'ccRecordAnswers',
    'modelUnderscore': 'cc_record_answer',
    'modelUnderscorePlural': 'cc_record_answers',
    'columns': [
      {
        'id': 'o672',
        'objectId': '3032444C-71F5-4E9D-9FB8-BCD2B40CB3D1',
        'name': '题目id',
        'code': 'cc_subject_id',
        'creationDate': '1520391013',
        'creator': 'yide',
        'modificationDate': '1520391237',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccSubjectId',
        'codeCamelPlural': 'ccSubjectIds',
        'codeUnderscore': 'cc_subject_id',
        'codeUnderscorePlural': 'cc_subject_ids',
        'type': 'string'
      },
      {
        'id': 'o673',
        'objectId': '27F76720-746F-4CAB-84B2-7F7EC01272A5',
        'name': '选项id',
        'code': 'cc_option_id',
        'creationDate': '1520391013',
        'creator': 'yide',
        'modificationDate': '1520391237',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'ccOptionId',
        'codeCamelPlural': 'ccOptionIds',
        'codeUnderscore': 'cc_option_id',
        'codeUnderscorePlural': 'cc_option_ids',
        'type': 'string'
      },
      {
        'id': 'o674',
        'objectId': '97EF14AD-53E3-4074-AA37-2EDF780F2EB2',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520391013',
        'creator': 'yide',
        'modificationDate': '1520391237',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o675',
        'objectId': '4F630CC8-C812-4E3B-BB64-5104B3E837D1',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520391013',
        'creator': 'yide',
        'modificationDate': '1520391237',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o676',
        'objectId': '3E4E84E2-2FA3-4F7F-A8D2-F6B0C33E6470',
        'name': '用户试卷记录id',
        'code': 'cc_user_test_record_id',
        'creationDate': '1520391243',
        'creator': 'yide',
        'modificationDate': '1520391295',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcUserTestRecord',
          'modelCamel': 'ccUserTestRecord',
          'modelCamelPlural': 'ccUserTestRecords',
          'modelUnderscore': 'cc_user_test_record',
          'modelUnderscorePlural': 'cc_user_test_records'
        },
        'codeCamel': 'ccUserTestRecordId',
        'codeCamelPlural': 'ccUserTestRecordIds',
        'codeUnderscore': 'cc_user_test_record_id',
        'codeUnderscorePlural': 'cc_user_test_record_ids',
        'type': 'string'
      }
    ]
  },
  'CcOcrFile': {
    'model': 'CcOcrFile',
    'modelPlural': 'CcOcrFiles',
    'modelCamel': 'ccOcrFile',
    'modelCamelPlural': 'ccOcrFiles',
    'modelUnderscore': 'cc_ocr_file',
    'modelUnderscorePlural': 'cc_ocr_files',
    'columns': [
      {
        'id': 'o679',
        'objectId': 'C2487224-C5E5-415B-B528-618FEE733B77',
        'name': '文件名称',
        'code': 'file_name',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o680',
        'objectId': '0C5ED59D-94B7-4E0F-A9A4-6CF1788CD457',
        'name': '文件路径',
        'code': 'file_path',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o681',
        'objectId': '840BC944-C718-459D-815A-5A4D949CD95D',
        'name': '上传人',
        'code': 'upload_user',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadUser',
        'codeCamelPlural': 'uploadUsers',
        'codeUnderscore': 'upload_user',
        'codeUnderscorePlural': 'upload_users',
        'type': 'string'
      },
      {
        'id': 'o682',
        'objectId': '1AA8A494-9359-4FAA-AD1C-08193D62F075',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o683',
        'objectId': '0B4F0FD1-4449-45E8-A2AD-9FFB2CF38D3A',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o684',
        'objectId': '5AC156D6-9245-4089-A8B6-96C40E846B19',
        'name': '状态',
        'code': 'status',
        'creationDate': '1520396567',
        'creator': 'yide',
        'modificationDate': '1520396785',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'string'
      }
    ]
  },
  'CcVoiceFile': {
    'model': 'CcVoiceFile',
    'modelPlural': 'CcVoiceFiles',
    'modelCamel': 'ccVoiceFile',
    'modelCamelPlural': 'ccVoiceFiles',
    'modelUnderscore': 'cc_voice_file',
    'modelUnderscorePlural': 'cc_voice_files',
    'columns': [
      {
        'id': 'o687',
        'objectId': '23C464DF-186A-4015-868C-46C239888D14',
        'name': '文件名称',
        'code': 'file_name',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o688',
        'objectId': '1B3930F9-246C-4A38-927F-15149434A738',
        'name': '文件路径',
        'code': 'file_path',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o689',
        'objectId': '990F5CF5-10FF-4DB3-8338-CA39CC3F2A44',
        'name': '上传人',
        'code': 'upload_user',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadUser',
        'codeCamelPlural': 'uploadUsers',
        'codeUnderscore': 'upload_user',
        'codeUnderscorePlural': 'upload_users',
        'type': 'string'
      },
      {
        'id': 'o690',
        'objectId': 'CD0726DA-CD21-4270-8787-2F09B1A5E61C',
        'name': '状态',
        'code': 'status',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'string'
      },
      {
        'id': 'o691',
        'objectId': 'F6CDC375-C63D-43A1-8337-1AF2EFD93AEC',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o692',
        'objectId': '0E79B70E-638D-4C83-912F-EF1251F02E93',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520396829',
        'creator': 'yide',
        'modificationDate': '1520397026',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcExportRecord': {
    'model': 'CcExportRecord',
    'modelPlural': 'CcExportRecords',
    'modelCamel': 'ccExportRecord',
    'modelCamelPlural': 'ccExportRecords',
    'modelUnderscore': 'cc_export_record',
    'modelUnderscorePlural': 'cc_export_records',
    'columns': [
      {
        'id': 'o695',
        'objectId': '0CA72AA7-E536-4CCD-8547-848DDB9BD954',
        'name': '文件id',
        'code': 'file_id',
        'creationDate': '1520397481',
        'creator': 'yide',
        'modificationDate': '1520397623',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileId',
        'codeCamelPlural': 'fileIds',
        'codeUnderscore': 'file_id',
        'codeUnderscorePlural': 'file_ids',
        'type': 'string'
      },
      {
        'id': 'o696',
        'objectId': '1F290D78-6515-4765-A083-AFF719F01D92',
        'name': '导出人',
        'code': 'export_user',
        'creationDate': '1520397481',
        'creator': 'yide',
        'modificationDate': '1520397623',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'exportUser',
        'codeCamelPlural': 'exportUsers',
        'codeUnderscore': 'export_user',
        'codeUnderscorePlural': 'export_users',
        'type': 'string'
      },
      {
        'id': 'o697',
        'objectId': '3F25DA28-ECB2-416A-83CC-4A1CCAD77C04',
        'name': '导出时间',
        'code': 'create_time',
        'creationDate': '1520397481',
        'creator': 'yide',
        'modificationDate': '1520397623',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o698',
        'objectId': '1D8D8640-E659-49FB-B51C-051E766D42B3',
        'name': '导出类型',
        'code': 'type',
        'creationDate': '1520397481',
        'creator': 'yide',
        'modificationDate': '1520397676',
        'modifier': 'yide',
        'comment': '0,ocr 1.语音',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o699',
        'objectId': '8238E117-071F-4D7E-BC21-2620E3EEBE18',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520397623',
        'creator': 'yide',
        'modificationDate': '1520397676',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcSharingRecord': {
    'model': 'CcSharingRecord',
    'modelPlural': 'CcSharingRecords',
    'modelCamel': 'ccSharingRecord',
    'modelCamelPlural': 'ccSharingRecords',
    'modelUnderscore': 'cc_sharing_record',
    'modelUnderscorePlural': 'cc_sharing_records',
    'columns': [
      {
        'id': 'o702',
        'objectId': 'B59D1713-C445-4F8E-8E55-724B3100CE97',
        'name': '分享人',
        'code': 'sharing_peple',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'sharingPeple',
        'codeCamelPlural': 'sharingPeples',
        'codeUnderscore': 'sharing_peple',
        'codeUnderscorePlural': 'sharing_peples',
        'type': 'string'
      },
      {
        'id': 'o703',
        'objectId': '9088E7CC-10D3-4A9F-896D-CC9DD19827C0',
        'name': '被分享人',
        'code': 'cover_sharing_peple',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'coverSharingPeple',
        'codeCamelPlural': 'coverSharingPeples',
        'codeUnderscore': 'cover_sharing_peple',
        'codeUnderscorePlural': 'cover_sharing_peples',
        'type': 'string'
      },
      {
        'id': 'o704',
        'objectId': '256AF95E-CB35-4722-93F2-952C4840C727',
        'name': '分享类型',
        'code': 'type',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'number'
      },
      {
        'id': 'o705',
        'objectId': '9731A316-9EAD-4D56-B217-89664BE0F182',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o706',
        'objectId': '25120047-C7C4-4422-9660-55DD7EDDF08A',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o707',
        'objectId': '82E1D480-F560-474F-B6ED-9FA31E9280BA',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520397702',
        'creator': 'yide',
        'modificationDate': '1520397903',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcFace': {
    'model': 'CcFace',
    'modelPlural': 'CcFaces',
    'modelCamel': 'ccFace',
    'modelCamelPlural': 'ccFaces',
    'modelUnderscore': 'cc_face',
    'modelUnderscorePlural': 'cc_faces',
    'columns': [
      {
        'id': 'o710',
        'objectId': 'DB3153CE-08DB-472C-9751-DDA1CB2B4256',
        'name': '登录账号',
        'code': 'login_name',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'loginName',
        'codeCamelPlural': 'loginNames',
        'codeUnderscore': 'login_name',
        'codeUnderscorePlural': 'login_names',
        'type': 'string'
      },
      {
        'id': 'o711',
        'objectId': '298919BB-9337-4A3C-912A-9D0DA0020EC3',
        'name': '人员姓名',
        'code': 'name',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o712',
        'objectId': '78420D9A-DC6E-4957-B50F-89043ADEA70E',
        'name': '人脸文件路径',
        'code': 'face_url',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'faceUrl',
        'codeCamelPlural': 'faceUrls',
        'codeUnderscore': 'face_url',
        'codeUnderscorePlural': 'face_urls',
        'type': 'string'
      },
      {
        'id': 'o713',
        'objectId': 'B779DD48-8195-4A90-98BA-F03F670EAFFD',
        'name': '上传人',
        'code': 'upload_peple',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadPeple',
        'codeCamelPlural': 'uploadPeples',
        'codeUnderscore': 'upload_peple',
        'codeUnderscorePlural': 'upload_peples',
        'type': 'string'
      },
      {
        'id': 'o714',
        'objectId': '15D4572C-7791-4E6D-89E7-100A970E0B08',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o715',
        'objectId': '9B26F520-2B1A-4B2E-ADA6-A2FCB551B8EE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520398197',
        'creator': 'yide',
        'modificationDate': '1520398350',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcConferenceSigning': {
    'model': 'CcConferenceSigning',
    'modelPlural': 'CcConferenceSignings',
    'modelCamel': 'ccConferenceSigning',
    'modelCamelPlural': 'ccConferenceSignings',
    'modelUnderscore': 'cc_conference_signing',
    'modelUnderscorePlural': 'cc_conference_signings',
    'columns': [
      {
        'id': 'o718',
        'objectId': '9640357C-8450-4AE4-8E3C-DE5A767EE360',
        'name': '会议id',
        'code': 'meeting_id',
        'creationDate': '1520493645',
        'creator': 'yide',
        'modificationDate': '1520494029',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'meetingId',
        'codeCamelPlural': 'meetingIds',
        'codeUnderscore': 'meeting_id',
        'codeUnderscorePlural': 'meeting_ids',
        'type': 'string'
      },
      {
        'id': 'o719',
        'objectId': '79B79D8A-61D1-407D-BC60-775907302F85',
        'name': '签到人',
        'code': 'sign_peple',
        'creationDate': '1520493645',
        'creator': 'yide',
        'modificationDate': '1520494029',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'signPeple',
        'codeCamelPlural': 'signPeples',
        'codeUnderscore': 'sign_peple',
        'codeUnderscorePlural': 'sign_peples',
        'type': 'string'
      },
      {
        'id': 'o720',
        'objectId': '6A1AA6B6-B89A-4F45-8DB9-55A18E9F3D64',
        'name': '签到时间',
        'code': 'create_time',
        'creationDate': '1520493645',
        'creator': 'yide',
        'modificationDate': '1520494029',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o721',
        'objectId': 'D727FE2F-5E34-48B3-AA89-C2D69A23EE62',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520493645',
        'creator': 'yide',
        'modificationDate': '1520494029',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o722',
        'objectId': '40B0842C-84D4-4289-8544-E62630A77291',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520494029',
        'creator': 'yide',
        'modificationDate': '1520494046',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      }
    ]
  },
  'CcEnclosure': {
    'model': 'CcEnclosure',
    'modelPlural': 'CcEnclosures',
    'modelCamel': 'ccEnclosure',
    'modelCamelPlural': 'ccEnclosures',
    'modelUnderscore': 'cc_enclosure',
    'modelUnderscorePlural': 'cc_enclosures',
    'columns': [
      {
        'id': 'o725',
        'objectId': '5EA8DE83-7646-40D0-9547-566D153442F3',
        'name': '文件名称',
        'code': 'file_name',
        'creationDate': '1520568060',
        'creator': 'yide',
        'modificationDate': '1520568720',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o726',
        'objectId': 'F69A13A7-E464-4350-AB7B-AE097E3F5CEC',
        'name': '文件路径',
        'code': 'file_path',
        'creationDate': '1520568060',
        'creator': 'yide',
        'modificationDate': '1520568720',
        'modifier': 'yide',
        'dataType': 'varchar(256)',
        'length': '256',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o727',
        'objectId': 'E4C1A06F-7C7E-4BAC-8323-A4FAF5194E7C',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520568060',
        'creator': 'yide',
        'modificationDate': '1520568720',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o728',
        'objectId': 'CDA64A53-44F7-4C34-BF4F-FE8E8840F2FE',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520568060',
        'creator': 'yide',
        'modificationDate': '1520568720',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o729',
        'objectId': 'EB2AFF5A-C8D0-4F0E-AF8C-E9D4754CD348',
        'name': '上传人',
        'code': 'upload_peple',
        'creationDate': '1520568060',
        'creator': 'yide',
        'modificationDate': '1520568720',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadPeple',
        'codeCamelPlural': 'uploadPeples',
        'codeUnderscore': 'upload_peple',
        'codeUnderscorePlural': 'upload_peples',
        'type': 'string'
      },
      {
        'id': 'o730',
        'objectId': 'F1BA5BA5-ADEC-4F57-AE0E-33539504D39C',
        'name': '资源id',
        'code': 'cc_resource_id',
        'creationDate': '1520569402',
        'creator': 'yide',
        'modificationDate': '1520569443',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcResource',
          'modelCamel': 'ccResource',
          'modelCamelPlural': 'ccResources',
          'modelUnderscore': 'cc_resource',
          'modelUnderscorePlural': 'cc_resources'
        },
        'codeCamel': 'ccResourceId',
        'codeCamelPlural': 'ccResourceIds',
        'codeUnderscore': 'cc_resource_id',
        'codeUnderscorePlural': 'cc_resource_ids',
        'type': 'string'
      }
    ]
  },
  'CcIssue': {
    'model': 'CcIssue',
    'modelPlural': 'CcIssues',
    'modelCamel': 'ccIssue',
    'modelCamelPlural': 'ccIssues',
    'modelUnderscore': 'cc_issue',
    'modelUnderscorePlural': 'cc_issues',
    'columns': [
      {
        'id': 'o733',
        'objectId': 'A20D12D5-8BCE-4775-9EF9-6F135C76BC0B',
        'name': '议题名称',
        'code': 'name',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520574505',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'name',
        'codeCamelPlural': 'names',
        'codeUnderscore': 'name',
        'codeUnderscorePlural': 'names',
        'type': 'string'
      },
      {
        'id': 'o734',
        'objectId': '81C0BEBB-C34E-4E01-87D7-E98278F73AC1',
        'name': '议题类型',
        'code': 'type',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520574505',
        'modifier': 'yide',
        'dataType': 'varchar(32)',
        'length': '32',
        'codeCamel': 'type',
        'codeCamelPlural': 'types',
        'codeUnderscore': 'type',
        'codeUnderscorePlural': 'types',
        'type': 'string'
      },
      {
        'id': 'o735',
        'objectId': '2FFC3A77-533E-465B-BD68-388A3784E898',
        'name': '截止时间',
        'code': 'deadline',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520574505',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'deadline',
        'codeCamelPlural': 'deadlines',
        'codeUnderscore': 'deadline',
        'codeUnderscorePlural': 'deadlines',
        'type': 'datetime'
      },
      {
        'id': 'o736',
        'objectId': '9B0208F9-1491-4DB4-A334-2C5338339C58',
        'name': '提交要求',
        'code': 'requirement',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520574505',
        'modifier': 'yide',
        'dataType': 'varchar(2048)',
        'length': '2048',
        'codeCamel': 'requirement',
        'codeCamelPlural': 'requirements',
        'codeUnderscore': 'requirement',
        'codeUnderscorePlural': 'requirements',
        'type': 'string'
      },
      {
        'id': 'o737',
        'objectId': 'A8FBCEEC-2966-4FBF-9846-4BB352A93CA3',
        'name': '短信通知',
        'code': 'notification',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520574505',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'notification',
        'codeCamelPlural': 'notifications',
        'codeUnderscore': 'notification',
        'codeUnderscorePlural': 'notifications',
        'type': 'number'
      },
      {
        'id': 'o738',
        'objectId': '01F8F8B1-16AA-4D64-8CC9-2179B859CA98',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520575041',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o739',
        'objectId': '8B1CFE57-1EA1-47DF-9AE8-86D00389F790',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520570899',
        'creator': 'yide',
        'modificationDate': '1520575041',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o740',
        'objectId': 'DFF7EBD2-5B06-4388-ABFE-739B24D99631',
        'name': '发起人',
        'code': 'lnitiator',
        'creationDate': '1520575780',
        'creator': 'yide',
        'modificationDate': '1520575823',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'lnitiator',
        'codeCamelPlural': 'lnitiators',
        'codeUnderscore': 'lnitiator',
        'codeUnderscorePlural': 'lnitiators',
        'type': 'string'
      },
      {
        'id': 'o741',
        'objectId': 'EF5F5EE3-C909-46D7-A616-70F33C61BB7F',
        'name': '状态',
        'code': 'status',
        'creationDate': '1520577559',
        'creator': 'yide',
        'modificationDate': '1520577575',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      }
    ]
  },
  'CcEnclosureIssue': {
    'model': 'CcEnclosureIssue',
    'modelPlural': 'CcEnclosureIssues',
    'modelCamel': 'ccEnclosureIssue',
    'modelCamelPlural': 'ccEnclosureIssues',
    'modelUnderscore': 'cc_enclosure_issue',
    'modelUnderscorePlural': 'cc_enclosure_issues',
    'columns': [
      {
        'id': 'o744',
        'objectId': '9C3CAF04-7BD7-41B3-86A2-890B6B4170E8',
        'name': '文件名称',
        'code': 'file_name',
        'creationDate': '1520575888',
        'creator': 'yide',
        'modificationDate': '1520576098',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'fileName',
        'codeCamelPlural': 'fileNames',
        'codeUnderscore': 'file_name',
        'codeUnderscorePlural': 'file_names',
        'type': 'string'
      },
      {
        'id': 'o745',
        'objectId': 'B8416035-3B84-4E68-A397-5AEDDCE4C1C5',
        'name': '文件路径',
        'code': 'file_path',
        'creationDate': '1520575888',
        'creator': 'yide',
        'modificationDate': '1520576098',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'filePath',
        'codeCamelPlural': 'filePaths',
        'codeUnderscore': 'file_path',
        'codeUnderscorePlural': 'file_paths',
        'type': 'string'
      },
      {
        'id': 'o746',
        'objectId': '40794CE5-5F24-407F-99B1-9B07B5D88B52',
        'name': '上传人',
        'code': 'upload_peple',
        'creationDate': '1520575888',
        'creator': 'yide',
        'modificationDate': '1520576098',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'uploadPeple',
        'codeCamelPlural': 'uploadPeples',
        'codeUnderscore': 'upload_peple',
        'codeUnderscorePlural': 'upload_peples',
        'type': 'string'
      },
      {
        'id': 'o747',
        'objectId': '1B3BFB5D-57C1-49F1-A820-CCE99191667A',
        'name': '上传时间',
        'code': 'create_time',
        'creationDate': '1520575888',
        'creator': 'yide',
        'modificationDate': '1520576098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o748',
        'objectId': '09CC2171-79D3-4C07-AF12-42E46EFEE51A',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520575888',
        'creator': 'yide',
        'modificationDate': '1520576098',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcIssueDocumentAssociation': {
    'model': 'CcIssueDocumentAssociation',
    'modelPlural': 'CcIssueDocumentAssociations',
    'modelCamel': 'ccIssueDocumentAssociation',
    'modelCamelPlural': 'ccIssueDocumentAssociations',
    'modelUnderscore': 'cc_issue_document_association',
    'modelUnderscorePlural': 'cc_issue_document_associations',
    'columns': [
      {
        'id': 'o751',
        'objectId': 'A416628E-4BA4-4D06-A0D7-87A6686A2BEB',
        'name': '议题id',
        'code': 'cc_issue_id',
        'creationDate': '1520576170',
        'creator': 'yide',
        'modificationDate': '1520579953',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcIssue',
          'modelCamel': 'ccIssue',
          'modelCamelPlural': 'ccIssues',
          'modelUnderscore': 'cc_issue',
          'modelUnderscorePlural': 'cc_issues'
        },
        'codeCamel': 'ccIssueId',
        'codeCamelPlural': 'ccIssueIds',
        'codeUnderscore': 'cc_issue_id',
        'codeUnderscorePlural': 'cc_issue_ids',
        'type': 'string'
      },
      {
        'id': 'o752',
        'objectId': '3769B6B7-7885-4703-9C67-E17ACC362679',
        'name': '附件id',
        'code': 'cc_enclosure_issue_id',
        'creationDate': '1520576170',
        'creator': 'yide',
        'modificationDate': '1520579953',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcEnclosureIssue',
          'modelCamel': 'ccEnclosureIssue',
          'modelCamelPlural': 'ccEnclosureIssues',
          'modelUnderscore': 'cc_enclosure_issue',
          'modelUnderscorePlural': 'cc_enclosure_issues'
        },
        'codeCamel': 'ccEnclosureIssueId',
        'codeCamelPlural': 'ccEnclosureIssueIds',
        'codeUnderscore': 'cc_enclosure_issue_id',
        'codeUnderscorePlural': 'cc_enclosure_issue_ids',
        'type': 'string'
      },
      {
        'id': 'o753',
        'objectId': '867FEC00-8A4D-49BB-8D54-CB42FA25B666',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520576170',
        'creator': 'yide',
        'modificationDate': '1520576313',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o754',
        'objectId': '7F93EAEA-69A4-47F1-B858-4909258AC75F',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520576170',
        'creator': 'yide',
        'modificationDate': '1520576313',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      }
    ]
  },
  'CcReceiver': {
    'model': 'CcReceiver',
    'modelPlural': 'CcReceivers',
    'modelCamel': 'ccReceiver',
    'modelCamelPlural': 'ccReceivers',
    'modelUnderscore': 'cc_receiver',
    'modelUnderscorePlural': 'cc_receivers',
    'columns': [
      {
        'id': 'o757',
        'objectId': 'B215E5AD-440B-45D0-B4D0-D74BE94044A5',
        'name': '议题id',
        'code': 'cc_issue_id',
        'creationDate': '1520576594',
        'creator': 'yide',
        'modificationDate': '1520579975',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcIssue',
          'modelCamel': 'ccIssue',
          'modelCamelPlural': 'ccIssues',
          'modelUnderscore': 'cc_issue',
          'modelUnderscorePlural': 'cc_issues'
        },
        'codeCamel': 'ccIssueId',
        'codeCamelPlural': 'ccIssueIds',
        'codeUnderscore': 'cc_issue_id',
        'codeUnderscorePlural': 'cc_issue_ids',
        'type': 'string'
      },
      {
        'id': 'o758',
        'objectId': 'D090B27F-F12B-4251-9CD6-1820F4850AE3',
        'name': '接收人id',
        'code': 'user_id',
        'creationDate': '1520576594',
        'creator': 'yide',
        'modificationDate': '1520577042',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o759',
        'objectId': '8DCABC4E-C672-4463-9C23-79B9FD586765',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520576594',
        'creator': 'yide',
        'modificationDate': '1520577042',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o760',
        'objectId': '4454DBB2-AE2B-4599-B7F2-09F815D1E4CA',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520576594',
        'creator': 'yide',
        'modificationDate': '1520577042',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o761',
        'objectId': 'CF652602-04F1-40D3-9CE7-517E3DC2ED67',
        'name': '是否反馈',
        'code': 'status',
        'creationDate': '1520577779',
        'creator': 'yide',
        'modificationDate': '1520577795',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o762',
        'objectId': '2F3A85C5-13D3-45AA-B6EB-ACAFE3BE38F0',
        'name': '反馈信息',
        'code': 'feedback_info',
        'creationDate': '1520578127',
        'creator': 'yide',
        'modificationDate': '1520578263',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'feedbackInfo',
        'codeCamelPlural': 'feedbackInfos',
        'codeUnderscore': 'feedback_info',
        'codeUnderscorePlural': 'feedback_infos',
        'type': 'string'
      },
      {
        'id': 'o763',
        'objectId': '33F8A35B-C8E7-41C7-94E0-4FC4D1980F54',
        'name': '反馈时间',
        'code': 'feedback_time',
        'creationDate': '1520578127',
        'creator': 'yide',
        'modificationDate': '1520578263',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'feedbackTime',
        'codeCamelPlural': 'feedbackTimes',
        'codeUnderscore': 'feedback_time',
        'codeUnderscorePlural': 'feedback_times',
        'type': 'datetime'
      }
    ]
  },
  'CcIssueApproval': {
    'model': 'CcIssueApproval',
    'modelPlural': 'CcIssueApprovals',
    'modelCamel': 'ccIssueApproval',
    'modelCamelPlural': 'ccIssueApprovals',
    'modelUnderscore': 'cc_issue_approval',
    'modelUnderscorePlural': 'cc_issue_approvals',
    'columns': [
      {
        'id': 'o766',
        'objectId': '631740A8-5700-4EFD-9873-BC729697C512',
        'name': '审批人',
        'code': 'user_id',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'codeCamel': 'userId',
        'codeCamelPlural': 'userIds',
        'codeUnderscore': 'user_id',
        'codeUnderscorePlural': 'user_ids',
        'type': 'string'
      },
      {
        'id': 'o767',
        'objectId': '357A9F09-0942-40CD-BA4C-A336E9E1AF21',
        'name': '是否通过',
        'code': 'status',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'status',
        'codeCamelPlural': 'statuses',
        'codeUnderscore': 'status',
        'codeUnderscorePlural': 'statuses',
        'type': 'number'
      },
      {
        'id': 'o768',
        'objectId': 'E0B5C28A-E27A-47EC-BD6E-6C09D0E00B89',
        'name': '备注',
        'code': 'remark',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'varchar(1024)',
        'length': '1024',
        'codeCamel': 'remark',
        'codeCamelPlural': 'remarks',
        'codeUnderscore': 'remark',
        'codeUnderscorePlural': 'remarks',
        'type': 'string'
      },
      {
        'id': 'o769',
        'objectId': 'F5C058F2-CED0-4E3E-B5E8-D5091644E4E5',
        'name': '是否审批',
        'code': 'examination_approval',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'int',
        'codeCamel': 'examinationApproval',
        'codeCamelPlural': 'examinationApprovals',
        'codeUnderscore': 'examination_approval',
        'codeUnderscorePlural': 'examination_approvals',
        'type': 'number'
      },
      {
        'id': 'o770',
        'objectId': 'E136D8D3-FED9-44A8-A525-B12E96159ABD',
        'name': '创建时间',
        'code': 'create_time',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'createTime',
        'codeCamelPlural': 'createTimes',
        'codeUnderscore': 'create_time',
        'codeUnderscorePlural': 'create_times',
        'type': 'datetime'
      },
      {
        'id': 'o771',
        'objectId': 'FA5D2F81-B62D-49C9-A431-CDC9D30079D2',
        'name': '最后更新时间',
        'code': 'last_update_time',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'lastUpdateTime',
        'codeCamelPlural': 'lastUpdateTimes',
        'codeUnderscore': 'last_update_time',
        'codeUnderscorePlural': 'last_update_times',
        'type': 'datetime'
      },
      {
        'id': 'o772',
        'objectId': 'C90C65E2-465B-4252-81DF-AB3CE3A8944B',
        'name': '审批时间',
        'code': 'approval_time',
        'creationDate': '1520578730',
        'creator': 'yide',
        'modificationDate': '1520579097',
        'modifier': 'yide',
        'dataType': 'datetime',
        'codeCamel': 'approvalTime',
        'codeCamelPlural': 'approvalTimes',
        'codeUnderscore': 'approval_time',
        'codeUnderscorePlural': 'approval_times',
        'type': 'datetime'
      },
      {
        'id': 'o773',
        'objectId': 'DA9A3821-319F-4D98-AB5F-A3A241CFB40A',
        'name': '议题id',
        'code': 'cc_Issue_id',
        'creationDate': '1520579097',
        'creator': 'yide',
        'modificationDate': '1520579142',
        'modifier': 'yide',
        'dataType': 'varchar(128)',
        'length': '128',
        'foreignTable': {
          'model': 'CcIssue',
          'modelCamel': 'ccIssue',
          'modelCamelPlural': 'ccIssues',
          'modelUnderscore': 'cc_issue',
          'modelUnderscorePlural': 'cc_issues'
        },
        'codeCamel': 'ccIssueId',
        'codeCamelPlural': 'ccIssueIds',
        'codeUnderscore': 'cc_issue_id',
        'codeUnderscorePlural': 'cc_issue_ids',
        'type': 'string'
      }
    ]
  }
}

exports = module.exports = ModelSchema
