/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    public static final String SPRING4_DISCOVERER = "org.springframework.core.DefaultParameterNameDiscoverer";
    private final ParameterNameDiscoverer parameterNameDiscover = this.parameterNameDiscoverer();

    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        String name = this.findParameterNameFromAnnotations(methodParameter);
        if (Strings.isNullOrEmpty((String)name)) {
            Optional<String> discoveredName = this.discoveredName(methodParameter);
            name = discoveredName.isPresent() ? (String)discoveredName.get() : String.format("param%s", methodParameter.getParameterIndex());
        }
        context.parameterBuilder().name(name).description(name);
    }

    private Optional<String> discoveredName(MethodParameter methodParameter) {
        String[] discoveredNames = this.parameterNameDiscover.getParameterNames(methodParameter.getMethod());
        return discoveredNames != null && methodParameter.getParameterIndex() < discoveredNames.length ? Optional.fromNullable((Object)Strings.emptyToNull((String)discoveredNames[methodParameter.getParameterIndex()])) : Optional.absent();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findParameterNameFromAnnotations(MethodParameter methodParameter) {
        ArrayList methodAnnotations = Lists.newArrayList((Object[])methodParameter.getParameterAnnotations());
        return (String)FluentIterable.from((Iterable)methodAnnotations).filter(PathVariable.class).first().transform(this.pathVariableValue()).or(this.first(methodAnnotations, ModelAttribute.class).transform(this.modelAttributeValue())).or(this.first(methodAnnotations, RequestParam.class).transform(this.requestParamValue())).or(this.first(methodAnnotations, RequestHeader.class).transform(this.requestHeaderValue())).orNull();
    }

    private ParameterNameDiscoverer parameterNameDiscoverer() {
        ParameterNameDiscoverer dicoverer;
        try {
            dicoverer = (ParameterNameDiscoverer)Class.forName(SPRING4_DISCOVERER).newInstance();
        }
        catch (Exception e) {
            dicoverer = new LocalVariableTableParameterNameDiscoverer();
        }
        return dicoverer;
    }

    private <T> Optional<T> first(List<Annotation> methodAnnotations, Class<T> ofType) {
        return FluentIterable.from(methodAnnotations).filter(ofType).first();
    }

    private Function<RequestHeader, String> requestHeaderValue() {
        return new Function<RequestHeader, String>(){

            public String apply(RequestHeader input) {
                return input.value();
            }
        };
    }

    private Function<RequestParam, String> requestParamValue() {
        return new Function<RequestParam, String>(){

            public String apply(RequestParam input) {
                return input.value();
            }
        };
    }

    private Function<ModelAttribute, String> modelAttributeValue() {
        return new Function<ModelAttribute, String>(){

            public String apply(ModelAttribute input) {
                return input.value();
            }
        };
    }

    private Function<PathVariable, String> pathVariableValue() {
        return new Function<PathVariable, String>(){

            public String apply(PathVariable input) {
                return input.value();
            }
        };
    }
}

