/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.ServletUtil;
import jodd.servlet.URLCoder;

public class URLBuilder {
    protected final StringBuilder url = new StringBuilder();
    protected final String encoding;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected boolean hasParams = false;
    protected boolean firstpath;

    public URLBuilder(HttpServletRequest request, HttpServletResponse response, String encoding) {
        this.encoding = encoding;
        this.request = request;
        this.response = response;
        this.firstpath = true;
    }

    public URLBuilder path(String value) {
        if (this.hasParams) {
            throw new IllegalArgumentException("Path element can't come after query parameters.");
        }
        if (this.firstpath) {
            if (this.request != null) {
                value = ServletUtil.resolveUrl(value, this.request);
            }
            this.firstpath = false;
        }
        URLCoder.appendPath(this.url, value);
        return this;
    }

    public URLBuilder param(String name, Object value) {
        return this.param(name, value == null ? null : value.toString());
    }

    public URLBuilder param(String name, String value) {
        this.url.append(this.hasParams ? (char)'&' : '?');
        this.hasParams = true;
        URLCoder.appendQuery(this.url, name, this.encoding);
        if (value != null && value.length() > 0) {
            this.url.append('=');
            URLCoder.appendQuery(this.url, value, this.encoding);
        }
        return this;
    }

    public URLBuilder param(String nameValue) {
        String name;
        this.url.append(this.hasParams ? (char)'&' : '?');
        this.hasParams = true;
        int eqNdx = nameValue.indexOf(61);
        String value = null;
        if (eqNdx == -1) {
            name = nameValue;
        } else {
            name = nameValue.substring(0, eqNdx);
            value = nameValue.substring(eqNdx + 1);
        }
        URLCoder.appendQuery(this.url, name, this.encoding);
        if (value != null && value.length() > 0) {
            this.url.append('=');
            URLCoder.appendQuery(this.url, value, this.encoding);
        }
        return this;
    }

    public String toString() {
        String result = this.url.toString();
        return this.response != null ? this.response.encodeURL(result) : result;
    }
}

