/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.IOException;
import jodd.JoddDefault;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.ClassScanner;
import jodd.props.Props;
import jodd.util.StringUtil;

public class PropsUtil {
    public static void loadFromClasspath(final Props p, String ... patterns) {
        ClassScanner scanner = new ClassScanner(){

            protected void onEntry(ClassFinder.EntryData entryData) throws IOException {
                String encoding = JoddDefault.encoding;
                if (StringUtil.endsWithIgnoreCase(entryData.getName(), ".properties")) {
                    encoding = "ISO-8859-1";
                }
                p.load(entryData.openInputStream(), encoding);
            }
        };
        scanner.setIncludeResources(true);
        scanner.setIgnoreException(true);
        scanner.setIncludedEntries(patterns);
        scanner.scanDefaultClasspath();
    }

    public static Props createFromClasspath(String ... patterns) {
        Props p = new Props();
        PropsUtil.loadFromClasspath(p, patterns);
        return p;
    }
}

