/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import jodd.io.FastCharArrayWriter;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.props.PropsData;
import jodd.props.PropsParser;
import jodd.props.PropsValue;
import jodd.typeconverter.Convert;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Props
implements Cloneable {
    private static final String DEFAULT_PROFILES_PROP = "@profiles";
    protected final PropsParser parser;
    protected final PropsData data;
    protected String activeProfilesProp = "@profiles";
    protected String[] activeProfiles;
    protected volatile boolean initialized;

    public Props() {
        this(new PropsParser());
    }

    protected Props(PropsParser parser) {
        this.parser = parser;
        this.data = parser.getPropsData();
    }

    protected Props clone() {
        PropsParser parser = this.parser.clone();
        Props p = new Props(parser);
        p.activeProfilesProp = this.activeProfilesProp;
        return p;
    }

    public void setEscapeNewLineValue(String escapeNewLineValue) {
        this.parser.escapeNewLineValue = escapeNewLineValue;
    }

    public void setValueTrimLeft(boolean valueTrimLeft) {
        this.parser.valueTrimLeft = valueTrimLeft;
    }

    public void setValueTrimRight(boolean valueTrimRight) {
        this.parser.valueTrimRight = valueTrimRight;
    }

    public void setIgnorePrefixWhitespacesOnNewLine(boolean ignorePrefixWhitespacesOnNewLine) {
        this.parser.ignorePrefixWhitespacesOnNewLine = ignorePrefixWhitespacesOnNewLine;
    }

    public void setSkipEmptyProps(boolean skipEmptyProps) {
        this.parser.skipEmptyProps = skipEmptyProps;
    }

    public void setAppendDuplicateProps(boolean appendDuplicateProps) {
        this.data.appendDuplicateProps = appendDuplicateProps;
    }

    protected synchronized void parse(String data) {
        this.initialized = false;
        this.parser.parse(data);
    }

    public void load(String data) {
        this.parse(data);
    }

    public void load(File file) throws IOException {
        String extension = FileNameUtil.getExtension(file.getAbsolutePath());
        String data = extension.equalsIgnoreCase("properties") ? FileUtil.readString(file, "ISO-8859-1") : FileUtil.readString(file);
        this.parse(data);
    }

    public void load(File file, String encoding) throws IOException {
        this.parse(FileUtil.readString(file, encoding));
    }

    public void load(InputStream in) throws IOException {
        FastCharArrayWriter out = new FastCharArrayWriter();
        StreamUtil.copy(in, (Writer)out);
        this.parse(((Object)out).toString());
    }

    public void load(InputStream in, String encoding) throws IOException {
        FastCharArrayWriter out = new FastCharArrayWriter();
        StreamUtil.copy(in, (Writer)out, encoding);
        this.parse(((Object)out).toString());
    }

    public void load(Properties p) {
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = p.getProperty(name);
            if (value == null) continue;
            this.data.putBaseProperty(name, p.getProperty(name));
        }
    }

    public void load(Properties p, String prefix) {
        Enumeration<?> names = p.propertyNames();
        prefix = prefix + '.';
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = p.getProperty(name);
            if (value == null) continue;
            this.data.putBaseProperty(prefix + name, value);
        }
    }

    public void load(Map<?, ?> map, String prefix) {
        prefix = prefix + '.';
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            this.data.putBaseProperty(prefix + name, value.toString());
        }
    }

    public void loadSystemProperties(String prefix) {
        Properties environmentProperties = System.getProperties();
        this.load(environmentProperties, prefix);
    }

    public void loadEnvironment(String prefix) {
        Map<String, String> environmentMap = System.getenv();
        this.load(environmentMap, prefix);
    }

    public int countTotalProperties() {
        return this.data.countBaseProperties() + this.data.countProfileProperties();
    }

    public String getBaseValue(String key) {
        return this.getValue(key, null);
    }

    public String getValue(String key) {
        return this.getValue(key, this.activeProfiles);
    }

    public String getValue(String key, String ... profiles) {
        this.initialize();
        return this.data.lookupValue(key, profiles);
    }

    public void setValue(String key, String value) {
        this.setValue(key, value, null);
    }

    public void setValue(String key, String value, String profile) {
        if (profile == null) {
            this.data.putBaseProperty(key, value);
        } else {
            this.data.putProfileProperty(key, value, profile);
        }
        this.initialized = false;
    }

    public Properties extractBaseProperties() {
        return this.extractProperties(null);
    }

    public Properties extractProperties() {
        return this.extractProperties(this.activeProfiles);
    }

    public Properties extractProperties(String ... profiles) {
        this.initialize();
        return this.data.extractProperties(profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (!this.initialized) {
            Props props = this;
            synchronized (props) {
                if (!this.initialized) {
                    this.data.resolveMacros();
                    this.resolveActiveProfiles();
                    this.initialized = true;
                }
            }
        }
    }

    protected void resolveActiveProfiles() {
        if (this.activeProfilesProp == null) {
            this.activeProfiles = null;
            return;
        }
        PropsValue pv = this.data.getBaseProperty(this.activeProfilesProp);
        if (pv == null) {
            this.activeProfiles = null;
            return;
        }
        String value = pv.getValue();
        if (StringUtil.isBlank(value)) {
            this.activeProfiles = null;
            return;
        }
        this.activeProfiles = Convert.toStringArray(value);
        StringUtil.trimAll(this.activeProfiles);
    }
}

