/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jodd.io.FileNameUtil;
import jodd.io.findfile.FileScanner;
import jodd.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardFileScanner
extends FileScanner {
    protected final String wildcard;
    protected boolean usePathWildcards;
    protected List<File> files = new ArrayList<File>();

    public WildcardFileScanner(String wildcard) {
        this(wildcard, false);
    }

    public WildcardFileScanner(String wildcard, boolean usePathWildcards) {
        this.wildcard = wildcard;
        this.usePathWildcards = usePathWildcards;
    }

    public boolean isUsePathWildcards() {
        return this.usePathWildcards;
    }

    public void setUsePathWildcards(boolean usePathWildcards) {
        this.usePathWildcards = usePathWildcards;
    }

    @Override
    protected void onFile(File file) {
        boolean match;
        String path = file.getAbsolutePath();
        path = FileNameUtil.separatorsToUnix(path);
        boolean bl = match = this.usePathWildcards ? Wildcard.matchPath(path, this.wildcard) : Wildcard.match(path, this.wildcard);
        if (match) {
            this.files.add(file);
        }
    }

    public List<File> getMatchedFiles() {
        return this.files;
    }

    public List<File> list(File root) {
        this.files.clear();
        this.scan(root);
        return this.files;
    }

    public List<File> list(String root) {
        this.files.clear();
        this.scan(root);
        return this.files;
    }
}

