/*
 * Decompiled with CFR 0.152.
 */
package jodd.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jodd.compiler.CompilationException;
import jodd.io.FileNameUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringBand;
import jodd.util.ThreadUtil;

public class JavaCompiler {
    protected static final String[] COMPILERS = new String[]{"%j/bin/jikesw", "jikesw", "jikes", "javaw com.sun.tools.javac.Main -classpath %C", "javac -classpath %c"};
    protected String classpath;
    protected String compilerSpec = "-nowarn -sourcepath %s -d %d %f";
    protected String argDebug = "";
    protected String argEncoding = "";
    protected String argSource = "";
    protected String argTarget = "";
    protected boolean haveToolsJar;
    protected boolean useJikes = false;

    public JavaCompiler() {
        File[] classPath = ClassLoaderUtil.getDefaultClasspath();
        StringBand sb = new StringBand(classPath.length + 1);
        for (File entry : classPath) {
            sb.append(entry.toString() + File.pathSeparatorChar);
        }
        File toolsJar = ClassLoaderUtil.findToolsJar();
        if (toolsJar != null) {
            this.haveToolsJar = true;
            sb.append(toolsJar);
        }
        this.classpath = sb.toString();
    }

    public void setCompilerSpec(String compiler) {
        this.compilerSpec = compiler;
    }

    public void setUseJikes(boolean useJikes) {
        this.useJikes = useJikes;
    }

    public void appendClasspath(String ... classpathItems) {
        for (String classpathItem : classpathItems) {
            try {
                File file = new File(classpathItem);
                String canonicalPath = file.getCanonicalPath();
                if (this.classpath.contains(canonicalPath)) continue;
                this.classpath = this.classpath + File.pathSeparatorChar + canonicalPath;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public void setDebug(boolean debug) {
        this.argDebug = debug ? "-g" : "";
    }

    public void setEncoding(String encoding) {
        this.argEncoding = "-encoding " + encoding;
    }

    public void setSourceVersion(String source) {
        this.argSource = "-source " + source;
    }

    public void setTargetVersion(String target) {
        this.argTarget = "-target " + target;
    }

    public void compile(String source) throws IOException {
        this.compile(new File(source), null, null, null);
    }

    public void compile(File sourceFile, String className, File sourceDirectoryFile, File outputDirectoryFile) throws IOException {
        StringBuffer errors;
        boolean status;
        String outputDirectory;
        String sourceDirectory;
        String source;
        if (sourceDirectoryFile == null) {
            sourceDirectoryFile = sourceFile.getParentFile();
        }
        if (!(source = sourceFile.getCanonicalPath()).startsWith(sourceDirectory = sourceDirectoryFile.getCanonicalPath())) {
            throw new CompilationException("Source file is not under source directory.");
        }
        if (className == null) {
            className = source.substring(sourceDirectory.length() + 1);
            className = className.replace('/', '.');
            className = className.replace('\\', '.');
            className = FileNameUtil.removeExtension(className);
        }
        if (outputDirectoryFile == null) {
            outputDirectoryFile = sourceFile.getParentFile();
            int index = 0;
            while ((index = className.indexOf(46, index)) != -1) {
                outputDirectoryFile = outputDirectoryFile.getParentFile();
                ++index;
            }
        }
        if (!this.classpath.contains(outputDirectory = outputDirectoryFile.getCanonicalPath())) {
            this.classpath = this.classpath + File.pathSeparatorChar + outputDirectory;
        }
        if (!(status = this.invokeCompileProcess(source, sourceDirectory, outputDirectory, this.classpath, errors = new StringBuffer()))) {
            if (errors.length() > 0) {
                throw new CompilationException(errors.toString());
            }
            throw new CompilationException("Java compilation failure.");
        }
    }

    private boolean invokeCompileProcess(String source, String sourceDir, String resultDir, String classpath, StringBuffer err) throws IOException {
        Process p;
        Runtime runtime = Runtime.getRuntime();
        String[] envs = new String[]{"CLASSPATH=" + classpath};
        int compilerIndex = 0;
        if (!this.useJikes) {
            compilerIndex = 3;
        }
        while (true) {
            try {
                String compSpec = COMPILERS[compilerIndex];
                compSpec = compSpec + ' ' + this.argDebug;
                compSpec = compSpec + ' ' + this.argSource;
                compSpec = compSpec + ' ' + this.argTarget;
                if (!this.useJikes) {
                    compSpec = compSpec + ' ' + this.argEncoding;
                }
                compSpec = compSpec + ' ' + this.compilerSpec;
                String command = this.parseCompileArgs(compSpec, source, sourceDir, resultDir, classpath);
                p = runtime.exec(command, envs);
            }
            catch (IOException ignore) {
                if (++compilerIndex < COMPILERS.length) continue;
                throw new CompilationException("Compiler not found.");
            }
            break;
        }
        boolean processDone = false;
        InputStream stdout = p.getInputStream();
        InputStream stderr = p.getErrorStream();
        while (stdout.available() == 0 && stderr.available() == 0 && !processDone) {
            ThreadUtil.sleep(100L);
            try {
                p.exitValue();
                processDone = true;
            }
            catch (IllegalThreadStateException ignore) {}
        }
        if (!JavaCompiler.isStreamEmpty(stdout, err) || !JavaCompiler.isStreamEmpty(stderr, err)) {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                throw new CompilationException(e);
            }
            return false;
        }
        return true;
    }

    private static boolean isStreamEmpty(InputStream in, StringBuffer err) throws IOException {
        BufferedReader errorIn = new BufferedReader(new InputStreamReader(in));
        if (in.available() == 0) {
            return true;
        }
        String line = errorIn.readLine();
        if (line == null) {
            return true;
        }
        err.append(line).append("\n");
        while ((line = errorIn.readLine()) != null) {
            err.append(line).append("\n");
        }
        return false;
    }

    private String parseCompileArgs(String compilerSpec, String source, String srcdir, String outdir, String classpath) throws CompilationException {
        String quote = "\"";
        if (File.separator.equals("/")) {
            quote = "";
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = compilerSpec.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '%') {
                if ((c = chars[++i]) == 'd' && outdir != null) {
                    sb.append(quote).append(outdir).append(quote);
                    continue;
                }
                if (c == 'C') {
                    if (!this.haveToolsJar) {
                        throw new CompilationException("Can't find tools.jar");
                    }
                    sb.append(quote).append(classpath).append(quote);
                    continue;
                }
                if (c == 'c') {
                    sb.append(quote).append(classpath).append(quote);
                    continue;
                }
                if (c == 'f') {
                    sb.append(quote).append(source).append(quote);
                    continue;
                }
                if (c != 's') continue;
                if (srcdir == null) {
                    srcdir = outdir;
                }
                sb.append(quote).append(srcdir).append(quote);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

