/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.HashMap;
import java.util.Iterator;
import jodd.cache.AbstractCacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUCache<K, V>
extends AbstractCacheMap<K, V> {
    public LFUCache(int maxSize) {
        this(maxSize, 0L);
    }

    public LFUCache(int maxSize, long timeout) {
        this.cacheSize = maxSize;
        this.timeout = timeout;
        this.cacheMap = new HashMap(maxSize + 1);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        AbstractCacheMap.CacheObject comin = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
            if (co.isExpired()) {
                values.remove();
                this.onRemove(co);
                ++count;
                continue;
            }
            if (comin == null) {
                comin = co;
                continue;
            }
            if (co.accessCount >= comin.accessCount) continue;
            comin = co;
        }
        if (!this.isFull()) {
            return count;
        }
        if (comin != null) {
            int minAccessCount = comin.accessCount;
            values = this.cacheMap.values().iterator();
            while (values.hasNext()) {
                AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
                co.accessCount -= minAccessCount;
                if (co.accessCount > 0) continue;
                values.remove();
                this.onRemove(co);
                ++count;
            }
        }
        return count;
    }

    protected void onRemove(AbstractCacheMap.CacheObject<K, V> cacheObject) {
    }
}

