/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.Block;
import com.github.underscore.Function;
import com.github.underscore.Function1;
import com.github.underscore.FunctionAccum;
import com.github.underscore.MemoizeFunction1;
import com.github.underscore.Optional;
import com.github.underscore.Predicate;
import com.github.underscore.Template;
import com.github.underscore.Tuple;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class $<T> {
    private static ClassForName classForName = new ClassForName();
    private static final Map<String, Function1<String, String>> FUNCTIONS = $.newLinkedHashMap();
    private static final Map<String, String> TEMPLATE_SETTINGS = new HashMap<String, String>(){
        {
            this.put("evaluate", "<%([\\s\\S]+?)%>");
            this.put("interpolate", "<%=([\\s\\S]+?)%>");
            this.put("escape", "<%-([\\s\\S]+?)%>");
        }
    };
    private static final AtomicInteger UNIQUE_ID = new AtomicInteger(0);
    private static final String ALL_SYMBOLS = "([\\s\\S]+?)";
    private final Iterable<T> iterable;
    private final Optional<String> string;

    public $(Iterable<T> iterable) {
        this.iterable = iterable;
        this.string = Optional.absent();
    }

    public $(String string) {
        this.iterable = null;
        this.string = Optional.of(string);
    }

    public static void setClassForName(ClassForName classForName) {
        $.classForName = classForName;
    }

    private static void setTemplateKey(Map<String, String> templateSettings, String key) {
        if (templateSettings.containsKey(key) && templateSettings.get(key).contains(ALL_SYMBOLS)) {
            TEMPLATE_SETTINGS.put(key, templateSettings.get(key));
        }
    }

    public static void templateSettings(Map<String, String> templateSettings) {
        $.setTemplateKey(templateSettings, "evaluate");
        $.setTemplateKey(templateSettings, "interpolate");
        $.setTemplateKey(templateSettings, "escape");
    }

    private static Class<?> classForName(String name) throws Exception {
        return classForName.call(name);
    }

    public static <K, V> Function1<Map<K, V>, V> iteratee(final K key) {
        return new Function1<Map<K, V>, V>(){

            @Override
            public V apply(Map<K, V> item) {
                return item.get(key);
            }
        };
    }

    public static <T> void each(Iterable<T> iterable, Block<? super T> func) {
        for (T element : iterable) {
            func.apply(element);
        }
    }

    public void each(Block<? super T> func) {
        $.each(this.iterable, func);
    }

    public static <T> void eachRight(Iterable<T> iterable, Block<? super T> func) {
        $.each($.reverse(iterable), func);
    }

    public void eachRight(Block<? super T> func) {
        $.eachRight(this.iterable, func);
    }

    public static <T> void forEach(Iterable<T> iterable, Block<? super T> func) {
        $.each(iterable, func);
    }

    public void forEach(Block<? super T> func) {
        $.each(this.iterable, func);
    }

    public static <T> void forEachRight(Iterable<T> iterable, Block<? super T> func) {
        $.eachRight(iterable, func);
    }

    public void forEachRight(Block<? super T> func) {
        $.eachRight(this.iterable, func);
    }

    public static <T, E> List<T> map(List<E> list, Function1<? super E, T> func) {
        List<T> transformed = $.newArrayListWithExpectedSize(list.size());
        for (E element : list) {
            transformed.add(func.apply(element));
        }
        return transformed;
    }

    public static <T, E> Set<T> map(Set<E> set, Function1<? super E, T> func) {
        Set<T> transformed = $.newLinkedHashSetWithExpectedSize(set.size());
        for (E element : set) {
            transformed.add(func.apply(element));
        }
        return transformed;
    }

    public static <T, E> List<T> collect(List<E> list, Function1<? super E, T> func) {
        return $.map(list, func);
    }

    public static <T, E> Set<T> collect(Set<E> set, Function1<? super E, T> func) {
        return $.map(set, func);
    }

    public static <T, E> E reduce(Iterable<T> iterable, FunctionAccum<E, T> func, E zeroElem) {
        E accum = zeroElem;
        for (T element : iterable) {
            accum = func.apply(accum, element);
        }
        return accum;
    }

    public static <T, E> E foldl(Iterable<T> iterable, FunctionAccum<E, T> func, E zeroElem) {
        return $.reduce(iterable, func, zeroElem);
    }

    public static <T, E> E inject(Iterable<T> iterable, FunctionAccum<E, T> func, E zeroElem) {
        return $.reduce(iterable, func, zeroElem);
    }

    public static <T, E> E reduceRight(Iterable<T> iterable, FunctionAccum<E, T> func, E zeroElem) {
        return $.reduce($.reverse(iterable), func, zeroElem);
    }

    public static <T, E> E foldr(Iterable<T> iterable, FunctionAccum<E, T> func, E zeroElem) {
        return $.reduceRight(iterable, func, zeroElem);
    }

    public static <E> Optional<E> find(Iterable<E> iterable, Predicate<E> pred) {
        for (E element : iterable) {
            if (!((Boolean)pred.apply(element)).booleanValue()) continue;
            return Optional.of(element);
        }
        return Optional.absent();
    }

    public static <E> Optional<E> detect(Iterable<E> iterable, Predicate<E> pred) {
        return $.find(iterable, pred);
    }

    public static <E> Optional<E> findLast(Iterable<E> iterable, Predicate<E> pred) {
        return $.find($.reverse(iterable), pred);
    }

    public static <E> List<E> filter(List<E> list, Predicate<E> pred) {
        List filtered = $.newArrayList();
        for (E element : list) {
            if (!((Boolean)pred.apply(element)).booleanValue()) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <E> Set<E> filter(Set<E> set, Predicate<E> pred) {
        Set filtered = $.newLinkedHashSet();
        for (E element : set) {
            if (!((Boolean)pred.apply(element)).booleanValue()) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <E> List<E> select(List<E> list, Predicate<E> pred) {
        return $.filter(list, pred);
    }

    public static <E> Set<E> select(Set<E> set, Predicate<E> pred) {
        return $.filter(set, pred);
    }

    public static <E> List<E> reject(List<E> list, final Predicate<E> pred) {
        return $.filter(list, new Predicate<E>(){

            @Override
            public Boolean apply(E input) {
                return (Boolean)pred.apply(input) == false;
            }
        });
    }

    public static <E> Set<E> reject(Set<E> set, final Predicate<E> pred) {
        return $.filter(set, new Predicate<E>(){

            @Override
            public Boolean apply(E input) {
                return (Boolean)pred.apply(input) == false;
            }
        });
    }

    public static <E> boolean every(Iterable<E> iterable, final Predicate<E> pred) {
        return !$.find(iterable, new Predicate<E>(){

            @Override
            public Boolean apply(E arg) {
                return (Boolean)pred.apply(arg) == false;
            }
        }).isPresent();
    }

    public boolean every(Predicate<T> pred) {
        return $.every(this.iterable, pred);
    }

    public static <E> boolean all(Iterable<E> iterable, Predicate<E> pred) {
        return $.every(iterable, pred);
    }

    public boolean all(Predicate<T> pred) {
        return $.every(this.iterable, pred);
    }

    public static <E> boolean some(Iterable<E> iterable, Predicate<E> pred) {
        return $.find(iterable, pred).isPresent();
    }

    public boolean some(Predicate<T> pred) {
        return $.some(this.iterable, pred);
    }

    public static <E> boolean any(Iterable<E> iterable, Predicate<E> pred) {
        return $.some(iterable, pred);
    }

    public boolean any(Predicate<T> pred) {
        return $.some(this.iterable, pred);
    }

    public static <E> boolean contains(Iterable<E> iterable, final E elem) {
        return $.some(iterable, new Predicate<E>(){

            @Override
            public Boolean apply(E e) {
                return elem == null ? e == null : elem.equals(e);
            }
        });
    }

    public boolean contains(T elem) {
        return $.contains(this.iterable, elem);
    }

    public static <E> boolean contains(Iterable<E> iterable, E elem, int fromIndex) {
        List<E> list = $.newArrayList(iterable);
        return $.contains(list.subList(fromIndex, list.size()), elem);
    }

    public static <E> boolean include(Iterable<E> iterable, E elem) {
        return $.contains(iterable, elem);
    }

    public static <E> List<E> invoke(Iterable<E> iterable, String methodName, final List<Object> args) {
        final List result = $.newArrayList();
        List<Class> argTypes = $.map(args, new Function1<Object, Class<?>>(){

            @Override
            public Class<?> apply(Object input) {
                return input.getClass();
            }
        });
        try {
            final Method method = iterable.iterator().next().getClass().getMethod(methodName, argTypes.toArray(new Class[argTypes.size()]));
            $.each(iterable, new Block<E>(){

                @Override
                public void apply(E arg) {
                    try {
                        result.add(method.invoke(arg, args.toArray(new Object[args.size()])));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public List<T> invoke(String methodName, List<Object> args) {
        return $.invoke(this.iterable, methodName, args);
    }

    public static <E> List<E> invoke(Iterable<E> iterable, String methodName) {
        return $.invoke(iterable, methodName, Collections.<Object>emptyList());
    }

    public List<T> invoke(String methodName) {
        return $.invoke(this.iterable, methodName);
    }

    public static <E> List<Object> pluck(List<E> list, final String propertyName) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return $.map(list, new Function1<E, Object>(){

            @Override
            public Object apply(E elem) {
                try {
                    return elem.getClass().getField(propertyName).get(elem);
                }
                catch (Exception e) {
                    try {
                        return elem.getClass().getMethod(propertyName, new Class[0]).invoke(elem, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        });
    }

    public List<Object> pluck(String propertyName) {
        return $.pluck($.newArrayList(this.iterable), propertyName);
    }

    public static <E> Set<Object> pluck(Set<E> set, final String propertyName) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        return $.map(set, new Function1<E, Object>(){

            @Override
            public Object apply(E elem) {
                try {
                    return elem.getClass().getField(propertyName).get(elem);
                }
                catch (Exception e) {
                    try {
                        return elem.getClass().getMethod(propertyName, new Class[0]).invoke(elem, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        });
    }

    public static <T, E> List<E> where(List<E> list, List<Tuple<String, T>> properties) {
        return $.filter(list, new WherePredicate(properties));
    }

    public <E> List<T> where(List<Tuple<String, E>> properties) {
        return $.where($.newArrayList(this.iterable), properties);
    }

    public static <T, E> Set<E> where(Set<E> set, List<Tuple<String, T>> properties) {
        return $.filter(set, new WherePredicate(properties));
    }

    public static <T, E> Optional<E> findWhere(Iterable<E> iterable, List<Tuple<String, T>> properties) {
        return $.find(iterable, new WherePredicate(properties));
    }

    public <E> Optional<T> findWhere(List<Tuple<String, E>> properties) {
        return $.findWhere(this.iterable, properties);
    }

    public static <E extends Comparable<? super E>> E max(Collection<E> collection) {
        return (E)((Comparable)Collections.max(collection));
    }

    public T max() {
        return (T)$.max((Collection)this.iterable);
    }

    public static <E, F extends Comparable> E max(Collection<E> collection, final Function1<E, F> func) {
        return Collections.max(collection, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
    }

    public <F extends Comparable<? super F>> T max(Function1<T, F> func) {
        return $.max((Collection)this.iterable, func);
    }

    public static <E extends Comparable<? super E>> E min(Collection<E> collection) {
        return (E)((Comparable)Collections.min(collection));
    }

    public T min() {
        return (T)$.min((Collection)this.iterable);
    }

    public static <E, F extends Comparable> E min(Collection<E> collection, final Function1<E, F> func) {
        return Collections.min(collection, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
    }

    public <F extends Comparable<? super F>> T min(Function1<T, F> func) {
        return $.min((Collection)this.iterable, func);
    }

    public static <E> List<E> shuffle(Iterable<E> iterable) {
        List<E> shuffled = $.newArrayList(iterable);
        Collections.shuffle(shuffled);
        return shuffled;
    }

    public List<T> shuffle() {
        return $.shuffle(this.iterable);
    }

    public static <E> E sample(Iterable<E> iterable) {
        return $.newArrayList(iterable).get(new Random().nextInt($.size(iterable)));
    }

    public T sample() {
        return $.sample(this.iterable);
    }

    public static <E> Set<E> sample(List<E> list, int howMany) {
        int size = Math.min(howMany, list.size());
        Set samples = $.newLinkedHashSetWithExpectedSize(size);
        while (samples.size() < size) {
            E sample = $.sample(list);
            samples.add(sample);
        }
        return samples;
    }

    public static <E, T extends Comparable<? super T>> List<E> sortBy(Iterable<E> iterable, final Function1<E, T> func) {
        List<E> sortedList = $.newArrayList(iterable);
        Collections.sort(sortedList, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
        return sortedList;
    }

    public <E, V extends Comparable<? super V>> List<E> sortBy(Function1<E, V> func) {
        return $.sortBy(this.iterable, func);
    }

    public static <K, V extends Comparable<? super V>> List<Map<K, V>> sortBy(Iterable<Map<K, V>> iterable, final K key) {
        List<Map<K, V>> sortedList = $.newArrayList(iterable);
        Collections.sort(sortedList, new Comparator<Map<K, V>>(){

            @Override
            public int compare(Map<K, V> o1, Map<K, V> o2) {
                return ((Comparable)o1.get(key)).compareTo(o2.get(key));
            }
        });
        return sortedList;
    }

    public static <K, E> Map<K, List<E>> groupBy(Iterable<E> iterable, Function1<E, K> func) {
        Map<K, E> retVal = $.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            List val = retVal.containsKey(key) ? (List)retVal.get(key) : $.newArrayList();
            val.add(e);
            retVal.put(key, val);
        }
        return retVal;
    }

    public <K, E> Map<K, List<E>> groupBy(Function1<E, K> func) {
        return $.groupBy(this.iterable, func);
    }

    public static <K, E> Map<K, List<E>> indexBy(Iterable<E> iterable, final String property) {
        return $.groupBy(iterable, new Function1<E, K>(){

            @Override
            public K apply(E elem) {
                try {
                    return elem.getClass().getField(property).get(elem);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    public <K, E> Map<K, List<E>> indexBy(String property) {
        return $.indexBy(this.iterable, property);
    }

    public static <K, E> Map<K, Integer> countBy(Iterable<E> iterable, Function1<E, K> func) {
        Map<K, E> retVal = $.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            if (retVal.containsKey(key)) {
                retVal.put(key, 1 + (Integer)retVal.get(key));
                continue;
            }
            retVal.put(key, 1);
        }
        return retVal;
    }

    public <K, E> Map<K, Integer> countBy(Function1<E, K> func) {
        return $.countBy(this.iterable, func);
    }

    public static <E> E[] toArray(Iterable<E> iterable) {
        return $.newArrayList(iterable).toArray();
    }

    public <E> E[] toArray() {
        return $.toArray(this.iterable);
    }

    public static <K, V> Map<K, V> toMap(Iterable<Map.Entry<K, V>> iterable) {
        Map result = $.newLinkedHashMap();
        for (Map.Entry<K, V> entry : iterable) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <K, V> Map<K, V> toMap() {
        return $.toMap(this.iterable);
    }

    public static <K, V> Map<K, V> toMap(List<Tuple<K, V>> tuples) {
        Map result = $.newLinkedHashMap();
        for (Tuple<K, V> entry : tuples) {
            result.put(entry.fst(), entry.snd());
        }
        return result;
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public int size() {
        return $.size(this.iterable);
    }

    public static <E> int size(E ... array) {
        return array.length;
    }

    public static <E> List<List<E>> partition(Iterable<E> iterable, Predicate<E> pred) {
        List retVal1 = $.newArrayList();
        List retVal2 = $.newArrayList();
        for (E e : iterable) {
            if (((Boolean)pred.apply(e)).booleanValue()) {
                retVal1.add(e);
                continue;
            }
            retVal2.add(e);
        }
        return Arrays.asList(retVal1, retVal2);
    }

    public static <E> List<E>[] partition(E[] iterable, Predicate<E> pred) {
        return $.partition(Arrays.asList(iterable), pred).toArray(new ArrayList[2]);
    }

    public static <E> E first(Iterable<E> iterable) {
        return iterable.iterator().next();
    }

    public static <E> E first(E ... array) {
        return array[0];
    }

    public static <E> List<E> first(List<E> list, int n) {
        return list.subList(0, Math.min(n, list.size()));
    }

    public T first() {
        return this.iterable.iterator().next();
    }

    public List<T> first(int n) {
        return ((List)this.iterable).subList(0, n);
    }

    public static <E> E first(Iterable<E> iterable, Predicate<E> pred) {
        return $.filter($.newArrayList(iterable), pred).iterator().next();
    }

    public T first(Predicate<T> pred) {
        return $.filter($.newArrayList(this.iterable), pred).iterator().next();
    }

    public static <E> E firstOrNull(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    public T firstOrNull() {
        Iterator<T> iterator = this.iterable.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <E> E firstOrNull(Iterable<E> iterable, Predicate<E> pred) {
        Iterator<E> iterator = $.filter($.newArrayList(iterable), pred).iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    public T firstOrNull(Predicate<T> pred) {
        Iterator<T> iterator = $.filter($.newArrayList(this.iterable), pred).iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <E> E head(Iterable<E> iterable) {
        return $.first(iterable);
    }

    public static <E> E head(E ... array) {
        return $.first(array);
    }

    public static <E> List<E> head(List<E> list, int n) {
        return $.first(list, n);
    }

    public T head() {
        return this.first();
    }

    public List<T> head(int n) {
        return this.first(n);
    }

    public static <E> List<E> initial(List<E> list) {
        return $.initial(list, 1);
    }

    public static <E> List<E> initial(List<E> list, int n) {
        return list.subList(0, Math.max(0, list.size() - n));
    }

    public static <E> E[] initial(E ... array) {
        return $.initial(array, 1);
    }

    public static <E> E[] initial(E[] array, int n) {
        return Arrays.copyOf(array, array.length - n);
    }

    public List<T> initial() {
        return $.initial((List)this.iterable, 1);
    }

    public List<T> initial(int n) {
        return $.initial((List)this.iterable, n);
    }

    public static <E> E last(E ... array) {
        return array[array.length - 1];
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> last(List<E> list, int n) {
        return list.subList(Math.max(0, list.size() - n), list.size());
    }

    public T last() {
        return (T)$.last((List)this.iterable);
    }

    public List<T> last(int n) {
        return $.last((List)this.iterable, n);
    }

    public static <E> E last(List<E> list, Predicate<E> pred) {
        List<E> filteredList = $.filter(list, pred);
        return filteredList.get(filteredList.size() - 1);
    }

    public T last(Predicate<T> pred) {
        return $.last((List)this.iterable, pred);
    }

    public static <E> E lastOrNull(List<E> list) {
        return list.isEmpty() ? null : (E)list.get(list.size() - 1);
    }

    public T lastOrNull() {
        return (T)$.lastOrNull((List)this.iterable);
    }

    public static <E> E lastOrNull(List<E> list, Predicate<E> pred) {
        List<E> filteredList = $.filter(list, pred);
        return filteredList.isEmpty() ? null : (E)filteredList.get(filteredList.size() - 1);
    }

    public T lastOrNull(Predicate<T> pred) {
        return $.lastOrNull((List)this.iterable, pred);
    }

    public static <E> List<E> rest(List<E> list) {
        return $.rest(list, 1);
    }

    public static <E> List<E> rest(List<E> list, int n) {
        return list.subList(Math.min(n, list.size()), list.size());
    }

    public static <E> E[] rest(E ... array) {
        return $.rest(array, 1);
    }

    public static <E> E[] rest(E[] array, int n) {
        return $.rest(Arrays.asList(array), n).toArray();
    }

    public List<T> rest() {
        return $.rest((List)this.iterable);
    }

    public List<T> rest(int n) {
        return $.rest((List)this.iterable, n);
    }

    public static <E> List<E> tail(List<E> list) {
        return $.rest(list);
    }

    public static <E> List<E> tail(List<E> list, int n) {
        return $.rest(list, n);
    }

    public static <E> E[] tail(E ... array) {
        return $.rest(array);
    }

    public static <E> E[] tail(E[] array, int n) {
        return $.rest(array, n);
    }

    public List<T> tail() {
        return this.rest();
    }

    public List<T> tail(int n) {
        return this.rest(n);
    }

    public static <E> List<E> drop(List<E> list) {
        return $.rest(list);
    }

    public static <E> List<E> drop(List<E> list, int n) {
        return $.rest(list, n);
    }

    public static <E> E[] drop(E ... array) {
        return $.rest(array);
    }

    public static <E> E[] drop(E[] array, int n) {
        return $.rest(array, n);
    }

    public static <E> List<E> compact(List<E> list) {
        return $.filter(list, new Predicate<E>(){

            @Override
            public Boolean apply(E arg) {
                return !String.valueOf(arg).equals("null") && !String.valueOf(arg).equals("0") && !String.valueOf(arg).equals("false") && !String.valueOf(arg).equals("");
            }
        });
    }

    public static <E> E[] compact(E ... array) {
        return $.compact(Arrays.asList(array)).toArray();
    }

    public static <E> List<E> compact(List<E> list, final E falsyValue) {
        return $.filter(list, new Predicate<E>(){

            @Override
            public Boolean apply(E arg) {
                return !(arg != null ? arg.equals(falsyValue) : falsyValue == null);
            }
        });
    }

    public static <E> E[] compact(E[] array, E falsyValue) {
        return $.compact(Arrays.asList(array), falsyValue).toArray();
    }

    public List<T> compact() {
        return $.compact((List)this.iterable);
    }

    public List<T> compact(T falsyValue) {
        return $.compact((List)this.iterable, falsyValue);
    }

    public static <E> List<E> flatten(List<?> list) {
        List flattened = $.newArrayList();
        $.flatten(list, flattened, -1);
        return flattened;
    }

    public static <E> List<E> flatten(List<?> list, boolean shallow) {
        List flattened = $.newArrayList();
        $.flatten(list, flattened, shallow ? 1 : -1);
        return flattened;
    }

    private static <E> void flatten(List<?> fromTreeList, List<E> toFlatList, int shallowLevel) {
        for (Object item : fromTreeList) {
            if (item instanceof List && shallowLevel != 0) {
                $.flatten((List)item, toFlatList, shallowLevel - 1);
                continue;
            }
            toFlatList.add(item);
        }
    }

    public List<T> flatten() {
        return $.flatten((List)this.iterable);
    }

    public List<T> flatten(boolean shallow) {
        return $.flatten((List)this.iterable, shallow);
    }

    public static <E> List<E> without(List<E> list, E ... values) {
        final List<E> valuesList = Arrays.asList(values);
        return $.filter(list, new Predicate<E>(){

            @Override
            public Boolean apply(E elem) {
                return !$.contains(valuesList, elem);
            }
        });
    }

    public static <E> E[] without(E[] array, E ... values) {
        return $.without(Arrays.asList(array), values).toArray();
    }

    public static <E> List<E> uniq(List<E> list) {
        return $.newArrayList($.newHashSet(list));
    }

    public static <E> E[] uniq(E ... array) {
        return $.uniq(Arrays.asList(array)).toArray();
    }

    public static <K, E> Collection<E> uniq(Iterable<E> iterable, Function1<E, K> func) {
        Map<K, E> retVal = $.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            retVal.put(key, e);
        }
        return retVal.values();
    }

    public static <K, E> E[] uniq(E[] array, Function1<E, K> func) {
        return $.uniq(Arrays.asList(array), func).toArray();
    }

    public static <E> List<E> union(List<E> list, List<E> ... lists) {
        Set union = $.newLinkedHashSet();
        union.addAll(list);
        for (List<E> localList : lists) {
            union.addAll(localList);
        }
        return $.newArrayList(union);
    }

    public List<T> unionWith(List<T> ... lists) {
        return $.union($.newArrayList(this.iterable), lists);
    }

    public static <E> E[] union(E[] ... arrays) {
        Set union = $.newLinkedHashSet();
        for (E[] array : arrays) {
            union.addAll(Arrays.asList(array));
        }
        return $.newArrayList(union).toArray();
    }

    public static <E> List<E> intersection(List<E> list1, final List<E> list2) {
        return $.filter(list1, new Predicate<E>(){

            @Override
            public Boolean apply(E elem) {
                return $.contains(list2, elem);
            }
        });
    }

    public static <E> List<E> intersection(List<E> list, List<E> ... lists) {
        Stack<List<E>> stack = new Stack<List<E>>();
        stack.push(list);
        for (int index = 0; index < lists.length; ++index) {
            stack.push($.intersection((List)stack.peek(), lists[index]));
        }
        return (List)stack.peek();
    }

    public List<T> intersectionWith(List<T> ... lists) {
        return $.intersection($.newArrayList(this.iterable), lists);
    }

    public static <E> E[] intersection(E[] ... arrays) {
        Stack<List<E>> stack = new Stack<List<E>>();
        stack.push(Arrays.asList(arrays[0]));
        for (int index = 1; index < arrays.length; ++index) {
            stack.push($.intersection((List)stack.peek(), Arrays.asList(arrays[index])));
        }
        return ((List)stack.peek()).toArray();
    }

    public static <E> List<E> difference(List<E> list1, final List<E> list2) {
        return $.filter(list1, new Predicate<E>(){

            @Override
            public Boolean apply(E elem) {
                return !$.contains(list2, elem);
            }
        });
    }

    public static <E> List<E> difference(List<E> list, List<E> ... lists) {
        Stack<List<E>> stack = new Stack<List<E>>();
        stack.push(list);
        for (int index = 0; index < lists.length; ++index) {
            stack.push($.difference((List)stack.peek(), lists[index]));
        }
        return (List)stack.peek();
    }

    public List<T> differenceWith(List<T> ... lists) {
        return $.difference($.newArrayList(this.iterable), lists);
    }

    public static <E> E[] difference(E[] ... arrays) {
        Stack<List<E>> stack = new Stack<List<E>>();
        stack.push(Arrays.asList(arrays[0]));
        for (int index = 1; index < arrays.length; ++index) {
            stack.push($.difference((List)stack.peek(), Arrays.asList(arrays[index])));
        }
        return ((List)stack.peek()).toArray();
    }

    public static <T> List<List<T>> zip(List<T> ... lists) {
        final List<List<T>> zipped = $.newArrayList();
        $.each(Arrays.asList(lists), new Block<List<T>>(){

            @Override
            public void apply(List<T> list) {
                $.each(list, new Block<T>(){
                    private int index;

                    @Override
                    public void apply(T elem) {
                        List nTuple;
                        List list = nTuple = this.index >= zipped.size() ? $.newArrayList() : (List)zipped.get(this.index);
                        if (this.index >= zipped.size()) {
                            zipped.add(nTuple);
                        }
                        ++this.index;
                        nTuple.add(elem);
                    }
                });
            }
        });
        return zipped;
    }

    public static <T> List<List<T>> unzip(List<T> ... lists) {
        List<List<T>> unzipped = $.newArrayList();
        for (int index = 0; index < lists[0].size(); ++index) {
            List<T> nTuple = $.newArrayList();
            for (int index2 = 0; index2 < lists.length; ++index2) {
                nTuple.add(lists[index2].get(index));
            }
            unzipped.add(nTuple);
        }
        return unzipped;
    }

    public static <K, V> List<Tuple<K, V>> object(List<K> keys, final List<V> values) {
        return $.map(keys, new Function1<K, Tuple<K, V>>(){
            private int index;

            @Override
            public Tuple<K, V> apply(K key) {
                return Tuple.create(key, values.get(this.index++));
            }
        });
    }

    public static <E> int findIndex(List<E> list, Predicate<E> pred) {
        for (int index = 0; index < list.size(); ++index) {
            if (!((Boolean)pred.apply(list.get(index))).booleanValue()) continue;
            return index;
        }
        return -1;
    }

    public static <E> int findIndex(E[] array, Predicate<E> pred) {
        return $.findIndex(Arrays.asList(array), pred);
    }

    public static <E> int findLastIndex(List<E> list, Predicate<E> pred) {
        for (int index = list.size() - 1; index >= 0; --index) {
            if (!((Boolean)pred.apply(list.get(index))).booleanValue()) continue;
            return index;
        }
        return -1;
    }

    public static <E> int findLastIndex(E[] array, Predicate<E> pred) {
        return $.findLastIndex(Arrays.asList(array), pred);
    }

    public static <E extends Comparable<E>> int sortedIndex(List<E> list, E value) {
        int index = 0;
        for (Comparable elem : list) {
            if (elem.compareTo(value) >= 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <E extends Comparable<E>> int sortedIndex(E[] array, E value) {
        return $.sortedIndex(Arrays.asList(array), value);
    }

    public static <E extends Comparable<E>> int sortedIndex(List<E> list, E value, String propertyName) {
        try {
            Field property = value.getClass().getField(propertyName);
            Object valueProperty = property.get(value);
            int index = 0;
            for (Comparable elem : list) {
                if (((Comparable)property.get(elem)).compareTo(valueProperty) >= 0) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <E extends Comparable<E>> int sortedIndex(E[] array, E value, String propertyName) {
        return $.sortedIndex(Arrays.asList(array), value, propertyName);
    }

    public static <E> int indexOf(List<E> list, E value) {
        return list.indexOf(value);
    }

    public static <E> int indexOf(E[] array, E value) {
        return $.indexOf(Arrays.asList(array), value);
    }

    public static <E> int lastIndexOf(List<E> list, E value) {
        return list.lastIndexOf(value);
    }

    public static <E> int lastIndexOf(E[] array, E value) {
        return $.lastIndexOf(Arrays.asList(array), value);
    }

    public static int[] range(int stop) {
        return $.range(0, stop, 1);
    }

    public static int[] range(int start, int stop) {
        return $.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        int[] array = new int[Math.abs(stop - start) / Math.abs(step)];
        int index2 = 0;
        if (start < stop) {
            int index = start;
            while (index < stop) {
                array[index2] = index;
                index += step;
                ++index2;
            }
        } else {
            int index = start;
            while (index > stop) {
                array[index2] = index;
                index += step;
                ++index2;
            }
        }
        return array;
    }

    public static <T> List<List<T>> chunk(Iterable<T> iterable, int size) {
        int length = $.size(iterable);
        ArrayList<List<T>> result = new ArrayList<List<T>>(length / size);
        for (int index = 0; index < length; index += size) {
            result.add($.newArrayList(iterable).subList(index, Math.min(length, index + size)));
        }
        return result;
    }

    public List<List<T>> chunk(int size) {
        return $.chunk(this.getIterable(), size);
    }

    public static <T, F> Function1<F, T> bind(final Function1<F, T> function) {
        return new Function1<F, T>(){

            @Override
            public T apply(F arg) {
                return function.apply(arg);
            }
        };
    }

    public static <T, F> Function1<F, T> memoize(final Function1<F, T> function) {
        return new MemoizeFunction1<F, T>(){

            @Override
            public T calc(F arg) {
                return function.apply(arg);
            }
        };
    }

    public static <T> void delay(final Function<T> function, int delayMilliseconds) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                function.apply();
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
        scheduler.shutdown();
    }

    public static <T> void defer(Function<T> function) {
        $.delay(function, 0);
    }

    public static <T> Function<T> debounce(final Function<T> function, final int delayMilliseconds) {
        return new Function<T>(){

            @Override
            public T apply() {
                $.delay(function, delayMilliseconds);
                return null;
            }
        };
    }

    public static <T> Function1<Void, T> wrap(final Function1<T, T> function, final Function1<Function1<T, T>, T> wrapper) {
        return new Function1<Void, T>(){

            @Override
            public T apply(Void arg) {
                return wrapper.apply(function);
            }
        };
    }

    public static <E> Predicate<E> negate(final Predicate<E> pred) {
        return new Predicate<E>(){

            @Override
            public Boolean apply(E item) {
                return (Boolean)pred.apply(item) == false;
            }
        };
    }

    public static <T> Function1<T, T> compose(final Function1<T, T> ... func) {
        return new Function1<T, T>(){

            @Override
            public T apply(T arg) {
                Object result = arg;
                for (int index = func.length - 1; index >= 0; --index) {
                    result = func[index].apply(result);
                }
                return result;
            }
        };
    }

    public static <E> Function<E> after(int count, final Function<E> function) {
        class AfterFunction
        implements Function<E> {
            private final int count;
            private int index;
            private E result;

            public AfterFunction(int count) {
                this.count = count;
            }

            @Override
            public E apply() {
                if (++this.index >= this.count) {
                    this.result = function.apply();
                }
                return this.result;
            }
        }
        return new AfterFunction(count);
    }

    public static <E> Function<E> before(int count, final Function<E> function) {
        class BeforeFunction
        implements Function<E> {
            private final int count;
            private int index;
            private E result;

            public BeforeFunction(int count) {
                this.count = count;
            }

            @Override
            public E apply() {
                if (++this.index <= this.count) {
                    this.result = function.apply();
                }
                return this.result;
            }
        }
        return new BeforeFunction(count);
    }

    public static <T> Function<T> once(final Function<T> function) {
        return new Function<T>(){
            private volatile boolean executed;
            private T result;

            @Override
            public T apply() {
                if (!this.executed) {
                    this.executed = true;
                    this.result = function.apply();
                }
                return this.result;
            }
        };
    }

    public static <K, V> Set<K> keys(Map<K, V> object) {
        return object.keySet();
    }

    public static <K, V> Collection<V> values(Map<K, V> object) {
        return object.values();
    }

    public static <K, V> List<Tuple<K, V>> mapObject(Map<K, V> object, final Function1<? super V, V> func) {
        return $.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getKey(), func.apply(entry.getValue()));
            }
        });
    }

    public static <K, V> List<Tuple<K, V>> pairs(Map<K, V> object) {
        return $.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        });
    }

    public static <K, V> List<Tuple<V, K>> invert(Map<K, V> object) {
        return $.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<V, K>>(){

            @Override
            public Tuple<V, K> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getValue(), entry.getKey());
            }
        });
    }

    public static List<String> functions(Object object) {
        List result = $.newArrayList();
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (method.getName().contains("$")) continue;
            result.add(method.getName());
        }
        return $.sort($.uniq(result));
    }

    public static List<String> methods(Object object) {
        return $.functions(object);
    }

    public static <K, V> Map<K, V> extend(Map<K, V> destination, Map<K, V> ... sources) {
        Map result = $.newLinkedHashMap();
        for (Map.Entry<K, V> entry : destination.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map<K, V> source : sources) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static <E> E findKey(List<E> list, Predicate<E> pred) {
        for (int index = 0; index < list.size(); ++index) {
            if (!((Boolean)pred.apply(list.get(index))).booleanValue()) continue;
            return list.get(index);
        }
        return null;
    }

    public static <E> E findKey(E[] array, Predicate<E> pred) {
        return $.findKey(Arrays.asList(array), pred);
    }

    public static <E> E findLastKey(List<E> list, Predicate<E> pred) {
        for (int index = list.size() - 1; index >= 0; --index) {
            if (!((Boolean)pred.apply(list.get(index))).booleanValue()) continue;
            return list.get(index);
        }
        return null;
    }

    public static <E> E findLastKey(E[] array, Predicate<E> pred) {
        return $.findLastKey(Arrays.asList(array), pred);
    }

    public static <K, V> List<Tuple<K, V>> pick(Map<K, V> object, final V ... keys) {
        return $.without($.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (Arrays.asList(keys).contains(entry.getKey())) {
                    return Tuple.create(entry.getKey(), entry.getValue());
                }
                return null;
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> pick(final Map<K, V> object, final Predicate<V> pred) {
        return $.without($.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (((Boolean)pred.apply(object.get(entry.getKey()))).booleanValue()) {
                    return Tuple.create(entry.getKey(), entry.getValue());
                }
                return null;
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> omit(Map<K, V> object, final V ... keys) {
        return $.without($.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (Arrays.asList(keys).contains(entry.getKey())) {
                    return null;
                }
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> omit(Map<K, V> object, final Predicate<V> pred) {
        return $.without($.map($.newArrayList(object.entrySet()), new Function1<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (((Boolean)pred.apply(entry.getValue())).booleanValue()) {
                    return null;
                }
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        }), new Tuple[]{null});
    }

    public static <K, V> Map<K, V> defaults(Map<K, V> object, Map<K, V> defaults) {
        Map result = $.newLinkedHashMap();
        for (Map.Entry<K, V> entry : defaults.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<K, V> entry : object.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Object clone(Object obj) {
        try {
            if (obj instanceof Cloneable) {
                for (Method method : obj.getClass().getMethods()) {
                    if (!method.getName().equals("clone") || method.getParameterTypes().length != 0) continue;
                    return method.invoke(obj, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("Cannot clone object");
    }

    public static <E> E[] clone(E ... iterable) {
        return Arrays.copyOf(iterable, iterable.length);
    }

    public static <T> void tap(Iterable<T> iterable, Block<? super T> func) {
        for (T element : iterable) {
            func.apply(element);
        }
    }

    public static <K, V> boolean isMatch(Map<K, V> object, Map<K, V> properties) {
        for (K key : $.keys(properties)) {
            if (object.containsKey(key) && object.get(key).equals(properties.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(Object object, Object other) {
        return object == null ? other == null : object.equals(other);
    }

    public static <K, V> boolean isEmpty(Map<K, V> object) {
        return object == null || object.isEmpty();
    }

    public static <T> boolean isEmpty(Iterable<T> iterable) {
        return iterable == null || $.size(iterable) == 0;
    }

    public boolean isEmpty() {
        return this.iterable == null || $.size(this.iterable) == 0;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isObject(Object object) {
        return object instanceof Map;
    }

    public static boolean isFunction(Object object) {
        return object instanceof Function1;
    }

    public static boolean isString(Object object) {
        return object instanceof String;
    }

    public static boolean isNumber(Object object) {
        return object instanceof Number;
    }

    public static boolean isDate(Object object) {
        return object instanceof Date;
    }

    public static boolean isRegExp(Object object) {
        return object instanceof Pattern;
    }

    public static boolean isError(Object object) {
        return object instanceof Throwable;
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static <K, V> boolean has(Map<K, V> object, K key) {
        return object.containsKey(key);
    }

    public static <E> E identity(E value) {
        return value;
    }

    public static <E> Function<E> constant(final E value) {
        return new Function<E>(){

            @Override
            public E apply() {
                return value;
            }
        };
    }

    public static <K, V> Function1<Map<K, V>, V> property(final K key) {
        return new Function1<Map<K, V>, V>(){

            @Override
            public V apply(Map<K, V> object) {
                return object.get(key);
            }
        };
    }

    public static <K, V> Function1<K, V> propertyOf(final Map<K, V> object) {
        return new Function1<K, V>(){

            @Override
            public V apply(K key) {
                return object.get(key);
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> matcher(final Map<K, V> object) {
        return new Predicate<Map<K, V>>(){

            @Override
            public Boolean apply(Map<K, V> item) {
                for (Object key : $.keys(object)) {
                    if (item.containsKey(key) && item.get(key).equals(object.get(key))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <E> void times(int count, Function<E> function) {
        for (int index = 0; index < count; ++index) {
            function.apply();
        }
    }

    public static int random(int min, int max) {
        return min + new Random().nextInt(max - min + 1);
    }

    public static int random(int max) {
        return new Random().nextInt(max + 1);
    }

    public static long now() {
        return new Date().getTime();
    }

    public static String escape(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#x27;").replaceAll("`", "&#x60;");
    }

    public static String unescape(String value) {
        return value.replaceAll("&#x60;", "`").replaceAll("&#x27;", "'").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    public static <E> Object result(Iterable<E> iterable, Predicate<E> pred) {
        for (E element : iterable) {
            if (!((Boolean)pred.apply(element)).booleanValue()) continue;
            if (element instanceof Map.Entry) {
                if (((Map.Entry)element).getValue() instanceof Function) {
                    return ((Function)((Map.Entry)element).getValue()).apply();
                }
                return ((Map.Entry)element).getValue();
            }
            return element;
        }
        return null;
    }

    public static String uniqueId(String prefix) {
        return prefix + UNIQUE_ID.incrementAndGet();
    }

    public static String uniquePassword() {
        String[] passwords = new String[]{"ALKJVBPIQYTUIWEBVPQALZVKQRWORTUYOYISHFLKAJMZNXBVMNFGAHKJSDFALAPOQIERIUYTGSFGKMZNXBVJAHGFAKX", "1234567890", "qpowiealksdjzmxnvbfghsdjtreiuowiruksfhksajmzxncbvlaksjdhgqwetytopskjhfgvbcnmzxalksjdfhgbvzm", ".@,-+/()#$%^&*!"};
        StringBuilder result = new StringBuilder();
        long passwordLength = Math.abs(UUID.randomUUID().getLeastSignificantBits() % 8L) + 8L;
        int index = 0;
        while ((long)index < passwordLength) {
            int passIndex = (int)((long)(passwords.length * index) / passwordLength);
            int charIndex = (int)Math.abs(UUID.randomUUID().getLeastSignificantBits() % (long)passwords[passIndex].length());
            result.append(passwords[passIndex].charAt(charIndex));
            ++index;
        }
        return result.toString();
    }

    public static <E> Template<Set<E>> template(String template) {
        return new TemplateImpl(template);
    }

    public static <T> Chain<T> chain(List<T> list) {
        return new Chain<T>(list);
    }

    public static <T> Chain<T> chain(Iterable<T> iterable) {
        return new Chain<T>($.newArrayList(iterable));
    }

    public static <T> Chain<T> chain(T ... array) {
        return new Chain<T>(Arrays.asList(array));
    }

    public Chain<T> chain() {
        return new Chain<T>($.newArrayList(this.iterable));
    }

    public static void mixin(String funcName, Function1<String, String> func) {
        FUNCTIONS.put(funcName, func);
    }

    public Optional<String> call(String funcName) {
        if (this.string.isPresent() && FUNCTIONS.containsKey(funcName)) {
            return Optional.of(FUNCTIONS.get(funcName).apply(this.string.get()));
        }
        return Optional.absent();
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> iterable) {
        List<T> localList = $.newArrayList(iterable);
        Collections.sort(localList);
        return localList;
    }

    public static <T extends Comparable<T>> T[] sort(T ... array) {
        Object[] localArray = (Comparable[])array.clone();
        Arrays.sort(localArray);
        return localArray;
    }

    public List<Comparable> sort() {
        return $.sort(this.iterable);
    }

    public static <T> String join(Iterable<T> iterable, final String separator) {
        final StringBuilder sb = new StringBuilder();
        $.each(iterable, new Block<T>(){

            @Override
            public void apply(T item) {
                if (!sb.toString().isEmpty()) {
                    sb.append(separator);
                }
                sb.append(item.toString());
            }
        });
        return sb.toString();
    }

    public static <T> String join(Iterable<T> iterable) {
        return $.join(iterable, " ");
    }

    public static <T> String join(T[] array, String separator) {
        return $.join(Arrays.asList(array), separator);
    }

    public static <T> String join(T[] array) {
        return $.join(array, " ");
    }

    public String join(String separator) {
        return $.join(this.iterable, separator);
    }

    public String join() {
        return $.join(this.iterable);
    }

    public static <T> T[] concat(T[] first, T[] ... other) {
        int length = 0;
        for (T[] otherItem : other) {
            length += otherItem.length;
        }
        T[] result = Arrays.copyOf(first, first.length + length);
        int index = 0;
        for (T[] otherItem : other) {
            System.arraycopy(otherItem, 0, result, first.length + index, otherItem.length);
            index += otherItem.length;
        }
        return result;
    }

    public static <T> List<T> concat(Iterable<T> first, Iterable<T> ... other) {
        int length = 0;
        for (Iterable<T> otherItem : other) {
            length += $.size(otherItem);
        }
        T[] result = Arrays.copyOf($.toArray(first), $.size(first) + length);
        int index = 0;
        for (Iterable<T> otherItem : other) {
            System.arraycopy($.toArray(otherItem), 0, result, $.size(first) + index, $.size(otherItem));
            index += $.size(otherItem);
        }
        return Arrays.asList(result);
    }

    public List<T> concatWith(Iterable<T> ... other) {
        return $.concat(this.iterable, other);
    }

    public static <T> List<T> slice(Iterable<T> iterable, int start) {
        List<T> result = start >= 0 ? $.newArrayList(iterable).subList(start, $.size(iterable)) : $.newArrayList(iterable).subList($.size(iterable) + start, $.size(iterable));
        return result;
    }

    public static <T> T[] slice(T[] array, int start) {
        return $.slice(Arrays.asList(array), start).toArray();
    }

    public List<T> slice(int start) {
        return $.slice(this.iterable, start);
    }

    public static <T> List<T> slice(Iterable<T> iterable, int start, int end) {
        List<T> result = start >= 0 ? (end > 0 ? $.newArrayList(iterable).subList(start, end) : $.newArrayList(iterable).subList(start, $.size(iterable) + end)) : (end > 0 ? $.newArrayList(iterable).subList($.size(iterable) + start, end) : $.newArrayList(iterable).subList($.size(iterable) + start, $.size(iterable) + end));
        return result;
    }

    public static <T> T[] slice(T[] array, int start, int end) {
        return $.slice(Arrays.asList(array), start, end).toArray();
    }

    public List<T> slice(int start, int end) {
        return $.slice(this.iterable, start, end);
    }

    public static <T> List<T> reverse(Iterable<T> iterable) {
        List<T> result = $.newArrayList(iterable);
        Collections.reverse(result);
        return result;
    }

    public static <T> T[] reverse(T ... array) {
        return $.reverse(Arrays.asList(array)).toArray();
    }

    public List<T> reverse() {
        return $.reverse(this.iterable);
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public Iterable<T> value() {
        return this.iterable;
    }

    public Optional<String> getString() {
        return this.string;
    }

    public static <T> ScheduledFuture setTimeout(final Function<T> function, int delayMilliseconds) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> future = scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                function.apply();
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
        scheduler.shutdown();
        return future;
    }

    public static void clearTimeout(ScheduledFuture scheduledFuture) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    public static <T> ScheduledFuture setInterval(final Function<T> function, int delayMilliseconds) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                function.apply();
            }
        }, delayMilliseconds, delayMilliseconds, TimeUnit.MILLISECONDS);
        return future;
    }

    public static void clearInterval(ScheduledFuture scheduledFuture) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    protected static <T> List<T> newArrayList() {
        try {
            Class<?> listsClass = $.classForName("com.google.common.collect.Lists");
            return (List)listsClass.getDeclaredMethod("newArrayList", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    protected static <T> List<T> newArrayList(Iterable<T> iterable) {
        try {
            Class<?> listsClass = $.classForName("com.google.common.collect.Lists");
            return (List)listsClass.getDeclaredMethod("newArrayList", Iterable.class).invoke(null, iterable);
        }
        catch (Exception e) {
            ArrayList<T> result;
            if (iterable instanceof Collection) {
                result = new ArrayList((Collection)iterable);
            } else {
                result = new ArrayList<T>();
                for (T item : iterable) {
                    result.add(item);
                }
            }
            return result;
        }
    }

    protected static List<Integer> newIntegerList(int ... array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        for (int item : array) {
            result.add(item);
        }
        return result;
    }

    protected static <T> List<T> newArrayListWithExpectedSize(int size) {
        try {
            Class<?> listsClass = $.classForName("com.google.common.collect.Lists");
            return (List)listsClass.getDeclaredMethod("newArrayListWithExpectedSize", Integer.TYPE).invoke(null, size);
        }
        catch (Exception e) {
            return new ArrayList(size);
        }
    }

    protected static <T> Set<T> newLinkedHashSet() {
        try {
            Class<?> setsClass = $.classForName("com.google.common.collect.Sets");
            return (Set)setsClass.getDeclaredMethod("newLinkedHashSet", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return new LinkedHashSet();
        }
    }

    protected static <T> Set<T> newHashSet(Iterable<T> iterable) {
        try {
            Class<?> setsClass = $.classForName("com.google.common.collect.Sets");
            return (Set)setsClass.getDeclaredMethod("newHashSet", Iterable.class).invoke(null, iterable);
        }
        catch (Exception e) {
            HashSet<T> result = new HashSet<T>();
            for (T item : iterable) {
                result.add(item);
            }
            return result;
        }
    }

    protected static <T> Set<T> newLinkedHashSetWithExpectedSize(int size) {
        try {
            Class<?> setsClass = $.classForName("com.google.common.collect.Sets");
            return (Set)setsClass.getDeclaredMethod("newLinkedHashSetWithExpectedSize", Integer.TYPE).invoke(null, size);
        }
        catch (Exception e) {
            return new LinkedHashSet(size);
        }
    }

    protected static <K, E> Map<K, E> newLinkedHashMap() {
        try {
            Class<?> mapsClass = $.classForName("com.google.common.collect.Maps");
            return (Map)mapsClass.getDeclaredMethod("newLinkedHashMap", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return new LinkedHashMap();
        }
    }

    public static void main(String ... args) {
        String message = "Underscore-java is a java port of Underscore.js.\n\nIn addition to porting Underscore's functionality, Underscore-java includes matching unit tests.\n\nFor docs, license, tests, and downloads, see: http://javadev.github.io/underscore-java";
        System.out.println("Underscore-java is a java port of Underscore.js.\n\nIn addition to porting Underscore's functionality, Underscore-java includes matching unit tests.\n\nFor docs, license, tests, and downloads, see: http://javadev.github.io/underscore-java");
    }

    public static class Chain<T> {
        private final T item;
        private final List<T> list;

        public Chain(T item) {
            this.item = item;
            this.list = null;
        }

        public Chain(List<T> list) {
            this.item = null;
            this.list = list;
        }

        public Chain<T> first() {
            return new Chain<T>($.first(this.list));
        }

        public Chain<T> first(int n) {
            return new Chain<T>($.first(this.list, n));
        }

        public Chain<T> initial() {
            return new Chain<T>($.initial(this.list));
        }

        public Chain<T> initial(int n) {
            return new Chain<T>($.initial(this.list, n));
        }

        public Chain<T> last() {
            return new Chain<T>($.last(this.list));
        }

        public Chain<T> last(int n) {
            return new Chain<T>($.last(this.list, n));
        }

        public Chain<T> rest() {
            return new Chain<T>($.rest(this.list));
        }

        public Chain<T> rest(int n) {
            return new Chain<T>($.rest(this.list, n));
        }

        public Chain<T> compact() {
            return new Chain<List<T>>($.compact(this.list));
        }

        public Chain<T> compact(T falsyValue) {
            return new Chain<T>($.compact(this.list, falsyValue));
        }

        public Chain flatten() {
            return new Chain($.flatten(this.list));
        }

        public <F> Chain<F> map(Function1<? super T, F> func) {
            return new Chain<F>($.map(this.list, func));
        }

        public Chain<T> filter(Predicate<T> pred) {
            return new Chain<T>($.filter(this.list, pred));
        }

        public Chain<T> reject(Predicate<T> pred) {
            return new Chain<T>($.reject(this.list, pred));
        }

        public <F> Chain<F> reduce(FunctionAccum<F, T> func, F zeroElem) {
            return new Chain<F>($.reduce(this.list, func, zeroElem));
        }

        public <F> Chain<F> reduceRight(FunctionAccum<F, T> func, F zeroElem) {
            return new Chain<F>($.reduceRight(this.list, func, zeroElem));
        }

        public Chain<Optional<T>> find(Predicate<T> pred) {
            return new Chain<Optional<T>>($.find(this.list, pred));
        }

        public Chain<Optional<T>> findLast(Predicate<T> pred) {
            return new Chain<Optional<T>>($.findLast(this.list, pred));
        }

        public Chain<Comparable> max() {
            return new Chain<Comparable>((Comparable)$.max(this.list));
        }

        public <F extends Comparable<? super F>> Chain<T> max(Function1<T, F> func) {
            return new Chain<T>($.max(this.list, func));
        }

        public Chain<Comparable> min() {
            return new Chain<Comparable>((Comparable)$.min(this.list));
        }

        public <F extends Comparable<? super F>> Chain<T> min(Function1<T, F> func) {
            return new Chain<T>($.min(this.list, func));
        }

        public Chain<Comparable> sort() {
            return new Chain<Comparable>($.sort(this.list));
        }

        public <F extends Comparable<? super F>> Chain<T> sortBy(Function1<T, F> func) {
            return new Chain($.sortBy(this.list, func));
        }

        public <K> Chain<Map<K, Comparable>> sortBy(K key) {
            return new Chain<Map<K, Comparable>>($.sortBy(this.list, key));
        }

        public <F> Chain<Map<F, List<T>>> groupBy(Function1<T, F> func) {
            return new Chain<Map<F, List<T>>>($.groupBy(this.list, func));
        }

        public Chain<Map<Object, List<T>>> indexBy(String property) {
            return new Chain<Map<Object, List<T>>>($.indexBy(this.list, property));
        }

        public <F> Chain<Map<F, Integer>> countBy(Function1<T, F> func) {
            return new Chain<Map<F, Integer>>($.countBy(this.list, func));
        }

        public Chain<T> shuffle() {
            return new Chain<T>($.shuffle(this.list));
        }

        public Chain<T> sample() {
            return new Chain<T>($.sample(this.list));
        }

        public Chain<T> sample(int howMany) {
            return new Chain<T>($.newArrayList($.sample(this.list, howMany)));
        }

        public Chain<T> tap(Block<T> func) {
            $.tap(this.list, func);
            return new Chain<T>(this.list);
        }

        public Chain<Boolean> every(Predicate<T> pred) {
            return new Chain<Boolean>($.every(this.list, pred));
        }

        public Chain<Boolean> some(Predicate<T> pred) {
            return new Chain<Boolean>($.some(this.list, pred));
        }

        public Chain<Boolean> contains(T elem) {
            return new Chain<Boolean>($.contains(this.list, elem));
        }

        public Chain<T> invoke(String methodName, List<Object> args) {
            return new Chain<T>($.invoke(this.list, methodName, args));
        }

        public Chain<T> invoke(String methodName) {
            return new Chain<T>($.invoke(this.list, methodName));
        }

        public Chain<Object> pluck(String propertyName) {
            return new Chain<Object>($.pluck(this.list, propertyName));
        }

        public <E> Chain<T> where(List<Tuple<String, E>> properties) {
            return new Chain<T>($.where(this.list, properties));
        }

        public <E> Chain<Optional<T>> findWhere(List<Tuple<String, E>> properties) {
            return new Chain<Optional<T>>($.findWhere(this.list, properties));
        }

        public Chain<T> uniq() {
            return new Chain<T>($.uniq(this.list));
        }

        public <F> Chain<F> uniq(Function1<T, F> func) {
            return new Chain<T>($.newArrayList($.uniq(this.list, func)));
        }

        public Chain<T> union(List<T> ... lists) {
            return new Chain<T>($.union(this.list, lists));
        }

        public Chain<T> intersection(List<T> ... lists) {
            return new Chain<T>($.intersection(this.list, lists));
        }

        public Chain<T> difference(List<T> ... lists) {
            return new Chain<T>($.difference(this.list, lists));
        }

        public Chain<Integer> range(int stop) {
            return new Chain<Integer>($.newIntegerList($.range(stop)));
        }

        public Chain<Integer> range(int start, int stop) {
            return new Chain<Integer>($.newIntegerList($.range(start, stop)));
        }

        public Chain<Integer> range(int start, int stop, int step) {
            return new Chain<Integer>($.newIntegerList($.range(start, stop, step)));
        }

        public Chain<List<T>> chunk(int size) {
            return new Chain<List<T>>($.chunk(this.value(), size));
        }

        public Chain<T> concat(List<T> ... lists) {
            return new Chain<T>($.concat(this.list, lists));
        }

        public Chain<T> slice(int start) {
            return new Chain<T>($.slice(this.list, start));
        }

        public Chain<T> slice(int start, int end) {
            return new Chain<T>($.slice(this.list, start, end));
        }

        public Chain<T> reverse() {
            return new Chain<T>($.reverse(this.list));
        }

        public Chain<String> join() {
            return new Chain<String>($.join(this.list));
        }

        public Chain<String> join(String separator) {
            return new Chain<String>($.join(this.list, separator));
        }

        public Chain<T> skip(int numberToSkip) {
            return new Chain<T>(this.list.subList(numberToSkip, this.list.size()));
        }

        public Chain<T> limit(int size) {
            return new Chain<T>(this.list.subList(0, size));
        }

        public <K, V> Chain<Map<K, V>> toMap() {
            return new Chain($.toMap(this.list));
        }

        public boolean isEmpty() {
            return $.isEmpty(this.list);
        }

        public int size() {
            return $.size(this.list);
        }

        public T item() {
            return this.item;
        }

        public List<T> value() {
            return this.list;
        }

        public String toString() {
            return String.valueOf(this.list);
        }
    }

    public static class ClassForName {
        public Class<?> call(String name) throws Exception {
            return Class.forName(name);
        }
    }

    private static final class TemplateImpl<E>
    implements Template<Set<E>> {
        private final String template;

        private TemplateImpl(String template) {
            this.template = template;
        }

        @Override
        public String apply(Set<E> value) {
            String evaluate = (String)TEMPLATE_SETTINGS.get("evaluate");
            String interpolate = (String)TEMPLATE_SETTINGS.get("interpolate");
            String escape = (String)TEMPLATE_SETTINGS.get("escape");
            String result = this.template;
            for (E element : value) {
                Matcher matcherPrint;
                result = Pattern.compile(interpolate.replace($.ALL_SYMBOLS, "\\s*\\Q" + ((Map.Entry)element).getKey() + "\\E\\s*")).matcher(result).replaceAll(String.valueOf(((Map.Entry)element).getValue()));
                result = Pattern.compile(escape.replace($.ALL_SYMBOLS, "\\s*\\Q" + ((Map.Entry)element).getKey() + "\\E\\s*")).matcher(result).replaceAll($.escape(String.valueOf(((Map.Entry)element).getValue())));
                Matcher matcher = Pattern.compile(evaluate.replace($.ALL_SYMBOLS, "\\s*_\\.each\\((\\w+),\\s*function\\((\\w+)\\)\\s*\\{\\s*") + "(.*?)" + evaluate.replace($.ALL_SYMBOLS, "\\s*\\}\\);\\s*")).matcher(result);
                if (matcher.find() && ((Map.Entry)element).getKey().equals(matcher.group(1))) {
                    StringBuilder repeatResult = new StringBuilder();
                    for (String item : (List)((Map.Entry)element).getValue()) {
                        repeatResult.append(Pattern.compile(interpolate.replace($.ALL_SYMBOLS, "\\s*\\Q" + matcher.group(2) + "\\E\\s*")).matcher(matcher.group(3)).replaceAll(item));
                    }
                    result = matcher.replaceFirst(repeatResult.toString());
                }
                if (!(matcherPrint = Pattern.compile(evaluate.replace($.ALL_SYMBOLS, "\\s*print\\('([^']*)'\\s*\\+\\s*(\\w+)\\);\\s*")).matcher(result)).find() || !((Map.Entry)element).getKey().equals(matcherPrint.group(2))) continue;
                result = matcherPrint.replaceFirst(matcherPrint.group(1) + ((Map.Entry)element).getValue());
            }
            return result;
        }
    }

    private static final class WherePredicate<E, T>
    implements Predicate<E> {
        private final List<Tuple<String, T>> properties;

        private WherePredicate(List<Tuple<String, T>> properties) {
            this.properties = properties;
        }

        @Override
        public Boolean apply(E elem) {
            for (Tuple<String, T> prop : this.properties) {
                try {
                    if (elem.getClass().getField(prop.fst()).get(elem).equals(prop.snd())) continue;
                    return false;
                }
                catch (Exception ex) {
                    try {
                        if (elem.getClass().getMethod(prop.fst(), new Class[0]).invoke(elem, new Object[0]).equals(prop.snd())) continue;
                        return false;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return true;
        }
    }
}

