/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.util.ScannerUtil;
import org.apache.maven.plugin.surefire.util.SpecificFileFilter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.MatchPatterns;
import org.apache.maven.surefire.util.DefaultScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyScanner {
    private final List<File> dependenciesToScan;
    protected final List<String> includes;
    @Nonnull
    protected final List<String> excludes;
    protected final List<String> specificTests;

    public DependencyScanner(List<File> dependenciesToScan, List<String> includes, @Nonnull List<String> excludes, List<String> specificTests) {
        this.dependenciesToScan = dependenciesToScan;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
    }

    public DefaultScanResult scan() throws MojoExecutionException {
        Matcher matcher = new Matcher(this.includes, this.excludes, this.specificTests);
        ArrayList<String> found = new ArrayList<String>();
        for (File artifact : this.dependenciesToScan) {
            try {
                found.addAll(this.scanArtifact(artifact, matcher));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not scan dependency " + artifact.toString(), (Exception)e);
            }
        }
        return new DefaultScanResult(found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> scanArtifact(File artifact, Matcher matcher) throws IOException {
        ArrayList<String> found = new ArrayList<String>();
        if (artifact == null || !artifact.isFile()) return found;
        JarFile jar = null;
        try {
            jar = new JarFile(artifact);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!matcher.shouldInclude(entry.getName())) continue;
                found.add(ScannerUtil.convertJarFileResourceToJavaClassName(entry.getName()));
            }
            Object var8_7 = null;
            if (jar == null) return found;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (jar == null) throw throwable;
            jar.close();
            throw throwable;
        }
        jar.close();
        return found;
    }

    public static List<File> filter(List<Artifact> artifacts, List<String> groupArtifactIds) {
        ArrayList<File> matches = new ArrayList<File>();
        if (groupArtifactIds == null || artifacts == null) {
            return matches;
        }
        for (Artifact artifact : artifacts) {
            for (String groups : groupArtifactIds) {
                String[] groupArtifact = groups.split(":");
                if (groupArtifact.length != 2) {
                    throw new IllegalArgumentException("dependencyToScan argument should be in format 'groupid:artifactid': " + groups);
                }
                if (!artifact.getGroupId().matches(groupArtifact[0]) || !artifact.getArtifactId().matches(groupArtifact[1])) continue;
                matches.add(artifact.getFile());
            }
        }
        return matches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Matcher {
        private MatchPatterns includes;
        private MatchPatterns excludes;
        private SpecificFileFilter specificTestFilter;

        public Matcher(@Nonnull List<String> includes, @Nullable List<String> excludes, List<String> specificTests) {
            String[] specific = specificTests == null ? new String[]{} : ScannerUtil.processIncludesExcludes(specificTests);
            this.specificTestFilter = new SpecificFileFilter(specific);
            this.includes = includes != null && includes.size() > 0 ? MatchPatterns.from(ScannerUtil.processIncludesExcludes(includes)) : MatchPatterns.from("**");
            this.excludes = MatchPatterns.from(ScannerUtil.processIncludesExcludes(excludes));
        }

        public boolean shouldInclude(String name) {
            if (!name.endsWith(".class")) {
                return false;
            }
            name = ScannerUtil.convertSlashToSystemFileSeparator(name);
            boolean isIncluded = this.includes.matches(name, false);
            boolean isExcluded = this.excludes.matches(name, false);
            return isIncluded && !isExcluded && this.specificTestFilter.accept(name);
        }
    }
}

