/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.repository.support.AnnotationAttribute;
import org.springframework.util.Assert;

class MethodParameters {
    private final ParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
    private final List<MethodParameter> parameters;

    public MethodParameters(Method method) {
        this(method, null);
    }

    public MethodParameters(Method method, AnnotationAttribute namingAnnotation) {
        Assert.notNull((Object)method);
        this.parameters = new ArrayList<MethodParameter>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            AnnotationNamingMethodParameter parameter = new AnnotationNamingMethodParameter(method, i, namingAnnotation);
            parameter.initParameterNameDiscovery(this.discoverer);
            this.parameters.add(parameter);
        }
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public MethodParameter getParameter(String name) {
        Assert.hasText((String)name, (String)"Parameter name must not be null!");
        for (MethodParameter parameter : this.parameters) {
            if (!name.equals(parameter.getParameterName())) continue;
            return parameter;
        }
        return null;
    }

    public List<MethodParameter> getParametersOfType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        ArrayList<MethodParameter> result = new ArrayList<MethodParameter>();
        for (MethodParameter parameter : this.getParameters()) {
            if (!parameter.getParameterType().equals(type)) continue;
            result.add(parameter);
        }
        return result;
    }

    public List<MethodParameter> getParametersWith(Class<? extends Annotation> annotation) {
        Assert.notNull(annotation);
        ArrayList<MethodParameter> result = new ArrayList<MethodParameter>();
        for (MethodParameter parameter : this.getParameters()) {
            if (!parameter.hasParameterAnnotation(annotation)) continue;
            result.add(parameter);
        }
        return result;
    }

    private static class AnnotationNamingMethodParameter
    extends MethodParameter {
        private final AnnotationAttribute attribute;
        private String name;

        public AnnotationNamingMethodParameter(Method method, int parameterIndex, AnnotationAttribute attribute) {
            super(method, parameterIndex);
            this.attribute = attribute;
        }

        public String getParameterName() {
            Object foundName;
            if (this.name != null) {
                return this.name;
            }
            if (this.attribute != null && (foundName = this.attribute.getValueFrom(this)) != null) {
                this.name = foundName.toString();
                return this.name;
            }
            this.name = super.getParameterName();
            return this.name;
        }
    }
}

