/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.sort;

import java.util.Comparator;
import jodd.util.ComparableComparator;
import jodd.util.sort.Sorter;

public class FastMergeSort
implements Sorter {
    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Object temp = dest[j];
                    dest[j] = dest[j - 1];
                    dest[j - 1] = temp;
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        FastMergeSort.mergeSort(dest, src, low, mid, -off, c);
        FastMergeSort.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    public void sort(Object[] a, Comparator comparator) {
        Object[] aux = (Object[])a.clone();
        FastMergeSort.mergeSort(aux, a, 0, a.length, 0, comparator);
    }

    public void sort(Comparable[] a) {
        Object[] aux = (Object[])a.clone();
        FastMergeSort.mergeSort(aux, a, 0, a.length, 0, ComparableComparator.INSTANCE);
    }

    public static void doSort(Object[] a, Comparator c) {
        Object[] aux = (Object[])a.clone();
        FastMergeSort.mergeSort(aux, a, 0, a.length, 0, c);
    }

    public static void doSort(Comparable[] a) {
        Object[] aux = (Object[])a.clone();
        FastMergeSort.mergeSort(aux, a, 0, a.length, 0, ComparableComparator.INSTANCE);
    }
}

