/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    private static final String[] MANIFESTS = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};
    public static final String[] PRIMITIVE_TYPE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    public static final Class[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    public static final char[] PRIMITIVE_BYTECODE_NAME = new char[]{'Z', 'B', 'C', 'D', 'F', 'I', 'J', 'S'};

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoaderUtil.class.getClassLoader();
        }
        return cl;
    }

    public static void addFileToClassPath(String path) {
        ClassLoaderUtil.addFileToClassPath(path, (URLClassLoader)ClassLoaderUtil.getDefaultClassLoader());
    }

    public static void addFileToClassPath(String path, URLClassLoader classLoader) {
        ClassLoaderUtil.addFileToClassPath(new File(path), classLoader);
    }

    public static void addFileToClassPath(File path) {
        ClassLoaderUtil.addFileToClassPath(path, (URLClassLoader)ClassLoaderUtil.getDefaultClassLoader());
    }

    public static void addFileToClassPath(File path, URLClassLoader classLoader) {
        try {
            ClassLoaderUtil.addUrlToClassPath(path.toURL(), classLoader);
        }
        catch (MalformedURLException muex) {
            throw new IllegalArgumentException("Unable to convert path to URL: " + path, muex);
        }
    }

    public static void addUrlToClassPath(URL url) {
        ClassLoaderUtil.addUrlToClassPath(url, (URLClassLoader)ClassLoaderUtil.getDefaultClassLoader());
    }

    public static void addUrlToClassPath(URL url, URLClassLoader classLoader) {
        try {
            ReflectUtil.invokeDeclared(URLClassLoader.class, classLoader, "addURL", new Class[]{URL.class}, new Object[]{url});
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to extend classpath with URL: " + url, ex);
        }
    }

    public static Class defineClass(byte[] classData) {
        return ClassLoaderUtil.defineClass(null, classData, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static Class defineClass(String className, byte[] classData) {
        return ClassLoaderUtil.defineClass(className, classData, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static Class defineClass(byte[] classData, ClassLoader classLoader) {
        return ClassLoaderUtil.defineClass(null, classData, classLoader);
    }

    public static Class defineClass(String className, byte[] classData, ClassLoader classLoader) {
        try {
            return (Class)ReflectUtil.invokeDeclared(ClassLoader.class, classLoader, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{className, classData, new Integer(0), new Integer(classData.length)});
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to define class: " + className, th);
        }
    }

    public static Class findClass(String className, File[] classPath) {
        URL[] urls = new URL[classPath.length];
        for (int i = 0; i < classPath.length; ++i) {
            File file = classPath[i];
            try {
                urls[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return ClassLoaderUtil.findClass(className, urls, null);
    }

    public static Class findClass(String className, URL[] classPath) {
        return ClassLoaderUtil.findClass(className, classPath, null);
    }

    public static Class findClass(String className, URL[] classPath, ClassLoader parent) {
        URLClassLoader tempClassLoader = parent != null ? new URLClassLoader(classPath, parent) : new URLClassLoader(classPath);
        try {
            return (Class)ReflectUtil.invokeDeclared(URLClassLoader.class, tempClassLoader, "findClass", new Class[]{String.class}, new Object[]{className});
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to find class: " + className, th);
        }
    }

    public static File findToolsJar() {
        String tools = new File(SystemUtil.getJavaHome()).getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
        File toolsFile = new File(tools);
        if (toolsFile.exists()) {
            return toolsFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Manifest getClasspathItemManifest(File classpathItem) {
        Manifest manifest;
        block11: {
            block12: {
                manifest = null;
                if (!classpathItem.isFile()) break block12;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(classpathItem);
                    JarFile jar = new JarFile(classpathItem);
                    manifest = jar.getManifest();
                }
                catch (IOException ignore) {
                    StreamUtil.close(fis);
                    break block11;
                    catch (Throwable throwable) {
                        StreamUtil.close(fis);
                        throw throwable;
                    }
                }
                StreamUtil.close(fis);
                break block11;
            }
            File metaDir = new File(classpathItem, "META-INF");
            File manifestFile = null;
            if (metaDir.isDirectory()) {
                for (String m : MANIFESTS) {
                    File mFile = new File(metaDir, m);
                    if (!mFile.isFile()) continue;
                    manifestFile = mFile;
                    break;
                }
            }
            if (manifestFile != null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(manifestFile);
                    manifest = new Manifest(fis);
                }
                catch (IOException ignore) {
                    StreamUtil.close(fis);
                    catch (Throwable throwable) {
                        StreamUtil.close(fis);
                        throw throwable;
                    }
                }
                StreamUtil.close(fis);
            }
        }
        return manifest;
    }

    public static String getClasspathItemBaseDir(File classpathItem) {
        String base = classpathItem.isFile() ? classpathItem.getParent() : classpathItem.toString();
        return base;
    }

    public static File[] getDefaultClasspath() {
        return ClassLoaderUtil.getDefaultClasspath(ClassLoaderUtil.getDefaultClassLoader());
    }

    public static File[] getDefaultClasspath(ClassLoader classLoader) {
        HashSet<File> classpaths = new HashSet<File>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] urls;
                for (URL u : urls = ((URLClassLoader)classLoader).getURLs()) {
                    File f = FileUtil.toFile(u);
                    if (f == null) continue;
                    try {
                        f = f.getCanonicalFile();
                        classpaths.add(f);
                        ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
        String bootstrap = SystemUtil.getSunBoothClassPath();
        if (bootstrap != null) {
            classpaths.add(new File(bootstrap));
        }
        File[] result = new File[classpaths.size()];
        return classpaths.toArray(result);
    }

    private static void addInnerClasspathItems(Set<File> classpaths, File item) {
        String[] tokens;
        Manifest manifest = ClassLoaderUtil.getClasspathItemManifest(item);
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String s = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (s == null) {
            return;
        }
        String base = ClassLoaderUtil.getClasspathItemBaseDir(item);
        for (String t : tokens = StringUtil.splitc(s, ' ')) {
            try {
                File file = new File(base, t);
                file = file.getCanonicalFile();
                if (!file.exists()) continue;
                classpaths.add(file);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public static URL getResourceUrl(String resourceName) {
        return ClassLoaderUtil.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = Reflection.getCallerClass((int)2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader && (resourceUrl = callerClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        return null;
    }

    public static File getResourceFile(String resourceName) {
        return ClassLoaderUtil.getResourceFile(resourceName, null);
    }

    public static File getResourceFile(String resourceName, ClassLoader classLoader) {
        try {
            return new File(ClassLoaderUtil.getResourceUrl(resourceName, classLoader).toURI());
        }
        catch (URISyntaxException ignore) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(clazz), null);
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(className));
    }

    public static String prepareClassnameForLoading(String className) {
        int bracketCount = StringUtil.count(className, '[');
        if (bracketCount == 0) {
            return className;
        }
        String brackets = StringUtil.repeat('[', bracketCount);
        int bracketIndex = className.indexOf(91);
        int primitiveNdx = ClassLoaderUtil.getPrimitiveClassNameIndex(className = className.substring(0, bracketIndex));
        if (primitiveNdx >= 0) {
            className = String.valueOf(PRIMITIVE_BYTECODE_NAME[primitiveNdx]);
            return brackets + className;
        }
        return brackets + 'L' + className + ';';
    }

    private static int getPrimitiveClassNameIndex(String className) {
        int dotIndex = className.indexOf(46);
        if (dotIndex != -1) {
            return -1;
        }
        return Arrays.binarySearch(PRIMITIVE_TYPE_NAMES, className);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass(className, null);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class callerClass;
        ClassLoader callerClassLoader;
        int primitiveNdx;
        if (((className = ClassLoaderUtil.prepareClassnameForLoading(className)).indexOf(46) == -1 || className.indexOf(91) == -1) && (primitiveNdx = ClassLoaderUtil.getPrimitiveClassNameIndex(className)) >= 0) {
            return PRIMITIVE_TYPES[primitiveNdx];
        }
        try {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader) {
            try {
                return currentThreadClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if ((callerClassLoader = (callerClass = Reflection.getCallerClass((int)2)).getClassLoader()) != classLoader && callerClassLoader != currentThreadClassLoader) {
            try {
                return callerClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            throw new ClassNotFoundException("Class not found: " + className);
        }
    }

    public static String getClassFileName(Class clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderUtil.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

