/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import jodd.JoddDefault;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.FileUploadFactory;
import jodd.servlet.upload.MultipartStreamParser;

public class MultipartRequest
extends MultipartStreamParser {
    private HttpServletRequest request;
    private String characterEncoding;
    private static final String MREQ_ATTR_NAME = MultipartRequest.class.getName();

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MultipartRequest(HttpServletRequest request) {
        this(request, null, null);
    }

    public MultipartRequest(HttpServletRequest request, FileUploadFactory fileUploadFactory) {
        this(request, fileUploadFactory, null);
    }

    public MultipartRequest(HttpServletRequest request, String encoding) {
        this(request, null, encoding);
    }

    public MultipartRequest(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) {
        super(fileUploadFactory);
        this.request = request;
        this.characterEncoding = encoding != null ? encoding : request.getCharacterEncoding();
        if (this.characterEncoding == null) {
            this.characterEncoding = JoddDefault.encoding;
        }
    }

    public static MultipartRequest getInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) {
        MultipartRequest mreq = (MultipartRequest)request.getAttribute(MREQ_ATTR_NAME);
        if (mreq == null) {
            mreq = new MultipartRequest(request, fileUploadFactory, encoding);
            request.setAttribute(MREQ_ATTR_NAME, (Object)mreq);
        }
        return mreq;
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, fileUploadFactory, encoding);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request, String encoding) {
        return MultipartRequest.getInstance(request, null, encoding);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, String encoding) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, null, encoding);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory) {
        return MultipartRequest.getInstance(request, fileUploadFactory, null);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, fileUploadFactory, null);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request) {
        return MultipartRequest.getInstance(request, null, null);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, null, null);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public void parseMultipartRequest() throws IOException {
        this.parseRequestStream((InputStream)this.request.getInputStream(), this.characterEncoding);
    }

    public void parseRequest() throws IOException {
        if (ServletUtil.isMultipartRequest(this.request)) {
            this.parseRequestStream((InputStream)this.request.getInputStream(), this.characterEncoding);
        } else {
            Enumeration names = this.request.getParameterNames();
            while (names.hasMoreElements()) {
                String paramName = (String)names.nextElement();
                String[] values = this.request.getParameterValues(paramName);
                this.putParameters(paramName, values);
            }
        }
    }
}

