/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import jodd.bean.BeanTemplateMacroResolver;
import jodd.bean.BeanTemplateParser;
import jodd.props.PropsValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsData
implements Cloneable {
    private static final int MAX_INNER_MACROS = 100;
    private static final String APPEND_SEPARATOR = ",";
    protected final HashMap<String, PropsValue> properties;
    protected final HashMap<String, Map<String, PropsValue>> profiles;
    protected final BeanTemplateParser beanTemplateParser;
    protected boolean appendDuplicateProps;

    public PropsData() {
        this(new HashMap<String, PropsValue>(), new HashMap<String, Map<String, PropsValue>>());
    }

    protected PropsData(HashMap<String, PropsValue> properties, HashMap<String, Map<String, PropsValue>> profiles) {
        this.properties = properties;
        this.profiles = profiles;
        this.beanTemplateParser = new BeanTemplateParser();
        this.beanTemplateParser.setResolveEscapes(false);
        this.beanTemplateParser.setReplaceMissingKey(false);
    }

    public PropsData clone() {
        HashMap<String, PropsValue> newBase = new HashMap<String, PropsValue>();
        HashMap<String, Map<String, PropsValue>> newProfiles = new HashMap<String, Map<String, PropsValue>>();
        newBase.putAll(this.properties);
        for (Map.Entry<String, Map<String, PropsValue>> entry : this.profiles.entrySet()) {
            HashMap<String, PropsValue> map = new HashMap<String, PropsValue>(entry.getValue().size());
            map.putAll(entry.getValue());
            newProfiles.put(entry.getKey(), map);
        }
        PropsData pd = new PropsData(newBase, newProfiles);
        pd.appendDuplicateProps = this.appendDuplicateProps;
        return pd;
    }

    protected void put(Map<String, PropsValue> map, String key, String value) {
        PropsValue pv;
        if (this.appendDuplicateProps && (pv = map.get(key)) != null) {
            value = pv.value + APPEND_SEPARATOR + value;
        }
        map.put(key, new PropsValue(value));
    }

    public int countBaseProperties() {
        return this.properties.size();
    }

    public void putBaseProperty(String key, String value) {
        this.put(this.properties, key, value);
    }

    public PropsValue getBaseProperty(String key) {
        return this.properties.get(key);
    }

    public int countProfileProperties() {
        HashSet<String> profileKeys = new HashSet<String>();
        for (Map<String, PropsValue> map : this.profiles.values()) {
            for (String key : map.keySet()) {
                if (this.properties.containsKey(key)) continue;
                profileKeys.add(key);
            }
        }
        return profileKeys.size();
    }

    public void putProfileProperty(String key, String value, String profile) {
        Map<String, PropsValue> map = this.profiles.get(profile);
        if (map == null) {
            map = new HashMap<String, PropsValue>();
            this.profiles.put(profile, map);
        }
        this.put(map, key, value);
    }

    public PropsValue getProfileProperty(String profile, String key) {
        Map<String, PropsValue> profileMap = this.profiles.get(profile);
        if (profileMap == null) {
            return null;
        }
        return profileMap.get(key);
    }

    protected String lookupValue(String key, String ... profiles) {
        PropsValue value;
        if (profiles != null) {
            block0: for (String profile : profiles) {
                Map<String, PropsValue> profileMap;
                while ((profileMap = this.profiles.get(profile)) != null) {
                    PropsValue value2 = profileMap.get(key);
                    if (value2 != null) {
                        return value2.getValue();
                    }
                    int ndx = profile.lastIndexOf(46);
                    if (ndx == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        return (value = this.getBaseProperty(key)) == null ? null : value.getValue();
    }

    public void resolveMacros() {
        int loopCount = 0;
        while (loopCount++ < 100) {
            boolean replaced = this.resolveMacros(this.properties, null);
            for (Map.Entry<String, Map<String, PropsValue>> entry : this.profiles.entrySet()) {
                String profile = entry.getKey();
                replaced = this.resolveMacros(entry.getValue(), profile) || replaced;
            }
            if (replaced) continue;
            break;
        }
    }

    protected boolean resolveMacros(Map<String, PropsValue> map, final String profile) {
        boolean replaced = false;
        BeanTemplateMacroResolver macroResolver = new BeanTemplateMacroResolver(){

            public Object resolve(String name) {
                return PropsData.this.lookupValue(name, profile);
            }
        };
        for (Map.Entry<String, PropsValue> entry : map.entrySet()) {
            PropsValue pv = entry.getValue();
            String newValue = this.beanTemplateParser.parse(pv.value, macroResolver);
            if (!newValue.equals(pv.value)) {
                pv.resolved = newValue;
                replaced = true;
                continue;
            }
            pv.resolved = null;
        }
        return replaced;
    }

    public Properties extractProperties(String ... profiles) {
        Properties properties = new Properties();
        if (profiles != null) {
            block0: for (String profile : profiles) {
                while (true) {
                    int ndx;
                    Map<String, PropsValue> map;
                    if ((map = this.profiles.get(profile)) != null) {
                        this.extract(properties, map);
                    }
                    if ((ndx = profile.indexOf(46)) == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        this.extract(properties, this.properties);
        return properties;
    }

    protected void extract(Properties properties, Map<String, PropsValue> map) {
        for (Map.Entry<String, PropsValue> entry : map.entrySet()) {
            String key = entry.getKey();
            String existingValue = properties.getProperty(key);
            if (existingValue != null) continue;
            properties.setProperty(key, entry.getValue().getValue());
        }
    }
}

