/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import jodd.io.FileNameUtil;
import jodd.io.findfile.FindFile;
import jodd.util.Wildcard;

public class WildcardFindFile
extends FindFile {
    protected String wildcard;
    protected boolean usePathWildcards;

    public WildcardFindFile() {
    }

    public WildcardFindFile(String wildcard) {
        this.wildcard = wildcard;
    }

    public WildcardFindFile(String wildcard, boolean usePathWildcards) {
        this.wildcard = wildcard;
        this.usePathWildcards = usePathWildcards;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public boolean isUsePathWildcards() {
        return this.usePathWildcards;
    }

    public WildcardFindFile setUsePathWildcards(boolean usePathWildcards) {
        this.usePathWildcards = usePathWildcards;
        return this;
    }

    protected boolean acceptFile(File currentFile) {
        String path = currentFile.getAbsolutePath();
        path = FileNameUtil.separatorsToUnix(path);
        return this.usePathWildcards ? Wildcard.matchPath(path, this.wildcard) : Wildcard.match(path, this.wildcard);
    }
}

