/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import jodd.bean.loader.BaseBeanLoader;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.MultipartRequest;

public class MultipartRequestBeanLoader
extends BaseBeanLoader {
    protected boolean trim;

    public MultipartRequestBeanLoader() {
        this.trim = false;
    }

    public MultipartRequestBeanLoader(boolean trim) {
        this.trim = trim;
    }

    public void load(Object bean, Object source) {
        if (source instanceof MultipartRequest) {
            String paramName;
            MultipartRequest multipartRequest = (MultipartRequest)source;
            for (String o : multipartRequest.getParameterNames()) {
                paramName = o;
                String[] paramValues = multipartRequest.getParameterValues(paramName);
                if (paramValues == null || paramValues.length == 0) continue;
                if (this.trim) {
                    for (int i = 0; i < paramValues.length; ++i) {
                        paramValues[i] = paramValues[i].trim();
                    }
                }
                if (paramValues.length == 1) {
                    this.beanUtilBean.setPropertyForced(bean, paramName, paramValues[0]);
                    continue;
                }
                this.beanUtilBean.setPropertyForced(bean, paramName, paramValues);
            }
            for (String o1 : multipartRequest.getFileParameterNames()) {
                paramName = o1;
                FileUpload[] uf = multipartRequest.getFiles(paramName);
                if (uf == null || uf.length == 0) continue;
                if (uf.length == 1) {
                    this.beanUtilBean.setPropertyForcedSilent(bean, paramName, uf[0]);
                    continue;
                }
                this.beanUtilBean.setPropertyForcedSilent(bean, paramName, uf);
            }
        }
    }
}

