/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import jodd.bean.BeanException;
import jodd.bean.BeanTemplateMacroResolver;
import jodd.bean.BeanUtil;
import jodd.util.StringUtil;

public class BeanTemplateParser {
    public static final String MACRO_START = "${";
    public static final String MACRO_END = "}";
    protected boolean replaceMissingKey = true;
    protected String missingKeyReplacement;
    protected boolean resolveEscapes = true;
    protected String macroStart = "${";
    protected String macroEnd = "}";
    protected char escapeChar = (char)92;

    public boolean isReplaceMissingKey() {
        return this.replaceMissingKey;
    }

    public void setReplaceMissingKey(boolean replaceMissingKey) {
        this.replaceMissingKey = replaceMissingKey;
    }

    public String getMissingKeyReplacement() {
        return this.missingKeyReplacement;
    }

    public void setMissingKeyReplacement(String missingKeyReplacement) {
        this.missingKeyReplacement = missingKeyReplacement;
    }

    public boolean isResolveEscapes() {
        return this.resolveEscapes;
    }

    public void setResolveEscapes(boolean resolveEscapes) {
        this.resolveEscapes = resolveEscapes;
    }

    public String getMacroStart() {
        return this.macroStart;
    }

    public void setMacroStart(String macroStart) {
        this.macroStart = macroStart;
    }

    public String getMacroEnd() {
        return this.macroEnd;
    }

    public void setMacroEnd(String macroEnd) {
        this.macroEnd = macroEnd;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public String parse(String template, Object context) {
        return this.parse(template, context, false);
    }

    public String parse(String template, BeanTemplateMacroResolver macroResolver) {
        return this.parse(template, macroResolver, true);
    }

    protected String parse(String template, Object context, boolean isResolver) {
        BeanTemplateMacroResolver macroResolver = null;
        if (isResolver) {
            macroResolver = (BeanTemplateMacroResolver)context;
        }
        StringBuilder result = new StringBuilder(template.length());
        int i = 0;
        int len = template.length();
        while (i < len) {
            Object value;
            int n;
            int ndx = template.indexOf(MACRO_START, i);
            if (ndx == -1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == this.escapeChar; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            if (this.resolveEscapes) {
                result.append(template.substring(i, ndx - count));
            } else {
                result.append(template.substring(i, ndx));
            }
            if (escape) {
                result.append(MACRO_START);
                i = ndx + 2;
                continue;
            }
            int ndx2 = template.indexOf(MACRO_END, ndx += 2);
            if (ndx2 == -1) {
                throw new BeanException("Bad template, unclosed macro at: " + (ndx - 2));
            }
            int ndx1 = ndx;
            while (ndx1 < ndx2 && (n = StringUtil.indexOf(template, MACRO_START, ndx1, ndx2)) != -1) {
                ndx1 = n + 2;
            }
            String name = template.substring(ndx1, ndx2);
            if (this.missingKeyReplacement != null || !this.replaceMissingKey) {
                if (macroResolver != null) {
                    try {
                        value = macroResolver.resolve(name);
                    }
                    catch (Exception ignore) {
                        value = null;
                    }
                } else {
                    value = BeanUtil.getDeclaredPropertySilently(context, name);
                }
                if (value == null) {
                    value = this.replaceMissingKey ? this.missingKeyReplacement : template.substring(ndx1 - 2, ndx2 + 1);
                }
            } else {
                value = macroResolver != null ? macroResolver.resolve(name) : BeanUtil.getDeclaredProperty(context, name);
                if (value == null) {
                    value = "";
                }
            }
            if (ndx == ndx1) {
                result.append(value.toString());
                i = ndx2 + 1;
                continue;
            }
            template = template.substring(0, ndx1 - 2) + value.toString() + template.substring(ndx2 + 1);
            len = template.length();
            i = ndx - 2;
        }
        return result.toString();
    }
}

