/*
 * Decompiled with CFR 0.152.
 */
package com.haomostudio.SpringMVCTemplate.service.common.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.haomostudio.SpringMVCTemplate.common.domain.Column;
import com.haomostudio.SpringMVCTemplate.common.util.DataBaseOperationUtils;
import com.haomostudio.SpringMVCTemplate.dao.impl.DataBaseDao;
import com.haomostudio.SpringMVCTemplate.service.common.service.DataBaseService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="databaseService")
public class OracleDataBaseServiceImpl
implements DataBaseService {
    @Autowired
    private DataBaseDao databaseDao;
    public static final String EQUALS = "equals";
    public static final String RANGE = "range";
    public static final String START = "start";
    public static final String END = "end";
    public static final String LIKE = "like";
    public static final String IN = "in";

    @Override
    public boolean createTable(String tableNamePrefix, String tableName, List<Column> columns) {
        String sql = "CREATE TABLE " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)tableName) + " (";
        for (Column tc : columns) {
            sql = sql + tc.getName().toUpperCase() + " " + DataBaseOperationUtils.getDataType((Column)tc) + " " + DataBaseOperationUtils.getIsNull((Column)tc) + ",";
        }
        if ("".equals(DataBaseOperationUtils.getPrimaryKey(columns))) {
            sql = sql.substring(0, sql.length() - 1);
        }
        sql = sql + DataBaseOperationUtils.getPrimaryKey(columns) + ");";
        return this.executeSQL(sql);
    }

    @Override
    public boolean dropTable(String tableNamePrefix, String tableName) {
        String sql = "DROP TABLE " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)tableName);
        return this.executeSQL(sql);
    }

    @Override
    public boolean renameTable(String tableNamePrefix, String oldName, String newName) {
        String sql = "ALTER TABLE " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)oldName) + " RENAME TO " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)newName);
        return this.executeSQL(sql);
    }

    @Override
    public boolean addColumn(String tableNamePrefix, String tableName, Column column) {
        String sql = "ALTER TABLE " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)tableName) + " ADD " + column.getName().toUpperCase() + " " + DataBaseOperationUtils.getDataType((Column)column) + " " + DataBaseOperationUtils.getIsNull((Column)column) + ";";
        return this.executeSQL(sql);
    }

    @Override
    public boolean dropColumn(String tableNamePrefix, String tableName, String columnName) {
        String sql = "ALTER TABLE " + DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)tableName) + " DROP COLUMN " + columnName.toUpperCase() + ";";
        return this.executeSQL(sql);
    }

    @Override
    public boolean changeColumn(String tableNamePrefix, String tableName, String columnName, Column column) {
        String newColumnName = column.getName().toUpperCase();
        String orclTableName = DataBaseOperationUtils.getOracleTableName((String)tableNamePrefix, (String)tableName);
        String sql = "";
        if (!columnName.equalsIgnoreCase(newColumnName)) {
            sql = "ALTER TABLE " + orclTableName + " RENAME COLUMN " + columnName.toUpperCase() + " TO " + newColumnName + ";";
        }
        sql = sql + "ALTER TABLE " + orclTableName + " MODIFY " + newColumnName + " " + DataBaseOperationUtils.getDataType((Column)column) + " " + DataBaseOperationUtils.getIsNull((Column)column) + ";";
        return this.executeSQL(sql);
    }

    @Override
    public boolean executeSQL(String sql) {
        return this.databaseDao.executeSQL(sql);
    }

    @Override
    public List<Map<String, Object>> getTableData(String tableNamePrefix, String tableName, Map<String, Object> params) {
        return this.databaseDao.getTableData(tableNamePrefix, tableName, params);
    }

    @Override
    public int getTableDataCount(String tableNamePrefix, String tableName, Map<String, Object> params) {
        return this.databaseDao.getTableDataCount(tableNamePrefix, tableName, params);
    }

    @Override
    public int getColumnValueHasValueCount(String tableNamePrefix, String tableName, String columnName, Integer type) {
        if (9 == type || 10 == type) {
            return this.databaseDao.getColumnNotZeroCount(tableNamePrefix, tableName, columnName);
        }
        return this.databaseDao.getColumnNotNullCount(tableNamePrefix, tableName, columnName);
    }

    @Override
    public int getColumnValueNotNullCount(String tableNamePrefix, String tableName, String columnName) {
        return this.databaseDao.getColumnNotNullCount(tableNamePrefix, tableName, columnName);
    }

    @Override
    public int getColumnValueNotZeroCount(String tableNamePrefix, String tableName, String columnName) {
        return this.databaseDao.getColumnNotZeroCount(tableNamePrefix, tableName, columnName);
    }

    @Override
    public boolean executeSQL(String sql, List<Object> params) {
        return this.databaseDao.executeSQL(sql, params);
    }

    @Override
    public int update(String tableNamePrefix, String tableName, Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (null != map) {
            linkedHashMap.putAll(map);
        }
        return this.databaseDao.update(tableNamePrefix, tableName, linkedHashMap);
    }

    @Override
    public int insert(String tableNamePrefix, String tableName, Map<String, Object> map) {
        return this.databaseDao.insert(tableNamePrefix, tableName, map);
    }

    @Override
    public int inserts(String tableNamePrefix, String tableName, List<Map<String, Object>> maps) {
        return this.databaseDao.inserts(tableNamePrefix, tableName, maps);
    }

    @Override
    public int delete(String tableNamePrefix, String tableName, Map<String, Object> map) {
        return this.databaseDao.delete(tableNamePrefix, tableName, map);
    }

    @Override
    public String convertParam2SqlConnByAnd(String sortItem, String sortOrder, String filters) {
        StringBuffer sql = new StringBuffer();
        if (!org.springframework.util.StringUtils.isEmpty((Object)filters)) {
            try {
                filters = URLDecoder.decode(filters, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject filtersJsonObj = JSONObject.parseObject((String)filters);
            for (String tableName : filtersJsonObj.keySet()) {
                JSONObject conditionsJsonObj = filtersJsonObj.getJSONObject(tableName);
                for (String columnName : conditionsJsonObj.keySet()) {
                    JSONObject columnJsonObj = conditionsJsonObj.getJSONObject(columnName);
                    for (String operationName : columnJsonObj.keySet()) {
                        String value2;
                        sql.append(" AND ");
                        String column = tableName + "." + columnName;
                        if (RANGE.equals(operationName)) {
                            JSONObject rangeJsonObj = columnJsonObj.getJSONObject(operationName);
                            String start = rangeJsonObj.getString(START);
                            String end = rangeJsonObj.getString(END);
                            sql.append("(").append(column).append(">").append("'").append(start).append("'").append(" AND ").append(column).append("<").append("'").append(end).append("'").append(")");
                            continue;
                        }
                        if (LIKE.equals(operationName)) {
                            value2 = columnJsonObj.getString(LIKE);
                            sql.append("(").append(column).append(" like '%").append(value2).append("%')");
                            continue;
                        }
                        if ("notLike".equals(operationName)) {
                            value2 = columnJsonObj.getString("notLike");
                            sql.append("(").append(column).append(" not like '").append(value2).append("')");
                            continue;
                        }
                        if (EQUALS.equals(operationName)) {
                            ArrayList<String> valueArray = new ArrayList<String>();
                            try {
                                JSONArray jsonArray = columnJsonObj.getJSONArray(EQUALS);
                                for (int i = 0; i < jsonArray.size(); ++i) {
                                    String v = jsonArray.getString(i);
                                    valueArray.add(v);
                                }
                            }
                            catch (Exception e) {
                                String values = columnJsonObj.getString(EQUALS);
                                for (String s : values.split(",")) {
                                    valueArray.add(s);
                                }
                            }
                            sql.append("(");
                            for (int i = 0; i < valueArray.size(); ++i) {
                                String value3 = (String)valueArray.get(i);
                                if (i != 0) {
                                    sql.append(" OR ");
                                }
                                sql.append(column).append("=").append("'").append(value3).append("'");
                            }
                            sql.append(")");
                            continue;
                        }
                        if (!IN.equals(operationName)) continue;
                        JSONArray values = columnJsonObj.getJSONArray(IN);
                        sql.append("(").append(column).append(" in ('").append(StringUtils.join((Iterable)values.stream().map(value -> (String)value).collect(Collectors.toList()), (String)"', '")).append("'))");
                    }
                }
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)sortItem) && !org.springframework.util.StringUtils.isEmpty((Object)sortOrder)) {
            String[] sorts = sortItem.split(",");
            String[] orders = sortOrder.split(",");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (i = 0; i < sorts.length - 1; ++i) {
                sb.append(" " + sorts[i]);
                if (i < orders.length) {
                    sb.append(" " + orders[i]);
                }
                sb.append(" , ");
            }
            sb.append(" " + sorts[i]);
            if (i < orders.length) {
                sb.append(" " + orders[i]);
            }
            sql.append(" order by ").append(sb.toString());
        }
        return sql.toString();
    }

    @Override
    public String convertParam2SqlConnByAndForUser(String sortItem, String sortOrder, String filters) {
        StringBuffer sql = new StringBuffer();
        if (!org.springframework.util.StringUtils.isEmpty((Object)filters)) {
            try {
                filters = URLDecoder.decode(filters, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject filtersJsonObj = JSONObject.parseObject((String)filters);
            for (String tableName : filtersJsonObj.keySet()) {
                JSONObject conditionsJsonObj = filtersJsonObj.getJSONObject(tableName);
                for (String columnName : conditionsJsonObj.keySet()) {
                    JSONObject columnJsonObj = conditionsJsonObj.getJSONObject(columnName);
                    for (String operationName : columnJsonObj.keySet()) {
                        sql.append(" AND ");
                        String column = tableName + "." + columnName;
                        if (RANGE.equals(operationName)) {
                            JSONObject rangeJsonObj = columnJsonObj.getJSONObject(operationName);
                            String start = rangeJsonObj.getString(START);
                            String end = rangeJsonObj.getString(END);
                            sql.append("(").append(column).append(">").append("'").append(start).append("'").append(" AND ").append(column).append("<").append("'").append(end).append("'").append(")");
                            continue;
                        }
                        if (LIKE.equals(operationName)) {
                            String value = columnJsonObj.getString(LIKE);
                            if (column.equals("crm_user.username")) {
                                sql.append("((crm_user.username like '%" + value + "%') or (crm_user.loginid like '%" + value + "%'))");
                                continue;
                            }
                            sql.append("(").append(column).append(" like '%").append(value).append("%')");
                            continue;
                        }
                        if (!EQUALS.equals(operationName)) continue;
                        ArrayList<String> valueArray = new ArrayList<String>();
                        try {
                            JSONArray jsonArray = columnJsonObj.getJSONArray(EQUALS);
                            for (int i = 0; i < jsonArray.size(); ++i) {
                                String v = jsonArray.getString(i);
                                valueArray.add(v);
                            }
                        }
                        catch (Exception e) {
                            String values = columnJsonObj.getString(EQUALS);
                            for (String s : values.split(",")) {
                                valueArray.add(s);
                            }
                        }
                        sql.append("(");
                        for (int i = 0; i < valueArray.size(); ++i) {
                            String value = (String)valueArray.get(i);
                            if (i != 0) {
                                sql.append(" OR ");
                            }
                            sql.append(column).append("=").append("'").append(value).append("'");
                        }
                        sql.append(")");
                    }
                }
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)sortItem) && !org.springframework.util.StringUtils.isEmpty((Object)sortOrder)) {
            String[] sorts = sortItem.split(",");
            String[] orders = sortOrder.split(",");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (i = 0; i < sorts.length - 1; ++i) {
                sb.append(" " + sorts[i]);
                if (i < orders.length) {
                    sb.append(" " + orders[i]);
                }
                sb.append(" , ");
            }
            sb.append(" " + sorts[i]);
            if (i < orders.length) {
                sb.append(" " + orders[i]);
            }
            sql.append(" order by ").append(sb.toString());
        }
        return sql.toString();
    }

    @Override
    public String convertParam2SqlConnByWhere(String sortItem, String sortOrder, String filters) {
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE 1=1 ").append(this.convertParam2SqlConnByAnd(sortItem, sortOrder, filters));
        return sql.toString();
    }

    @Override
    public String convertParam2SqlConnByWhereForUser(String sortItem, String sortOrder, String filters) {
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE 1=1 ").append(this.convertParam2SqlConnByAndForUser(sortItem, sortOrder, filters));
        return sql.toString();
    }

    @Override
    public String convertParam2SqlConnByAnd(String filters) {
        return this.convertParam2SqlConnByAnd(null, null, filters);
    }

    @Override
    public String convertParam2SqlConnByWhere(String filters) {
        return this.convertParam2SqlConnByWhere(null, null, filters);
    }

    @Override
    public Map<String, Object> executeQuerySQL(String sql) {
        return this.databaseDao.executeQuerySQL(sql);
    }

    @Override
    public List<Map<String, Object>> zxexecuteListSQL(String sql) {
        return this.databaseDao.executeListSQL(sql);
    }

    @Override
    public Integer zxqueryForInt(String sql) {
        return this.databaseDao.queryForInt(sql, null);
    }

    @Override
    public void executeSingleSQL(String sql) {
        this.databaseDao.executeSingleSQL(sql);
    }
}

