/*
 * Decompiled with CFR 0.152.
 */
package com.haomostudio.SpringMVCTemplate.service.HmUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public class Tools {
    private static SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String dateFormat = "yyyy-MM-dd";
    public static final String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    public static final String dateTimePattern = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$";

    public static String getUUID() {
        return UUID.randomUUID().toString().trim().replaceAll("-", "");
    }

    public static int getRandomNumber(int min, int max) {
        Random random = new Random();
        int result = random.nextInt(max) % (max - min + 1) + min;
        return result;
    }

    public static File uploadFile(HttpServletRequest request, MultipartFile multipartFile, String targetName, String targetFolder) throws IOException {
        String fileName;
        if (null == multipartFile || multipartFile.isEmpty()) {
            return null;
        }
        String dir = request.getSession().getServletContext().getRealPath(targetFolder);
        if (StringUtils.isEmpty((CharSequence)targetName)) {
            fileName = multipartFile.getOriginalFilename();
        } else {
            String type = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf("."));
            fileName = targetName + type;
        }
        File file = new File(dir, fileName);
        FileUtils.writeByteArrayToFile((File)file, (byte[])multipartFile.getBytes());
        return file;
    }

    public static <T> T readJson(String jsonStr, Class<?> collectionClass, Class<?> ... elementClasses) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        JavaType javaType = mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        return (T)mapper.readValue(jsonStr, javaType);
    }

    public static WebApplicationContext getSpringContext() {
        return ContextLoader.getCurrentWebApplicationContext();
    }

    public static Object getSpringBean(String beanName) {
        return Tools.getSpringContext().getBean(beanName);
    }

    public static String nullObjToEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return StringUtils.trim((String)obj.toString());
    }

    public static int transferToInt(String intStr) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Double transferToDouble(String intStr) {
        try {
            return Double.valueOf(intStr);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static String joinStr(List<String> strs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.size() - 1; ++i) {
            sb.append("'").append(strs.get(i)).append("',");
        }
        sb.append("'").append(strs.get(strs.size() - 1)).append("'");
        return sb.toString();
    }

    public static String joinStrBySp(List<String> strs, String sp) {
        if (strs == null || strs.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.size() - 1; ++i) {
            sb.append(strs.get(i) + sp);
        }
        sb.append(strs.get(strs.size() - 1));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T clone(T obj) {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        Serializable t = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            t = (Serializable)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ois.close();
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)t;
    }

    public static String convertDateToString(Date value, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String result = sdf.format(value);
        return result;
    }

    public static String convertToSapString(Object value) {
        SimpleDateFormat sdf = new SimpleDateFormat(yyyyMMdd);
        String result = null;
        if (value instanceof Date) {
            result = sdf.format(value);
        }
        return result;
    }

    public static Date convertStringToDate(String str, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Date date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getApplicationRootPath() {
        return ContextLoader.getCurrentWebApplicationContext().getServletContext().getRealPath("/");
    }

    public static List<Map<String, Object>> transToLower(List<Map<String, Object>> maps) {
        ArrayList<Map<String, Object>> tmps = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : maps) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            for (String s : map.keySet()) {
                tmp.put(s.toLowerCase(), map.get(s));
            }
            tmps.add(tmp);
        }
        return tmps;
    }

    public static List<Map<String, Object>> addPrefix(String prefix, List<Map<String, Object>> maps) {
        ArrayList<Map<String, Object>> tmps = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : maps) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            for (String s : map.keySet()) {
                tmp.put(prefix + "." + s, map.get(s));
            }
            tmps.add(tmp);
        }
        return tmps;
    }

    public static List<Map<String, Object>> mergeMap(List<Map<String, Object>> amaps, List<Map<String, Object>> bmaps) {
        for (int i = 0; i < bmaps.size(); ++i) {
            for (String key : bmaps.get(i).keySet()) {
                amaps.get(i).put(key, bmaps.get(i).get(key));
            }
        }
        return amaps;
    }

    public static List<Map<String, Object>> transToLowerJustID(List<Map<String, Object>> maps) {
        ArrayList<Map<String, Object>> tmps = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : maps) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            for (String s : map.keySet()) {
                if (s.equals("ID")) {
                    tmp.put(s.toLowerCase(), map.get(s));
                    continue;
                }
                tmp.put(s, map.get(s));
            }
            tmps.add(tmp);
        }
        return tmps;
    }

    public static String getOrclPageSql(String sql, Integer pageNo, Integer pageSize) {
        sql = "select * from (select row_.*, rownum rownum_ from( " + sql + ")row_ where rownum <= " + Integer.valueOf(pageNo * pageSize) + ") where rownum_ >= " + Integer.valueOf((pageNo - 1) * pageSize + 1);
        return sql;
    }

    public static String changeToSapPay(String ht31, String ht33, String ht35) {
        String checkDay;
        String string = StringUtils.isNotBlank((CharSequence)ht35) ? ht35 : (checkDay = StringUtils.isNotBlank((CharSequence)ht33) ? ht33 : ht31);
        if ("0".equals(checkDay)) {
            return "0001";
        }
        return "H0" + Tools.getFloorDay(Integer.parseInt(checkDay));
    }

    private static int getFloorDay(int htDay) {
        int[] days;
        for (int day : days = new int[]{10, 20, 30, 45, 60, 90}) {
            if (day - htDay < 0) continue;
            return day;
        }
        return 0;
    }

    public static boolean containsKeyIgnoreCase(Map<String, Object> map, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (StringUtils.isBlank((CharSequence)entry.getKey())) {
                return false;
            }
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static String escapeSql(String str) {
        if (str.indexOf("%") > -1) {
            str = str.replaceAll("%", "\\\\%");
        }
        if (str.indexOf("_") > -1) {
            str = str.replaceAll("_", "\\\\_");
        }
        return str;
    }

    public static String joinDbKV(String key, Object value) {
        if (value == null) {
            return key + "=" + value;
        }
        return key + "='" + value + "'";
    }

    public static String getOracleToDate(Date date) {
        return "to_date('" + Tools.convertDateToString(date, dateFormat) + "', 'yyyy-MM-dd')";
    }

    public static String getOracleToDateTime(Date date) {
        return "to_date('" + Tools.convertDateToString(date, dateTimeFormat) + "', 'yyyy-MM-dd hh24:mi:ss')";
    }

    public static Map<String, Object> convertJSONObjectToMap(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static List<Map<String, Object>> convertJSONArrayToList(JSONArray array) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object item : array) {
            Map<String, Object> map = Tools.convertJSONObjectToMap((JSONObject)item);
            list.add(map);
        }
        return list;
    }
}

