package com.haomostudio.SpringMVCTemplate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.haomostudio.SpringMVCTemplate.dao.*;
import com.haomostudio.SpringMVCTemplate.po.TesMenuModule;
import com.haomostudio.SpringMVCTemplate.po.TesMenuModuleExample;
import com.haomostudio.SpringMVCTemplate.service.HmUtils.MybatisExampleHelper;
import com.haomostudio.SpringMVCTemplate.service.TesMenuModuleService;
import com.haomostudio.SpringMVCTemplate.vo.TesMenuModuleVO;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* Created by hxgqh on 2016/1/7.
*/
@Service("tesMenuModuleService")
public class TesMenuModuleServiceImpl implements TesMenuModuleService {
    protected static final Logger LOG = LoggerFactory.getLogger(TesMenuModuleServiceImpl.class);

    // 将所有的modelMapper注入
    @Autowired
    TesUserMapper tesUserMapper;

    TesRoleMapper tesRoleMapper;

    @Autowired
    TesMenuMapper tesMenuMapper;

    @Autowired
    TesDepartmentMapper tesDepartmentMapper;

    @Autowired
    TesMenuModuleMapper tesMenuModuleMapper;

    @Autowired
    TestRoleGroupMapper testRoleGroupMapper;

    @Autowired
    TesMenuGroupMapper tesMenuGroupMapper;


    @Override
    public int create(TesMenuModule item) {
        return tesMenuModuleMapper.insertSelective(item);
    }

    @Override
    public int delete(String id) {
        return tesMenuModuleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public int update(TesMenuModule item) {
        return tesMenuModuleMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    public TesMenuModule get(String id) {
        return tesMenuModuleMapper.selectByPrimaryKey(Integer.valueOf(id));
    }

    private void assignRelates(String relates, List<TesMenuModuleVO> modelVOList){
        JSONObject relatesObj = JSON.parseObject(relates);
        for (String table: relatesObj.keySet()) {
            for(TesMenuModuleVO modelVO: modelVOList){
                List<String> joinCols = (List<String>) relatesObj.get(table);
                TesMenuModuleExample tableExampleObj = new TesMenuModuleExample();
                Map<String, Map<String, Map<String, String>>> tableFilters = new HashMap<>();
                for(String joinCol: joinCols){
                    Map<String, Map<String, String>> column = new HashMap<>();
                    Method m = MybatisExampleHelper.getMethod(modelVO.getSuperior(),
                        "get"+ CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, joinCol));
                    Map<String, String> condition = new HashMap<String, String>();
                    try{
                        condition.put("equalTo", (String)JSON.parse(JSON.toJSONString(m.invoke(modelVO.getSuperior()))));
                        column.put(joinCol, condition);
                        tableFilters.put(table, column);
                    }
                    catch (InvocationTargetException e) {
                        LOG.error(e.toString());
                    }
                    catch (IllegalAccessException e){
                        LOG.error(e.toString());
                    }
                }

                MybatisExampleHelper.assignWhereClause(tableExampleObj, tableExampleObj.or(), table, JSON.toJSONString(tableFilters));
                tableExampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause("id", "asc"));

                // 获取到关联表的列表
                try{
                    Field mapperFieldDef = this.getClass()
                    .getDeclaredField(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table)+"Mapper");
                    mapperFieldDef.setAccessible(true);
                    Object fieldValue = mapperFieldDef.get(this);
                    MapperProxy proxy = (MapperProxy) Proxy.getInvocationHandler(fieldValue);
                    Method sbewr = MybatisExampleHelper.getMethod(fieldValue, "selectByExampleWithRowbounds");
                    Object[] args = new Object[]{tableExampleObj, new RowBounds(1, 1000)};
                    modelVO.getRelates().put(table, (List<Object>)(proxy.invoke(proxy, sbewr, args)));
                }
                catch (Throwable e){
                    LOG.error(e.toString());
                }
            }
        }
    }

    @Override
    public List<TesMenuModule> getListWithPagingAndFilter(
        Integer pageNo, Integer pageSize,
        String sortItem, String sortOrder,
        String filters){
        TesMenuModuleExample exampleObj = new TesMenuModuleExample();
        RowBounds rowBounds = new RowBounds((pageNo - 1) * pageSize, pageSize);
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesMenuModule", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));

        return tesMenuModuleMapper.selectByExampleWithRowbounds(exampleObj, rowBounds);
    }

    @Override
    public Object getListWithPagingAndFilter(
        Integer pageNo, Integer pageSize,
        String sortItem, String sortOrder,
        String filters, String includes, String refers, String relates){
        TesMenuModuleExample exampleObj = new TesMenuModuleExample();
        RowBounds rowBounds = new RowBounds((pageNo - 1) * pageSize, pageSize);
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesMenuModule", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));

        List<TesMenuModule> modelList = tesMenuModuleMapper.selectByExampleWithRowbounds(
        exampleObj, rowBounds);

        List<TesMenuModuleVO> modelVOList = modelList.stream().map(model -> new TesMenuModuleVO(model)).collect(Collectors.toList());

         // 处理includes的外链字段  处理refers的关联表
        if((includes != null || refers != null)&& modelList.size() > 0){
            //对Vo层数据循环处理外链表数据
            modelVOList.stream().forEach(status->{
                if (includes != null){
                    this.assignIncludes(includes,status);
                }
                if (refers != null){
                    this.assignRefers(refers,status);
                }
            });
        }

        // 处理join的关联表
        if(relates != null && modelList.size() > 0){
            this.assignRelates(relates, modelVOList);
        }

        if(includes == null && refers == null && relates == null){
            return modelList;
        }
        else{
            return modelVOList;
        }
    }

    @Override
    public Long countListWithPagingAndFilter(String filters){
        TesMenuModuleExample exampleObj = new TesMenuModuleExample();
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesMenuModule", filters);
        return tesMenuModuleMapper.countByExample(exampleObj);
    }


    private void assignIncludes(String includes, TesMenuModuleVO status){
        JSONObject includesObj = JSON.parseObject(includes);
        //定义容器存储所有外链表数据
        Map<String,Object> map = new HashMap();
        // 循环解析每一个键值对
        if (includesObj!=null && includesObj.keySet().size() >0){
            includesObj.keySet().stream().forEach(table->{
                //每一个key都是一个po实体类名
                Object className = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table);
                JSONObject jsonObject = includesObj.getJSONObject(
                        CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                //对内层的includes数据进行解析
                JSONArray columnCondition = jsonObject.getJSONArray("includes");
                if (columnCondition != null && columnCondition.toArray().length >0){
                    //循环数组
                    Arrays.stream(columnCondition.toArray()).forEach(obj -> {
                        //反射机制将要执行的方法名
                        String ffName = "get"+CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, obj.toString());
                        //获取Method的对象
                        Method m = MybatisExampleHelper.getMethod(status.getSuperior(), ffName);
                        MybatisExampleHelper.dealSearchIncludes(m,status.getSuperior(),
                                className,map,table,this.getClass().getPackage().getName());

                    });
                }
            });
        }
        status.setIncludes(map);
    }

    private void assignRefers(String refers, TesMenuModuleVO status){
        //解析includes字符串为JSONObject
        JSONObject refersObj = JSON.parseObject(refers);
        //定义容器存储所有外链表数据
        Map<String,List<Object>> map = new HashMap();
        if (refersObj!=null && refersObj.keySet().size() > 0){
            // 循环解析每一个键值对
            refersObj.keySet().stream().forEach(table -> {
                //每一个key都是一个po实体类名
                JSONObject jsonObject = refersObj.getJSONObject(
                        CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                //对内层的includes数据进行解析
                JSONArray columnCondition = jsonObject.getJSONArray("includes");
                if (columnCondition != null && columnCondition.toArray().length > 0){
                    //循环数组
                    Arrays.stream(columnCondition.toArray()).forEach(obj -> {
                        MybatisExampleHelper.dealSearchRefers(status.getSuperior().getId(),
                                table,map,obj,CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table),
                                this.getClass().getPackage().getName());
                    });
                }
            });
        }

        status.setRefers(map);
    }

}
