/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractThreadPoolStrategy
extends SchedulingStrategy {
    private final ExecutorService threadPool;
    private final Collection<Future<?>> futureResults;
    private final AtomicBoolean canSchedule = new AtomicBoolean(true);

    AbstractThreadPoolStrategy(ExecutorService threadPool) {
        this(threadPool, null);
    }

    AbstractThreadPoolStrategy(ExecutorService threadPool, Collection<Future<?>> futureResults) {
        this.threadPool = threadPool;
        this.futureResults = futureResults;
    }

    protected final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected final Collection<Future<?>> getFutureResults() {
        return this.futureResults;
    }

    protected final void disable() {
        this.canSchedule.set(false);
    }

    @Override
    public void schedule(Runnable task) {
        if (this.canSchedule()) {
            Future<?> futureResult = this.threadPool.submit(task);
            if (this.futureResults != null) {
                this.futureResults.add(futureResult);
            }
        }
    }

    @Override
    protected boolean stop() {
        boolean wasRunning = this.canSchedule.getAndSet(false);
        if (this.threadPool.isShutdown()) {
            wasRunning = false;
        } else {
            this.threadPool.shutdown();
        }
        return wasRunning;
    }

    @Override
    protected boolean stopNow() {
        boolean wasRunning = this.canSchedule.getAndSet(false);
        if (this.threadPool.isShutdown()) {
            wasRunning = false;
        } else {
            this.threadPool.shutdownNow();
        }
        return wasRunning;
    }

    @Override
    protected void setDefaultShutdownHandler(Scheduler.ShutdownHandler handler) {
        if (this.threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor pool = (ThreadPoolExecutor)this.threadPool;
            handler.setRejectedExecutionHandler(pool.getRejectedExecutionHandler());
            pool.setRejectedExecutionHandler(handler);
        }
    }

    @Override
    public final boolean canSchedule() {
        return this.canSchedule.get();
    }
}

