/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterArrayConverter
implements TypeConverter<char[]> {
    protected final ConvertBean convertBean;

    public CharacterArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public char[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            return value.toString().toCharArray();
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == char[].class) {
                return (char[])value;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
            if (type == long[].class) {
                int[] values = (int[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 49 : 48;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                char[] results = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (char)values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected char[] convertArray(Object[] values) {
        char[] results = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toCharValue(values[i]);
        }
        return results;
    }
}

