/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.ArrayList;
import jodd.props.PropsData;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class PropsParser
implements Cloneable {
    protected static final String PROFILE_LEFT = "<";
    protected static final String PROFILE_RIGHT = ">";
    protected String escapeNewLineValue = "";
    protected boolean valueTrimLeft = true;
    protected boolean valueTrimRight = true;
    protected boolean ignorePrefixWhitespacesOnNewLine = true;
    protected boolean skipEmptyProps = true;
    protected final PropsData propsData;

    public PropsParser() {
        this.propsData = new PropsData();
    }

    public PropsParser(PropsData propsData) {
        this.propsData = propsData;
    }

    public PropsData getPropsData() {
        return this.propsData;
    }

    public PropsParser clone() {
        PropsParser pp = new PropsParser(this.propsData.clone());
        pp.escapeNewLineValue = this.escapeNewLineValue;
        pp.valueTrimLeft = this.valueTrimLeft;
        pp.valueTrimRight = this.valueTrimRight;
        pp.ignorePrefixWhitespacesOnNewLine = this.ignorePrefixWhitespacesOnNewLine;
        pp.skipEmptyProps = this.skipEmptyProps;
        return pp;
    }

    public void parse(String in) {
        ParseState state = ParseState.TEXT;
        boolean insideSection = false;
        String currentSection = null;
        String key = null;
        StringBuilder sb = new StringBuilder();
        int len = in.length();
        int ndx = 0;
        block17: while (ndx < len) {
            char c = in.charAt(ndx);
            ++ndx;
            if (state == ParseState.COMMENT) {
                if (c != '\n') continue;
                state = ParseState.TEXT;
            }
            if (state == ParseState.ESCAPE) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        state = ParseState.ESCAPE_NEWLINE;
                        continue block17;
                    }
                    case 'u': {
                        int value = 0;
                        for (int i = 0; i < 4; ++i) {
                            char hexChar;
                            if (CharUtil.isDigit(hexChar = in.charAt(ndx++))) {
                                value = (value << 4) + hexChar - 48;
                                continue;
                            }
                            if (hexChar >= 'a' && hexChar <= 'f') {
                                value = (value << 4) + 10 + hexChar - 97;
                                continue;
                            }
                            if (hexChar >= 'A' && hexChar <= 'F') {
                                value = (value << 4) + 10 + hexChar - 65;
                                continue;
                            }
                            throw new IllegalArgumentException("Malformed \\uXXXX encoding.");
                        }
                        sb.append((char)value);
                        state = ParseState.TEXT;
                        continue block17;
                    }
                    case 't': {
                        sb.append('\t');
                        state = ParseState.TEXT;
                        continue block17;
                    }
                    case 'n': {
                        sb.append('\n');
                        state = ParseState.TEXT;
                        continue block17;
                    }
                    case 'r': {
                        sb.append('\r');
                        state = ParseState.TEXT;
                        continue block17;
                    }
                    case 'f': {
                        sb.append('\f');
                        state = ParseState.TEXT;
                        continue block17;
                    }
                }
                sb.append(c);
                state = ParseState.TEXT;
                continue;
            }
            switch (c) {
                case '[': {
                    sb.setLength(0);
                    insideSection = true;
                    break;
                }
                case ']': {
                    if (insideSection) {
                        currentSection = sb.toString().trim();
                        sb.setLength(0);
                        insideSection = false;
                        if (currentSection.length() != 0) continue block17;
                        currentSection = null;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '\\': {
                    state = ParseState.ESCAPE;
                    break;
                }
                case '#': 
                case ';': {
                    state = ParseState.COMMENT;
                    break;
                }
                case ':': 
                case '=': {
                    if (key == null) {
                        key = sb.toString().trim();
                        sb.setLength(0);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (state == ParseState.ESCAPE_NEWLINE && c == '\n') {
                        sb.append(this.escapeNewLineValue);
                        if (this.ignorePrefixWhitespacesOnNewLine) continue block17;
                        state = ParseState.TEXT;
                        break;
                    }
                    this.add(currentSection, key, sb);
                    sb.setLength(0);
                    key = null;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (state == ParseState.ESCAPE_NEWLINE) break;
                }
                default: {
                    sb.append(c);
                    state = ParseState.TEXT;
                }
            }
        }
        if (key != null) {
            this.add(currentSection, key, sb);
        }
    }

    protected void add(String section, String key, StringBuilder value) {
        if (value.length() == 0 && this.skipEmptyProps) {
            return;
        }
        if (key == null) {
            return;
        }
        if (section != null) {
            key = section + '.' + key;
        }
        String v = value.toString();
        v = this.valueTrimLeft && this.valueTrimRight ? v.trim() : (this.valueTrimLeft ? StringUtil.trimLeft(v) : StringUtil.trimRight(v));
        this.add(key, v);
    }

    protected void add(String key, String value) {
        int ndx = key.indexOf(PROFILE_LEFT);
        if (ndx == -1) {
            this.propsData.putBaseProperty(key, value);
            return;
        }
        ArrayList<String> keyProfiles = new ArrayList<String>();
        while ((ndx = key.indexOf(PROFILE_LEFT)) != -1) {
            int len = key.length();
            int ndx2 = key.indexOf(PROFILE_RIGHT, ndx + 1);
            if (ndx2 == -1) {
                ndx2 = len;
            }
            String profile = key.substring(ndx + 1, ndx2);
            keyProfiles.add(profile);
            String right = ++ndx2 == len ? "" : key.substring(ndx2);
            key = key.substring(0, ndx) + right;
        }
        for (String p : keyProfiles) {
            this.propsData.putProfileProperty(key, value, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ParseState {
        TEXT,
        ESCAPE,
        ESCAPE_NEWLINE,
        COMMENT;

    }
}

