/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail.att;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import jodd.mail.EmailAttachment;
import jodd.mail.MailException;

public class ByteArrayAttachment
extends EmailAttachment {
    protected final byte[] content;
    protected final InputStream inputStream;
    protected final String contentType;

    public ByteArrayAttachment(byte[] content, String contentType, String name, String contentId) {
        super(name, contentId);
        this.content = content;
        this.inputStream = null;
        this.contentType = contentType;
    }

    public ByteArrayAttachment(byte[] content, String contentType, String name) {
        super(name, null);
        this.content = content;
        this.inputStream = null;
        this.contentType = contentType;
    }

    public ByteArrayAttachment(InputStream inputStream, String contentType, String name, String contentId) {
        super(name, contentId);
        this.content = null;
        this.inputStream = inputStream;
        this.contentType = contentType;
    }

    public ByteArrayAttachment(InputStream inputStream, String contentType, String name) {
        super(name, null);
        this.content = null;
        this.inputStream = inputStream;
        this.contentType = contentType;
    }

    public DataSource getDataSource() {
        if (this.inputStream != null) {
            try {
                return new ByteArrayDataSource(this.inputStream, this.contentType);
            }
            catch (IOException ioex) {
                throw new MailException(ioex);
            }
        }
        if (this.content != null) {
            return new ByteArrayDataSource(this.content, this.contentType);
        }
        throw new MailException("No data source");
    }
}

