/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jodd.io.FileUtil;
import jodd.io.findfile.FindFileException;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindFile {
    protected boolean recursive;
    protected boolean includeDirs = true;
    protected boolean includeFiles = true;
    protected LinkedList<File> fileList;
    protected boolean listSubfilesAfterFolder = true;

    public boolean isRecursive() {
        return this.recursive;
    }

    public FindFile setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isIncludeDirs() {
        return this.includeDirs;
    }

    public FindFile setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
        return this;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public FindFile setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
        return this;
    }

    protected void addSearchPath(File searchPath) {
        if (!searchPath.exists()) {
            return;
        }
        if (this.fileList == null) {
            this.fileList = new LinkedList();
        }
        if (!searchPath.isDirectory()) {
            this.fileList.add(searchPath);
            return;
        }
        this.listFiles(searchPath);
    }

    public FindFile searchPath(File searchPath) {
        this.addSearchPath(searchPath);
        return this;
    }

    public FindFile searchPath(File ... searchPath) {
        for (File file : searchPath) {
            this.addSearchPath(file);
        }
        return this;
    }

    public FindFile searchPath(String searchPath) {
        if (searchPath.indexOf(File.pathSeparatorChar) != -1) {
            String[] paths;
            for (String path : paths = StringUtil.split(searchPath, File.pathSeparator)) {
                this.addSearchPath(new File(path));
            }
            return this;
        }
        this.addSearchPath(new File(searchPath));
        return this;
    }

    public FindFile searchPath(String ... searchPaths) {
        for (String searchPath : searchPaths) {
            this.searchPath(searchPath);
        }
        return this;
    }

    public FindFile searchPath(URI searchPath) {
        File file = FileUtil.toFile(searchPath);
        if (file == null) {
            throw new FindFileException("Invalid search path URI: " + searchPath);
        }
        this.addSearchPath(file);
        return this;
    }

    public FindFile searchPath(URI ... searchPath) {
        for (URI uri : searchPath) {
            this.searchPath(uri);
        }
        return this;
    }

    public FindFile searchPath(URL searchPath) {
        File file = FileUtil.toFile(searchPath);
        if (file == null) {
            throw new FindFileException("Invalid search path URL: " + searchPath);
        }
        this.addSearchPath(file);
        return this;
    }

    public FindFile searchPath(URL ... searchPath) {
        for (URL url : searchPath) {
            this.searchPath(url);
        }
        return this;
    }

    public boolean isListSubfilesAfterFolder() {
        return this.listSubfilesAfterFolder;
    }

    public FindFile setListSubfilesAfterFolder(boolean listSubfilesAfterFolder) {
        this.listSubfilesAfterFolder = listSubfilesAfterFolder;
        return this;
    }

    public File nextFile() {
        File currentFile;
        block3: {
            if (this.fileList == null) {
                return null;
            }
            do {
                if (this.fileList.isEmpty()) {
                    this.fileList = null;
                    return null;
                }
                currentFile = this.fileList.removeFirst();
                if (!currentFile.isDirectory()) break block3;
                if (!this.recursive) continue;
                this.listFiles(currentFile);
            } while (!this.includeDirs || !this.acceptFile(currentFile));
            return currentFile;
        }
        return currentFile;
    }

    public Iterator<File> iterator() {
        return new Iterator<File>(){
            private File nextFile;

            @Override
            public boolean hasNext() {
                this.nextFile = FindFile.this.nextFile();
                return this.nextFile != null;
            }

            @Override
            public File next() {
                if (this.nextFile == null) {
                    throw new NoSuchElementException();
                }
                return this.nextFile;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void listFiles(File directory) {
        LinkedList<File> subFiles;
        LinkedList<File> subFolders;
        File[] list = directory.listFiles();
        if (!this.listSubfilesAfterFolder) {
            subFolders = this.fileList;
            subFiles = this.fileList;
        } else {
            subFolders = new LinkedList();
            subFiles = new LinkedList();
        }
        for (File currentFile : list) {
            if (currentFile.isFile()) {
                if (!this.includeFiles || !this.acceptFile(currentFile)) continue;
                subFiles.addLast(currentFile);
                continue;
            }
            if (!currentFile.isDirectory()) continue;
            subFolders.addLast(currentFile);
        }
        if (this.listSubfilesAfterFolder) {
            if (!subFiles.isEmpty()) {
                this.fileList.addAll(0, subFiles);
            }
            if (!subFolders.isEmpty()) {
                this.fileList.addAll(0, subFolders);
            }
        }
    }

    protected boolean acceptFile(File currentFile) {
        return true;
    }
}

