/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jpush.api.common.ClientConfig;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.connection.NativeHttpClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.BaseResult;
import cn.jpush.api.common.resp.ResponseWrapper;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.utils.Preconditions;
import cn.jpush.api.utils.StringUtils;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class PushClient {
    private final NativeHttpClient _httpClient;
    private String _baseUrl;
    private String _pushPath;
    private String _pushValidatePath;
    private JsonParser _jsonParser = new JsonParser();
    private int _apnsProduction;
    private long _timeToLive;

    public PushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        this._baseUrl = (String)conf.get("push.host.name");
        this._pushPath = (String)conf.get("push.path");
        this._pushValidatePath = (String)conf.get("push.validate.path");
        this._apnsProduction = (Integer)conf.get("apns.production");
        this._timeToLive = (Long)conf.get("time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public PushClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        this._baseUrl = (String)conf.get("push.host.name");
        this._pushPath = (String)conf.get("push.path");
        this._pushValidatePath = (String)conf.get("push.validate.path");
        this._apnsProduction = (Integer)conf.get("apns.production");
        this._timeToLive = (Long)conf.get("time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this(masterSecret, appKey);
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    @Deprecated
    public void setDefaults(boolean apnsProduction, long timeToLive) {
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(null != pushPayload, "pushPayload should not be null");
        if (this._apnsProduction > 0) {
            pushPayload.resetOptionsApnsProduction(true);
        } else if (this._apnsProduction == 0) {
            pushPayload.resetOptionsApnsProduction(false);
        }
        if (this._timeToLive >= 0L) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, pushPayload.toString());
        return BaseResult.fromResponse(response, PushResult.class);
    }

    public PushResult sendPushValidate(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(null != pushPayload, "pushPayload should not be null");
        if (this._apnsProduction > 0) {
            pushPayload.resetOptionsApnsProduction(true);
        } else if (this._apnsProduction == 0) {
            pushPayload.resetOptionsApnsProduction(false);
        }
        if (this._timeToLive >= 0L) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, pushPayload.toString());
        return BaseResult.fromResponse(response, PushResult.class);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(StringUtils.isNotEmpty(payloadString), "pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument(false, "payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, payloadString);
        return BaseResult.fromResponse(response, PushResult.class);
    }

    public PushResult sendPushValidate(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(StringUtils.isNotEmpty(payloadString), "pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument(false, "payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, payloadString);
        return BaseResult.fromResponse(response, PushResult.class);
    }
}

