/*
 * Decompiled with CFR 0.152.
 */
package com.haomostudio.SpringMVCTemplate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.haomostudio.SpringMVCTemplate.dao.TesDepartmentMapper;
import com.haomostudio.SpringMVCTemplate.dao.TesMenuGroupMapper;
import com.haomostudio.SpringMVCTemplate.dao.TesMenuMapper;
import com.haomostudio.SpringMVCTemplate.dao.TesMenuModuleMapper;
import com.haomostudio.SpringMVCTemplate.dao.TesRoleMapper;
import com.haomostudio.SpringMVCTemplate.dao.TesUserMapper;
import com.haomostudio.SpringMVCTemplate.dao.TestRoleGroupMapper;
import com.haomostudio.SpringMVCTemplate.po.TesRole;
import com.haomostudio.SpringMVCTemplate.po.TesRoleExample;
import com.haomostudio.SpringMVCTemplate.service.HmUtils.MybatisExampleHelper;
import com.haomostudio.SpringMVCTemplate.service.TesRoleService;
import com.haomostudio.SpringMVCTemplate.vo.TesRoleVO;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tesRoleService")
public class TesRoleServiceImpl
implements TesRoleService {
    protected static final Logger LOG = LoggerFactory.getLogger(TesRoleServiceImpl.class);
    @Autowired
    TesUserMapper tesUserMapper;
    TesRoleMapper tesRoleMapper;
    @Autowired
    TesMenuMapper tesMenuMapper;
    @Autowired
    TesDepartmentMapper tesDepartmentMapper;
    @Autowired
    TesMenuModuleMapper tesMenuModuleMapper;
    @Autowired
    TestRoleGroupMapper testRoleGroupMapper;
    @Autowired
    TesMenuGroupMapper tesMenuGroupMapper;

    @Override
    public int create(TesRole item) {
        return this.tesRoleMapper.insertSelective(item);
    }

    @Override
    public int delete(String id) {
        return this.tesRoleMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int update(TesRole item) {
        return this.tesRoleMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    public TesRole get(String id) {
        return this.tesRoleMapper.selectByPrimaryKey(id);
    }

    private void assignRelates(String relates, List<TesRoleVO> modelVOList) {
        JSONObject relatesObj = JSON.parseObject((String)relates);
        for (String table : relatesObj.keySet()) {
            for (TesRoleVO modelVO : modelVOList) {
                List joinCols = (List)relatesObj.get((Object)table);
                TesRoleExample tableExampleObj = new TesRoleExample();
                HashMap tableFilters = new HashMap();
                for (String joinCol : joinCols) {
                    HashMap column = new HashMap();
                    Method m = MybatisExampleHelper.getMethod(modelVO.getSuperior(), "get" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, joinCol));
                    HashMap<String, String> condition = new HashMap<String, String>();
                    try {
                        condition.put("equalTo", (String)JSON.parse((String)JSON.toJSONString((Object)m.invoke((Object)modelVO.getSuperior(), new Object[0]))));
                        column.put(joinCol, condition);
                        tableFilters.put(table, column);
                    }
                    catch (InvocationTargetException e) {
                        LOG.error(e.toString());
                    }
                    catch (IllegalAccessException e) {
                        LOG.error(e.toString());
                    }
                }
                MybatisExampleHelper.assignWhereClause(tableExampleObj, tableExampleObj.or(), table, JSON.toJSONString(tableFilters));
                tableExampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause("id", "asc"));
                try {
                    Field mapperFieldDef = this.getClass().getDeclaredField(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table) + "Mapper");
                    mapperFieldDef.setAccessible(true);
                    Object fieldValue = mapperFieldDef.get(this);
                    MapperProxy proxy = (MapperProxy)Proxy.getInvocationHandler(fieldValue);
                    Method sbewr = MybatisExampleHelper.getMethod(fieldValue, "selectByExampleWithRowbounds");
                    Object[] args = new Object[]{tableExampleObj, new RowBounds(1, 1000)};
                    modelVO.getRelates().put(table, (List)proxy.invoke((Object)proxy, sbewr, args));
                }
                catch (Throwable e) {
                    LOG.error(e.toString());
                }
            }
        }
    }

    @Override
    public List<TesRole> getListWithPagingAndFilter(Integer pageNo, Integer pageSize, String sortItem, String sortOrder, String filters) {
        TesRoleExample exampleObj = new TesRoleExample();
        RowBounds rowBounds = new RowBounds((pageNo - 1) * pageSize, pageSize.intValue());
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesRole", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));
        return this.tesRoleMapper.selectByExampleWithRowbounds(exampleObj, rowBounds);
    }

    @Override
    public Object getListWithPagingAndFilter(Integer pageNo, Integer pageSize, String sortItem, String sortOrder, String filters, String includes, String refers, String relates) {
        TesRoleExample exampleObj = new TesRoleExample();
        RowBounds rowBounds = new RowBounds((pageNo - 1) * pageSize, pageSize.intValue());
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesRole", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));
        List modelList = this.tesRoleMapper.selectByExampleWithRowbounds(exampleObj, rowBounds);
        List<TesRoleVO> modelVOList = modelList.stream().map(model -> new TesRoleVO(model)).collect(Collectors.toList());
        if ((includes != null || refers != null) && modelList.size() > 0) {
            modelVOList.stream().forEach(status -> {
                if (includes != null) {
                    this.assignIncludes(includes, (TesRoleVO)status);
                }
                if (refers != null) {
                    this.assignRefers(refers, (TesRoleVO)status);
                }
            });
        }
        if (relates != null && modelList.size() > 0) {
            this.assignRelates(relates, modelVOList);
        }
        if (includes == null && refers == null && relates == null) {
            return modelList;
        }
        return modelVOList;
    }

    @Override
    public Long countListWithPagingAndFilter(String filters) {
        TesRoleExample exampleObj = new TesRoleExample();
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TesRole", filters);
        return this.tesRoleMapper.countByExample(exampleObj);
    }

    private void assignIncludes(String includes, TesRoleVO status) {
        JSONObject includesObj = JSON.parseObject((String)includes);
        HashMap map = new HashMap();
        if (includesObj != null && includesObj.keySet().size() > 0) {
            includesObj.keySet().stream().forEach(table -> {
                String className = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table);
                JSONObject jsonObject = includesObj.getJSONObject(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                JSONArray columnCondition = jsonObject.getJSONArray("includes");
                if (columnCondition != null && columnCondition.toArray().length > 0) {
                    Arrays.stream(columnCondition.toArray()).forEach(obj -> {
                        String ffName = "get" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, obj.toString());
                        Method m = MybatisExampleHelper.getMethod(status.getSuperior(), ffName);
                        MybatisExampleHelper.dealSearchIncludes(m, status.getSuperior(), className, map, table, this.getClass().getPackage().getName());
                    });
                }
            });
        }
        status.setIncludes(map);
    }

    private void assignRefers(String refers, TesRoleVO status) {
        JSONObject refersObj = JSON.parseObject((String)refers);
        HashMap map = new HashMap();
        if (refersObj != null && refersObj.keySet().size() > 0) {
            refersObj.keySet().stream().forEach(table -> {
                JSONObject jsonObject = refersObj.getJSONObject(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                JSONArray columnCondition = jsonObject.getJSONArray("includes");
                if (columnCondition != null && columnCondition.toArray().length > 0) {
                    Arrays.stream(columnCondition.toArray()).forEach(obj -> MybatisExampleHelper.dealSearchRefers(status.getSuperior().getId(), table, map, obj, CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table), this.getClass().getPackage().getName()));
                }
            });
        }
        status.setRefers(map);
    }
}

