/*
 * Decompiled with CFR 0.152.
 */
package com.haomostudio.SpringMVCTemplate.service.HmUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.haomostudio.SpringMVCTemplate.service.HmUtils.Tools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class MybatisExampleHelper {
    public static String createOrderClause(String sortItem, String sortOrder) {
        List<String> items = Arrays.asList(sortItem.split(",\\s*"));
        List<String> orders = Arrays.asList(sortOrder.split(",\\s*"));
        if (items.size() != orders.size()) {
            return null;
        }
        ArrayList<String> itemOrder = new ArrayList<String>();
        for (int i = 0; i < items.size(); ++i) {
            itemOrder.add(items.get(i) + " " + orders.get(i));
        }
        return String.join((CharSequence)", ", itemOrder);
    }

    public static String getFilterFuncName(String column, String condition) {
        if (column.contains("_")) {
            return "and" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, column) + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, condition);
        }
        return "and" + column.substring(0, 1).toUpperCase() + column.substring(1) + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, condition);
    }

    public static Method getMethod(Object obj, String methodName) {
        for (Method m : obj.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static Method getMethodNumber(Object obj, String methodName, int parameterNuber) {
        for (Method m : obj.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterNuber) continue;
            return m;
        }
        return null;
    }

    public static Object assignCondition(Object exampleObj, Object exampleObjCriteria, String column, String condition, Object value) {
        String funcName = MybatisExampleHelper.getFilterFuncName(column, condition);
        Method m = MybatisExampleHelper.getMethod(exampleObjCriteria, funcName);
        switch (condition) {
            case "fieldsValuesOr": {
                try {
                    m = MybatisExampleHelper.getMethod(exampleObjCriteria, condition);
                    m.invoke(exampleObjCriteria, (List)((Map)value).get("values"), (List)((Map)value).get("fields"), column);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "isNull": 
            case "isNotNull": {
                try {
                    m.invoke(exampleObjCriteria, new Object[0]);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            case "between": 
            case "notBetween": {
                try {
                    if (m.getParameterTypes()[0].getName().contains("Date")) {
                        m.invoke(exampleObjCriteria, Tools.convertStringToDate((String)((List)value).get(0), "yyyy-MM-dd HH:mm:ss"), Tools.convertStringToDate((String)((List)value).get(1), "yyyy-MM-dd HH:mm:ss"));
                        break;
                    }
                    if (m.getParameterTypes()[0].getName().contains("Long")) {
                        m.invoke(exampleObjCriteria, ((List)value).get(0), ((List)value).get(1));
                        break;
                    }
                    m.invoke(exampleObjCriteria, ((List)value).get(0), ((List)value).get(1));
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                try {
                    if (m.getParameterTypes()[0].getName().contains("Date")) {
                        m.invoke(exampleObjCriteria, Tools.convertStringToDate((String)value, "yyyy-MM-dd HH:mm:ss"));
                        break;
                    }
                    if (m.getParameterTypes()[0].getName().contains("Long")) {
                        m.invoke(exampleObjCriteria, Long.valueOf(String.valueOf(value)));
                        break;
                    }
                    if (m.getParameterTypes()[0].getName().contains("Integer")) {
                        m.invoke(exampleObjCriteria, Integer.valueOf((String)value));
                        break;
                    }
                    if (m.getParameterTypes()[0].getName().contains("int")) {
                        m.invoke(exampleObjCriteria, (int)((Integer)value));
                        break;
                    }
                    m.invoke(exampleObjCriteria, value);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return exampleObj;
    }

    public static Object assignWhereClause(Object exampleObj, Object exampleObjCriteria, String className, String filters) {
        JSONObject filterObj = JSON.parseObject((String)filters);
        if (!filterObj.containsKey((Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className))) {
            return exampleObjCriteria;
        }
        JSONObject columnCondition = filterObj.getJSONObject(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className));
        Set entrySet = columnCondition.entrySet();
        for (Map.Entry entry : entrySet) {
            String column = (String)entry.getKey();
            JSONObject conditionObj = (JSONObject)entry.getValue();
            Set conditionObjEntrySet = conditionObj.entrySet();
            for (Map.Entry coes : conditionObjEntrySet) {
                exampleObj = MybatisExampleHelper.assignCondition(exampleObj, exampleObjCriteria, column, (String)coes.getKey(), coes.getValue());
            }
        }
        return exampleObjCriteria;
    }

    public static String getSimpleFilter(final String table, final String column, final String oper, final Object value) {
        return JSON.toJSONString((Object)new HashMap(){
            {
                this.put(table, new HashMap(){
                    {
                        this.put(column, new HashMap(){
                            {
                                this.put(oper, value);
                            }
                        });
                    }
                });
            }
        });
    }

    public static void dealSearchIncludes(Method m, Object superior, Object className, Map<String, Object> map, String table, String packageName) {
        try {
            Object id;
            if (m != null && (id = m.invoke(superior, new Object[0])) != null) {
                Method m1;
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                Class<?> onwClass = Class.forName(packageName + "." + className + "ServiceImpl");
                Object impl = onwClass.newInstance();
                String get = "get";
                if (className.equals("CrmUser")) {
                    get = "getUserById";
                }
                if ((m1 = MybatisExampleHelper.getMethod(impl, get)) != null) {
                    Object obj2 = m1.invoke(wac.getBean(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table) + "Service"), id);
                    map.put(table.toString(), obj2);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void dealSearchRefers(Object id, String table, Map<String, List<Object>> map, Object obj, Object className, String packageName) {
        try {
            if (id != null) {
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                Class<?> onwClass = Class.forName(packageName + "." + className + "ServiceImpl");
                Object impl = onwClass.newInstance();
                Method m1 = MybatisExampleHelper.getMethodNumber(impl, "getListWithPagingAndFilter", 5);
                StringBuffer buffer = new StringBuffer();
                buffer.append("{");
                buffer.append("\"" + table + "\"");
                buffer.append(":{");
                buffer.append("\"" + obj.toString() + "\"");
                buffer.append(":{");
                buffer.append("\"equalTo\": \"" + id.toString() + "\"");
                buffer.append("} } }");
                Object[] methodObject = new Object[]{1, 1000, "id", "asc", buffer.toString()};
                if (m1 != null) {
                    List obj2 = (List)m1.invoke(wac.getBean(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table) + "Service"), 1, 1000, "id", "asc", buffer.toString());
                    map.put(table.toString(), obj2);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}

