/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.models.Swagger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.HostNameProvider;

@Controller
@ApiIgnore
public class Swagger2Controller {
    public static final String DEFAULT_URL = "/v2/api-docs";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    @Value(value="${springfox.documentation.swagger.v2.host:DEFAULT}")
    private String hostNameOverride;
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired
    private ServiceModelToSwagger2Mapper mapper;
    @Autowired
    private JsonSerializer jsonSerializer;

    @ApiIgnore
    @RequestMapping(value={"${springfox.documentation.swagger.v2.path:/v2/api-docs}"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            swagger.host(this.hostName(servletRequest));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swagger), HttpStatus.OK);
    }

    private String hostName(HttpServletRequest servletRequest) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            UriComponents uri = HostNameProvider.componentsFrom(servletRequest);
            String host = uri.getHost();
            int port = uri.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }
}

