/*
 * Decompiled with CFR 0.152.
 */
package com.haomostudio.SpringMVCTemplate.dao.impl;

import com.haomostudio.SpringMVCTemplate.dao.common.util.DataBaseOperationUtils;
import com.haomostudio.SpringMVCTemplate.dao.impl.DataBaseDao;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="databaseDao")
public class OracleDataBaseDaoImpl
implements DataBaseDao {
    public static final String PAGINATION_PREFIX = "select * from (select row_.*, rownum rownum_ from(";
    public static final String PAGINATION_SUFFIX = ")row_ where rownum <= ?) where rownum_ > ?";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DataSource dataSource;

    public List<Map<String, Object>> queryForList(String sql, List<Object> params) {
        try {
            List e = params.size() > 0 ? this.getJdbcTemplate().queryForList(sql, params.toArray()) : this.getJdbcTemplate().queryForList(sql);
            return e;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Override
    public int queryForInt(String sql, List<Object> params) {
        try {
            if (null == params) {
                params = new ArrayList<Object>();
            }
            this.logger.debug("executeSQL:{}\r\nparams:{}", (Object)sql, params);
            return params.size() > 0 ? ((Integer)this.getJdbcTemplate().queryForObject(sql, params.toArray(), Integer.class)).intValue() : ((Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class)).intValue();
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean executeSQL(String sql) {
        this.logger.debug("executeSQL:{}", (Object)sql);
        String[] sqlList = sql.split(";");
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        for (String s : sqlList) {
            jdbcTemplate.execute(s);
        }
        return true;
    }

    @Override
    public int update(String tableNamePrefix, String tableName, Map<String, Object> map) {
        try {
            String id = (String)map.get("ID");
            map.remove("ID");
            map.put("ID", id);
            String sql = "UPDATE " + DataBaseOperationUtils.getOracleTableName(tableNamePrefix, tableName) + " SET " + DataBaseOperationUtils.GetNames(map, "UPDATE", "oracle");
            this.logger.debug("update sql:{}\r\nparams:{}", (Object)sql, map);
            int row = this.getJdbcTemplate().update(sql, DataBaseOperationUtils.GetObjectArgs(map, "oracle"));
            return row;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            throw var4;
        }
    }

    @Override
    public int insert(String tableNamePrefix, String tableName, Map<String, Object> map) {
        try {
            String sql = "INSERT INTO " + DataBaseOperationUtils.getOracleTableName(tableNamePrefix, tableName) + " " + DataBaseOperationUtils.GetNames(map, "INSERT", "oracle");
            this.logger.debug("insert sql:{}\r\nparams:{}", (Object)sql, map);
            int ID = this.getJdbcTemplate().update(sql, DataBaseOperationUtils.GetObjectArgs(map, "oracle"));
            return ID;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            throw var4;
        }
    }

    @Override
    public int inserts(String tableNamePrefix, String tableName, List<Map<String, Object>> maps) {
        try {
            String sql = "INSERT INTO " + DataBaseOperationUtils.getOracleTableName(tableNamePrefix, tableName) + " " + DataBaseOperationUtils.GetNames(maps.get(0), "INSERT", "oracle");
            this.logger.debug("inserts sql:{}\r\nparams:{}", (Object)sql, maps);
            int[] ints = this.getJdbcTemplate().batchUpdate(sql, DataBaseOperationUtils.GetObjectArgs(maps, "oracle"));
            return 0;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            throw var4;
        }
    }

    @Override
    public int delete(String tableNamePrefix, String tableName, Map<String, Object> map) {
        try {
            String sql = "DELETE FROM " + DataBaseOperationUtils.getOracleTableName(tableNamePrefix, tableName) + " WHERE " + DataBaseOperationUtils.GetNames(map, "DELETE", "oracle");
            this.logger.debug("delete sql:{}\r\nparams:{}", (Object)sql, map);
            int rows = this.getJdbcTemplate().update(sql, DataBaseOperationUtils.GetObjectArgs(map, "oracle"));
            return rows;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean executeSQL(String sql, List<Object> params) {
        this.logger.debug("executeSQL:{}\r\nparams:{}", (Object)sql, params);
        int status = this.getJdbcTemplate().update(sql, params.toArray());
        return status > 0;
    }

    @Override
    public Map<String, Object> executeQuerySQL(String sql) {
        this.logger.debug("executeQuerySQL:{}", (Object)sql);
        return this.getJdbcTemplate().queryForMap(sql);
    }

    @Override
    public List<Map<String, Object>> executeListSQL(String sql) {
        this.logger.debug("executeListSQL:{}", (Object)sql);
        return this.getJdbcTemplate().queryForList(sql);
    }

    @Override
    public void executeSingleSQL(String sql) {
        this.logger.debug("executeSingleSQL:{}", (Object)sql);
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public List<Map<String, Object>> getTableData(String tableNamePrefix, String tableName, Map<String, Object> params) {
        return null;
    }

    @Override
    public int getTableDataCount(String tableNamePrefix, String tableName, Map<String, Object> params) {
        return 0;
    }

    @Override
    public int getColumnNotNullCount(String tableNamePrefix, String tableName, String columnName) {
        return 0;
    }

    @Override
    public int getColumnNotZeroCount(String tableNamePrefix, String tableName, String columnName) {
        return 0;
    }

    private JdbcTemplate getJdbcTemplate() {
        return new JdbcTemplate(this.dataSource);
    }
}

