package com.haomostudio.SpringMVCTemplate.controller;

import com.haomostudio.SpringMVCTemplate.common.Resp;
import com.haomostudio.SpringMVCTemplate.po.TestRoleGroup;
import com.haomostudio.SpringMVCTemplate.service.HmUtils.Tools;
import com.haomostudio.SpringMVCTemplate.service.TestRoleGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by hxg on 2016/10/06.
 */
@Api(description = "TESTROLEGROUP")
@Controller
public class TestRoleGroupController {

    @Autowired
    TestRoleGroupService testRoleGroupService;

    @Autowired
    HttpServletResponse response;

    @ApiOperation(value = "创建'TESTROLEGROUP'表中一条信息", notes = "通过post方法请求，传入表中字段的对应信息，创建一条数据。并返回给View层")
    @RequestMapping(value = "/test_role_groups/new",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object createTestRoleGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "role_id", required = false) String role_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        TestRoleGroup item = new TestRoleGroup();
        String id = Tools.getUUID();
        item.setId(id);
        if( name != null ){
            item.setName(name);
        }
        if( role_id != null ){
            item.setRoleId(role_id);
        }
        if( create_time != null ){
            item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
        }
        if( last_update_time != null ){
            item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
        }
        testRoleGroupService.create(item);

        //若request param为null，但字段定义有默认值，则需从数据库中返回结果
        return testRoleGroupService.get(id);
        //return item;
    }

    @ApiOperation(value = "删除'TESTROLEGROUP'表中的某条记录", notes = "根据url传入的数据id，删除整条记录。")
    @RequestMapping(value = "/test_role_groups/{test_role_group_id}/delete",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object deleteTestRoleGroup(
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "test_role_group_id") String id
    ) {
        TestRoleGroup item = testRoleGroupService.get(id);
        if (null == item) {
            response.setStatus(404);
            return Resp.fail("the asset to be deleted doesn't exist");
        }

        testRoleGroupService.delete(id);
        return Resp.succ("delete success");
    }

    @ApiOperation(value = "修改'TESTROLEGROUP'表中的某条记录", notes = "根据url传入的数据id，确定修改表中的某条记录，传入表中字段要修改的信息，不传代表不修改。并返回给View层")
    @RequestMapping(value = "/test_role_groups/{test_role_group_id}/edit",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object editTestRoleGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "test_role_group_id") String id,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "role_id", required = false) String role_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        TestRoleGroup item = testRoleGroupService.get(id);
        if (null == item) {
            response.setStatus(404);
            return Resp.fail("the asset to be edited doesn't exist");
        }

        if( name != null ){
            item.setName(name);
        }
        if( role_id != null ){
            item.setRoleId(role_id);
        }
        if( create_time != null ){
            item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
        }
        if( last_update_time != null ){
            item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
        }
        testRoleGroupService.update(item);

        return testRoleGroupService.get(id);
    }

    @ApiOperation(value = "查询'TESTROLEGROUP'表中的某条记录", notes = "根据url传入的数据id，查询对应的一条数据。")
    @RequestMapping(value = "/test_role_groups/{test_role_group_id}",
                    method = {RequestMethod.GET, RequestMethod.DELETE, RequestMethod.PUT},
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object getTestRoleGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "test_role_group_id") String id,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "role_id", required = false) String role_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        if(request.getMethod().equals("GET")){
            TestRoleGroup item = testRoleGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be edited doesn't exist");
            }

            return item;
        }
        else if(request.getMethod().equals("PUT")){
            TestRoleGroup item = testRoleGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be edited doesn't exist");
            }

            if( name != null ){
                item.setName(name);
            }
            if( role_id != null ){
                item.setRoleId(role_id);
            }
            if( create_time != null ){
                item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
            }
            if( last_update_time != null ){
                item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
            }
            testRoleGroupService.update(item);

            return testRoleGroupService.get(id);
        }
        else if(request.getMethod().equals("DELETE")){
            TestRoleGroup item = testRoleGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be deleted doesn't exist");
            }

            testRoleGroupService.delete(id);
            return Resp.succ("delete success");
        }
        return Resp.fail("Unknown http method");
    }

    @ApiOperation(value = "查询'TESTROLEGROUP'表中的多条记录或者新增某条记录", notes = "get传参：根据url传入的filters（过滤条件），查询对应的多条数据。数据数量取决于page_no和page_size；数据的先后顺序取决于sort_item，sort_order；   post请求：新增某条记录，传入表字段对应的值")
    @RequestMapping(value = "/test_role_groups",
                    method = { RequestMethod.GET, RequestMethod.POST },
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object getTestRoleGroups(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token", required = false) String token,
            @RequestParam(value = "page_no", required = false) Integer pageNo,
            @RequestParam(value = "page_size", required = false) Integer pageSize,
            @RequestParam(value = "sort_item", required = false) String sortItem,
            @RequestParam(value = "sort_order", required = false) String sortOrder,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "role_id", required = false) String role_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time,
            @RequestParam(value = "filters", required = false) String filters,
            @RequestParam(value = "includes", required = false) String includes,
            @RequestParam(value = "refers", required = false) String refers,
            @RequestParam(value = "relates", required = false) String relates
    ) {
        if(request.getMethod().equals("GET")){
            if(pageNo == null){
                pageNo = 1;
            }
            if(pageSize == null){
                pageSize = 10;
            }
            if(sortItem == null){
                sortItem = "id";
            }
            if(sortOrder == null){
                sortOrder = "asc";
            }
            if(filters == null){
                filters = "{}";
             }

            Long total = testRoleGroupService.countListWithPagingAndFilter(filters);
            response.addHeader("total", String.valueOf(total));

            return testRoleGroupService.getListWithPagingAndFilter(
                            pageNo, pageSize, sortItem, sortOrder, filters, includes, refers, relates);
        }
        else{
            TestRoleGroup item = new TestRoleGroup();
            String id = Tools.getUUID();
            item.setId(id);
            if( name != null ){
                item.setName(name);
            }
            if( role_id != null ){
                item.setRoleId(role_id);
            }
            if( create_time != null ){
                item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
            }
            if( last_update_time != null ){
                item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
            }
            testRoleGroupService.create(item);

            //若request param为null，但字段定义有默认值，则需从数据库中返回结果
            return testRoleGroupService.get(id);
            //return item;
        }
    }
}
