/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T arg;
    private final boolean absent;

    private Optional() {
        this.arg = null;
        this.absent = true;
    }

    private Optional(T arg) {
        this.arg = arg;
        this.absent = false;
    }

    public static <T> Optional<T> of(T arg) {
        return new Optional<T>(arg);
    }

    public static <T> Optional<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Optional<T>(nullableReference);
    }

    public static <T> Optional<T> absent() {
        return EMPTY;
    }

    public T get() {
        if (this.absent) {
            throw new IllegalStateException("Optional.get() cannot be called on an absent value");
        }
        return this.arg;
    }

    public T or(T defaultValue) {
        if (this.absent) {
            return defaultValue;
        }
        return this.arg;
    }

    public T orNull() {
        if (this.absent) {
            return null;
        }
        return this.arg;
    }

    public boolean isPresent() {
        return !this.absent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Optional optional = (Optional)o;
        if (this.absent != optional.absent) {
            return false;
        }
        return !(this.arg != null ? !this.arg.equals(optional.arg) : optional.arg != null);
    }

    public int hashCode() {
        int result = this.arg == null ? 0 : this.arg.hashCode();
        result = 31 * result + (this.absent ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.absent ? "Optional.absent()" : "Optional.of(" + this.arg + ")";
    }
}

