package com.haomostudio.SpringMVCTemplate.controller;

import com.haomostudio.SpringMVCTemplate.common.Resp;
import com.haomostudio.SpringMVCTemplate.po.TesMenuGroup;
import com.haomostudio.SpringMVCTemplate.service.HmUtils.Tools;
import com.haomostudio.SpringMVCTemplate.service.TesMenuGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by hxg on 2016/10/06.
 */
@Api(description = "TESMENUGROUP")
@Controller
public class TesMenuGroupController {

    @Autowired
    TesMenuGroupService tesMenuGroupService;

    @Autowired
    HttpServletResponse response;

    @ApiOperation(value = "创建'TESMENUGROUP'表中一条信息", notes = "通过post方法请求，传入表中字段的对应信息，创建一条数据。并返回给View层")
    @RequestMapping(value = "/tes_menu_groups/new",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object createTesMenuGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "sort", required = false) String sort,
            @RequestParam(value = "module_id", required = false) String module_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        TesMenuGroup item = new TesMenuGroup();
        String id = Tools.getUUID();
        item.setId(Integer.valueOf(id));
        if( name != null ){
            item.setName(name);
        }
        if( sort != null ){
            item.setSort(sort);
        }
        if( module_id != null ){
            item.setModuleId(module_id);
        }
        if( create_time != null ){
            item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
        }
        if( last_update_time != null ){
            item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
        }
        tesMenuGroupService.create(item);

        //若request param为null，但字段定义有默认值，则需从数据库中返回结果
        return tesMenuGroupService.get(id);
        //return item;
    }

    @ApiOperation(value = "修改'TESMENUGROUP'表中的某条记录", notes = "根据url传入的数据id，确定修改表中的某条记录，传入表中字段要修改的信息，不传代表不修改。并返回给View层")
    @RequestMapping(value = "/tes_menu_groups/{tes_menu_group_id}/delete",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object deleteTesMenuGroup(
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "tes_menu_group_id") String id
    ) {
        TesMenuGroup item = tesMenuGroupService.get(id);
        if (null == item) {
            response.setStatus(404);
            return Resp.fail("the asset to be deleted doesn't exist");
        }

        tesMenuGroupService.delete(id);
        return Resp.succ("delete success");
    }

    @ApiOperation(value = "删除'TESMENUGROUP'表中的某条记录", notes = "根据url传入的数据id，删除整条记录。")
    @RequestMapping(value = "/tes_menu_groups/{tes_menu_group_id}/edit",
                    method = RequestMethod.POST,
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object editTesMenuGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "tes_menu_group_id") String id,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "sort", required = false) String sort,
            @RequestParam(value = "module_id", required = false) String module_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        TesMenuGroup item = tesMenuGroupService.get(id);
        if (null == item) {
            response.setStatus(404);
            return Resp.fail("the asset to be edited doesn't exist");
        }

        if( name != null ){
            item.setName(name);
        }
        if( sort != null ){
            item.setSort(sort);
        }
        if( module_id != null ){
            item.setModuleId(module_id);
        }
        if( create_time != null ){
            item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
        }
        if( last_update_time != null ){
            item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
        }
        tesMenuGroupService.update(item);

        return tesMenuGroupService.get(id);
    }

    @ApiOperation(value = "查询'TESMENUGROUP'表中的某条记录", notes = "根据url传入的数据id，查询对应的一条数据。")
    @RequestMapping(value = "/tes_menu_groups/{tes_menu_group_id}",
                    method = {RequestMethod.GET, RequestMethod.DELETE, RequestMethod.PUT},
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object getTesMenuGroup(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token") String token,
            @PathVariable(value = "tes_menu_group_id") String id,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "sort", required = false) String sort,
            @RequestParam(value = "module_id", required = false) String module_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time
    ) {
        if(request.getMethod().equals("GET")){
            TesMenuGroup item = tesMenuGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be edited doesn't exist");
            }

            return item;
        }
        else if(request.getMethod().equals("PUT")){
            TesMenuGroup item = tesMenuGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be edited doesn't exist");
            }

            if( name != null ){
                item.setName(name);
            }
            if( sort != null ){
                item.setSort(sort);
            }
            if( module_id != null ){
                item.setModuleId(module_id);
            }
            if( create_time != null ){
                item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
            }
            if( last_update_time != null ){
                item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
            }
            tesMenuGroupService.update(item);

            return tesMenuGroupService.get(id);
        }
        else if(request.getMethod().equals("DELETE")){
            TesMenuGroup item = tesMenuGroupService.get(id);
            if (null == item) {
                response.setStatus(404);
                return Resp.fail("the asset to be deleted doesn't exist");
            }

            tesMenuGroupService.delete(id);
            return Resp.succ("delete success");
        }
        return Resp.fail("Unknown http method");
    }

    @ApiOperation(value = "查询'TESMENUGROUP'表中的多条记录或者新增某条记录", notes = "get传参：根据url传入的filters（过滤条件），查询对应的多条数据。数据数量取决于page_no和page_size；数据的先后顺序取决于sort_item，sort_order；   post请求：新增某条记录，传入表字段对应的值")
    @RequestMapping(value = "/tes_menu_groups",
                    method = { RequestMethod.GET, RequestMethod.POST },
                    produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object getTesMenuGroups(
            HttpServletRequest request,
            @RequestHeader(value = "X-Auth-Token", required = false) String token,
            @RequestParam(value = "page_no", required = false) Integer pageNo,
            @RequestParam(value = "page_size", required = false) Integer pageSize,
            @RequestParam(value = "sort_item", required = false) String sortItem,
            @RequestParam(value = "sort_order", required = false) String sortOrder,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "sort", required = false) String sort,
            @RequestParam(value = "module_id", required = false) String module_id,
            @RequestParam(value = "create_time", required = false) String create_time,
            @RequestParam(value = "last_update_time", required = false) String last_update_time,
            @RequestParam(value = "filters", required = false) String filters,
            @RequestParam(value = "includes", required = false) String includes,
            @RequestParam(value = "refers", required = false) String refers,
            @RequestParam(value = "relates", required = false) String relates
    ) {
        if(request.getMethod().equals("GET")){
            if(pageNo == null){
                pageNo = 1;
            }
            if(pageSize == null){
                pageSize = 10;
            }
            if(sortItem == null){
                sortItem = "id";
            }
            if(sortOrder == null){
                sortOrder = "asc";
            }
            if(filters == null){
                filters = "{}";
             }

            Long total = tesMenuGroupService.countListWithPagingAndFilter(filters);
            response.addHeader("total", String.valueOf(total));

            return tesMenuGroupService.getListWithPagingAndFilter(
                            pageNo, pageSize, sortItem, sortOrder, filters, includes, refers, relates);
        }
        else{
            TesMenuGroup item = new TesMenuGroup();
            String id = Tools.getUUID();
            item.setId(Integer.valueOf(id));
            if( name != null ){
                item.setName(name);
            }
            if( sort != null ){
                item.setSort(sort);
            }
            if( module_id != null ){
                item.setModuleId(module_id);
            }
            if( create_time != null ){
                item.setCreateTime(Tools.convertStringToDate(create_time, "yyyy-MM-dd HH:mm:ss"));
            }
            if( last_update_time != null ){
                item.setLastUpdateTime(Tools.convertStringToDate(last_update_time, "yyyy-MM-dd HH:mm:ss"));
            }
            tesMenuGroupService.create(item);

            //若request param为null，但字段定义有默认值，则需从数据库中返回结果
            return tesMenuGroupService.get(id);
            //return item;
        }
    }
}
