# CONTRIBUTING GUIDELINES

Oh-My-Zsh is a community-driven project. Contribution is welcome, encouraged and appreciated.
It is also essential for the development of the project.

These guidelines are an attempt at better addressing the huge amount of pending
issues and pull requests. Please read them closely.

Foremost, be so kind as to [search](#use-the-search-luke). This ensures any contribution
you would make is not already covered.

* [Issues](#reporting-issues)
  * [You have a problem](#you-have-a-problem)
  * [You have a suggestion](#you-have-a-suggestion)
* [Pull Requests](#submitting-pull-requests)
  * [Getting started](#getting-started)
  * [You have a solution](#you-have-a-solution)
  * [You have an addition](#you-have-an-addition)
* [Information sources (_aka_ search)](#use-the-search-luke)

**BONUS:** [Volunteering](#you-have-spare-time-to-volunteer)

## Reporting Issues

### You have a problem

Please be so kind as to [search](#use-the-search-luke) for any open issue already covering
your problem.

If you find one, comment on it so we can know there are more people experiencing it.

If not, look at the [Troubleshooting](https://github.com/robbyrussell/oh-my-zsh/wiki/Troubleshooting)
page for instructions on how to gather data to better debug your problem.

Then, you can go ahead and create an issue with as much detail as you can provide.
It should include the data gathered as indicated above, along with:

1. How to reproduce the problem
2. What the correct behavior should be
3. What the actual behavior is

Please copy to anyone relevant (_eg_ plugin maintainers) by mentioning their GitHub handle
(starting with `@`) in your message.

We will do our very best to help you.

### You have a suggestion

Please be so kind as to [search](#use-the-search-luke) for any open issue already covering
your suggestion.

If you find one, comment on it so we can know there are more people supporting it.

If not, you can go ahead and create an issue. Please copy to anyone relevant (_eg_ plugin
maintainers) by mentioning their GitHub handle (starting with `@`) in your message.

## Submitting Pull Requests

### Getting started

You should be familiar with the basics of
[contributing on GitHub](https://help.github.com/articles/using-pull-requests) and have a fork
[properly set up](https://github.com/robbyrussell/oh-my-zsh/wiki/Contribution-Technical-Practices).

You MUST always create PRs with _a dedicated branch_ based on the latest upstream tree.

If you create your own PR, please make sure you do it right. Also be so kind as to reference
any issue that would be solved in the PR description body,
[for instance](https://help.github.com/articles/closing-issues-via-commit-messages/)
_"Fixes #XXXX"_ for issue number XXXX.

### You have a solution

Please be so kind as to [search](#use-the-search-luke) for any open issue already covering
your [problem](#you-have-a-problem), and any pending PR covering your solution.

If the solution is already reported, try it out and +1 the pull request if the
solution works ok. On the other hand, if you think your solution is better, post
it so we can have both solutions to compare.

If not, then go ahead and submit a PR. Please copy to anyone relevant (_eg_ plugin
maintainers) by mentioning their GitHub handle (starting with `@`) in your message.

### You have an addition

Please [do not](https://github.com/robbyrussell/oh-my-zsh/wiki/Themes#dont-send-us-your-theme-for-now)
send themes for now.

Please be so kind as to [search](#use-the-search-luke) for any pending PR covering or
related to what you want to add.

If you find one, try it out and work with the author on a common solution.

If not, then go ahead and submit a PR. Please copy to anyone relevant (_eg_ plugin
maintainers) by mentioning their GitHub handle (starting with `@`) in your message.

For any extensive change, _eg_ a new plugin, you will have to find testers to +1 your PR.

----

## Use the Search, Luke

_May the Force (of past experiences) be with you_

GitHub offers [many search features](https://help.github.com/articles/searching-github/)
to help you check whether a similar contribution to yours already exists. Please search
before making any contribution, it avoids duplicates and eases maintenance. Trust me,
that works 90% of the time.

You can also take a look at the [FAQ](https://github.com/robbyrussell/oh-my-zsh/wiki/FAQ)
to be sure your contribution has not already come up.

If all fails, your thing has probably not been reported yet, so you can go ahead
and [create an issue](#reporting-issues) or [submit a PR](#submitting-pull-requests).

----

### You have spare time to volunteer

Very nice!! :)

Please have a look at the [Volunteer](https://github.com/robbyrussell/oh-my-zsh/wiki/Volunteers)
page for instructions on where to start and more.
