function vundle-init () {
  if [ ! -d ~/.vim/bundle/vundle/ ]
  then
    mkdir -p ~/.vim/bundle/vundle/
  fi

  if [ ! -d ~/.vim/bundle/vundle/.git ] && [ ! -f ~/.vim/bundle/vundle/.git ]
  then
    git clone http://github.com/gmarik/vundle.git ~/.vim/bundle/vundle
    echo "\n\tRead about vim configuration for vundle at https://github.com/gmarik/vundle\n"
  fi
}

function vundle () {
  vundle-init
  vim -c "execute \"PluginInstall\" | qa"
}

function vundle-update () {
  vundle-init
  vim -c "execute \"PluginInstall!\" | qa"
}

function vundle-clean () {
  vundle-init
  vim -c "execute \"PluginClean!\" | qa"
}
